/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "support.h"

#include "plugs.h"
#include "mp3info.h"
#include "tageditor.h"
#include "gui_tageditor.h"

/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/
/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/


void tageditor_tag_to_gui(id3Tag *tag, gint mode)
{
	extern GtkWidget *cantus;
	gchar *comment = NULL;

// put the tag to the form (mode 0)
	if( mode == 0 )
	{
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_artist")), tag->artist);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_song")), tag->title);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_album")), tag->album);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_year")), tag->year);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_track")), tag->track);
		gtk_text_insert(GTK_TEXT(lookup_widget(cantus, "text_cantus_tagedit_comment")), NULL, NULL, NULL, tag->comment, -1);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_genre")), tag->genre);
	}
	else
	{
// or delete all fields where the tag does not match the already selected tags (mode 1).
		if(strcmp(gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_artist"))), tag->artist))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_artist")), "");
		if(strcmp(gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_song"))), tag->title))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_song")), "");
		if(strcmp(gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_album"))), tag->album))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_album")), "");
		if(strcmp(gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_year"))), tag->year))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_year")), "");
		if(strcmp(gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_track"))), tag->track))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_track")), "");
		
		comment = gtk_editable_get_chars(GTK_EDITABLE (lookup_widget (cantus, "text_cantus_tagedit_comment")), 0,
			gtk_text_get_length(GTK_TEXT (lookup_widget (cantus, "text_cantus_tagedit_comment"))));
		if(strcmp(comment, tag->comment))
		{
			gtk_text_set_point(GTK_TEXT(lookup_widget (cantus, "text_cantus_tagedit_comment")), 0);
			gtk_text_forward_delete(GTK_TEXT (lookup_widget (cantus, "text_cantus_tagedit_comment")), 
				gtk_text_get_length(GTK_TEXT (lookup_widget (cantus, "text_cantus_tagedit_comment"))));
		}
		free(comment);
		
		if(strcmp(tag->genre, gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_genre")))))
			gtk_entry_set_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_genre")), "");
	}
}






void
tageditor_gui_to_tag(id3Tag *tag)
{
	extern GtkWidget *cantus;
	
// Overwrite tag where user wants to set new fields
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_song"))))
		strncpy(tag->title, gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_song"))), 1023);
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_artist"))))
		strncpy(tag->artist, gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_artist"))), 1023);
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_album"))))
		strncpy(tag->album, gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_album"))), 1023);

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_year"))))
		strncpy(tag->year, gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_year"))), 1023);

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_comment"))))
		strncpy(tag->comment,
		gtk_editable_get_chars(GTK_EDITABLE (lookup_widget (cantus, "text_cantus_tagedit_comment")), 0,
			gtk_text_get_length(GTK_TEXT (lookup_widget (cantus, "text_cantus_tagedit_comment")))),
		1023);

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_track"))))
		strncpy(tag->track,	gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_track"))), 3);
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (lookup_widget (cantus, "check_cantus_tagedit_genre"))))
		strncpy(tag->genre,	gtk_entry_get_text(GTK_ENTRY (lookup_widget (cantus, "entry_cantus_tagedit_genre"))), 511);
}




// Clears all fields.
void
tageditor_gui_clear(void)
{
	extern GtkWidget *cantus;
	
// Clear all fields.
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_artist")), (char *)"");
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_song")), (char *)"");
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_album")), (char *)"");
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_year")), (char *)"");
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_track")), (char *)"");
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tagedit_genre")), "Other");
	gtk_text_set_point(GTK_TEXT(lookup_widget(cantus, "text_cantus_tagedit_comment")), 0);
	gtk_text_forward_delete(GTK_TEXT(lookup_widget(cantus, "text_cantus_tagedit_comment")), 
		gtk_text_get_length(GTK_TEXT(lookup_widget(cantus, "text_cantus_tagedit_comment"))));
}
