/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "support.h"
#include "shared.h"
#include "rules.h"
#include "rules_plugs.h"
#include "memory.h"
#include "gui_rules.h"
#include "gui_shared.h"
#include "configfile.h"

/**********************************************************************
 * this will unhide the rules dialog and add existing rules to the clist.
 **********************************************************************/
void
rules_open(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	extern GList *queue;
	gchar *example = NULL;
	
	gtk_widget_show(rules);
	clist_rules_add_rules(GTK_CLIST(lookup_widget(rules, "clist_rules_rules")), rulelist);
	
	example = rules_plugs_update_example(queue);
	gtk_label_set_text(GTK_LABEL(lookup_widget(rules, "label_rules_example")),
		example);
	free(example);
}





/**********************************************************************
 * this will add new rules to the rulelist.
 **********************************************************************/
void
rules_add(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	extern GList *queue;
	
	gchar *example = NULL;
	GList *newrules = NULL;
	
	newrules = dialog_rules_get_rules(newrules);
	clist_rules_add_rules(GTK_CLIST(lookup_widget(rules, "clist_rules_rules")), newrules);
	rulelist = g_list_concat(rulelist, newrules);
	
	dialog_rules_init();
	
	example = rules_plugs_update_example(queue);
	gtk_label_set_text(GTK_LABEL(lookup_widget(rules, "label_rules_example")),
		example);
}







/**********************************************************************
 * this will clear the rulelist and its clist.
 **********************************************************************/
void
rules_clear(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	
	gtk_clist_clear(GTK_CLIST(lookup_widget(rules, "clist_rules_rules")));
	rulelist = mem_free(rulelist);
}







/**********************************************************************
 * this hides the rules dialog and copy the rulelist to the mainwindows
 * rule clist.
 **********************************************************************/
void
rules_close(void)
{
	extern GtkWidget *cantus;
	extern GtkWidget *rules;
	extern GList *rulelist;
	
	gtk_widget_hide(rules);
	
	gtk_clist_clear(GTK_CLIST(lookup_widget(cantus, "clist_cantus_rules")));
	clist_rules_add_rules(GTK_CLIST(lookup_widget(cantus, "clist_cantus_rules")), rulelist);
}







/**********************************************************************
 * this moves selected rows up, in the rulelist as well as in the gui
 **********************************************************************/
void
rules_rules_up(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	GtkCList *clist = NULL;
	
	GList *selection = NULL;
	gchar *foo = NULL;
	gint row = 0;
	gint max = -1;
	gboolean stopit = FALSE;

	clist = GTK_CLIST(lookup_widget(rules, "clist_rules_rules"));
	
// count rows	
	while(gtk_clist_get_text (clist, ++max, 0, &foo));

// swap each selected items datapointer with the previous one (if present)
	while (row < max)
	{
		selection = clist->selection;
		while (selection)
		{
			if((gint)selection->data==row)
			{
				if(gtk_clist_get_text (clist, row-1, 0, &foo))
				{
// move row up int the gui.
					gtk_clist_swap_rows (clist, row, row-1);
// and in the rulelist
					foo = g_list_nth_data(rulelist, row-1);
					g_list_nth(rulelist, row-1)->data = g_list_nth_data(rulelist, row);
					g_list_nth(rulelist, row)->data = foo;
				}
				else
					stopit=TRUE;
				break;
			}
			selection = selection->next;
		}
		if(stopit) break;
		++row;
	}
}










/**********************************************************************
 * this moves selected rows down, in the rulelist as well as in the gui
 **********************************************************************/
void
rules_rules_down(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	GtkCList *clist = NULL;
	
	GList *selection = NULL;
	gchar *foo = NULL;
	gint row = -1;
	gboolean stopit = FALSE;

	clist = GTK_CLIST(lookup_widget(rules, "clist_rules_rules"));

// count rows in clist
	while(gtk_clist_get_text (clist, ++row, 0, &foo));

// and toggle swap each selected item with its followed one (if one is present)
	while (row >= 0)
	{
		selection = clist->selection;
		while (selection)
		{
			if((gint)selection->data==row)
			{
				if(gtk_clist_get_text(clist, row+1, 0, &foo))
				{
// move row down int the gui.
					gtk_clist_swap_rows(clist, row, row+1);
// and in the rulelist
					foo = g_list_nth_data(rulelist, row+1);
					g_list_nth(rulelist, row+1)->data = g_list_nth_data(rulelist, row);
					g_list_nth(rulelist, row)->data = foo;
				}
				else
					stopit=TRUE;
				break;
			}
			selection = selection->next;
		}
		if(stopit) break;
		--row;
	}
}




void
rules_remove_selected(void)
{
	extern GtkWidget *rules;
	extern GList *rulelist;
	extern GList *queue;
	
	GList *selected = NULL;
	GtkCList *clist = NULL;
	gchar *example = NULL;
	
	clist = GTK_CLIST(lookup_widget(rules, "clist_rules_rules"));
	
// Get a list of all filenames selected
	selected = clist_get_selected(clist);
	
// Remove items from the list which are already in the queue.
	rulelist = g_list_remove_matching(rulelist, selected);
	g_list_free(selected);

// Update queue lists
	gtk_clist_clear(clist);
	clist_rules_add_rules(clist, rulelist);
	
	example = rules_plugs_update_example(queue);
	gtk_label_set_text(GTK_LABEL(lookup_widget(rules, "label_rules_example")),
		example);
}






// saves a preset
gint
rules_dialog_save(gchar *presetname)
{
	gchar *my_options[200][3]={
// Tab "Tagging rules"
		{ "check_rules_v1tag_get", "rules preset", "v1 to filename" },
		{ "entry_rules_v1tag_get", "rules preset", "v1 to filename format" },

		{ "check_rules_v2tag_get", "rules preset", "v2 to filename" },
		{ "entry_rules_v2tag_get", "rules preset", "v2 to filename format" },

		{ "check_rules_vorbistag_get", "rules preset", "ogg to filename" },
		{ "entry_rules_vorbistag_get", "rules preset", "ogg to filename format" },
		
		{ "check_rules_tag_cleanup", "rules preset", "cleanup v1tag" },

		{ "check_rules_tag_v2tov1", "rules preset", "copy v2 to v1" },
		{ "check_rules_tag_v1tov2", "rules preset", "copy v1 to v2" },
		
		{ "check_rules_tag_deleteid3v1", "rules preset", "delete v1" },
		{ "check_rules_tag_deleteid3v2", "rules preset", "delete v2" },
		{ "check_rules_tag_deletevorbis", "rules preset", "delete ogg" },
		
		{ "check_rules_tag_twodigit2tag", "rules preset", "twodigit as track to tag" },
		
// Tab "General rules"
		{ "check_rules_perms", "rules preset", "set perms" },
		{ "option_rules_perms_mode", "rules preset", "set perms mode" },
		{ "option_rules_perms_rwx", "rules preset", "set perms rwx" },

		{ "check_rules_replace", "rules preset", "replace" },
		{ "entry_rules_replace_from", "rules preset", "replace from" },
		{ "entry_rules_replace_to", "rules preset", "replace by" },

		{ "check_rules_remove", "rules preset", "remove parentheses" },
		{ "option_rules_remove_leading", "rules preset", "remove parentheses which" },
		
		{ "check_rules_forcecc", "rules preset", "forcecc" },
		{ "option_rules_forcecc_case", "rules preset", "forcecc case" },
		
		{ "check_rules_increase", "rules preset", "increase first digit" },
		{ "spin_rules_increase_by", "rules preset", "increase first digit by" },
		
		{ "check_rules_killspace", "rules preset", "wipe spaces" },
		{ "option_rules_killspace", "rules preset", "wipe spaces at" },
		
		{ "check_rules_stripchar", "rules preset", "strip chars before digit" },
		{ "check_rules_twodigit", "rules preset", "first number twodigit" },
		{ "check_rules_insertspace", "rules preset", "insert space before uppercase" },
		{ "check_rules_stripspace", "rules preset", "strip double spaces" },
		
// Tab "More rules"
		{ "check_rules_format", "rules preset", "format" },
		{ "entry_rules_fromformat", "rules preset", "format from" },
		{ "entry_rules_toformat", "rules preset", "format to" },
		
		{ "check_rules_deletechar", "rules preset", "delete char" },
		{ "spin_rules_deletechar_from", "rules preset", "delete char from" },
		{ "spin_rules_deletechar_to", "rules preset", "delete char to" },

		{ "check_rules_delete_occurence", "rules preset", "delete char before occurence" },
		{ "option_rules_delete_occurence", "rules preset", "delete char before occurence first last" },
		{ "entry_rules_delete_occurence", "rules preset", "delete char befor occurence of" },
		
		{ "check_rules_move_file_to", "rules preset", "move file" },
		{ "entry_rules_move_file_to", "rules preset", "move file to" },
		
// The clist
		{ "clist_rules_rules", "rules list preset", "rule" },
		{ "\0", "\0", "\0" }
	};
	
	extern GtkWidget *rules;
	gchar category[2048];
	gchar temp[2048];
	gchar somevalues[2048];
	Rule *rule = NULL;
	gchar *config = malloc(10000);
	gint i=-1, f=0;
	gchar *foo = NULL;
	
// read old configfile
	config_read(config, 10000);
	
	while(*my_options[++i][0]!='\0')
	{
		snprintf(category, 2048, "%s %s", my_options[i][1], presetname);
		if(!strncmp(my_options[i][0], "check", 5))
		{
			if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(rules, my_options[i][0]))) )
				configfile_option_add(config, category, my_options[i][2], "TRUE");
			else
				configfile_option_add(config, category, my_options[i][2], "FALSE");
		}
		else if(!strncmp(my_options[i][0], "entry", 5))
		{
			configfile_option_add(config, category, my_options[i][2],
				gtk_entry_get_text(GTK_ENTRY(lookup_widget(rules, my_options[i][0]))));
		}
		else if(!strncmp(my_options[i][0], "spin", 4))
		{
			sprintf(somevalues, "%i", gtk_spin_button_get_value_as_int(
								GTK_SPIN_BUTTON(lookup_widget(rules, my_options[i][0]))));
			configfile_option_add(config, category, my_options[i][2], somevalues);
		}
		else if(!strncmp(my_options[i][0], "option", 6))
		{
			gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, my_options[i][0]))->child), &foo);
			configfile_option_add(config, category, my_options[i][2], foo);
		}
		else if(!strncmp(my_options[i][0], "clist", 5))
		{
// remove all list entries from the config, to then add the current again.
			configfile_category_remove(config, category);
			f = -1;
			while(gtk_clist_get_text(GTK_CLIST(lookup_widget(rules, my_options[i][0])), ++f, 0, &foo))
			{
				rule = gtk_clist_get_row_data(GTK_CLIST(lookup_widget(rules, my_options[i][0])), f);
				
// append a row number to the option name.
				snprintf(temp, 2048, "%s%i#1", my_options[i][2], f);
// and add the option to the config.
				configfile_option_add(config, category, temp, rule->text);

				snprintf(temp, 2048, "%s%i#2", my_options[i][2], f);
				configfile_option_add(config, category, temp, rule->name);

				snprintf(temp, 2048, "%s%i#3", my_options[i][2], f);
				configfile_option_add(config, category, temp, rule->option1);

				snprintf(temp, 2048, "%s%i#4", my_options[i][2], f);
				configfile_option_add(config, category, temp, rule->option2);
			}
		}
	}

// Put to configfile
	config_write(config);
	free(config);
	return 0;
}








/**********************************************************************
 * This function will load all options from the rule-configfile, and display them
 **********************************************************************/
gint
rules_dialog_load(gchar *presetname)
{
	gchar *my_options[200][3]={
// Tab "Tagging rules"
		{ "check_rules_v1tag_get", "rules preset", "v1 to filename" },
		{ "entry_rules_v1tag_get", "rules preset", "v1 to filename format" },

		{ "check_rules_v2tag_get", "rules preset", "v2 to filename" },
		{ "entry_rules_v2tag_get", "rules preset", "v2 to filename format" },

		{ "check_rules_vorbistag_get", "rules preset", "ogg to filename" },
		{ "entry_rules_vorbistag_get", "rules preset", "ogg to filename format" },
		
		{ "check_rules_tag_cleanup", "rules preset", "cleanup v1tag" },

		{ "check_rules_tag_v2tov1", "rules preset", "copy v2 to v1" },
		{ "check_rules_tag_v1tov2", "rules preset", "copy v1 to v2" },
		{ "check_rules_tag_deletevorbis", "rules preset", "delete ogg" },
		
		{ "check_rules_tag_deleteid3v1", "rules preset", "delete v1" },
		{ "check_rules_tag_deleteid3v2", "rules preset", "delete v2" },
		
		{ "check_rules_tag_twodigit2tag", "rules preset", "twodigit as track to tag" },
		
// Tab "Standard rules"
		{ "check_rules_perms", "rules preset", "set perms" },
		{ "option_rules_perms_mode", "rules preset", "set perms mode" },
		{ "option_rules_perms_rwx", "rules preset", "set perms rwx" },

		{ "check_rules_replace", "rules preset", "replace" },
		{ "entry_rules_replace_from", "rules preset", "replace from" },
		{ "entry_rules_replace_to", "rules preset", "replace by" },

		{ "check_rules_remove", "rules preset", "remove parentheses" },
		{ "option_rules_remove_leading", "rules preset", "remove parentheses which" },
		
		{ "check_rules_forcecc", "rules preset", "forcecc" },
		{ "option_rules_forcecc_case", "rules preset", "forcecc case" },
		
		{ "check_rules_increase", "rules preset", "increase first digit" },
		{ "spin_rules_increase_by", "rules preset", "increase first digit by" },
		
		{ "check_rules_killspace", "rules preset", "wipe spaces" },
		{ "option_rules_killspace", "rules preset", "wipe spaces at" },
		
		{ "check_rules_stripchar", "rules preset", "strip chars before digit" },
		{ "check_rules_twodigit", "rules preset", "first number twodigit" },
		{ "check_rules_insertspace", "rules preset", "insert space before uppercase" },
		{ "check_rules_stripspace", "rules preset", "strip double spaces" },
		
// Tab "More rules"
		{ "check_rules_format", "rules preset", "format" },
		{ "entry_rules_fromformat", "rules preset", "format from" },
		{ "entry_rules_toformat", "rules preset", "format to" },
		
		{ "check_rules_deletechar", "rules preset", "delete char" },
		{ "spin_rules_deletechar_from", "rules preset", "delete char from" },
		{ "spin_rules_deletechar_to", "rules preset", "delete char to" },

		{ "check_rules_delete_occurence", "rules preset", "delete char before occurence" },
		{ "option_rules_delete_occurence", "rules preset", "delete char before occurence first last" },
		{ "entry_rules_delete_occurence", "rules preset", "delete char befor occurence of" },
		
		{ "check_rules_move_file_to", "rules preset", "move file" },
		{ "entry_rules_move_file_to", "rules preset", "move file to" },
		
// The clist
		{ "clist_rules_rules", "rules list preset", "rule" },
		{ "\0", "\0" }
	};
	
	extern GtkWidget *rules;
	extern GList *rulelist;
	Rule *rule = NULL;
	gint i=-1, f=0;
	gchar value[2048];
	gchar rowdata[2048];
	gchar category[2048];
	gchar *config = malloc(10000);

	rulelist = mem_free(rulelist);
	
// read configfile
	config_read(config, 10000);
	
	while(*my_options[++i][0]!='\0')
	{
		snprintf(category, 2048, "%s %s", my_options[i][1], presetname);
		if(!strncmp(my_options[i][0], "check", 5))
		{
			configfile_option_get(config, category, my_options[i][2], value);
			if( !strncmp(value, "TRUE", 4) )
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(rules, my_options[i][0])), TRUE);
			else
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(rules, my_options[i][0])), FALSE);
		}
		else if(!strncmp(my_options[i][0], "entry", 5))
		{
			configfile_option_get(config, category, my_options[i][2], value);
			gtk_entry_set_text(GTK_ENTRY(lookup_widget(rules, my_options[i][0])), value);
		}
		else if(!strncmp(my_options[i][0], "clist", 5))
		{
			f = -1;
			value[0] = '\0';
			snprintf(rowdata, 2048, "%s%i#1", my_options[i][2], ++f);
			while(configfile_option_get(config, category, rowdata, value))
			{
				rule = malloc(sizeof(Rule));
				
				strncpy(rule->text, value, 2048);
				
				snprintf(rowdata, 2048, "%s%i#2", my_options[i][2], f);
				if(configfile_option_get(config, category, rowdata, value))
					strncpy(rule->name, value, 2048);
				
				snprintf(rowdata, 2048, "%s%i#3", my_options[i][2], f);
				if(configfile_option_get(config, category, rowdata, value))
					strncpy(rule->option1, value, 2048);
				
				snprintf(rowdata, 2048, "%s%i#4", my_options[i][2], f);
				if(configfile_option_get(config, category, rowdata, value))
					strncpy(rule->option2, value, 2048);
				
				rulelist = g_list_append(rulelist, rule);
				snprintf(rowdata, 2048, "%s%i#1", my_options[i][2], ++f);
			}
			gtk_clist_clear(GTK_CLIST(lookup_widget(rules, my_options[i][0])));
			clist_rules_add_rules(GTK_CLIST(lookup_widget(rules, my_options[i][0])), rulelist);
		}
		
	}

	free(config);
	return 0;
}




void
rules_presets_update(void)
{
	extern GtkWidget *rules;
	gchar *config = malloc(10000);
	gchar *pconfig = config;
	GList *file = NULL;
	GList *fileitem = NULL;
	GList *presets = NULL;
	gchar *data = NULL;
	gchar *preset = NULL;
	gchar rowdata[2047] = "\0";
	gint i = -1;
	
// read configfile
	config_read(config, 10000);
	
// get the complete config to a glist (so the rows are separated)
	while(*pconfig != '\0')
	{
		while( *pconfig != '\n'
			&& *pconfig != '\0' )
		{
			rowdata[++i] = *pconfig;
			rowdata[i+1] = '\0';
			++pconfig;
		}
		file = g_list_append(file, strdup(rowdata));
		rowdata[0] = '\0';
		
		if(*pconfig == '\0')
			break;
		++pconfig;
		i = -1;
	}

// If the list is empty, return.
	if(!file)
		return;
	
// parse through the glist, looking for the correct category
	fileitem = g_list_first(file);
	while(fileitem)
	{
		data = (gchar *)fileitem->data;
// if the line begins with a "[", we expect an category
		if( *data == '['
			&& *(data + 1) != ']'
			&& *(data + 1) != '\n'
			&& *(data + 1) != '\0' )
		{
// is it a valid preset category?
			if( strncmp(data, "[rules preset ", 14) == 0
				&& *(data + 14) != '\0'
				&& *(data + 14) != ']' )
			{
// ...then add it to the list of presets.
				preset = malloc(256);
				strcpy(preset, data +  14);
				if(strrchr(preset, ']'))
					*strrchr(preset, ']') = '\0';
				presets = g_list_append(presets, preset);
			}
		}
		free(data);
		fileitem = fileitem->next;
	}

// now we don't need the file no more.
	g_list_free(file);
	
// If the list is empty, return.
	if(!presets)
		return;

// Define the content of the combo.
	gtk_combo_set_popdown_strings(GTK_COMBO(lookup_widget(rules, "combo_rules_presets")),
		presets);
	
	free(config);
}



void
rules_preset_delete(gchar *preset)
{
	gchar category[2048];
	gchar *config = malloc(10000);
	
// read configfile
	config_read(config, 10000);
	
	snprintf(category, 2047, "rules preset %s", preset);
	configfile_category_remove(config, category);
	
	snprintf(category, 2047, "rules list preset %s", preset);
	configfile_category_remove(config, category);
	
// Put to configfile
	config_write(config);
	free(config);
}


