/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_EVENTBUS_H
#define HAVE_EVENTBUS_H

#include <iostream>
#include <glib.h>
#include <glib-object.h>
#include <gtkmm.h>
#include "libs/lib_shellpattern.h"

enum EVENTBUS_SIG_TYPES {
  EVENTBUS_SIG_SIGC,
  EVENTBUS_SIG_GCLOSURE
};

typedef struct {
  glong        id;        // A unique identifier for the listener.
  gboolean     invalid;   // Whether or not the listener is invalid.
  const gchar *pattern;   // An event pattern (glob).
  gshort      type;       // SigC-Slot or Closure?
  GClosure    *closure;   // The function (closure) to be called when the event
                          // pattern matches.
  SigC::Slot1<void, void*> sigcslot;  // The function (sigc) to be called when
                                      // the event pattern matches.
} EventBusListener;


class EventBus : public SigC::Object {
protected:
  // Prevent copys.
  EventBus(EventBus &e) { g_assert_not_reached(); }
  // Prevent assignments.
  EventBus& operator=(EventBus &e) { g_assert_not_reached(); }
  
public:
  EventBus();
  ~EventBus();
  
  /* Registers a listener for a specific event pattern; use the returned */
  /* id to unregister the listener. */
  glong add_listener(const gchar *event_pattern, GClosure *closure);
  
  /* Registers a listener for a specific event pattern; use the returned
   * id to unregister the listener. The function to be called is a SigC slot.
   */
  glong add_listener_sigc(const gchar *event_pattern,
                          SigC::Slot1<void, void*> slot);
  
  /* Invalidate the listener with the given id.
   */
  void remove_listener(glong id);
  
  /* Unregister all invalid listeners.
   */
  void delete_invalid_listeners(void);
  
  /* Emits an event in the bus.
   */
  void emit_event(const gchar *event, const GValue *values);
  
  /* Emits an event in the bus, convenience wrapper.
   */
  void emit_event_with_pointer(const gchar *event, gpointer value);
  
  /* Emits an event in the bus, convenience wrapper.
   */
  void emit_event_with_char(const gchar *event, const gchar *value);
  
  /* Emits an event in the bus, convenience wrapper.
   */
  void emit_event_with_int(const gchar *event, gint value);
  
private:
  glong  idpool;          // Holds the id of the listener registered last.
  GList *listeners;       // Holds all listeners.
};


#endif
