/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "plugin_id3copier.h"

//#define _DEBUG_

#ifdef _CPLUSPLUS_
extern "C" {
#endif

/******************************************************************************
 * Plugin specifications.
 ******************************************************************************/
#define PLUGINNAME    "ID3 Copier Plugin"
#define PLUGINLABEL   _("ID3 Tag-Copier")
#define PLUGINDESCR   "Cantus ID3 copier plugin relase 0.1, (c) by Samuel Abels"
#define MAJVERSION    0
#define MINVERSION    1
#define COMPATLEVEL   1
const gchar *pattern[] = {
  "*.mp3",
  NULL
};


/******************************************************************************
 * Plugin-internal variables and types.
 ******************************************************************************/
CantusHash *plugindata;


/******************************************************************************
 * Plugin constructor/destructor.
 ******************************************************************************/
/* Purpose: Plugin initializer.
 */
gint plugin_init(CantusHash *pplugindata)
{
#ifdef _DEBUG_
  printf("id3copier(): plugin_init(): Called.\n");
#endif
  plugindata = pplugindata;
  
  cantushash_set_char(plugindata, "Plugin:Name",                PLUGINNAME);
  cantushash_set_char(plugindata, "Plugin:Label",               PLUGINLABEL);
  cantushash_set_char(plugindata, "Plugin:Description",         PLUGINDESCR);
  cantushash_set_int(plugindata,  "Plugin:MajorVersion",        MAJVERSION);
  cantushash_set_int(plugindata,  "Plugin:MinorVersion",        MINVERSION);
  cantushash_set_int(plugindata,  "Plugin:CompatibilityLevel",  COMPATLEVEL);
  cantushash_set_pointer(plugindata, "Plugin:Pattern",          pattern);
  
  return 0;
}


/* Purpose: Plugin destructor.
 */
gint plugin_destroy(void)
{
#ifdef _DEBUG_
  printf("id3v1(): Hello, I am the ID3V1 plugin's destructor.\n");
#endif
  return 0;
}


/* Purpose: Returns TRUE if the plugin is responsible for handling this
 * filetype, otherwise FALSE.
 */
gboolean plugin_handles(const gchar *filename)
{
#ifdef _DEBUG_
  printf("id3copier(): plugin_handles(): Called.\n");
#endif
  return TRUE;
}


/******************************************************************************
 * Plugin GUI functions.
 ******************************************************************************/
/* Returns the widget tree to show as edit-area.
 * NULL as a return value is forbidden!
 * If this function returns NULL, the plugin will be deactivated.
 */
GtkWidget *plugin_get_uiwidget(gboolean vertical)
{
  TagCopier *copier = new TagCopier(plugindata);
  return copier->editarea_build(vertical);
}

#ifdef _CPLUSPLUS_
}
#endif
