/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "editarea.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
Editarea::Editarea()
{
}


Editarea::~Editarea(void)
{
#ifdef _DEBUG_
  printf(EDITAREANAME "(): Editarea::~Editarea(): Called.\n");
#endif
}


/******************************************************************************
 * Public
 ******************************************************************************/
GtkWidget *Editarea::build(gboolean vertical)
{
  std::list<Gtk::Widget*> focuschain;
  gchar               *str    = NULL;
  Gtk::Table          *top    = NULL;
  Gtk::Label          *label  = NULL;
  Gtk::CheckButton    *check  = NULL;
  Gtk::RadioButton    *radio  = NULL;
  Gtk::Entry          *entry  = NULL;
  Gtk::Button         *button = NULL;
  Gtk::Fixed          *fixed  = NULL;
  Gtk::AttachOptions   yfill  = vertical ? Gtk::FILL : Gtk::FILL|Gtk::EXPAND;
  
  // The main table.
  if (vertical)
    table = new Gtk::Table(11, 2);
  else
    table = new Gtk::Table(6, 6);
  table->set_row_spacings(3);
  table->set_col_spacings(5);
  table->set_border_width(5);
  table->set_col_spacing(1, 0);
  
  // Labels, Entries and CheckButtons.
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("%s", _("Source Tag:"));
  label->set_markup(str);
  g_free(str);
  table->attach(*label, 0, 1, 0, 1, Gtk::FILL, yfill);
  //widgets["Source"] = &combo_tag;
  
  // Radiobuttons (copy direction selector).
  //FIXME: Replace by a Gtk::ComboTextBox as soon as gtkmm2.4 made its way
  //       into Debian testing.
  radio = new Gtk::RadioButton(_("ID3V1"));
  widgets["Source:ID3V1:Check"] = radio;
  radio->signal_toggled().connect(signal_radio_sourcetag_changed);
  focuschain.push_back(radio);
  Gtk::RadioButton::Group group = radio->get_group();
  Gtk::HBox *box = new Gtk::HBox;
  box->set_spacing(3);
  box->pack_start(*radio, Gtk::PACK_SHRINK);
  radio = new Gtk::RadioButton(group, _("ID3V2"));
  widgets["Source:ID3V2:Check"] = radio;
  radio->signal_toggled().connect(signal_radio_sourcetag_changed);
  box->pack_start(*radio, Gtk::PACK_SHRINK);
  radio = new Gtk::RadioButton(group, _("Vorbis"));
  widgets["Source:OGG:Check"] = radio;
  radio->signal_toggled().connect(signal_radio_sourcetag_changed);
  box->pack_start(*radio, Gtk::PACK_SHRINK);
  fixed = new Gtk::Fixed;
  box->pack_start(*fixed);
  //FIXME END.
  
  if (vertical)
    table->attach(*box, 1, 2, 0, 1, Gtk::FILL, yfill);
  else
    table->attach(*box, 1, 4, 0, 1, Gtk::FILL, yfill);
  
  // Labels, Entries and CheckButtons.
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("%s", _("Format:"));
  label->set_markup(str);
  g_free(str);
  table->attach(*label, 0, 1, 1, 2, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  widgets["Format"] = entry;
  entry->signal_changed().connect(signal_format_changed);
  //widgets["Format"] = &combo_pattern;
  if (vertical)
    table->attach(*entry, 1, 2, 1, 2, Gtk::FILL, yfill);
  else
    table->attach(*entry, 1, 4, 1, 2, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Artist:"));
  label->set_markup(str);
  g_free(str);
  table->attach(*label, 0, 1, 2, 3, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Artist"] = label;
  table->attach(*label, 1, 2, 2, 3, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Song:"));
  label->set_markup(str);
  g_free(str);
  table->attach(*label, 0, 1, 3, 4, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Song"] = label;
  table->attach(*label, 1, 2, 3, 4, Gtk::FILL|Gtk::EXPAND, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Album:"));
  label->set_markup(str);
  g_free(str);
  table->attach(*label, 0, 1, 4, 5, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Album"] = label;
  table->attach(*label, 1, 2, 4, 5, Gtk::FILL|Gtk::EXPAND, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Year:"));
  label->set_markup(str);
  g_free(str);
  if (vertical)
    table->attach(*label, 0, 1, 5, 6, Gtk::FILL, yfill);
  else
    table->attach(*label, 2, 3, 2, 3, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Year"] = label;
  if (vertical)
    table->attach(*label, 1, 2, 5, 6, Gtk::FILL|Gtk::EXPAND, yfill);
  else
    table->attach(*label, 3, 4, 2, 3, Gtk::FILL|Gtk::EXPAND, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Track:"));
  label->set_markup(str);
  g_free(str);
  if (vertical)
    table->attach(*label, 0, 1, 6, 7, Gtk::FILL, yfill);
  else
    table->attach(*label, 2, 3, 3, 4, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  label->set_size_request(30, -1);
  widgets["Track"] = label;
  if (vertical)
    table->attach(*label, 1, 2, 6, 7, Gtk::FILL|Gtk::EXPAND, yfill);
  else
    table->attach(*label, 3, 4, 3, 4, Gtk::FILL|Gtk::EXPAND, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Genre:"));
  label->set_markup(str);
  g_free(str);
  if (vertical)
    table->attach(*label, 0, 1, 7, 8, Gtk::FILL, yfill);
  else
    table->attach(*label, 2, 3, 4, 5, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  label->set_size_request(70, -1);
  widgets["Genre"] = label;
  if (vertical)
    table->attach(*label, 1, 2, 7, 8, Gtk::FILL|Gtk::EXPAND, yfill);
  else
    table->attach(*label, 3, 4, 4, 5, Gtk::FILL|Gtk::EXPAND, yfill);
  
  // The filename field.
  label = new Gtk::Label("", 0, 0.5);
  str = g_strdup_printf("<b>%s</b>", _("Filename:"));
  label->set_markup(str);
  g_free(str);
  if (vertical)
    table->attach(*label, 0, 1, 8, 9, Gtk::FILL, yfill);
  else
    table->attach(*label, 0, 1, 5, 6, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Filename"] = label;
  label->set_size_request(-1, 60);
  if (vertical)
    table->attach(*label, 1, 2, 8, 9, Gtk::FILL|Gtk::EXPAND, yfill);
  else
    table->attach(*label, 1, 4, 5, 6, Gtk::FILL|Gtk::EXPAND, yfill);
  
  // Some distance between the fields and the buttons.
  fixed = new Gtk::Fixed;
  fixed->set_size_request(0, -1);
  if (vertical)
    table->attach(*fixed, 0, 2, 9, 10, Gtk::FILL, Gtk::FILL|Gtk::EXPAND);
  else
    table->attach(*fixed, 4, 5, 0, 6, Gtk::FILL, Gtk::FILL|Gtk::EXPAND);
  
  // Buttons
  if (vertical) {
    hvbox = new Gtk::HBox;
    hvbox->set_spacing(6);
    hvbox->set_border_width(3);
    table->attach(*hvbox, 0, 2, 10, 11, Gtk::FILL, Gtk::FILL);
    // Vertical boxes should have something expanding benath the buttons to make
    // them right-aligned.
    fixed = new Gtk::Fixed;
    hvbox->pack_start(*fixed, TRUE, TRUE);
  }
  else {
    hvbox = new Gtk::VBox;
    hvbox->set_spacing(6);
    table->attach(*hvbox, 5, 6, 0, 6, Gtk::FILL, Gtk::FILL);
  }
  
  button = new Gtk::Button(Gtk::Stock::SAVE);
  button->set_size_request(-1, 35);
  if (vertical)
    hvbox->pack_end(*button, FALSE, TRUE);
  else
    hvbox->pack_start(*button, FALSE, TRUE);
  button->signal_clicked().connect(signal_button_save_clicked);
  
  // A container table holding everything.
  top = new Gtk::Table(1, 1);
  top->attach(*table, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND, Gtk::FILL|Gtk::EXPAND);
  top->show_all();
  
  // Set the focus chain.
  table->set_focus_chain(focuschain);
  
  return (GtkWidget*)Glib::unwrap(top);
}


Gtk::Widget *Editarea::get_widget(const gchar *widgetname)
{
  Gtk::Widget *widget = widgets[widgetname];
  if (!widget)
    g_warning("Editarea::get_widget(): Widget not found: %s\n", widgetname);
  g_assert(widget != NULL);
  return widget;
}


void Editarea::set_label_text(const gchar *widgetname, const gchar *str)
{
#ifdef _DEBUG_
  printf("Editarea::~set_label_text(): Called. (%s)\n", str);
#endif
  Gtk::Label *label = (Gtk::Label*)get_widget(widgetname);
  label->set_text(str ? str : "");
}


Glib::ustring Editarea::get_entry_text(const gchar *widgetname)
{
  Gtk::Entry *entry = (Gtk::Entry*)get_widget(widgetname);
  return entry->get_text();
}


gboolean Editarea::get_check_active(const gchar *widgetname)
{
  Gtk::CheckButton *check = (Gtk::CheckButton*)get_widget(widgetname);
  return check->get_active();
}


void Editarea::set_active(gboolean active)
{
  hvbox->set_sensitive(active);
}


/******************************************************************************
 * Private
 ******************************************************************************/
