/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_PREFERENCES_H
#define HAVE_PREFERENCES_H

#include <glib.h>
#include <sigc++/object.h>
#include <sigc++/signal.h>
#include <map>
#include "plugins/cantushashvalue.h"
#include "configfile.h"

class Preferences : public SigC::Object {
protected:
  // Prevent copys.
  Preferences(Preferences &p) { g_assert_not_reached(); }
  // Prevent assignments.
  Preferences& operator=(Preferences &p) { g_assert_not_reached(); }
  
public:
  Preferences(void);
  ~Preferences(void);
  
  /* Triggered whenever something has been changed. */
  SigC::Signal1<void, std::string> signal_changed;
  
  /* Tests all edited preferences for sanity.
   */
  bool check_commit(void);
  
  /* Tests the preference with the given key for sanity.
   */
  bool check_commit(std::string key);
  
  /* Confirms all preferences. This also triggers a Preferences:Changed event.
   */
  bool commit(void);
  
  /* Confirms the preference with the given key. This also triggers a
   * Preferences:Changed event.
   */
  bool commit(std::string key);
  
  /* Set one preference value. Returns always TRUE.
   */
  bool set(std::string key, int type, void *value);
  
  /* Set one preference value (integer).
   */
  void set_int(std::string key, int value);
  
  /* Get one preference value (int).
   */
  int get_int(std::string key);
  
  /* Set one preference value (boolean).
   */
  void set_bool(std::string key, bool value);
  
  /* Get one preference value (char).
   */
  bool get_bool(std::string key);
  
  /* Set one preference value (char).
   */
  void set_char(std::string key, std::string value);
  
  /* Get one preference value (char).
   */
  std::string get_char(std::string key);
  
  /* Walks through all preferences calling the given slot.
   * Args passed to the slot are: The preference name, type (e.g. G_TYPE_INT)
   * and its value.
   * If the slot returns FALSE, list evaluation will be stopped.
   */
  void foreach(SigC::Slot3<bool, std::string, int, void*> slot);
  
protected:
  
  std::map<std::string, CantusHashValue*> prefs;
  std::map<std::string, CantusHashValue*> editedprefs;
};

#endif
