/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_controller.h"

extern Controller controller;
extern Mainwindow mainwindow;

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
/* Constructor.
 */
GUIController::GUIController(void)
{
  preferences = NULL;
  
  controller.eventbus->add_listener_sigc(
      "Preferences:Changed",
      SigC::slot(*this, &GUIController::on_preferences_changed));
  controller.eventbus->add_listener_sigc(
      "Plugin:Responsibility:Changed",
      SigC::slot(*this, &GUIController::on_plugin_responsibility_changed));
  controller.eventbus->add_listener_sigc(
      "File:Rename:Finished",
      SigC::slot(*this, &GUIController::on_file_rename_finished));
  
  mainwindow.signal_menu_file_save_activate.connect(
      SigC::slot(*this, &GUIController::on_menu_file_save_clicked));
  mainwindow.signal_menu_edit_preferences_activate.connect(
      SigC::slot(*this, &GUIController::on_menu_edit_preferences_clicked));
  mainwindow.signal_filebrowser_selection_changed.connect(
      SigC::slot(*this, &GUIController::on_filebrowser_selection_changed));
  mainwindow.signal_pluginarea_widget_removed.connect(
      SigC::slot(*this, &GUIController::on_pluginarea_widget_removed));
  mainwindow.signal_pluginarea1_visibility_changed.connect(
      SigC::slot(*this, &GUIController::on_pluginarea1_visibility_changed));
  mainwindow.signal_pluginarea2_visibility_changed.connect(
      SigC::slot(*this, &GUIController::on_pluginarea2_visibility_changed));
  
  Glib::signal_timeout().connect(
      SigC::slot(*this, &GUIController::on_progressbar_update_poll), 50);
  Glib::signal_timeout().connect(
      SigC::slot(*this, &GUIController::on_filelist_forcerefresh_poll), 2000);
  Glib::signal_timeout().connect(
      SigC::slot(*this, &GUIController::on_filelist_refresh_poll), 200);
}


/* Destructor.
 */
GUIController::~GUIController(void)
{
  if (preferences)
    delete preferences;
}


/******************************************************************************
 * Public
 ******************************************************************************/
void GUIController::init(void)
{
  preferences = new PreferencesWindow(PACKAGE_LIB_DIR "cantus-3.glade",
                                      "preferences");
  preferences->signal_preference_changed.connect(
      SigC::slot(*this, &GUIController::on_preferences_preference_changed));
}


/******************************************************************************
 * Protected
 ******************************************************************************/
// Callback from the preferences window.
void GUIController::on_preferences_preference_changed(std::string key,
                                                      gint type,
                                                      void *data)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_preferences_preference_changed(): Called.\n";
  printf("Key: %s, Type: %i\n", key.c_str(), type);
#endif
  controller.preferences->set(key, type, data);
  controller.preferences->commit(key);
}


// Callback from the engine.
void GUIController::on_preferences_changed(void *key)
{
  if (lock_on_preferences_changed)  // Prevent recursive events.
    return;
  lock_on_preferences_changed = TRUE;
  // Apply the preferences.
  mainwindow.pluginarea1_set_active(
                controller.preferences->get_bool("UIGTK2:Pluginarea1:Visible"));
  mainwindow.pluginarea2_set_active(
                controller.preferences->get_bool("UIGTK2:Pluginarea2:Visible"));
  mainwindow.filebrowser->set_showhidden(
                controller.preferences->get_bool("UIGTK2:Browser:Showhidden"));
  mainwindow.filebrowser->set_filepattern(
                controller.preferences->get_char("UIGTK2:Browser:Filetypes"));
  lock_on_preferences_changed = FALSE;
}


void GUIController::on_menu_file_save_clicked(void)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_menu_save_clicked(): Called.\n";
#endif
  controller.eventbus->emit_event_with_pointer("Filelist:Save:Request", NULL);
}


void GUIController::on_menu_edit_preferences_clicked(void)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_menu_edit_preferences_clicked(): Called.\n";
#endif
  preferences->show();
  // Fill the PreferencesWindow with the preferences.
  controller.preferences->foreach(
                   SigC::slot(*preferences, &PreferencesWindow::update_widget));
}


void GUIController::on_plugin_responsibility_changed(void *data)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_plugin_responsibility_changed(): Called.\n";
#endif
  mainwindow.pluginarea_update((std::list<Plugin*>*)data);
}


void GUIController::on_file_rename_finished(void *data)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_file_rename_finished(): Called.\n";
#endif
  have_renamed = TRUE;
}


void GUIController::on_filebrowser_selection_changed(GList *selection)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_filebrowser_selection_changed(): Called.\n";
  GList *item = selection;
  while (item) {
    printf("GUIController::on_filebrowser_selection_changed(): Selected: %s\n",
                                                               selection->data);
    item = item->next;
  }
#endif
  controller.eventbus->emit_event_with_pointer("GUI:Filelist:Selection:Changed",
                                               selection);
}


void GUIController::on_pluginarea_widget_removed(Plugin *plugin)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_pluginarea_widget_removed(): Called.\n";
#endif
  controller.eventbus->emit_event_with_char("GUI:PluginWidget:Destroyed",
                                            plugin->get_name());
}


void GUIController::on_pluginarea1_visibility_changed(gboolean visible)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_pluginarea1_visibility_changed(): Called.\n";
#endif
  controller.preferences->set_bool("UIGTK2:Pluginarea1:Visible", visible);
  controller.preferences->commit("UIGTK2:Pluginarea1:Visible");
}


void GUIController::on_pluginarea2_visibility_changed(gboolean visible)
{
#ifdef _DEBUG_
  std::cout << "GUIController::on_pluginarea2_visibility_changed(): Called.\n";
#endif
  controller.preferences->set_bool("UIGTK2:Pluginarea2:Visible", visible);
  controller.preferences->commit("UIGTK2:Pluginarea2:Visible");
}


bool GUIController::on_progressbar_update_poll(void)
{
  mainwindow.set_progress(controller.fileinfomanager->get_progress());
  return TRUE;
}


/* Filelist refresh, called every 2 seconds.
 */
bool GUIController::on_filelist_forcerefresh_poll(void)
{
  mainwindow.filebrowser->update(FALSE);
  return TRUE;
}


/* Filelist refresh, called every 200 milliseconds, but updates only if a
 * file has been renamed.
 */
bool GUIController::on_filelist_refresh_poll(void)
{
  if (have_renamed)
    mainwindow.filebrowser->update(FALSE);
  have_renamed = FALSE;
  return TRUE;
}
