/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_PLUGINAREA_H
#define HAVE_PLUGINAREA_H

#include <iostream>
#include <map>
#include <list>
#include <gtkmm.h>
#include "../plugin.h"


class PluginArea : public Gtk::Notebook {
public:
  PluginArea(gboolean is_vertical);
  ~PluginArea();
  
  /* Triggered whenever a widget has been removed. */
  SigC::Signal1<void, Plugin *> signal_widget_removed;
  
  // Operates on single plugins.
  void      plugin_attach(Plugin *plugin);
  void      plugin_remove(Plugin *plugin);
  gboolean  plugin_is_visible(Plugin *plugin);
  
  // Operates on a list of plugins.
  void      plugins_set(std::list<Plugin*> *plugins);
  void      plugins_attach(std::list<Plugin*> *plugins);
  void      plugins_remove(std::list<Plugin*> *plugins);
  
protected:
  std::map<Plugin*, Gtk::Widget*> visibleplugins;
  gboolean  vertical;  // Whether or not the plugin is shown in vertical pos.
  
  void      remove_unneeded(std::list<Plugin*> *required);
  gboolean  in_list(Plugin *plugin, std::list<Plugin*> *required);
};

#endif
