/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_preftree.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
PreferencesTree::PreferencesTree()
{
  // Attach the category liststore to the treeview.
  store = Gtk::ListStore::create(columns);
  set_model(store);
  //append_column("Categories", columns.pixbuf);
  append_column("Categories", columns.caption);
  get_selection()->signal_changed().connect(
                     SigC::slot(*this, &PreferencesTree::on_selection_changed));
}


PreferencesTree::~PreferencesTree()
{
}


/******************************************************************************
 * Public
 ******************************************************************************/
/* Add a category with an icon. */
void PreferencesTree::add(std::string catname, std::string pixmapfile)
{
  Gtk::TreeModel::Row row = *store->append();
  //Glib::RefPtr<Gdk::Pixbuf> pixbuf;
  //pixbuf = Gdk::Pixbuf::create_from_file(pixmapfile);
  //row[columns.pixbuf] = pixbuf;
  row[columns.caption] = catname;
}


void PreferencesTree::on_selection_changed(void)
{
#ifdef _DEBUG_
  printf("PreferencesTree::on_selection_changed(): Called.\n");
#endif
  signal_selection_changed.emit(get_selection()->get_selected());
}
