(* Capstone Disassembler Engine
 * By Nguyen Anh Quynh <aquynh@gmail.com>, 2013> *)

(* architecture specific info of instruction *)
type mips_op_mem = {
	base: int;
	displ: int
}

type mips_op_value =
	| MIPS_OP_INVALID of int
	| MIPS_OP_REG of int
	| MIPS_OP_IMM of int
	| MIPS_OP_MEM of mips_op_mem

type mips_op = {
	value: mips_op_value;
}

type cs_mips = {
	op_count: int;
	operands: mips_op array;
}

(* MIPS registers - including alias registers *)
let _MIPS_REG_INVALID = 0;;
let _MIPS_REG_0 = 1;;
let _MIPS_REG_ZERO = _MIPS_REG_0;;
let _MIPS_REG_1 = 2;;
let _MIPS_REG_AT = _MIPS_REG_1;;
let _MIPS_REG_2 = 3;;
let _MIPS_REG_V0 = _MIPS_REG_2;;
let _MIPS_REG_3 = 4;;
let _MIPS_REG_V1 = _MIPS_REG_3;;
let _MIPS_REG_4 = 5;;
let _MIPS_REG_A0 = _MIPS_REG_4;;
let _MIPS_REG_5 = 6;;
let _MIPS_REG_A1 = _MIPS_REG_5;;
let _MIPS_REG_6 = 7;;
let _MIPS_REG_A2 = _MIPS_REG_6;;
let _MIPS_REG_7 = 8;;
let _MIPS_REG_A3 = _MIPS_REG_7;;
let _MIPS_REG_8 = 9;;
let _MIPS_REG_T0 = _MIPS_REG_8;;
let _MIPS_REG_9 = 10;;
let _MIPS_REG_T1 = _MIPS_REG_9;;
let _MIPS_REG_10 = 11;;
let _MIPS_REG_T2 = _MIPS_REG_10;;
let _MIPS_REG_11 = 12;;
let _MIPS_REG_T3 = _MIPS_REG_11;;
let _MIPS_REG_12 = 13;;
let _MIPS_REG_T4 = _MIPS_REG_12;;
let _MIPS_REG_13 = 14;;
let _MIPS_REG_T5 = _MIPS_REG_13;;
let _MIPS_REG_14 = 15;;
let _MIPS_REG_T6 = _MIPS_REG_14;;
let _MIPS_REG_15 = 16;;
let _MIPS_REG_T7 = _MIPS_REG_15;;
let _MIPS_REG_16 = 17;;
let _MIPS_REG_S0 = _MIPS_REG_16;;
let _MIPS_REG_17 = 18;;
let _MIPS_REG_S1 = _MIPS_REG_17;;
let _MIPS_REG_18 = 19;;
let _MIPS_REG_S2 = _MIPS_REG_18;;
let _MIPS_REG_19 = 20;;
let _MIPS_REG_S3 = _MIPS_REG_19;;
let _MIPS_REG_20 = 21;;
let _MIPS_REG_S4 = _MIPS_REG_20;;
let _MIPS_REG_21 = 22;;
let _MIPS_REG_S5 = _MIPS_REG_21;;
let _MIPS_REG_22 = 23;;
let _MIPS_REG_S6 = _MIPS_REG_22;;
let _MIPS_REG_23 = 24;;
let _MIPS_REG_S7 = _MIPS_REG_23;;
let _MIPS_REG_24 = 25;;
let _MIPS_REG_T8 = _MIPS_REG_24;;
let _MIPS_REG_25 = 26;;
let _MIPS_REG_T9 = _MIPS_REG_25;;
let _MIPS_REG_26 = 27;;
let _MIPS_REG_K0 = _MIPS_REG_26;;
let _MIPS_REG_27 = 28;;
let _MIPS_REG_K1 = _MIPS_REG_27;;
let _MIPS_REG_28 = 29;;
let _MIPS_REG_GP = _MIPS_REG_28;;
let _MIPS_REG_29 = 30;;
let _MIPS_REG_SP = _MIPS_REG_29;;
let _MIPS_REG_30 = 31;;
let _MIPS_REG_FP = _MIPS_REG_30;;
let _MIPS_REG_S8 = _MIPS_REG_30;;
let _MIPS_REG_31 = 32;;
let _MIPS_REG_RA = _MIPS_REG_31;;
let _MIPS_REG_DSPCCOND = 33;;
let _MIPS_REG_DSPCARRY = 34;;
let _MIPS_REG_DSPEFI = 35;;
let _MIPS_REG_DSPOUTFLAG = 36;;
let _MIPS_REG_DSPOUTFLAG16_19 = 37;;
let _MIPS_REG_DSPOUTFLAG20 = 38;;
let _MIPS_REG_DSPOUTFLAG21 = 39;;
let _MIPS_REG_DSPOUTFLAG22 = 40;;
let _MIPS_REG_DSPOUTFLAG23 = 41;;
let _MIPS_REG_DSPPOS = 42;;
let _MIPS_REG_DSPSCOUNT = 43;;
let _MIPS_REG_AC0 = 44;;
let _MIPS_REG_HI0 = _MIPS_REG_AC0;;
let _MIPS_REG_AC1 = 45;;
let _MIPS_REG_HI1 = _MIPS_REG_AC1;;
let _MIPS_REG_AC2 = 46;;
let _MIPS_REG_HI2 = _MIPS_REG_AC2;;
let _MIPS_REG_AC3 = 47;;
let _MIPS_REG_HI3 = _MIPS_REG_AC3;;
let _MIPS_REG_LO0 = _MIPS_REG_HI0;;
let _MIPS_REG_LO1 = _MIPS_REG_HI1;;
let _MIPS_REG_LO2 = _MIPS_REG_HI2;;
let _MIPS_REG_LO3 = _MIPS_REG_HI3;;
let _MIPS_REG_F0 = 48;;
let _MIPS_REG_F1 = 49;;
let _MIPS_REG_F2 = 50;;
let _MIPS_REG_F3 = 51;;
let _MIPS_REG_F4 = 52;;
let _MIPS_REG_F5 = 53;;
let _MIPS_REG_F6 = 54;;
let _MIPS_REG_F7 = 55;;
let _MIPS_REG_F8 = 56;;
let _MIPS_REG_F9 = 57;;
let _MIPS_REG_F10 = 58;;
let _MIPS_REG_F11 = 59;;
let _MIPS_REG_F12 = 60;;
let _MIPS_REG_F13 = 61;;
let _MIPS_REG_F14 = 62;;
let _MIPS_REG_F15 = 63;;
let _MIPS_REG_F16 = 64;;
let _MIPS_REG_F17 = 65;;
let _MIPS_REG_F18 = 66;;
let _MIPS_REG_F19 = 67;;
let _MIPS_REG_F20 = 68;;
let _MIPS_REG_F21 = 69;;
let _MIPS_REG_F22 = 70;;
let _MIPS_REG_F23 = 71;;
let _MIPS_REG_F24 = 72;;
let _MIPS_REG_F25 = 73;;
let _MIPS_REG_F26 = 74;;
let _MIPS_REG_F27 = 75;;
let _MIPS_REG_F28 = 76;;
let _MIPS_REG_F29 = 77;;
let _MIPS_REG_F30 = 78;;
let _MIPS_REG_F31 = 79;;
let _MIPS_REG_FCC0 = 80;;
let _MIPS_REG_FCC1 = 81;;
let _MIPS_REG_FCC2 = 82;;
let _MIPS_REG_FCC3 = 83;;
let _MIPS_REG_FCC4 = 84;;
let _MIPS_REG_FCC5 = 85;;
let _MIPS_REG_FCC6 = 86;;
let _MIPS_REG_FCC7 = 87;;
let _MIPS_REG_W0 = 88;;
let _MIPS_REG_W1 = 89;;
let _MIPS_REG_W2 = 90;;
let _MIPS_REG_W3 = 91;;
let _MIPS_REG_W4 = 92;;
let _MIPS_REG_W5 = 93;;
let _MIPS_REG_W6 = 94;;
let _MIPS_REG_W7 = 95;;
let _MIPS_REG_W8 = 96;;
let _MIPS_REG_W9 = 97;;
let _MIPS_REG_W10 = 98;;
let _MIPS_REG_W11 = 99;;
let _MIPS_REG_W12 = 100;;
let _MIPS_REG_W13 = 101;;
let _MIPS_REG_W14 = 102;;
let _MIPS_REG_W15 = 103;;
let _MIPS_REG_W16 = 104;;
let _MIPS_REG_W17 = 105;;
let _MIPS_REG_W18 = 106;;
let _MIPS_REG_W19 = 107;;
let _MIPS_REG_W20 = 108;;
let _MIPS_REG_W21 = 109;;
let _MIPS_REG_W22 = 110;;
let _MIPS_REG_W23 = 111;;
let _MIPS_REG_W24 = 112;;
let _MIPS_REG_W25 = 113;;
let _MIPS_REG_W26 = 114;;
let _MIPS_REG_W27 = 115;;
let _MIPS_REG_W28 = 116;;
let _MIPS_REG_W29 = 117;;
let _MIPS_REG_W30 = 118;;
let _MIPS_REG_W31 = 119;;
let _MIPS_REG_MAX = 120;;


(* MIPS instructions *)
let _MIPS_INS_INVALID = 0;;
let _MIPS_INS_ABSQ_S = 1;;
let _MIPS_INS_ADD = 2;;
let _MIPS_INS_ADDQH = 3;;
let _MIPS_INS_ADDQH_R = 4;;
let _MIPS_INS_ADDQ = 5;;
let _MIPS_INS_ADDQ_S = 6;;
let _MIPS_INS_ADDSC = 7;;
let _MIPS_INS_ADDS_A = 8;;
let _MIPS_INS_ADDS_S = 9;;
let _MIPS_INS_ADDS_U = 10;;
let _MIPS_INS_ADDUH = 11;;
let _MIPS_INS_ADDUH_R = 12;;
let _MIPS_INS_ADDU = 13;;
let _MIPS_INS_ADDU_S = 14;;
let _MIPS_INS_ADDVI = 15;;
let _MIPS_INS_ADDV = 16;;
let _MIPS_INS_ADDWC = 17;;
let _MIPS_INS_ADD_A = 18;;
let _MIPS_INS_ADDI = 19;;
let _MIPS_INS_ADDIU = 20;;
let _MIPS_INS_AND = 21;;
let _MIPS_INS_ANDI = 22;;
let _MIPS_INS_APPEND = 23;;
let _MIPS_INS_ASUB_S = 24;;
let _MIPS_INS_ASUB_U = 25;;
let _MIPS_INS_AVER_S = 26;;
let _MIPS_INS_AVER_U = 27;;
let _MIPS_INS_AVE_S = 28;;
let _MIPS_INS_AVE_U = 29;;
let _MIPS_INS_BALIGN = 30;;
let _MIPS_INS_BC1F = 31;;
let _MIPS_INS_BC1T = 32;;
let _MIPS_INS_BCLRI = 33;;
let _MIPS_INS_BCLR = 34;;
let _MIPS_INS_BEQ = 35;;
let _MIPS_INS_BGEZ = 36;;
let _MIPS_INS_BGEZAL = 37;;
let _MIPS_INS_BGTZ = 38;;
let _MIPS_INS_BINSLI = 39;;
let _MIPS_INS_BINSL = 40;;
let _MIPS_INS_BINSRI = 41;;
let _MIPS_INS_BINSR = 42;;
let _MIPS_INS_BITREV = 43;;
let _MIPS_INS_BLEZ = 44;;
let _MIPS_INS_BLTZ = 45;;
let _MIPS_INS_BLTZAL = 46;;
let _MIPS_INS_BMNZI = 47;;
let _MIPS_INS_BMNZ = 48;;
let _MIPS_INS_BMZI = 49;;
let _MIPS_INS_BMZ = 50;;
let _MIPS_INS_BNE = 51;;
let _MIPS_INS_BNEGI = 52;;
let _MIPS_INS_BNEG = 53;;
let _MIPS_INS_BNZ = 54;;
let _MIPS_INS_BPOSGE32 = 55;;
let _MIPS_INS_BREAK = 56;;
let _MIPS_INS_BSELI = 57;;
let _MIPS_INS_BSEL = 58;;
let _MIPS_INS_BSETI = 59;;
let _MIPS_INS_BSET = 60;;
let _MIPS_INS_BZ = 61;;
let _MIPS_INS_BEQZ = 62;;
let _MIPS_INS_B = 63;;
let _MIPS_INS_BNEZ = 64;;
let _MIPS_INS_BTEQZ = 65;;
let _MIPS_INS_BTNEZ = 66;;
let _MIPS_INS_CEIL = 67;;
let _MIPS_INS_CEQI = 68;;
let _MIPS_INS_CEQ = 69;;
let _MIPS_INS_CFC1 = 70;;
let _MIPS_INS_CFCMSA = 71;;
let _MIPS_INS_CLEI_S = 72;;
let _MIPS_INS_CLEI_U = 73;;
let _MIPS_INS_CLE_S = 74;;
let _MIPS_INS_CLE_U = 75;;
let _MIPS_INS_CLO = 76;;
let _MIPS_INS_CLTI_S = 77;;
let _MIPS_INS_CLTI_U = 78;;
let _MIPS_INS_CLT_S = 79;;
let _MIPS_INS_CLT_U = 80;;
let _MIPS_INS_CLZ = 81;;
let _MIPS_INS_CMPGDU = 82;;
let _MIPS_INS_CMPGU = 83;;
let _MIPS_INS_CMPU = 84;;
let _MIPS_INS_CMP = 85;;
let _MIPS_INS_COPY_S = 86;;
let _MIPS_INS_COPY_U = 87;;
let _MIPS_INS_CTC1 = 88;;
let _MIPS_INS_CTCMSA = 89;;
let _MIPS_INS_CVT = 90;;
let _MIPS_INS_C = 91;;
let _MIPS_INS_CMPI = 92;;
let _MIPS_INS_DADD = 93;;
let _MIPS_INS_DADDI = 94;;
let _MIPS_INS_DADDIU = 95;;
let _MIPS_INS_DADDU = 96;;
let _MIPS_INS_DCLO = 97;;
let _MIPS_INS_DCLZ = 98;;
let _MIPS_INS_DERET = 99;;
let _MIPS_INS_DEXT = 100;;
let _MIPS_INS_DEXTM = 101;;
let _MIPS_INS_DEXTU = 102;;
let _MIPS_INS_DI = 103;;
let _MIPS_INS_DINS = 104;;
let _MIPS_INS_DINSM = 105;;
let _MIPS_INS_DINSU = 106;;
let _MIPS_INS_DIV_S = 107;;
let _MIPS_INS_DIV_U = 108;;
let _MIPS_INS_DMFC0 = 109;;
let _MIPS_INS_DMFC1 = 110;;
let _MIPS_INS_DMFC2 = 111;;
let _MIPS_INS_DMTC0 = 112;;
let _MIPS_INS_DMTC1 = 113;;
let _MIPS_INS_DMTC2 = 114;;
let _MIPS_INS_DMULT = 115;;
let _MIPS_INS_DMULTU = 116;;
let _MIPS_INS_DOTP_S = 117;;
let _MIPS_INS_DOTP_U = 118;;
let _MIPS_INS_DPADD_S = 119;;
let _MIPS_INS_DPADD_U = 120;;
let _MIPS_INS_DPAQX_SA = 121;;
let _MIPS_INS_DPAQX_S = 122;;
let _MIPS_INS_DPAQ_SA = 123;;
let _MIPS_INS_DPAQ_S = 124;;
let _MIPS_INS_DPAU = 125;;
let _MIPS_INS_DPAX = 126;;
let _MIPS_INS_DPA = 127;;
let _MIPS_INS_DPSQX_SA = 128;;
let _MIPS_INS_DPSQX_S = 129;;
let _MIPS_INS_DPSQ_SA = 130;;
let _MIPS_INS_DPSQ_S = 131;;
let _MIPS_INS_DPSUB_S = 132;;
let _MIPS_INS_DPSUB_U = 133;;
let _MIPS_INS_DPSU = 134;;
let _MIPS_INS_DPSX = 135;;
let _MIPS_INS_DPS = 136;;
let _MIPS_INS_DROTR = 137;;
let _MIPS_INS_DROTR32 = 138;;
let _MIPS_INS_DROTRV = 139;;
let _MIPS_INS_DSBH = 140;;
let _MIPS_INS_DDIV = 141;;
let _MIPS_INS_DSHD = 142;;
let _MIPS_INS_DSLL = 143;;
let _MIPS_INS_DSLL32 = 144;;
let _MIPS_INS_DSLLV = 145;;
let _MIPS_INS_DSRA = 146;;
let _MIPS_INS_DSRA32 = 147;;
let _MIPS_INS_DSRAV = 148;;
let _MIPS_INS_DSRL = 149;;
let _MIPS_INS_DSRL32 = 150;;
let _MIPS_INS_DSRLV = 151;;
let _MIPS_INS_DSUBU = 152;;
let _MIPS_INS_DDIVU = 153;;
let _MIPS_INS_DIV = 154;;
let _MIPS_INS_DIVU = 155;;
let _MIPS_INS_EI = 156;;
let _MIPS_INS_ERET = 157;;
let _MIPS_INS_EXT = 158;;
let _MIPS_INS_EXTP = 159;;
let _MIPS_INS_EXTPDP = 160;;
let _MIPS_INS_EXTPDPV = 161;;
let _MIPS_INS_EXTPV = 162;;
let _MIPS_INS_EXTRV_RS = 163;;
let _MIPS_INS_EXTRV_R = 164;;
let _MIPS_INS_EXTRV_S = 165;;
let _MIPS_INS_EXTRV = 166;;
let _MIPS_INS_EXTR_RS = 167;;
let _MIPS_INS_EXTR_R = 168;;
let _MIPS_INS_EXTR_S = 169;;
let _MIPS_INS_EXTR = 170;;
let _MIPS_INS_ABS = 171;;
let _MIPS_INS_FADD = 172;;
let _MIPS_INS_FCAF = 173;;
let _MIPS_INS_FCEQ = 174;;
let _MIPS_INS_FCLASS = 175;;
let _MIPS_INS_FCLE = 176;;
let _MIPS_INS_FCLT = 177;;
let _MIPS_INS_FCNE = 178;;
let _MIPS_INS_FCOR = 179;;
let _MIPS_INS_FCUEQ = 180;;
let _MIPS_INS_FCULE = 181;;
let _MIPS_INS_FCULT = 182;;
let _MIPS_INS_FCUNE = 183;;
let _MIPS_INS_FCUN = 184;;
let _MIPS_INS_FDIV = 185;;
let _MIPS_INS_FEXDO = 186;;
let _MIPS_INS_FEXP2 = 187;;
let _MIPS_INS_FEXUPL = 188;;
let _MIPS_INS_FEXUPR = 189;;
let _MIPS_INS_FFINT_S = 190;;
let _MIPS_INS_FFINT_U = 191;;
let _MIPS_INS_FFQL = 192;;
let _MIPS_INS_FFQR = 193;;
let _MIPS_INS_FILL = 194;;
let _MIPS_INS_FLOG2 = 195;;
let _MIPS_INS_FLOOR = 196;;
let _MIPS_INS_FMADD = 197;;
let _MIPS_INS_FMAX_A = 198;;
let _MIPS_INS_FMAX = 199;;
let _MIPS_INS_FMIN_A = 200;;
let _MIPS_INS_FMIN = 201;;
let _MIPS_INS_MOV = 202;;
let _MIPS_INS_FMSUB = 203;;
let _MIPS_INS_FMUL = 204;;
let _MIPS_INS_MUL = 205;;
let _MIPS_INS_NEG = 206;;
let _MIPS_INS_FRCP = 207;;
let _MIPS_INS_FRINT = 208;;
let _MIPS_INS_FRSQRT = 209;;
let _MIPS_INS_FSAF = 210;;
let _MIPS_INS_FSEQ = 211;;
let _MIPS_INS_FSLE = 212;;
let _MIPS_INS_FSLT = 213;;
let _MIPS_INS_FSNE = 214;;
let _MIPS_INS_FSOR = 215;;
let _MIPS_INS_FSQRT = 216;;
let _MIPS_INS_SQRT = 217;;
let _MIPS_INS_FSUB = 218;;
let _MIPS_INS_SUB = 219;;
let _MIPS_INS_FSUEQ = 220;;
let _MIPS_INS_FSULE = 221;;
let _MIPS_INS_FSULT = 222;;
let _MIPS_INS_FSUNE = 223;;
let _MIPS_INS_FSUN = 224;;
let _MIPS_INS_FTINT_S = 225;;
let _MIPS_INS_FTINT_U = 226;;
let _MIPS_INS_FTQ = 227;;
let _MIPS_INS_FTRUNC_S = 228;;
let _MIPS_INS_FTRUNC_U = 229;;
let _MIPS_INS_HADD_S = 230;;
let _MIPS_INS_HADD_U = 231;;
let _MIPS_INS_HSUB_S = 232;;
let _MIPS_INS_HSUB_U = 233;;
let _MIPS_INS_ILVEV = 234;;
let _MIPS_INS_ILVL = 235;;
let _MIPS_INS_ILVOD = 236;;
let _MIPS_INS_ILVR = 237;;
let _MIPS_INS_INS = 238;;
let _MIPS_INS_INSERT = 239;;
let _MIPS_INS_INSV = 240;;
let _MIPS_INS_INSVE = 241;;
let _MIPS_INS_J = 242;;
let _MIPS_INS_JAL = 243;;
let _MIPS_INS_JALR = 244;;
let _MIPS_INS_JR = 245;;
let _MIPS_INS_JRC = 246;;
let _MIPS_INS_JALRC = 247;;
let _MIPS_INS_LB = 248;;
let _MIPS_INS_LBUX = 249;;
let _MIPS_INS_LBU = 250;;
let _MIPS_INS_LD = 251;;
let _MIPS_INS_LDC1 = 252;;
let _MIPS_INS_LDC2 = 253;;
let _MIPS_INS_LDI = 254;;
let _MIPS_INS_LDL = 255;;
let _MIPS_INS_LDR = 256;;
let _MIPS_INS_LDXC1 = 257;;
let _MIPS_INS_LH = 258;;
let _MIPS_INS_LHX = 259;;
let _MIPS_INS_LHU = 260;;
let _MIPS_INS_LL = 261;;
let _MIPS_INS_LLD = 262;;
let _MIPS_INS_LSA = 263;;
let _MIPS_INS_LUXC1 = 264;;
let _MIPS_INS_LUI = 265;;
let _MIPS_INS_LW = 266;;
let _MIPS_INS_LWC1 = 267;;
let _MIPS_INS_LWC2 = 268;;
let _MIPS_INS_LWL = 269;;
let _MIPS_INS_LWR = 270;;
let _MIPS_INS_LWX = 271;;
let _MIPS_INS_LWXC1 = 272;;
let _MIPS_INS_LWU = 273;;
let _MIPS_INS_LI = 274;;
let _MIPS_INS_MADD = 275;;
let _MIPS_INS_MADDR_Q = 276;;
let _MIPS_INS_MADDU = 277;;
let _MIPS_INS_MADDV = 278;;
let _MIPS_INS_MADD_Q = 279;;
let _MIPS_INS_MAQ_SA = 280;;
let _MIPS_INS_MAQ_S = 281;;
let _MIPS_INS_MAXI_S = 282;;
let _MIPS_INS_MAXI_U = 283;;
let _MIPS_INS_MAX_A = 284;;
let _MIPS_INS_MAX_S = 285;;
let _MIPS_INS_MAX_U = 286;;
let _MIPS_INS_MFC0 = 287;;
let _MIPS_INS_MFC1 = 288;;
let _MIPS_INS_MFC2 = 289;;
let _MIPS_INS_MFHC1 = 290;;
let _MIPS_INS_MFHI = 291;;
let _MIPS_INS_MFLO = 292;;
let _MIPS_INS_MINI_S = 293;;
let _MIPS_INS_MINI_U = 294;;
let _MIPS_INS_MIN_A = 295;;
let _MIPS_INS_MIN_S = 296;;
let _MIPS_INS_MIN_U = 297;;
let _MIPS_INS_MODSUB = 298;;
let _MIPS_INS_MOD_S = 299;;
let _MIPS_INS_MOD_U = 300;;
let _MIPS_INS_MOVE = 301;;
let _MIPS_INS_MOVF = 302;;
let _MIPS_INS_MOVN = 303;;
let _MIPS_INS_MOVT = 304;;
let _MIPS_INS_MOVZ = 305;;
let _MIPS_INS_MSUB = 306;;
let _MIPS_INS_MSUBR_Q = 307;;
let _MIPS_INS_MSUBU = 308;;
let _MIPS_INS_MSUBV = 309;;
let _MIPS_INS_MSUB_Q = 310;;
let _MIPS_INS_MTC0 = 311;;
let _MIPS_INS_MTC1 = 312;;
let _MIPS_INS_MTC2 = 313;;
let _MIPS_INS_MTHC1 = 314;;
let _MIPS_INS_MTHI = 315;;
let _MIPS_INS_MTHLIP = 316;;
let _MIPS_INS_MTLO = 317;;
let _MIPS_INS_MULEQ_S = 318;;
let _MIPS_INS_MULEU_S = 319;;
let _MIPS_INS_MULQ_RS = 320;;
let _MIPS_INS_MULQ_S = 321;;
let _MIPS_INS_MULR_Q = 322;;
let _MIPS_INS_MULSAQ_S = 323;;
let _MIPS_INS_MULSA = 324;;
let _MIPS_INS_MULT = 325;;
let _MIPS_INS_MULTU = 326;;
let _MIPS_INS_MULV = 327;;
let _MIPS_INS_MUL_Q = 328;;
let _MIPS_INS_MUL_S = 329;;
let _MIPS_INS_NLOC = 330;;
let _MIPS_INS_NLZC = 331;;
let _MIPS_INS_NMADD = 332;;
let _MIPS_INS_NMSUB = 333;;
let _MIPS_INS_NOR = 334;;
let _MIPS_INS_NORI = 335;;
let _MIPS_INS_NOT = 336;;
let _MIPS_INS_OR = 337;;
let _MIPS_INS_ORI = 338;;
let _MIPS_INS_PACKRL = 339;;
let _MIPS_INS_PCKEV = 340;;
let _MIPS_INS_PCKOD = 341;;
let _MIPS_INS_PCNT = 342;;
let _MIPS_INS_PICK = 343;;
let _MIPS_INS_PRECEQU = 344;;
let _MIPS_INS_PRECEQ = 345;;
let _MIPS_INS_PRECEU = 346;;
let _MIPS_INS_PRECRQU_S = 347;;
let _MIPS_INS_PRECRQ = 348;;
let _MIPS_INS_PRECRQ_RS = 349;;
let _MIPS_INS_PRECR = 350;;
let _MIPS_INS_PRECR_SRA = 351;;
let _MIPS_INS_PRECR_SRA_R = 352;;
let _MIPS_INS_PREPEND = 353;;
let _MIPS_INS_RADDU = 354;;
let _MIPS_INS_RDDSP = 355;;
let _MIPS_INS_RDHWR = 356;;
let _MIPS_INS_REPLV = 357;;
let _MIPS_INS_REPL = 358;;
let _MIPS_INS_ROTR = 359;;
let _MIPS_INS_ROTRV = 360;;
let _MIPS_INS_ROUND = 361;;
let _MIPS_INS_RESTORE = 362;;
let _MIPS_INS_SAT_S = 363;;
let _MIPS_INS_SAT_U = 364;;
let _MIPS_INS_SB = 365;;
let _MIPS_INS_SC = 366;;
let _MIPS_INS_SCD = 367;;
let _MIPS_INS_SD = 368;;
let _MIPS_INS_SDC1 = 369;;
let _MIPS_INS_SDC2 = 370;;
let _MIPS_INS_SDL = 371;;
let _MIPS_INS_SDR = 372;;
let _MIPS_INS_SDXC1 = 373;;
let _MIPS_INS_SEB = 374;;
let _MIPS_INS_SEH = 375;;
let _MIPS_INS_SH = 376;;
let _MIPS_INS_SHF = 377;;
let _MIPS_INS_SHILO = 378;;
let _MIPS_INS_SHILOV = 379;;
let _MIPS_INS_SHLLV = 380;;
let _MIPS_INS_SHLLV_S = 381;;
let _MIPS_INS_SHLL = 382;;
let _MIPS_INS_SHLL_S = 383;;
let _MIPS_INS_SHRAV = 384;;
let _MIPS_INS_SHRAV_R = 385;;
let _MIPS_INS_SHRA = 386;;
let _MIPS_INS_SHRA_R = 387;;
let _MIPS_INS_SHRLV = 388;;
let _MIPS_INS_SHRL = 389;;
let _MIPS_INS_SLDI = 390;;
let _MIPS_INS_SLD = 391;;
let _MIPS_INS_SLL = 392;;
let _MIPS_INS_SLLI = 393;;
let _MIPS_INS_SLLV = 394;;
let _MIPS_INS_SLT = 395;;
let _MIPS_INS_SLTI = 396;;
let _MIPS_INS_SLTIU = 397;;
let _MIPS_INS_SLTU = 398;;
let _MIPS_INS_SPLATI = 399;;
let _MIPS_INS_SPLAT = 400;;
let _MIPS_INS_SRA = 401;;
let _MIPS_INS_SRAI = 402;;
let _MIPS_INS_SRARI = 403;;
let _MIPS_INS_SRAR = 404;;
let _MIPS_INS_SRAV = 405;;
let _MIPS_INS_SRL = 406;;
let _MIPS_INS_SRLI = 407;;
let _MIPS_INS_SRLRI = 408;;
let _MIPS_INS_SRLR = 409;;
let _MIPS_INS_SRLV = 410;;
let _MIPS_INS_ST = 411;;
let _MIPS_INS_SUBQH = 412;;
let _MIPS_INS_SUBQH_R = 413;;
let _MIPS_INS_SUBQ = 414;;
let _MIPS_INS_SUBQ_S = 415;;
let _MIPS_INS_SUBSUS_U = 416;;
let _MIPS_INS_SUBSUU_S = 417;;
let _MIPS_INS_SUBS_S = 418;;
let _MIPS_INS_SUBS_U = 419;;
let _MIPS_INS_SUBUH = 420;;
let _MIPS_INS_SUBUH_R = 421;;
let _MIPS_INS_SUBU = 422;;
let _MIPS_INS_SUBU_S = 423;;
let _MIPS_INS_SUBVI = 424;;
let _MIPS_INS_SUBV = 425;;
let _MIPS_INS_SUXC1 = 426;;
let _MIPS_INS_SW = 427;;
let _MIPS_INS_SWC1 = 428;;
let _MIPS_INS_SWC2 = 429;;
let _MIPS_INS_SWL = 430;;
let _MIPS_INS_SWR = 431;;
let _MIPS_INS_SWXC1 = 432;;
let _MIPS_INS_SYNC = 433;;
let _MIPS_INS_SYSCALL = 434;;
let _MIPS_INS_SAVE = 435;;
let _MIPS_INS_TEQ = 436;;
let _MIPS_INS_TEQI = 437;;
let _MIPS_INS_TGE = 438;;
let _MIPS_INS_TGEI = 439;;
let _MIPS_INS_TGEIU = 440;;
let _MIPS_INS_TGEU = 441;;
let _MIPS_INS_TLT = 442;;
let _MIPS_INS_TLTI = 443;;
let _MIPS_INS_TLTU = 444;;
let _MIPS_INS_TNE = 445;;
let _MIPS_INS_TNEI = 446;;
let _MIPS_INS_TRUNC = 447;;
let _MIPS_INS_TLTIU = 448;;
let _MIPS_INS_VSHF = 449;;
let _MIPS_INS_WAIT = 450;;
let _MIPS_INS_WRDSP = 451;;
let _MIPS_INS_WSBH = 452;;
let _MIPS_INS_XOR = 453;;
let _MIPS_INS_XORI = 454;;
let _MIPS_INS_NOP = 455;;
let _MIPS_INS_MAX = 456;;


(* MIPS group of instructions *)
let _MIPS_GRP_INVALID = 0;;
let _MIPS_GRP_BITCOUNT = 1;;
let _MIPS_GRP_DSP = 2;;
let _MIPS_GRP_DSPR2 = 3;;
let _MIPS_GRP_FPIDX = 4;;
let _MIPS_GRP_MSA = 5;;
let _MIPS_GRP_MIPS32R2 = 6;;
let _MIPS_GRP_MIPS64 = 7;;
let _MIPS_GRP_MIPS64R2 = 8;;
let _MIPS_GRP_SEINREG = 9;;
let _MIPS_GRP_STDENC = 10;;
let _MIPS_GRP_SWAP = 11;;
let _MIPS_GRP_MICROMIPS = 12;;
let _MIPS_GRP_MIPS16MODE = 13;;
let _MIPS_GRP_FP64BIT = 14;;
let _MIPS_GRP_NONANSFPMATH = 15;;
let _MIPS_GRP_NOTFP64BIT = 16;;
let _MIPS_GRP_RELOCSTATIC = 17;;
let _MIPS_GRP_MAX = 18;;

