// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
use super::*;
pub const D3D11_16BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xffff;
pub const D3D11_32BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xffffffff;
pub const D3D11_8BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xff;
pub const D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: DWORD = 9;
pub const D3D11_CLIP_OR_CULL_DISTANCE_COUNT: DWORD = 8;
pub const D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: DWORD = 2;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: DWORD = 14;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: DWORD = 15;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT: DWORD = 16;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: DWORD = 15;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: DWORD = 64;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: DWORD = 128;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: DWORD = 128;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT: DWORD = 16;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT: DWORD = 16;
pub const D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: DWORD = 32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COUNT: DWORD = 4096;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: DWORD = 3;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS: DWORD = 3;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: DWORD = 10;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: c_long = -10;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: c_long = -8;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: DWORD = 7;
pub const D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 256;
pub const D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: DWORD = 64;
pub const D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 240;
pub const D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: DWORD = 68;
pub const D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 224;
pub const D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: DWORD = 72;
pub const D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 208;
pub const D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: DWORD = 76;
pub const D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 192;
pub const D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: DWORD = 84;
pub const D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 176;
pub const D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: DWORD = 92;
pub const D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 160;
pub const D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: DWORD = 100;
pub const D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 144;
pub const D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: DWORD = 112;
pub const D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 128;
pub const D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: DWORD = 128;
pub const D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 112;
pub const D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: DWORD = 144;
pub const D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 96;
pub const D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: DWORD = 168;
pub const D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 80;
pub const D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: DWORD = 204;
pub const D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 64;
pub const D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: DWORD = 256;
pub const D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 48;
pub const D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: DWORD = 340;
pub const D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 32;
pub const D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: DWORD = 512;
pub const D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 16;
pub const D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: DWORD = 768;
pub const D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: DWORD = 1;
pub const D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: DWORD = 256;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: DWORD = 768;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_X: DWORD = 768;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_Y: DWORD = 768;
pub const D3D11_CS_4_X_UAV_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: DWORD = 65535;
pub const D3D11_CS_TGSM_REGISTER_COUNT: DWORD = 8192;
pub const D3D11_CS_TGSM_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_CS_THREADGROUPID_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADGROUPID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADID_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_X: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_Y: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_Z: DWORD = 64;
pub const D3D11_CS_THREAD_GROUP_MIN_X: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MIN_Y: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MIN_Z: DWORD = 1;
pub const D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: DWORD = 16384;
pub const D3D11_DEFAULT_BLEND_FACTOR_ALPHA: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_BLUE: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_GREEN: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_RED: FLOAT = 1.0;
pub const D3D11_DEFAULT_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D11_DEFAULT_DEPTH_BIAS: DWORD = 0;
pub const D3D11_DEFAULT_DEPTH_BIAS_CLAMP: FLOAT = 0.0;
pub const D3D11_DEFAULT_MAX_ANISOTROPY: DWORD = 16;
pub const D3D11_DEFAULT_MIP_LOD_BIAS: FLOAT = 0.0;
pub const D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX: DWORD = 0;
pub const D3D11_DEFAULT_SAMPLE_MASK: DWORD = 0xffffffff;
pub const D3D11_DEFAULT_SCISSOR_ENDX: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_ENDY: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_STARTX: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_STARTY: DWORD = 0;
pub const D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: FLOAT = 0.0;
pub const D3D11_DEFAULT_STENCIL_READ_MASK: DWORD = 0xff;
pub const D3D11_DEFAULT_STENCIL_REFERENCE: DWORD = 0;
pub const D3D11_DEFAULT_STENCIL_WRITE_MASK: DWORD = 0xff;
pub const D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_HEIGHT: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_MAX_DEPTH: FLOAT = 0.0;
pub const D3D11_DEFAULT_VIEWPORT_MIN_DEPTH: FLOAT = 0.0;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTX: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTY: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_WIDTH: DWORD = 0;
pub const D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: DWORD = 3968;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: DWORD = 1;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D11_FLOAT32_MAX: FLOAT = 3.402823466E+38;
pub const D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: FLOAT = 2.4;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: FLOAT = 1.0;
pub const D3D11_FLOAT_TO_SRGB_OFFSET: FLOAT = 0.055;
pub const D3D11_FLOAT_TO_SRGB_SCALE_1: FLOAT = 12.92;
pub const D3D11_FLOAT_TO_SRGB_SCALE_2: FLOAT = 1.055;
pub const D3D11_FLOAT_TO_SRGB_THRESHOLD: FLOAT = 0.0031308;
pub const D3D11_FTOI_INSTRUCTION_MAX_INPUT: FLOAT = 2147483647.999;
pub const D3D11_FTOI_INSTRUCTION_MIN_INPUT: FLOAT = -2147483648.999;
pub const D3D11_FTOU_INSTRUCTION_MAX_INPUT: FLOAT = 4294967295.999;
pub const D3D11_FTOU_INSTRUCTION_MIN_INPUT: FLOAT = 0.0;
pub const D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_REGISTER_VERTICES: DWORD = 32;
pub const D3D11_GS_MAX_INSTANCE_COUNT: DWORD = 32;
pub const D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: DWORD = 1024;
pub const D3D11_GS_OUTPUT_ELEMENTS: DWORD = 32;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: DWORD = 0xffffffff;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: DWORD = 0xffffffff;
pub const D3D11_HS_MAXTESSFACTOR_LOWER_BOUND: FLOAT = 1.0;
pub const D3D11_HS_MAXTESSFACTOR_UPPER_BOUND: FLOAT = 64.0;
pub const D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: DWORD = 3968;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: DWORD = 128;
pub const D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: DWORD = 0;
pub const D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY: DWORD = 0;
pub const D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: DWORD = 0;
pub const D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: DWORD = 1;
pub const D3D11_IA_INSTANCE_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT: DWORD = 32;
pub const D3D11_IA_PRIMITIVE_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: DWORD = 128;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: DWORD = 0xffffffff;
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER: DWORD = 0xffffffff;
pub const D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: DWORD = 0xffffffff;
pub const D3D11_KEEP_UNORDERED_ACCESS_VIEWS: DWORD = 0xffffffff;
pub const D3D11_LINEAR_GAMMA: FLOAT = 1.0;
pub const D3D11_MAJOR_VERSION: DWORD = 11;
pub const D3D11_MAX_BORDER_COLOR_COMPONENT: FLOAT = 1.0;
pub const D3D11_MAX_DEPTH: FLOAT = 1.0;
pub const D3D11_MAX_MAXANISOTROPY: DWORD = 16;
pub const D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT: DWORD = 32;
pub const D3D11_MAX_POSITION_VALUE: FLOAT = 3.402823466E+34;
pub const D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP: DWORD = 17;
pub const D3D11_MINOR_VERSION: DWORD = 0;
pub const D3D11_MIN_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D11_MIN_DEPTH: FLOAT = 0.0;
pub const D3D11_MIN_MAXANISOTROPY: DWORD = 0;
pub const D3D11_MIP_LOD_BIAS_MAX: FLOAT = 15.99;
pub const D3D11_MIP_LOD_BIAS_MIN: FLOAT = -16.0;
pub const D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_MIP_LOD_RANGE_BIT_COUNT: DWORD = 8;
pub const D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: FLOAT = 1.4;
pub const D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: DWORD = 0;
pub const D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 15;
pub const D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 16;
pub const D3D11_PS_CS_UAV_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_CS_UAV_REGISTER_COUNT: DWORD = 8;
pub const D3D11_PS_CS_UAV_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_PS_CS_UAV_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_PS_FRONTFACING_DEFAULT_VALUE: DWORD = 0xffffffff;
pub const D3D11_PS_FRONTFACING_FALSE_VALUE: DWORD = 0;
pub const D3D11_PS_FRONTFACING_TRUE_VALUE: DWORD = 0xffffffff;
pub const D3D11_PS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_PS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_PS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.0;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT: DWORD = 1;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COUNT: DWORD = 1;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_REGISTER_COUNT: DWORD = 8;
pub const D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.5;
pub const D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT: DWORD = 16;
pub const D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: DWORD = 27;
pub const D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: DWORD = 4096;
pub const D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: DWORD = 32;
pub const D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: DWORD = 32;
pub const D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: DWORD = 1024;
pub const D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: DWORD = 4096;
pub const D3D11_REQ_MAXANISOTROPY: DWORD = 16;
pub const D3D11_REQ_MIP_LEVELS: DWORD = 15;
pub const D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: DWORD = 2048;
pub const D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: DWORD = 16384;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: DWORD = 128;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: FLOAT = 0.25;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: DWORD = 2048;
pub const D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: DWORD = 20;
pub const D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURE1D_U_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURECUBE_DIMENSION: DWORD = 16384;
pub const D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: DWORD = 0;
pub const D3D11_SHADER_MAJOR_VERSION: DWORD = 5;
pub const D3D11_SHADER_MAX_INSTANCES: DWORD = 65535;
pub const D3D11_SHADER_MAX_INTERFACES: DWORD = 253;
pub const D3D11_SHADER_MAX_INTERFACE_CALL_SITES: DWORD = 4096;
pub const D3D11_SHADER_MAX_TYPES: DWORD = 65535;
pub const D3D11_SHADER_MINOR_VERSION: DWORD = 0;
pub const D3D11_SHIFT_INSTRUCTION_PAD_VALUE: DWORD = 0;
pub const D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: DWORD = 5;
pub const D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT: DWORD = 8;
pub const D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES: DWORD = 2048;
pub const D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: DWORD = 512;
pub const D3D11_SO_BUFFER_SLOT_COUNT: DWORD = 4;
pub const D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP: DWORD = 0xffffffff;
pub const D3D11_SO_NO_RASTERIZED_STREAM: DWORD = 0xffffffff;
pub const D3D11_SO_OUTPUT_COMPONENT_COUNT: DWORD = 128;
pub const D3D11_SO_STREAM_COUNT: DWORD = 4;
pub const D3D11_SPEC_DATE_DAY: DWORD = 16;
pub const D3D11_SPEC_DATE_MONTH: DWORD = 05;
pub const D3D11_SPEC_DATE_YEAR: DWORD = 2011;
pub const D3D11_SPEC_VERSION: FLOAT = 1.07;
pub const D3D11_SRGB_GAMMA: FLOAT = 2.2;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_1: FLOAT = 12.92;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_2: FLOAT = 1.055;
pub const D3D11_SRGB_TO_FLOAT_EXPONENT: FLOAT = 2.4;
pub const D3D11_SRGB_TO_FLOAT_OFFSET: FLOAT = 0.055;
pub const D3D11_SRGB_TO_FLOAT_THRESHOLD: FLOAT = 0.04045;
pub const D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: FLOAT = 0.5;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: DWORD = 64;
pub const D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: DWORD = 4;
pub const D3D11_STANDARD_PIXEL_COMPONENT_COUNT: DWORD = 128;
pub const D3D11_STANDARD_PIXEL_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_VECTOR_SIZE: DWORD = 4;
pub const D3D11_STANDARD_VERTEX_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: DWORD = 64;
pub const D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: DWORD = 63;
pub const D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: DWORD = 2;
pub const D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: DWORD = 1;
pub const D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: DWORD = 1;
pub const D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 16;
pub const D3D11_UNBOUND_MEMORY_ACCESS_RESULT: DWORD = 0;
pub const D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: DWORD = 15;
pub const D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: DWORD = 16;
pub const D3D11_VIEWPORT_BOUNDS_MAX: DWORD = 32767;
pub const D3D11_VIEWPORT_BOUNDS_MIN: c_long = -32768;
pub const D3D11_VS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_VS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_VS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_VS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_VS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: DWORD = 10;
pub const D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: DWORD = 25;
pub const D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: DWORD = 25;
pub const D3D11_1_UAV_SLOT_COUNT: DWORD = 64;
pub const D3D11_2_TILED_RESOURCE_TILE_SIZE_IN_BYTES: DWORD = 65536;
ENUM!{enum D3D11_INPUT_CLASSIFICATION {
    D3D11_INPUT_PER_VERTEX_DATA = 0,
    D3D11_INPUT_PER_INSTANCE_DATA = 1,
}}
pub const D3D11_APPEND_ALIGNED_ELEMENT: DWORD = 0xffffffff;
STRUCT!{struct D3D11_INPUT_ELEMENT_DESC {
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    Format: DXGI_FORMAT,
    InputSlot: UINT,
    AlignedByteOffset: UINT,
    InputSlotClass: D3D11_INPUT_CLASSIFICATION,
    InstanceDataStepRate: UINT,
}}
ENUM!{enum D3D11_FILL_MODE {
    D3D11_FILL_WIREFRAME = 2,
    D3D11_FILL_SOLID = 3,
}}
pub type D3D11_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY;
pub type D3D11_PRIMITIVE = D3D_PRIMITIVE;
ENUM!{enum D3D11_CULL_MODE {
    D3D11_CULL_NONE = 1,
    D3D11_CULL_FRONT = 2,
    D3D11_CULL_BACK = 3,
}}
STRUCT!{struct D3D11_SO_DECLARATION_ENTRY {
    Stream: UINT,
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    StartComponent: BYTE,
    ComponentCount: BYTE,
    OutputSlot: BYTE,
}}
STRUCT!{struct D3D11_VIEWPORT {
    TopLeftX: FLOAT,
    TopLeftY: FLOAT,
    Width: FLOAT,
    Height: FLOAT,
    MinDepth: FLOAT,
    MaxDepth: FLOAT,
}}
STRUCT!{struct D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    VertexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartVertexLocation: UINT,
    StartInstanceLocation: UINT,
}}
STRUCT!{struct D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    IndexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartIndexLocation: UINT,
    BaseVertexLocation: INT,
    StartInstanceLocation: UINT,
}}
ENUM!{enum D3D11_RESOURCE_DIMENSION {
    D3D11_RESOURCE_DIMENSION_UNKNOWN = 0,
    D3D11_RESOURCE_DIMENSION_BUFFER = 1,
    D3D11_RESOURCE_DIMENSION_TEXTURE1D = 2,
    D3D11_RESOURCE_DIMENSION_TEXTURE2D = 3,
    D3D11_RESOURCE_DIMENSION_TEXTURE3D = 4,
}}
pub type D3D11_SRV_DIMENSION = D3D_SRV_DIMENSION;
ENUM!{enum D3D11_DSV_DIMENSION {
    D3D11_DSV_DIMENSION_UNKNOWN = 0,
    D3D11_DSV_DIMENSION_TEXTURE1D = 1,
    D3D11_DSV_DIMENSION_TEXTURE1DARRAY = 2,
    D3D11_DSV_DIMENSION_TEXTURE2D = 3,
    D3D11_DSV_DIMENSION_TEXTURE2DARRAY = 4,
    D3D11_DSV_DIMENSION_TEXTURE2DMS = 5,
    D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY = 6,
}}
ENUM!{enum D3D11_RTV_DIMENSION {
    D3D11_RTV_DIMENSION_UNKNOWN = 0,
    D3D11_RTV_DIMENSION_BUFFER = 1,
    D3D11_RTV_DIMENSION_TEXTURE1D = 2,
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_RTV_DIMENSION_TEXTURE2D = 4,
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_RTV_DIMENSION_TEXTURE2DMS = 6,
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D11_RTV_DIMENSION_TEXTURE3D = 8,
}}
ENUM!{enum D3D11_UAV_DIMENSION {
    D3D11_UAV_DIMENSION_UNKNOWN = 0,
    D3D11_UAV_DIMENSION_BUFFER = 1,
    D3D11_UAV_DIMENSION_TEXTURE1D = 2,
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_UAV_DIMENSION_TEXTURE2D = 4,
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_UAV_DIMENSION_TEXTURE3D = 8,
}}
ENUM!{enum D3D11_USAGE {
    D3D11_USAGE_DEFAULT = 0,
    D3D11_USAGE_IMMUTABLE = 1,
    D3D11_USAGE_DYNAMIC = 2,
    D3D11_USAGE_STAGING = 3,
}}
FLAGS!{enum D3D11_BIND_FLAG {
    D3D11_BIND_VERTEX_BUFFER = 0x1,
    D3D11_BIND_INDEX_BUFFER = 0x2,
    D3D11_BIND_CONSTANT_BUFFER = 0x4,
    D3D11_BIND_SHADER_RESOURCE = 0x8,
    D3D11_BIND_STREAM_OUTPUT = 0x10,
    D3D11_BIND_RENDER_TARGET = 0x20,
    D3D11_BIND_DEPTH_STENCIL = 0x40,
    D3D11_BIND_UNORDERED_ACCESS = 0x80,
    D3D11_BIND_DECODER = 0x200,
    D3D11_BIND_VIDEO_ENCODER = 0x400,
}}
FLAGS!{enum D3D11_CPU_ACCESS_FLAG {
    D3D11_CPU_ACCESS_WRITE = 0x10000,
    D3D11_CPU_ACCESS_READ = 0x20000,
}}
FLAGS!{enum D3D11_RESOURCE_MISC_FLAG {
    D3D11_RESOURCE_MISC_GENERATE_MIPS = 0x1,
    D3D11_RESOURCE_MISC_SHARED = 0x2,
    D3D11_RESOURCE_MISC_TEXTURECUBE = 0x4,
    D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS = 0x10,
    D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS = 0x20,
    D3D11_RESOURCE_MISC_BUFFER_STRUCTURED = 0x40,
    D3D11_RESOURCE_MISC_RESOURCE_CLAMP = 0x80,
    D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX = 0x100,
    D3D11_RESOURCE_MISC_GDI_COMPATIBLE = 0x200,
    D3D11_RESOURCE_MISC_SHARED_NTHANDLE = 0x800,
    D3D11_RESOURCE_MISC_RESTRICTED_CONTENT = 0x1000,
    D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE = 0x2000,
    D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE_DRIVER = 0x4000,
    D3D11_RESOURCE_MISC_GUARDED = 0x8000,
    D3D11_RESOURCE_MISC_TILE_POOL = 0x20000,
    D3D11_RESOURCE_MISC_TILED = 0x40000,
    D3D11_RESOURCE_MISC_HW_PROTECTED = 0x80000,
}}
ENUM!{enum D3D11_MAP {
    D3D11_MAP_READ = 1,
    D3D11_MAP_WRITE = 2,
    D3D11_MAP_READ_WRITE = 3,
    D3D11_MAP_WRITE_DISCARD = 4,
    D3D11_MAP_WRITE_NO_OVERWRITE = 5,
}}
FLAGS!{enum D3D11_MAP_FLAG {
    D3D11_MAP_FLAG_DO_NOT_WAIT = 0x100000,
}}
FLAGS!{enum D3D11_RAISE_FLAG {
    D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR = 0x1,
}}
FLAGS!{enum D3D11_CLEAR_FLAG {
    D3D11_CLEAR_DEPTH = 0x1,
    D3D11_CLEAR_STENCIL = 0x2,
}}
pub type D3D11_RECT = RECT;
STRUCT!{struct D3D11_BOX {
    left: UINT,
    top: UINT,
    front: UINT,
    right: UINT,
    bottom: UINT,
    back: UINT,
}}
RIDL!{interface ID3D11DeviceChild(ID3D11DeviceChildVtbl): IUnknown(IUnknownVtbl) {
    fn GetDevice(&mut self, ppDevice: *mut *mut ID3D11Device) -> (),
    fn GetPrivateData(
        &mut self, guid: REFGUID, pDataSize: *mut UINT, pData: *mut c_void
    ) -> HRESULT,
    fn SetPrivateData(
        &mut self, guid: REFGUID, DataSize: UINT, pData: *const c_void
    ) -> HRESULT,
    fn SetPrivateDataInterface(&mut self, guid: REFGUID, pData: *const IUnknown) -> HRESULT
}}
ENUM!{enum D3D11_COMPARISON_FUNC {
    D3D11_COMPARISON_NEVER = 1,
    D3D11_COMPARISON_LESS = 2,
    D3D11_COMPARISON_EQUAL = 3,
    D3D11_COMPARISON_LESS_EQUAL = 4,
    D3D11_COMPARISON_GREATER = 5,
    D3D11_COMPARISON_NOT_EQUAL = 6,
    D3D11_COMPARISON_GREATER_EQUAL = 7,
    D3D11_COMPARISON_ALWAYS = 8,
}}
ENUM!{enum D3D11_DEPTH_WRITE_MASK {
    D3D11_DEPTH_WRITE_MASK_ZERO = 0,
    D3D11_DEPTH_WRITE_MASK_ALL = 1,
}}
ENUM!{enum D3D11_STENCIL_OP {
    D3D11_STENCIL_OP_KEEP = 1,
    D3D11_STENCIL_OP_ZERO = 2,
    D3D11_STENCIL_OP_REPLACE = 3,
    D3D11_STENCIL_OP_INCR_SAT = 4,
    D3D11_STENCIL_OP_DECR_SAT = 5,
    D3D11_STENCIL_OP_INVERT = 6,
    D3D11_STENCIL_OP_INCR = 7,
    D3D11_STENCIL_OP_DECR = 8,
}}
STRUCT!{struct D3D11_DEPTH_STENCILOP_DESC {
    StencilFailOp: D3D11_STENCIL_OP,
    StencilDepthFailOp: D3D11_STENCIL_OP,
    StencilPassOp: D3D11_STENCIL_OP,
    StencilFunc: D3D11_COMPARISON_FUNC,
}}
STRUCT!{struct D3D11_DEPTH_STENCIL_DESC {
    DepthEnable: BOOL,
    DepthWriteMask: D3D11_DEPTH_WRITE_MASK,
    DepthFunc: D3D11_COMPARISON_FUNC,
    StencilEnable: BOOL,
    StencilReadMask: UINT8,
    StencilWriteMask: UINT8,
    FrontFace: D3D11_DEPTH_STENCILOP_DESC,
    BackFace: D3D11_DEPTH_STENCILOP_DESC,
}}
RIDL!{interface ID3D11DepthStencilState(ID3D11DepthStencilStateVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_DEPTH_STENCIL_DESC) -> ()
}}
ENUM!{enum D3D11_BLEND {
    D3D11_BLEND_ZERO = 1,
    D3D11_BLEND_ONE = 2,
    D3D11_BLEND_SRC_COLOR = 3,
    D3D11_BLEND_INV_SRC_COLOR = 4,
    D3D11_BLEND_SRC_ALPHA = 5,
    D3D11_BLEND_INV_SRC_ALPHA = 6,
    D3D11_BLEND_DEST_ALPHA = 7,
    D3D11_BLEND_INV_DEST_ALPHA = 8,
    D3D11_BLEND_DEST_COLOR = 9,
    D3D11_BLEND_INV_DEST_COLOR = 10,
    D3D11_BLEND_SRC_ALPHA_SAT = 11,
    D3D11_BLEND_BLEND_FACTOR = 14,
    D3D11_BLEND_INV_BLEND_FACTOR = 15,
    D3D11_BLEND_SRC1_COLOR = 16,
    D3D11_BLEND_INV_SRC1_COLOR = 17,
    D3D11_BLEND_SRC1_ALPHA = 18,
    D3D11_BLEND_INV_SRC1_ALPHA = 19,
}}
ENUM!{enum D3D11_BLEND_OP {
    D3D11_BLEND_OP_ADD = 1,
    D3D11_BLEND_OP_SUBTRACT = 2,
    D3D11_BLEND_OP_REV_SUBTRACT = 3,
    D3D11_BLEND_OP_MIN = 4,
    D3D11_BLEND_OP_MAX = 5,
}}
FLAGS!{enum D3D11_COLOR_WRITE_ENABLE {
    D3D11_COLOR_WRITE_ENABLE_RED = 1,
    D3D11_COLOR_WRITE_ENABLE_GREEN = 2,
    D3D11_COLOR_WRITE_ENABLE_BLUE = 4,
    D3D11_COLOR_WRITE_ENABLE_ALPHA = 8,
    D3D11_COLOR_WRITE_ENABLE_ALL = D3D11_COLOR_WRITE_ENABLE_RED.0 | D3D11_COLOR_WRITE_ENABLE_GREEN.0 |
        D3D11_COLOR_WRITE_ENABLE_BLUE.0 | D3D11_COLOR_WRITE_ENABLE_ALPHA.0,
}}
STRUCT!{struct D3D11_RENDER_TARGET_BLEND_DESC {
    BlendEnable: BOOL,
    SrcBlend: D3D11_BLEND,
    DestBlend: D3D11_BLEND,
    BlendOp: D3D11_BLEND_OP,
    SrcBlendAlpha: D3D11_BLEND,
    DestBlendAlpha: D3D11_BLEND,
    BlendOpAlpha: D3D11_BLEND_OP,
    RenderTargetWriteMask: UINT8,
}}
STRUCT!{struct D3D11_BLEND_DESC {
    AlphaToCoverageEnable: BOOL,
    IndependentBlendEnable: BOOL,
    RenderTarget: [D3D11_RENDER_TARGET_BLEND_DESC; 8],
}}
RIDL!{interface ID3D11BlendState(ID3D11BlendStateVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_BLEND_DESC) -> ()
}}
STRUCT!{struct D3D11_RASTERIZER_DESC {
    FillMode: D3D11_FILL_MODE,
    CullMode: D3D11_CULL_MODE,
    FrontCounterClockwise: BOOL,
    DepthBias: INT,
    DepthBiasClamp: FLOAT,
    SlopeScaledDepthBias: FLOAT,
    DepthClipEnable: BOOL,
    ScissorEnable: BOOL,
    MultisampleEnable: BOOL,
    AntialiasedLineEnable: BOOL,
}}
RIDL!{interface ID3D11RasterizerState(ID3D11RasterizerStateVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_RASTERIZER_DESC) -> ()
}}
STRUCT!{struct D3D11_SUBRESOURCE_DATA {
    pSysMem: *const c_void,
    SysMemPitch: UINT,
    SysMemSlicePitch: UINT,
}}
STRUCT!{struct D3D11_MAPPED_SUBRESOURCE {
    pData: *mut c_void,
    RowPitch: UINT,
    DepthPitch: UINT,
}}
RIDL!{interface ID3D11Resource(ID3D11ResourceVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetType(&mut self, pResourceDimension: *mut D3D11_RESOURCE_DIMENSION) -> (),
    fn SetEvictionPriority(&mut self, EvictionPriority: UINT) -> (),
    fn GetEvictionPriority(&mut self) -> UINT
}}
STRUCT!{struct D3D11_BUFFER_DESC {
    ByteWidth: UINT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
    StructureByteStride: UINT,
}}
RIDL!{interface ID3D11Buffer(ID3D11BufferVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_BUFFER_DESC) -> ()
}}
STRUCT!{struct D3D11_TEXTURE1D_DESC {
    Width: UINT,
    MipLevels: UINT,
    ArraySize: UINT,
    Format: DXGI_FORMAT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{interface ID3D11Texture1D(ID3D11Texture1DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_TEXTURE1D_DESC) -> ()
}}
STRUCT!{struct D3D11_TEXTURE2D_DESC {
    Width: UINT,
    Height: UINT,
    MipLevels: UINT,
    ArraySize: UINT,
    Format: DXGI_FORMAT,
    SampleDesc: DXGI_SAMPLE_DESC,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{interface ID3D11Texture2D(ID3D11Texture2DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_TEXTURE2D_DESC) -> ()
}}
STRUCT!{struct D3D11_TEXTURE3D_DESC {
    Width: UINT,
    Height: UINT,
    Depth: UINT,
    MipLevels: UINT,
    Format: DXGI_FORMAT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{interface ID3D11Texture3D(ID3D11Texture3DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_TEXTURE3D_DESC) -> ()
}}
ENUM!{enum D3D11_TEXTURECUBE_FACE {
    D3D11_TEXTURECUBE_FACE_POSITIVE_X = 0,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_X = 1,
    D3D11_TEXTURECUBE_FACE_POSITIVE_Y = 2,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Y = 3,
    D3D11_TEXTURECUBE_FACE_POSITIVE_Z = 4,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Z = 5,
}}
RIDL!{interface ID3D11View(ID3D11ViewVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetResource(&mut self, ppResource: *mut *mut ID3D11Resource) -> ()
}}
STRUCT!{struct D3D11_BUFFER_SRV {
    u1: UINT,
    u2: UINT,
}}
UNION!{D3D11_BUFFER_SRV, u1, FirstElement, FirstElement_mut, UINT}
UNION!{D3D11_BUFFER_SRV, u1, ElementOffset, ElementOffset_mut, UINT}
UNION!{D3D11_BUFFER_SRV, u2, NumElements, NumElements_mut, UINT}
UNION!{D3D11_BUFFER_SRV, u2, ElementWidth, ElementWidth_mut, UINT}
FLAGS!{enum D3D11_BUFFEREX_SRV_FLAG {
    D3D11_BUFFEREX_SRV_FLAG_RAW = 0x1,
}}
STRUCT!{struct D3D11_BUFFEREX_SRV {
    FirstElement: UINT,
    NumElements: UINT,
    Flags: UINT,
}}
STRUCT!{struct D3D11_TEX1D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEXCUBE_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEXCUBE_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    First2DArrayFace: UINT,
    NumCubes: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_SRV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_SRV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_SHADER_RESOURCE_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension:  D3D11_SRV_DIMENSION,
    u: [UINT; 4],
}}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Buffer, Buffer_mut, D3D11_BUFFER_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture1D, Texture1D_mut, D3D11_TEX1D_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture1DArray, Texture1DArray_mut,
    D3D11_TEX1D_ARRAY_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture2D, Texture2D_mut, D3D11_TEX2D_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture2DArray, Texture2DArray_mut,
    D3D11_TEX2D_ARRAY_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture2DMS, Texture2DMS_mut, D3D11_TEX2DMS_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture2DMSArray, Texture2DMSArray_mut,
    D3D11_TEX2DMS_ARRAY_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, Texture3D, Texture3D_mut, D3D11_TEX3D_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, TextureCube, TextureCube_mut, D3D11_TEXCUBE_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, TextureCubeArray, TextureCubeArray_mut,
    D3D11_TEXCUBE_ARRAY_SRV}
UNION!{D3D11_SHADER_RESOURCE_VIEW_DESC, u, BufferEx, BufferEx_mut, D3D11_BUFFEREX_SRV}
RIDL!{interface ID3D11ShaderResourceView(ID3D11ShaderResourceViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_SHADER_RESOURCE_VIEW_DESC) -> ()
}}
STRUCT!{struct D3D11_BUFFER_RTV {
    u1: UINT,
    u2: UINT,
}}
UNION!{D3D11_BUFFER_RTV, u1, FirstElement, FirstElement_mut, UINT}
UNION!{D3D11_BUFFER_RTV, u1, ElementOffset, ElementOffset_mut, UINT}
UNION!{D3D11_BUFFER_RTV, u2, NumElements, NumElements_mut, UINT}
UNION!{D3D11_BUFFER_RTV, u2, ElementWidth, ElementWidth_mut, UINT}
STRUCT!{struct D3D11_TEX1D_RTV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_RTV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_RTV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_RTV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_RTV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
STRUCT!{struct D3D11_RENDER_TARGET_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_RTV_DIMENSION,
    u: [UINT; 3],
}}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Buffer, Buffer_mut, D3D11_BUFFER_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture1D, Texture1D_mut, D3D11_TEX1D_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture1DArray, Texture1DArray_mut,
    D3D11_TEX1D_ARRAY_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture2D, Texture2D_mut, D3D11_TEX2D_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture2DArray, Texture2DArray_mut,
    D3D11_TEX2D_ARRAY_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture2DMS, Texture2DMS_mut, D3D11_TEX2DMS_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture2DMSArray,Texture2DMSArray_mut,
    D3D11_TEX2DMS_ARRAY_RTV}
UNION!{D3D11_RENDER_TARGET_VIEW_DESC, u, Texture3D, Texture3D_mut, D3D11_TEX3D_RTV}
RIDL!{interface ID3D11RenderTargetView(ID3D11RenderTargetViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_RENDER_TARGET_VIEW_DESC) -> ()
}}
STRUCT!{struct D3D11_TEX1D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_DSV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_DSV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
FLAGS!{enum D3D11_DSV_FLAG{
    D3D11_DSV_READ_ONLY_DEPTH = 0x1,
    D3D11_DSV_READ_ONLY_STENCIL = 0x2,
}}
STRUCT!{struct D3D11_DEPTH_STENCIL_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_DSV_DIMENSION,
    Flags: UINT,
    u: [UINT; 3],
}}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture1D, Texture1D_mut, D3D11_TEX1D_DSV}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture1DArray, Texture1DArray_mut,
    D3D11_TEX1D_ARRAY_DSV}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture2D, Texture2D_mut, D3D11_TEX2D_DSV}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture2DArray, Texture2DArray_mut,
    D3D11_TEX2D_ARRAY_DSV}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture2DMS, Texture2DMS_mut, D3D11_TEX2DMS_DSV}
UNION!{D3D11_DEPTH_STENCIL_VIEW_DESC, u, Texture2DMSArray, Texture2DMSArray_mut,
    D3D11_TEX2DMS_ARRAY_DSV}
RIDL!{interface ID3D11DepthStencilView(ID3D11DepthStencilViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_DEPTH_STENCIL_VIEW_DESC) -> ()
}}
FLAGS!{enum D3D11_BUFFER_UAV_FLAG {
    D3D11_BUFFER_UAV_FLAG_RAW = 0x1,
    D3D11_BUFFER_UAV_FLAG_APPEND = 0x2,
    D3D11_BUFFER_UAV_FLAG_COUNTER = 0x4,
}}
STRUCT!{struct D3D11_BUFFER_UAV {
    FirstElement: UINT,
    NumElements: UINT,
    Flags: UINT,
}}
STRUCT!{struct D3D11_TEX1D_UAV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_UAV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_UAV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
STRUCT!{struct D3D11_UNORDERED_ACCESS_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_UAV_DIMENSION,
    u: [UINT; 3],
}}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Buffer, Buffer_mut, D3D11_BUFFER_UAV}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Texture1D, Texture1D_mut, D3D11_TEX1D_UAV}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Texture1DArray, Texture1DArray_mut,
    D3D11_TEX1D_ARRAY_UAV}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Texture2D, Texture2D_mut, D3D11_TEX2D_UAV}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Texture2DArray, Texture2DArray_mut,
    D3D11_TEX2D_ARRAY_UAV}
UNION!{D3D11_UNORDERED_ACCESS_VIEW_DESC, u, Texture3D, Texture3D_mut, D3D11_TEX3D_UAV}
RIDL!{interface ID3D11UnorderedAccessView(ID3D11UnorderedAccessViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_UNORDERED_ACCESS_VIEW_DESC) -> ()
}}
RIDL!{interface ID3D11VertexShader(ID3D11VertexShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11HullShader(ID3D11HullShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11DomainShader(ID3D11DomainShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11GeometryShader(ID3D11GeometryShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11PixelShader(ID3D11PixelShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11ComputeShader(ID3D11ComputeShaderVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{interface ID3D11InputLayout(ID3D11InputLayoutVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
ENUM!{enum D3D11_FILTER {
    D3D11_FILTER_MIN_MAG_MIP_POINT = 0,
    D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x1,
    D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x4,
    D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x5,
    D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
    D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
    D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
    D3D11_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
    D3D11_FILTER_ANISOTROPIC = 0x55,
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT = 0x80,
    D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR = 0x81,
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x84,
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR = 0x85,
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT = 0x90,
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x91,
    D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT = 0x94,
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR = 0x95,
    D3D11_FILTER_COMPARISON_ANISOTROPIC = 0xd5,
    D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT = 0x100,
    D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x101,
    D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x104,
    D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x105,
    D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x110,
    D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x111,
    D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x114,
    D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR = 0x115,
    D3D11_FILTER_MINIMUM_ANISOTROPIC = 0x155,
    D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT = 0x180,
    D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x181,
    D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x184,
    D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x185,
    D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x190,
    D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x191,
    D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x194,
    D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR = 0x195,
    D3D11_FILTER_MAXIMUM_ANISOTROPIC = 0x1d5,
}}
ENUM!{enum D3D11_FILTER_TYPE {
    D3D11_FILTER_TYPE_POINT = 0,
    D3D11_FILTER_TYPE_LINEAR = 1,
}}
ENUM!{enum D3D11_FILTER_REDUCTION_TYPE {
    D3D11_FILTER_REDUCTION_TYPE_STANDARD = 0,
    D3D11_FILTER_REDUCTION_TYPE_COMPARISON = 1,
    D3D11_FILTER_REDUCTION_TYPE_MINIMUM = 2,
    D3D11_FILTER_REDUCTION_TYPE_MAXIMUM = 3,
}}
pub const D3D11_FILTER_REDUCTION_TYPE_MASK: DWORD = 0x3;
pub const D3D11_FILTER_REDUCTION_TYPE_SHIFT: DWORD = 7;
pub const D3D11_FILTER_TYPE_MASK: DWORD = 0x3;
pub const D3D11_MIN_FILTER_SHIFT: DWORD = 4;
pub const D3D11_MAG_FILTER_SHIFT: DWORD = 2;
pub const D3D11_MIP_FILTER_SHIFT: DWORD = 0;
pub const D3D11_COMPARISON_FILTERING_BIT: DWORD = 0x80;
pub const D3D11_ANISOTROPIC_FILTERING_BIT: DWORD = 0x40;
ENUM!{enum D3D11_TEXTURE_ADDRESS_MODE {
    D3D11_TEXTURE_ADDRESS_WRAP = 1,
    D3D11_TEXTURE_ADDRESS_MIRROR = 2,
    D3D11_TEXTURE_ADDRESS_CLAMP = 3,
    D3D11_TEXTURE_ADDRESS_BORDER = 4,
    D3D11_TEXTURE_ADDRESS_MIRROR_ONCE = 5,
}}
STRUCT!{struct D3D11_SAMPLER_DESC {
    Filter:  D3D11_FILTER,
    AddressU: D3D11_TEXTURE_ADDRESS_MODE,
    AddressV: D3D11_TEXTURE_ADDRESS_MODE,
    AddressW: D3D11_TEXTURE_ADDRESS_MODE,
    MipLODBias: FLOAT,
    MaxAnisotropy: UINT,
    ComparisonFunc: D3D11_COMPARISON_FUNC,
    BorderColor: [FLOAT; 4],
    MinLOD: FLOAT,
    MaxLOD: FLOAT,
}}
RIDL!{interface ID3D11SamplerState(ID3D11SamplerStateVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_SAMPLER_DESC) -> ()
}}
FLAGS!{enum D3D11_FORMAT_SUPPORT {
    D3D11_FORMAT_SUPPORT_BUFFER = 0x1,
    D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER = 0x2,
    D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER = 0x4,
    D3D11_FORMAT_SUPPORT_SO_BUFFER = 0x8,
    D3D11_FORMAT_SUPPORT_TEXTURE1D = 0x10,
    D3D11_FORMAT_SUPPORT_TEXTURE2D = 0x20,
    D3D11_FORMAT_SUPPORT_TEXTURE3D = 0x40,
    D3D11_FORMAT_SUPPORT_TEXTURECUBE = 0x80,
    D3D11_FORMAT_SUPPORT_SHADER_LOAD = 0x100,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE = 0x200,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON = 0x400,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT = 0x800,
    D3D11_FORMAT_SUPPORT_MIP = 0x1000,
    D3D11_FORMAT_SUPPORT_MIP_AUTOGEN = 0x2000,
    D3D11_FORMAT_SUPPORT_RENDER_TARGET = 0x4000,
    D3D11_FORMAT_SUPPORT_BLENDABLE = 0x8000,
    D3D11_FORMAT_SUPPORT_DEPTH_STENCIL = 0x10000,
    D3D11_FORMAT_SUPPORT_CPU_LOCKABLE = 0x20000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE = 0x40000,
    D3D11_FORMAT_SUPPORT_DISPLAY = 0x80000,
    D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT = 0x100000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET = 0x200000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD = 0x400000,
    D3D11_FORMAT_SUPPORT_SHADER_GATHER = 0x800000,
    D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST = 0x1000000,
    D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW = 0x2000000,
    D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON = 0x4000000,
    D3D11_FORMAT_SUPPORT_DECODER_OUTPUT = 0x8000000,
    D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT = 0x10000000,
    D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT = 0x20000000,
    D3D11_FORMAT_SUPPORT_VIDEO_ENCODER = 0x40000000,
}}
FLAGS!{enum D3D11_FORMAT_SUPPORT2 {
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD = 0x1,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS = 0x2,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 0x4,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE = 0x8,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX = 0x10,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX = 0x20,
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD = 0x40,
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE = 0x80,
    D3D11_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP = 0x100,
    D3D11_FORMAT_SUPPORT2_TILED = 0x200,
    D3D11_FORMAT_SUPPORT2_SHAREABLE = 0x400,
    D3D11_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY = 0x4000,
}}
RIDL!{interface ID3D11Asynchronous(ID3D11AsynchronousVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDataSize(&mut self) -> UINT
}}
FLAGS!{enum D3D11_ASYNC_GETDATA_FLAG {
    D3D11_ASYNC_GETDATA_DONOTFLUSH = 0x1,
}}
ENUM!{enum D3D11_QUERY {
    D3D11_QUERY_EVENT = 0,
    D3D11_QUERY_OCCLUSION = D3D11_QUERY_EVENT.0 + 1,
    D3D11_QUERY_TIMESTAMP = D3D11_QUERY_OCCLUSION.0 + 1,
    D3D11_QUERY_TIMESTAMP_DISJOINT = D3D11_QUERY_TIMESTAMP.0 + 1,
    D3D11_QUERY_PIPELINE_STATISTICS = D3D11_QUERY_TIMESTAMP_DISJOINT.0 + 1,
    D3D11_QUERY_OCCLUSION_PREDICATE = D3D11_QUERY_PIPELINE_STATISTICS.0 + 1,
    D3D11_QUERY_SO_STATISTICS = D3D11_QUERY_OCCLUSION_PREDICATE.0 + 1,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE = D3D11_QUERY_SO_STATISTICS.0 + 1,
    D3D11_QUERY_SO_STATISTICS_STREAM0 = D3D11_QUERY_SO_OVERFLOW_PREDICATE.0 + 1,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 = D3D11_QUERY_SO_STATISTICS_STREAM0.0 + 1,
    D3D11_QUERY_SO_STATISTICS_STREAM1 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0.0 + 1,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 = D3D11_QUERY_SO_STATISTICS_STREAM1.0 + 1,
    D3D11_QUERY_SO_STATISTICS_STREAM2 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1.0 + 1,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 = D3D11_QUERY_SO_STATISTICS_STREAM2.0 + 1,
    D3D11_QUERY_SO_STATISTICS_STREAM3 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2.0 + 1,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3 = D3D11_QUERY_SO_STATISTICS_STREAM3.0 + 1,
}}
FLAGS!{enum D3D11_QUERY_MISC_FLAG {
    D3D11_QUERY_MISC_PREDICATEHINT = 0x1,
}}
STRUCT!{struct D3D11_QUERY_DESC {
    Query: D3D11_QUERY,
    MiscFlags: UINT,
}}
RIDL!{interface ID3D11Query(ID3D11QueryVtbl): ID3D11Asynchronous(ID3D11AsynchronousVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_QUERY_DESC) -> ()
}}
RIDL!{interface ID3D11Predicate(ID3D11PredicateVtbl): ID3D11Query(ID3D11QueryVtbl) {}}
STRUCT!{struct D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    Frequency: UINT64,
    Disjoint: BOOL,
}}
STRUCT!{struct D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    IAVertices: UINT64,
    IAPrimitives: UINT64,
    VSInvocations: UINT64,
    GSInvocations: UINT64,
    GSPrimitives: UINT64,
    CInvocations: UINT64,
    CPrimitives: UINT64,
    PSInvocations: UINT64,
    HSInvocations: UINT64,
    DSInvocations: UINT64,
    CSInvocations: UINT64,
}}
STRUCT!{struct D3D11_QUERY_DATA_SO_STATISTICS {
    NumPrimitivesWritten: UINT64,
    PrimitivesStorageNeeded: UINT64,
}}
FLAGS!{enum D3D11_COUNTER {
    D3D11_COUNTER_DEVICE_DEPENDENT_0 = 0x40000000,
}}
ENUM!{enum D3D11_COUNTER_TYPE {
    D3D11_COUNTER_TYPE_FLOAT32 = 0,
    D3D11_COUNTER_TYPE_UINT16 = D3D11_COUNTER_TYPE_FLOAT32.0 + 1,
    D3D11_COUNTER_TYPE_UINT32 = D3D11_COUNTER_TYPE_UINT16.0 + 1,
    D3D11_COUNTER_TYPE_UINT64 = D3D11_COUNTER_TYPE_UINT32.0 + 1,
}}
STRUCT!{struct D3D11_COUNTER_DESC {
    Counter: D3D11_COUNTER,
    MiscFlags: UINT,
}}
STRUCT!{struct D3D11_COUNTER_INFO {
    LastDeviceDependentCounter: D3D11_COUNTER,
    NumSimultaneousCounters: UINT,
    NumDetectableParallelUnits: UINT8,
}}
RIDL!{interface ID3D11Counter(ID3D11CounterVtbl): ID3D11Asynchronous(ID3D11AsynchronousVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_COUNTER_DESC) -> ()
}}
ENUM!{enum D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS {
    D3D11_STANDARD_MULTISAMPLE_PATTERN = 0xffffffff,
    D3D11_CENTER_MULTISAMPLE_PATTERN = 0xfffffffe,
}}
ENUM!{enum D3D11_DEVICE_CONTEXT_TYPE {
    D3D11_DEVICE_CONTEXT_IMMEDIATE = 0,
    D3D11_DEVICE_CONTEXT_DEFERRED = D3D11_DEVICE_CONTEXT_IMMEDIATE.0 + 1,
}}
STRUCT!{struct D3D11_CLASS_INSTANCE_DESC {
    InstanceId: UINT,
    InstanceIndex: UINT,
    TypeId: UINT,
    ConstantBuffer: UINT,
    BaseConstantBufferOffset: UINT,
    BaseTexture: UINT,
    BaseSampler: UINT,
    Created: BOOL,
}}
RIDL!{interface ID3D11ClassInstance(ID3D11ClassInstanceVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetClassLinkage(&mut self, ppLinkage: *mut *mut ID3D11ClassLinkage) -> (),
    fn GetDesc(&mut self, pDesc: *mut D3D11_CLASS_INSTANCE_DESC) -> (),
    fn GetInstanceName(&mut self, pInstanceName: LPSTR, pBufferLength: *mut SIZE_T) -> (),
    fn GetTypeName(&mut self, pTypeName: LPSTR, pBufferLength: *mut SIZE_T) -> ()
}}
RIDL!{interface ID3D11ClassLinkage(ID3D11ClassLinkageVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetClassInstance(
        &mut self, GetClassInstance: LPCSTR, InstanceIndex: UINT,
        ppInstance: *mut *mut ID3D11ClassInstance
    ) -> HRESULT,
    fn CreateClassInstance(
        &mut self, pClassTypeName: LPCSTR, ConstantBufferOffset: UINT, ConstantVectorOffset: UINT, TextureOffset: UINT, SamplerOffset: UINT, ppInstance: *mut *mut ID3D11ClassInstance
    ) -> HRESULT
}}
RIDL!{interface ID3D11CommandList(ID3D11CommandListVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetContextFlags(&mut self) -> UINT
}}
ENUM!{enum D3D11_FEATURE {
    D3D11_FEATURE_THREADING = 0,
    D3D11_FEATURE_DOUBLES = D3D11_FEATURE_THREADING.0 + 1,
    D3D11_FEATURE_FORMAT_SUPPORT = D3D11_FEATURE_DOUBLES.0 + 1,
    D3D11_FEATURE_FORMAT_SUPPORT2 = D3D11_FEATURE_FORMAT_SUPPORT.0 + 1,
    D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS = D3D11_FEATURE_FORMAT_SUPPORT2.0 + 1,
    D3D11_FEATURE_D3D11_OPTIONS = D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS.0 + 1,
    D3D11_FEATURE_ARCHITECTURE_INFO = D3D11_FEATURE_D3D11_OPTIONS.0 + 1,
    D3D11_FEATURE_D3D9_OPTIONS = D3D11_FEATURE_ARCHITECTURE_INFO.0 + 1,
    D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT = D3D11_FEATURE_D3D9_OPTIONS.0 + 1,
    D3D11_FEATURE_D3D9_SHADOW_SUPPORT = D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT.0 + 1,
    D3D11_FEATURE_D3D11_OPTIONS1 = D3D11_FEATURE_D3D9_SHADOW_SUPPORT.0 + 1,
    D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT = D3D11_FEATURE_D3D11_OPTIONS1.0 + 1,
    D3D11_FEATURE_MARKER_SUPPORT = D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT.0 + 1,
    D3D11_FEATURE_D3D9_OPTIONS1 = D3D11_FEATURE_MARKER_SUPPORT.0 + 1,
    D3D11_FEATURE_D3D11_OPTIONS2 = D3D11_FEATURE_D3D9_OPTIONS1.0 + 1,
    D3D11_FEATURE_D3D11_OPTIONS3 = D3D11_FEATURE_D3D11_OPTIONS2.0 + 1,
    D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT = D3D11_FEATURE_D3D11_OPTIONS3.0 + 1,
}}
STRUCT!{struct D3D11_FEATURE_DATA_THREADING {
    DriverConcurrentCreates: BOOL,
    DriverCommandLists: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_DOUBLES {
    DoublePrecisionFloatShaderOps: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    InFormat: DXGI_FORMAT,
    OutFormatSupport: UINT,
}}
STRUCT!{struct D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    InFormat: DXGI_FORMAT,
    OutFormatSupport2: UINT,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS {
    OutputMergerLogicOp: BOOL,
    UAVOnlyRenderingForcedSampleCount: BOOL,
    DiscardAPIsSeenByDriver: BOOL,
    FlagsForUpdateAndCopySeenByDriver: BOOL,
    ClearView: BOOL,
    CopyWithOverlap: BOOL,
    ConstantBufferPartialUpdate: BOOL,
    ConstantBufferOffsetting: BOOL,
    MapNoOverwriteOnDynamicConstantBuffer: BOOL,
    MapNoOverwriteOnDynamicBufferSRV: BOOL,
    MultisampleRTVWithForcedSampleCountOne: BOOL,
    SAD4ShaderInstructions: BOOL,
    ExtendedDoublesShaderInstructions: BOOL,
    ExtendedResourceSharing: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    TileBasedDeferredRenderer: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_OPTIONS {
    FullNonPow2TextureSupport: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    SupportsDepthAsTextureWithLessEqualComparisonFilter: BOOL,
}}
FLAGS!{enum D3D11_SHADER_MIN_PRECISION_SUPPORT {
    D3D11_SHADER_MIN_PRECISION_10_BIT = 0x1,
    D3D11_SHADER_MIN_PRECISION_16_BIT = 0x2,
}}
STRUCT!{struct D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    PixelShaderMinPrecision: UINT,
    AllOtherShaderStagesMinPrecision: UINT,
}}
ENUM!{enum D3D11_TILED_RESOURCES_TIER {
    D3D11_TILED_RESOURCES_NOT_SUPPORTED = 0,
    D3D11_TILED_RESOURCES_TIER_1 = 1,
    D3D11_TILED_RESOURCES_TIER_2 = 2,
    D3D11_TILED_RESOURCES_TIER_3 = 3,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    MinMaxFiltering: BOOL,
    ClearViewAlsoSupportsDepthOnlyFormats: BOOL,
    MapOnDefaultBuffers: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    SimpleInstancingSupported: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_MARKER_SUPPORT {
    Profile: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    FullNonPow2TextureSupported: BOOL,
    DepthAsTextureWithLessEqualComparisonFilterSupported: BOOL,
    SimpleInstancingSupported: BOOL,
    TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported: BOOL,
}}
ENUM!{enum D3D11_CONSERVATIVE_RASTERIZATION_TIER {
    D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED = 0,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_1 = 1,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_2 = 2,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_3 = 3,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    PSSpecifiedStencilRefSupported: BOOL,
    TypedUAVLoadAdditionalFormats: BOOL,
    ROVsSupported: BOOL,
    ConservativeRasterizationTier: D3D11_CONSERVATIVE_RASTERIZATION_TIER,
    TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    MapOnDefaultTextures: BOOL,
    StandardSwizzle: BOOL,
    UnifiedMemoryArchitecture: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    VPAndRTArrayIndexFromAnyShaderFeedingRasterizer: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    MaxGPUVirtualAddressBitsPerResource: UINT,
    MaxGPUVirtualAddressBitsPerProcess: UINT,
}}
RIDL!{interface ID3D11DeviceContext(ID3D11DeviceContextVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn VSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn PSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn PSSetShader(
        &mut self, pPixelShader: *mut ID3D11PixelShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn PSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn VSSetShader(
        &mut self, pVertexShader: *mut ID3D11VertexShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn DrawIndexed(
        &mut self, IndexCount: UINT, StartIndexLocation: UINT, BaseVertexLocation: INT
    ) -> (),
    fn Draw(&mut self, VertexCount: UINT, StartVertexLocation: UINT) -> (),
    fn Map(
        &mut self, pResource: *mut ID3D11Resource, Subresource: UINT, MapType: D3D11_MAP,
        MapFlags: UINT, pMappedResource: *mut D3D11_MAPPED_SUBRESOURCE
    ) -> HRESULT,
    fn Unmap(&mut self, pResource: *mut ID3D11Resource, Subresource: UINT) -> (),
    fn PSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn IASetInputLayout(&mut self, pInputLayout: *mut ID3D11InputLayout) -> (),
    fn IASetVertexBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppVertexBuffers: *const *mut ID3D11Buffer,
        pStrides: *const UINT, pOffsets: *const UINT
    ) -> (),
    fn IASetIndexBuffer(
        &mut self, pIndexBuffer: *mut ID3D11Buffer, Format: DXGI_FORMAT, Offset: UINT
    ) -> (),
    fn DrawIndexedInstanced(
        &mut self, IndexCountPerInstance: UINT, InstanceCount: UINT, StartIndexLocation: UINT,
        BaseVertexLocation: INT, StartInstanceLocation: UINT
    ) -> (),
    fn DrawInstanced(
        &mut self, VertexCountPerInstance: UINT, InstanceCount: UINT, StartVertexLocation: UINT,
        StartInstanceLocation: UINT
    ) -> (),
    fn GSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn GSSetShader(
        &mut self, pShader: *mut ID3D11GeometryShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn IASetPrimitiveTopology(&mut self, Topology: D3D11_PRIMITIVE_TOPOLOGY) -> (),
    fn VSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn VSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn Begin(&mut self, pAsync: *mut ID3D11Asynchronous) -> (),
    fn End(&mut self, pAsync: *mut ID3D11Asynchronous) -> (),
    fn GetData(
        &mut self,  pAsync: *mut ID3D11Asynchronous, pData: *mut c_void, DataSize: UINT,
        GetDataFlags: UINT
    ) -> HRESULT,
    fn SetPredication(
        &mut self, pPredicate: *mut ID3D11Predicate, PredicateValue: BOOL
    ) -> (),
    fn GSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn GSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn OMSetRenderTargets(
        &mut self, NumViews: UINT, ppRenderTargetViews: *const *mut ID3D11RenderTargetView,
        pDepthStencilView: *mut ID3D11DepthStencilView
    ) -> (),
    fn OMSetRenderTargetsAndUnorderedAccessViews(
        &mut self, NumRTVs: UINT, ppRenderTargetViews: *const *mut ID3D11RenderTargetView,
        pDepthStencilView: *mut ID3D11DepthStencilView, UAVStartSlot: UINT, NumUAVs: UINT,
        ppUnorderedAccessViews: *const *mut ID3D11UnorderedAccessView,
        pUAVInitialCounts: *const UINT
    ) -> (),
    fn OMSetBlendState(
        &mut self, pBlendState: *mut ID3D11BlendState, BlendFactor: &[FLOAT; 4], SampleMask: UINT
    ) -> (),
    fn OMSetDepthStencilState(
        &mut self, pDepthStencilState: *mut ID3D11DepthStencilState, StencilRef: UINT
    ) -> (),
    fn SOSetTargets(
        &mut self, NumBuffers: UINT, ppSOTargets: *const *mut ID3D11Buffer, pOffsets: *const UINT
    ) -> (),
    fn DrawAuto(&mut self) -> (),
    fn DrawIndexedInstancedIndirect(
        &mut self, pBufferForArgs: *mut ID3D11Buffer, AlignedByteOffsetForArgs: UINT
    ) -> (),
    fn DrawInstancedIndirect(
        &mut self, pBufferForArgs: *mut ID3D11Buffer, AlignedByteOffsetForArgs: UINT
    ) -> (),
    fn Dispatch(
        &mut self, ThreadGroupCountX: UINT, ThreadGroupCountY: UINT, ThreadGroupCountZ: UINT
    ) -> (),
    fn DispatchIndirect(
        &mut self, pBufferForArgs: *mut ID3D11Buffer, AlignedByteOffsetForArgs: UINT
    ) -> (),
    fn RSSetState(&mut self, pRasterizerState: *mut ID3D11RasterizerState) -> (),
    fn RSSetViewports(&mut self, NumViewports: UINT, pViewports: *const D3D11_VIEWPORT) -> (),
    fn RSSetScissorRects(&mut self, NumRects: UINT, pRects: *const D3D11_RECT) -> (),
    fn CopySubresourceRegion(
        &mut self, pDstResource: *mut ID3D11Resource, DstSubresource: UINT, DstX: UINT, DstY: UINT,
        DstZ: UINT, pSrcResource: *mut ID3D11Resource, SrcSubresource: UINT,
        pSrcBox: *const D3D11_BOX
    ) -> (),
    fn CopyResource(
        &mut self, pDstResource: *mut ID3D11Resource, pSrcResource: *mut ID3D11Resource
    ) -> (),
    fn UpdateSubresource(
        &mut self, pDstResource: *mut ID3D11Resource, DstSubresource: UINT,
        pDstBox: *const D3D11_BOX, pSrcData: *const c_void, SrcRowPitch: UINT, SrcDepthPitch: UINT
    ) -> (),
    fn CopyStructureCount(
        &mut self, pDstBuffer: *mut ID3D11Buffer, DstAlignedByteOffset: UINT,
        pSrcView: *mut ID3D11UnorderedAccessView
    ) -> (),
    fn ClearRenderTargetView(
        &mut self, pRenderTargetView: *mut ID3D11RenderTargetView, ColorRGBA: &[FLOAT; 4]
    ) -> (),
    fn ClearUnorderedAccessViewUint(
        &mut self, pUnorderedAccessView: *mut ID3D11UnorderedAccessView, Values: &[UINT; 4]
    ) -> (),
    fn ClearUnorderedAccessViewFloat(
        &mut self, pUnorderedAccessView: *mut ID3D11UnorderedAccessView, Values: &[FLOAT; 4]
    ) -> (),
    fn ClearDepthStencilView(
        &mut self, pDepthStencilView: *mut ID3D11DepthStencilView, ClearFlags: UINT, Depth: FLOAT,
        Stencil: UINT8
    ) -> (),
    fn GenerateMips(&mut self, pShaderResourceView: *mut ID3D11ShaderResourceView) -> (),
    fn SetResourceMinLOD(&mut self, pResource: *mut ID3D11Resource, MinLOD: FLOAT) -> (),
    fn GetResourceMinLOD(&mut self, pResource: *mut ID3D11Resource) -> FLOAT,
    fn ResolveSubresource(
        &mut self, pDstResource: *mut ID3D11Resource, DstSubresource: UINT,
        pSrcResource: *mut ID3D11Resource, SrcSubresource: UINT, Format: DXGI_FORMAT
    ) -> (),
    fn ExecuteCommandList(&mut self, pCommandList: *mut ID3D11CommandList) -> (),
    fn HSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn HSSetShader(
        &mut self, pHullShader: *mut ID3D11HullShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn HSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn HSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn DSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn DSSetShader(
        &mut self, pDomainShader: *mut ID3D11DomainShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn DSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn DSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn CSSetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView
    ) -> (),
    fn CSSetUnorderedAccessViews(
        &mut self, StartSlot: UINT, NumUAVs: UINT,
        ppUnorderedAccessViews: *const *mut ID3D11UnorderedAccessView
    ) -> (),
    fn CSSetShader(
        &mut self, pComputeShader: *mut ID3D11ComputeShader,
        ppClassInstances: *const *mut ID3D11ClassInstance, NumClassInstances: UINT
    ) -> (),
    fn CSSetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *const *mut ID3D11SamplerState
    ) -> (),
    fn CSSetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *const *mut ID3D11Buffer
    ) -> (),
    fn VSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn PSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn PSGetShader(
        &mut self, ppPixelShader: *mut *mut ID3D11PixelShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn PSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn VSGetShader(
        &mut self, ppVertexShader: *mut *mut ID3D11VertexShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn PSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn IAGetInputLayout(&mut self, ppInputLayout: *mut *mut ID3D11InputLayout) -> (),
    fn IAGetVertexBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppVertexBuffers: *mut *mut ID3D11Buffer,
        pStrides: *mut UINT, pOffsets: *mut UINT
    ) -> (),
    fn IAGetIndexBuffer(
        &mut self, pIndexBuffer: *mut *mut ID3D11Buffer, Format: *mut DXGI_FORMAT,
        Offset: *mut UINT
    ) -> (),
    fn GSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn GSGetShader(
        &mut self, ppGeometryShader: *mut *mut ID3D11GeometryShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn IAGetPrimitiveTopology(&mut self, pTopology: *mut D3D11_PRIMITIVE_TOPOLOGY) -> (),
    fn VSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn VSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn GetPredication(
        &mut self, ppPredicate: *mut *mut ID3D11Predicate, pPredicateValue: *mut BOOL
    ) -> (),
    fn GSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn GSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn OMGetRenderTargets(
        &mut self, NumViews: UINT, ppRenderTargetViews: *mut *mut ID3D11RenderTargetView,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView
    ) -> (),
    fn OMGetRenderTargetsAndUnorderedAccessViews(
        &mut self, NumRTVs: UINT, ppRenderTargetViews: *mut *mut ID3D11RenderTargetView,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView, UAVStartSlot: UINT,
        ppUnorderedAccessViews: *mut *mut ID3D11UnorderedAccessView
    ) -> (),
    fn OMGetBlendState(
        &mut self, ppBlendState: *mut *mut ID3D11BlendState, BlendFactor: &mut [FLOAT; 4],
        pSampleMask: *mut UINT
    ) -> (),
    fn OMGetDepthStencilState(
        &mut self, ppDepthStencilState: *mut *mut ID3D11DepthStencilState, pStencilRef: *mut UINT
    ) -> (),
    fn SOGetTargets(&mut self, NumBuffers: UINT, ppSOTargets: *mut *mut ID3D11Buffer) -> (),
    fn RSGetState(&mut self, ppRasterizerState: *mut *mut ID3D11RasterizerState) -> (),
    fn RSGetViewports(&mut self, pNumViewports: *mut UINT, pViewports: *mut D3D11_VIEWPORT) -> (),
    fn RSGetScissorRects(&mut self, pNumRects: *mut UINT, pRects: *mut D3D11_RECT) -> (),
    fn HSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn HSGetShader(
        &mut self, ppHullShader: *mut *mut ID3D11HullShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn HSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn HSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn DSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn DSGetShader(
        &mut self, ppDomainShader: *mut *mut ID3D11DomainShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn DSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn DSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn CSGetShaderResources(
        &mut self, StartSlot: UINT, NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView
    ) -> (),
    fn CSGetUnorderedAccessViews(
        &mut self, StartSlot: UINT, NumUAVs: UINT,
        ppUnorderedAccessViews: *mut *mut ID3D11UnorderedAccessView
    ) -> (),
    fn CSGetShader(
        &mut self, ppComputeShader: *mut *mut ID3D11ComputeShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance, pNumClassInstances: *mut UINT
    ) -> (),
    fn CSGetSamplers(
        &mut self, StartSlot: UINT, NumSamplers: UINT, ppSamplers: *mut *mut ID3D11SamplerState
    ) -> (),
    fn CSGetConstantBuffers(
        &mut self, StartSlot: UINT, NumBuffers: UINT, ppConstantBuffers: *mut *mut ID3D11Buffer
    ) -> (),
    fn ClearState(&mut self) -> (),
    fn Flush(&mut self) -> (),
    fn GetType(&mut self) -> D3D11_DEVICE_CONTEXT_TYPE,
    fn GetContextFlags(&mut self) -> UINT,
    fn FinishCommandList(
        &mut self, RestoreDeferredContextState: BOOL, ppCommandList: *mut *mut ID3D11CommandList
    ) -> HRESULT
}}
STRUCT!{struct D3D11_VIDEO_DECODER_DESC {
    Guid: GUID,
    SampleWidth: UINT,
    SampleHeight: UINT,
    OutputFormat: DXGI_FORMAT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_CONFIG {
    guidConfigBitstreamEncryption: GUID,
    guidConfigMBcontrolEncryption: GUID,
    guidConfigResidDiffEncryption: GUID,
    ConfigBitstreamRaw: UINT,
    ConfigMBcontrolRasterOrder: UINT,
    ConfigResidDiffHost: UINT,
    ConfigSpatialResid8: UINT,
    ConfigResid8Subtraction: UINT,
    ConfigSpatialHost8or9Clipping: UINT,
    ConfigSpatialResidInterleaved: UINT,
    ConfigIntraResidUnsigned: UINT,
    ConfigResidDiffAccelerator: UINT,
    ConfigHostInverseScan: UINT,
    ConfigSpecificIDCT: UINT,
    Config4GroupedCoefs: UINT,
    ConfigMinRenderTargetBuffCount: USHORT,
    ConfigDecoderSpecific: USHORT,
}}
ENUM!{enum D3D11_VIDEO_DECODER_BUFFER_TYPE {
    D3D11_VIDEO_DECODER_BUFFER_PICTURE_PARAMETERS = 0,
    D3D11_VIDEO_DECODER_BUFFER_MACROBLOCK_CONTROL = 1,
    D3D11_VIDEO_DECODER_BUFFER_RESIDUAL_DIFFERENCE = 2,
    D3D11_VIDEO_DECODER_BUFFER_DEBLOCKING_CONTROL = 3,
    D3D11_VIDEO_DECODER_BUFFER_INVERSE_QUANTIZATION_MATRIX = 4,
    D3D11_VIDEO_DECODER_BUFFER_SLICE_CONTROL = 5,
    D3D11_VIDEO_DECODER_BUFFER_BITSTREAM = 6,
    D3D11_VIDEO_DECODER_BUFFER_MOTION_VECTOR = 7,
    D3D11_VIDEO_DECODER_BUFFER_FILM_GRAIN = 8,
}}
STRUCT!{struct D3D11_AES_CTR_IV {
    IV: UINT64,
    Count: UINT64,
}}
STRUCT!{struct D3D11_ENCRYPTED_BLOCK_INFO {
    NumEncryptedBytesAtBeginning: UINT,
    NumBytesInSkipPattern: UINT,
    NumBytesInEncryptPattern: UINT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_BUFFER_DESC {
    BufferType: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    BufferIndex: UINT,
    DataOffset: UINT,
    DataSize: UINT,
    FirstMBaddress: UINT,
    NumMBsInBuffer: UINT,
    Width: UINT,
    Height: UINT,
    Stride: UINT,
    ReservedBits: UINT,
    pIV: *mut c_void,
    IVSize: UINT,
    PartialEncryption: BOOL,
    EncryptedBlockInfo: D3D11_ENCRYPTED_BLOCK_INFO,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_EXTENSION {
    Function: UINT,
    pPrivateInputData: *mut c_void,
    PrivateInputDataSize: UINT,
    pPrivateOutputData: *mut c_void,
    PrivateOutputDataSize: UINT,
    ResourceCount: UINT,
    ppResourceList: *mut *mut ID3D11Resource,
}}
RIDL!{interface ID3D11VideoDecoder(ID3D11VideoDecoderVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCreationParameters(
        &mut self, pVideoDesc: *mut D3D11_VIDEO_DECODER_DESC,
        pConfig: *mut D3D11_VIDEO_DECODER_CONFIG
    ) -> HRESULT,
    fn GetDriverHandle(&mut self, pDriverHandle: *mut HANDLE) -> HRESULT
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT {
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT = 0x1,
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT = 0x2,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_DEVICE_CAPS {
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_LINEAR_SPACE = 0x1,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_xvYCC = 0x2,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_RGB_RANGE_CONVERSION = 0x4,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION = 0x8,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_NOMINAL_RANGE = 0x10,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_FEATURE_CAPS {
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_FILL = 0x1,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_CONSTRICTION = 0x2,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LUMA_KEY = 0x4,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_PALETTE = 0x8,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LEGACY = 0x10,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_STEREO = 0x20,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ROTATION = 0x40,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_STREAM = 0x80,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_PIXEL_ASPECT_RATIO = 0x100,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_MIRROR = 0x200,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_SHADER_USAGE = 0x400,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_FILTER_CAPS {
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_BRIGHTNESS = 0x1,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_CONTRAST = 0x2,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_HUE = 0x4,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_SATURATION = 0x8,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_NOISE_REDUCTION = 0x10,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_EDGE_ENHANCEMENT = 0x20,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_ANAMORPHIC_SCALING = 0x40,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_STEREO_ADJUSTMENT = 0x80,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_FORMAT_CAPS {
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_INTERLACED = 0x1,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_PROCAMP = 0x2,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_LUMA_KEY = 0x4,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_PALETTE_INTERLACED = 0x8,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS {
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DENOISE = 0x1,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DERINGING = 0x2,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_EDGE_ENHANCEMENT = 0x4,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_COLOR_CORRECTION = 0x8,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_FLESH_TONE_MAPPING = 0x10,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_IMAGE_STABILIZATION = 0x20,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_SUPER_RESOLUTION = 0x40,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_ANAMORPHIC_SCALING = 0x80,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_STEREO_CAPS {
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_MONO_OFFSET = 0x1,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_ROW_INTERLEAVED = 0x2,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_COLUMN_INTERLEAVED = 0x4,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_CHECKERBOARD = 0x8,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_FLIP_MODE = 0x10,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CAPS {
    DeviceCaps: UINT,
    FeatureCaps: UINT,
    FilterCaps: UINT,
    InputFormatCaps: UINT,
    AutoStreamCaps: UINT,
    StereoCaps: UINT,
    RateConversionCapsCount: UINT,
    MaxInputStreams: UINT,
    MaxStreamStates: UINT,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS {
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BLEND = 0x1,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BOB = 0x2,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE = 0x4,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION = 0x8,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_INVERSE_TELECINE = 0x10,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_FRAME_RATE_CONVERSION = 0x20,
}}
FLAGS!{enum D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS {
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32 = 0x1,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22 = 0x2,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224 = 0x4,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332 = 0x8,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322 = 0x10,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55 = 0x20,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64 = 0x40,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87 = 0x80,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223 = 0x100,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER = 0x80000000,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    PastFrames: UINT,
    FutureFrames: UINT,
    ProcessorCaps: UINT,
    ITelecineCaps: UINT,
    CustomRateCount: UINT,
}}
FLAGS!{enum D3D11_CONTENT_PROTECTION_CAPS {
    D3D11_CONTENT_PROTECTION_CAPS_SOFTWARE = 0x1,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE = 0x2,
    D3D11_CONTENT_PROTECTION_CAPS_PROTECTION_ALWAYS_ON = 0x4,
    D3D11_CONTENT_PROTECTION_CAPS_PARTIAL_DECRYPTION = 0x8,
    D3D11_CONTENT_PROTECTION_CAPS_CONTENT_KEY = 0x10,
    D3D11_CONTENT_PROTECTION_CAPS_FRESHEN_SESSION_KEY = 0x20,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK = 0x40,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK_KEY = 0x80,
    D3D11_CONTENT_PROTECTION_CAPS_SEQUENTIAL_CTR_IV = 0x100,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPT_SLICEDATA_ONLY = 0x200,
    D3D11_CONTENT_PROTECTION_CAPS_DECRYPTION_BLT = 0x400,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECT_UNCOMPRESSED = 0x800,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECTED_MEMORY_PAGEABLE = 0x1000,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_TEARDOWN = 0x2000,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION = 0x4000,
}}
STRUCT!{struct D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    Caps: UINT,
    KeyExchangeTypeCount: UINT,
    BlockAlignmentSize: UINT,
    ProtectedMemorySize: ULONGLONG,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    CustomRate: DXGI_RATIONAL,
    OutputFrames: UINT,
    InputInterlaced: BOOL,
    InputFramesOrFields: UINT,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FILTER {
    D3D11_VIDEO_PROCESSOR_FILTER_BRIGHTNESS = 0,
    D3D11_VIDEO_PROCESSOR_FILTER_CONTRAST = 1,
    D3D11_VIDEO_PROCESSOR_FILTER_HUE = 2,
    D3D11_VIDEO_PROCESSOR_FILTER_SATURATION = 3,
    D3D11_VIDEO_PROCESSOR_FILTER_NOISE_REDUCTION = 4,
    D3D11_VIDEO_PROCESSOR_FILTER_EDGE_ENHANCEMENT = 5,
    D3D11_VIDEO_PROCESSOR_FILTER_ANAMORPHIC_SCALING = 6,
    D3D11_VIDEO_PROCESSOR_FILTER_STEREO_ADJUSTMENT = 7,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    Minimum: c_int,
    Maximum: c_int,
    Default: c_int,
    Multiplier: c_float,
}}
ENUM!{enum D3D11_VIDEO_FRAME_FORMAT {
    D3D11_VIDEO_FRAME_FORMAT_PROGRESSIVE = 0,
    D3D11_VIDEO_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST = 1,
    D3D11_VIDEO_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST = 2,
}}
ENUM!{enum D3D11_VIDEO_USAGE {
    D3D11_VIDEO_USAGE_PLAYBACK_NORMAL = 0,
    D3D11_VIDEO_USAGE_OPTIMAL_SPEED = 1,
    D3D11_VIDEO_USAGE_OPTIMAL_QUALITY = 2,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    InputFrameFormat: D3D11_VIDEO_FRAME_FORMAT,
    InputFrameRate: DXGI_RATIONAL,
    InputWidth: UINT,
    InputHeight: UINT,
    OutputFrameRate: DXGI_RATIONAL,
    OutputWidth: UINT,
    OutputHeight: UINT,
    Usage: D3D11_VIDEO_USAGE,
}}
RIDL!{interface ID3D11VideoProcessorEnumerator(ID3D11VideoProcessorEnumeratorVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetVideoProcessorContentDesc(
        &mut self, pContentDesc: *mut D3D11_VIDEO_PROCESSOR_CONTENT_DESC
    ) -> HRESULT,
    fn CheckVideoProcessorFormat(&mut self, Format: DXGI_FORMAT, pFlags: *mut UINT) -> HRESULT,
    fn GetVideoProcessorCaps(&mut self, pCaps: *mut D3D11_VIDEO_PROCESSOR_CAPS) -> HRESULT,
    fn GetVideoProcessorRateConversionCaps(
        &mut self, TypeIndex: UINT, pCaps: *mut D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS
    ) -> HRESULT,
    fn GetVideoProcessorCustomRate(
        &mut self, TypeIndex: UINT, CustomRateIndex: UINT,
        pRate: *mut D3D11_VIDEO_PROCESSOR_CUSTOM_RATE
    ) -> HRESULT,
    fn GetVideoProcessorFilterRange(
        &mut self, Filter: D3D11_VIDEO_PROCESSOR_FILTER,
        Range: *mut D3D11_VIDEO_PROCESSOR_FILTER_RANGE
    ) -> HRESULT
}}
STRUCT!{struct D3D11_VIDEO_COLOR_RGBA {
    R: c_float,
    G: c_float,
    B: c_float,
    A: c_float,
}}
STRUCT!{struct D3D11_VIDEO_COLOR_YCbCrA {
    Y: c_float,
    Cb: c_float,
    Cr: c_float,
    A: c_float,
}}
STRUCT!{struct D3D11_VIDEO_COLOR {
    u: [c_float; 4],
}}
UNION!{D3D11_VIDEO_COLOR, u, YCbCr, YCbCr_mut, D3D11_VIDEO_COLOR_YCbCrA}
UNION!{D3D11_VIDEO_COLOR, u, RGBA, RGBA_mut, D3D11_VIDEO_COLOR_RGBA}
ENUM!{enum D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE {
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_UNDEFINED = 0,
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_16_235 = 1,
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_0_255 = 2,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    bitfield: UINT,
}}
BITFIELD!{D3D11_VIDEO_PROCESSOR_COLOR_SPACE bitfield: UINT [
    Usage set_Usage[0..1],
    RGB_Range set_RGB_Range[1..2],
    YCbCr_Matrix set_YCbCr_Matrix[2..3],
    YCbCr_xvYCC set_YCbCr_xvYCC[3..4],
    Nominal_Range set_Nominal_Range[4..6],
]}
ENUM!{enum D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE {
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_OPAQUE = 0,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_BACKGROUND = 1,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_DESTINATION = 2,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_SOURCE_STREAM = 3,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_OUTPUT_RATE {
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL = 0,
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF = 1,
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM = 2,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_STEREO_FORMAT {
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO = 0,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_HORIZONTAL = 1,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_VERTICAL = 2,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_SEPARATE = 3,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO_OFFSET = 4,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_ROW_INTERLEAVED = 5,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_COLUMN_INTERLEAVED = 6,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_CHECKERBOARD = 7,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE {
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_NONE = 0,
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME0 = 1,
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME1 = 2,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_ROTATION {
    D3D11_VIDEO_PROCESSOR_ROTATION_IDENTITY = 0,
    D3D11_VIDEO_PROCESSOR_ROTATION_90 = 1,
    D3D11_VIDEO_PROCESSOR_ROTATION_180 = 2,
    D3D11_VIDEO_PROCESSOR_ROTATION_270 = 3,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_STREAM {
    Enable: BOOL,
    OutputIndex: UINT,
    InputFrameOrField: UINT,
    PastFrames: UINT,
    FutureFrames: UINT,
    ppPastSurfaces: *mut *mut ID3D11VideoProcessorInputView,
    pInputSurface: *mut ID3D11VideoProcessorInputView,
    ppFutureSurfaces: *mut *mut ID3D11VideoProcessorInputView,
    ppPastSurfacesRight: *mut *mut ID3D11VideoProcessorInputView,
    pInputSurfaceRight: *mut ID3D11VideoProcessorInputView,
    ppFutureSurfacesRight: *mut *mut ID3D11VideoProcessorInputView,
}}
RIDL!{interface ID3D11VideoProcessor(ID3D11VideoProcessorVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetContentDesc(&mut self, pDesc: *mut D3D11_VIDEO_PROCESSOR_CONTENT_DESC) -> (),
    fn GetRateConversionCaps(
        &mut self, pCaps: *mut D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS
    ) -> ()
}}
STRUCT!{struct D3D11_OMAC {
    Omac: [BYTE; 16],
}}
ENUM!{enum D3D11_AUTHENTICATED_CHANNEL_TYPE {
    D3D11_AUTHENTICATED_CHANNEL_D3D11 = 1,
    D3D11_AUTHENTICATED_CHANNEL_DRIVER_SOFTWARE = 2,
    D3D11_AUTHENTICATED_CHANNEL_DRIVER_HARDWARE = 3,
}}
RIDL!{interface ID3D11AuthenticatedChannel(ID3D11AuthenticatedChannelVtbl)
    : ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCertificateSize(&mut self, pCertificateSize: *mut UINT) -> HRESULT,
    fn GetCertificate(&mut self, CertificateSize: UINT, pCertificate: *mut BYTE) -> HRESULT,
    fn GetChannelHandle(&mut self, pChannelHandle: *mut HANDLE) -> ()
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_INPUT {
    QueryType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT {
    omac: D3D11_OMAC,
    QueryType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
    ReturnCode: HRESULT,
}}
//FIXME bitfield
STRUCT!{struct D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    u: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ProtectionFlags: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ChannelType: D3D11_AUTHENTICATED_CHANNEL_TYPE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DecoderHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DecoderHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    RestrictedSharedResourceProcessCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    ProcessIndex: UINT,
}}
ENUM!{enum D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE {
    DD3D11_PROCESSIDTYPE_UNKNOWN = 0,
    DD3D11_PROCESSIDTYPE_DWM = 1,
    DD3D11_PROCESSIDTYPE_HANDLE  = 2,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ProcessIndex: UINT,
    ProcessIdentifier: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    ProcessHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    UnrestrictedProtectedSharedResourceCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDIndex: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDIndex: UINT,
    OutputID: UINT64,
}}
ENUM!{enum D3D11_BUS_TYPE {
    D3D11_BUS_TYPE_OTHER = 0,
    D3D11_BUS_TYPE_PCI = 0x1,
    D3D11_BUS_TYPE_PCIX = 0x2,
    D3D11_BUS_TYPE_PCIEXPRESS = 0x3,
    D3D11_BUS_TYPE_AGP = 0x4,
    D3D11_BUS_IMPL_MODIFIER_INSIDE_OF_CHIPSET = 0x10000,
    D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_CHIP = 0x20000,
    D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_SOCKET = 0x30000,
    D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR = 0x40000,
    D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE = 0x50000,
    D3D11_BUS_IMPL_MODIFIER_NON_STANDARD = 0x80000000,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    BusType: D3D11_BUS_TYPE,
    AccessibleInContiguousBlocks: BOOL,
    AccessibleInNonContiguousBlocks: BOOL,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuidCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    EncryptionGuidIndex: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuidIndex: UINT,
    EncryptionGuid: GUID,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuid: GUID,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    omac: D3D11_OMAC,
    ConfigureType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    omac: D3D11_OMAC,
    ConfigureType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
    ReturnCode: HRESULT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    StartSequenceQuery: UINT,
    StartSequenceConfigure: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    Protections: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    DecoderHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    ProcessType: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    ProcessHandle: HANDLE,
    AllowAccess: BOOL,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    EncryptionGuid: GUID,
}}
RIDL!{interface ID3D11CryptoSession(ID3D11CryptoSessionVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCryptoType(&mut self, pCryptoType: *mut GUID) -> (),
    fn GetDecoderProfile(&mut self, pDecoderProfile: *mut GUID) -> (),
    fn GetCertificateSize(&mut self, pCertificateSize: *mut UINT) -> HRESULT,
    fn GetCertificate(&mut self, CertificateSize: UINT, pCertificate: *mut BYTE) -> HRESULT,
    fn GetCryptoSessionHandle(&mut self, pCertificate: *mut HANDLE) -> ()
}}
ENUM!{enum D3D11_VDOV_DIMENSION {
    D3D11_VDOV_DIMENSION_UNKNOWN = 0,
    D3D11_VDOV_DIMENSION_TEXTURE2D = 1,
}}
STRUCT!{struct D3D11_TEX2D_VDOV {
    ArraySlice: UINT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    DecodeProfile: GUID,
    ViewDimension: D3D11_VDOV_DIMENSION,
    Texture2D: D3D11_TEX2D_VDOV,
}}
RIDL!{interface ID3D11VideoDecoderOutputView(ID3D11VideoDecoderOutputViewVtbl)
    : ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC) -> ()
}}
ENUM!{enum D3D11_VPIV_DIMENSION {
    D3D11_VPIV_DIMENSION_UNKNOWN = 0,
    D3D11_VPIV_DIMENSION_TEXTURE2D = 1,
}}
STRUCT!{struct D3D11_TEX2D_VPIV {
    MipSlice: UINT,
    ArraySlice: UINT,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    FourCC: UINT,
    ViewDimension: D3D11_VPIV_DIMENSION,
    Texture2D: D3D11_TEX2D_VPIV,
}}
RIDL!{interface ID3D11VideoProcessorInputView(ID3D11VideoProcessorInputViewVtbl)
    : ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC) -> ()
}}
ENUM!{enum D3D11_VPOV_DIMENSION {
    D3D11_VPOV_DIMENSION_UNKNOWN = 0,
    D3D11_VPOV_DIMENSION_TEXTURE2D = 1,
    D3D11_VPOV_DIMENSION_TEXTURE2DARRAY = 2,
}}
STRUCT!{struct D3D11_TEX2D_VPOV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_VPOV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    ViewDimension: D3D11_VPOV_DIMENSION,
    u: [UINT; 3],
}}
UNION!{D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC, u, Texture2D, Texture2D_mut, D3D11_TEX2D_VPOV}
UNION!{D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC, u, Texture2DArray, Texture2DArray_mut,
    D3D11_TEX2D_ARRAY_VPOV}
RIDL!{interface ID3D11VideoProcessorOutputView(ID3D11VideoProcessorOutputViewVtbl)
    : ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(&mut self, pDesc: *mut D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC) -> ()
}}
RIDL!{interface ID3D11VideoContext(ID3D11VideoContextVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDecoderBuffer(
        &mut self, pDecoder: *mut ID3D11VideoDecoder, Type:  D3D11_VIDEO_DECODER_BUFFER_TYPE,
        pBufferSize: *mut UINT, ppBuffer: *mut *mut c_void
    ) -> HRESULT,
    fn ReleaseDecoderBuffer(
        &mut self, pDecoder: *mut ID3D11VideoDecoder, Type:  D3D11_VIDEO_DECODER_BUFFER_TYPE
    ) -> HRESULT,
    fn DecoderBeginFrame(
        &mut self, pDecoder: *mut ID3D11VideoDecoder, pView: *mut ID3D11VideoDecoderOutputView,
        ContentKeySize: UINT, pContentKey: *const c_void
    ) -> HRESULT,
    fn DecoderEndFrame(&mut self, pDecoder: *mut ID3D11VideoDecoder) -> HRESULT,
    fn SubmitDecoderBuffers(
        &mut self, pDecoder: *mut ID3D11VideoDecoder, NumBuffers: UINT,
        pBufferDesc: *const D3D11_VIDEO_DECODER_BUFFER_DESC
    ) -> HRESULT,
    fn DecoderExtension(
        &mut self, pDecoder: *mut ID3D11VideoDecoder,
        pExtensionData: *const D3D11_VIDEO_DECODER_EXTENSION
    ) -> HRESULT,
    fn VideoProcessorSetOutputTargetRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, Enable: BOOL, pRect: *const RECT
    ) -> (),
    fn VideoProcessorSetOutputBackgroundColor(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, YCbCr: BOOL, pRect: *const RECT
    ) -> (),
    fn VideoProcessorSetOutputColorSpace(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor,
        pColorSpace: *const D3D11_VIDEO_PROCESSOR_COLOR_SPACE
    ) -> HRESULT,
    fn VideoProcessorSetOutputAlphaFillMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor,
        AlphaFillMode: D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE, StreamIndex: UINT
    ) -> (),
    fn VideoProcessorSetOutputConstriction(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, Enable: BOOL, Size: SIZE
    ) -> (),
    fn VideoProcessorSetOutputStereoMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, Enable: BOOL
    ) -> (),
    fn VideoProcessorSetOutputExtension(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, pExtensionGuid: *const GUID,
        DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn VideoProcessorGetOutputTargetRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, Enabled: *mut BOOL, pRect: *mut RECT
    ) -> (),
    fn VideoProcessorGetOutputBackgroundColor(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, pYCbCr: *mut BOOL,
        pColor: *mut D3D11_VIDEO_COLOR
    ) -> (),
    fn VideoProcessorGetOutputColorSpace(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor,
        pColorSpace: *mut D3D11_VIDEO_PROCESSOR_COLOR_SPACE
    ) -> (),
    fn VideoProcessorGetOutputAlphaFillMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor,
        pAlphaFillMode: *mut D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE, pStreamIndex: *mut UINT
    ) -> (),
    fn VideoProcessorGetOutputConstriction(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, pEnabled: *mut BOOL,
        pSize: *mut SIZE
    ) -> (),
    fn VideoProcessorGetOutputStereoMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, pEnabled: *mut BOOL
    ) -> (),
    fn VideoProcessorGetOutputExtension(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, pExtensionGuid: *const GUID,
        DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn VideoProcessorSetStreamFrameFormat(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        FrameFormat: D3D11_VIDEO_FRAME_FORMAT
    ) -> (),
    fn VideoProcessorSetStreamColorSpace(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pColorSpace: *const D3D11_VIDEO_PROCESSOR_COLOR_SPACE
    ) -> (),
    fn VideoProcessorSetStreamOutputRate(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        OutputRate: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE, RepeatFrame: BOOL,
        pCustomRate: *const DXGI_RATIONAL
    ) -> (),
    fn VideoProcessorSetStreamSourceRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        pRect: *const RECT
    ) -> (),
    fn VideoProcessorSetStreamDestRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        pRect: *const RECT
    ) -> (),
    fn VideoProcessorSetStreamAlpha(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        Alpha: FLOAT
    ) -> (),
    fn VideoProcessorSetStreamPalette(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Count: UINT,
        pEntries: *const UINT
    ) -> (),
    fn VideoProcessorSetStreamPixelAspectRatio(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        pSourceAspectRatio: *const DXGI_RATIONAL, pDestinationAspectRatio: *const DXGI_RATIONAL
    ) -> (),
    fn VideoProcessorSetStreamLumaKey(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        Lower: FLOAT, Upper: FLOAT
    ) -> (),
    fn VideoProcessorSetStreamStereoFormat(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        Format: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT, LeftViewFrame0: BOOL, BaseViewFrame0: BOOL,
        FlipMode: D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE
    ) -> (),
    fn VideoProcessorSetStreamAutoProcessingMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL
    ) -> (),
    fn VideoProcessorSetStreamFilter(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        Filter: D3D11_VIDEO_PROCESSOR_FILTER, Enable: BOOL, Level: c_int
    ) -> (),
    fn VideoProcessorSetStreamExtension(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pExtensionGuid: *const GUID, DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn VideoProcessorGetStreamFrameFormat(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pFrameFormat: *mut D3D11_VIDEO_FRAME_FORMAT
    ) -> (),
    fn VideoProcessorGetStreamColorSpace(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pColorSpace: *mut D3D11_VIDEO_PROCESSOR_COLOR_SPACE
    ) -> (),
    fn VideoProcessorGetStreamOutputRate(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pOutputRate: *mut D3D11_VIDEO_PROCESSOR_OUTPUT_RATE, pRepeatFrame: *mut BOOL,
        pCustomRate: *mut DXGI_RATIONAL
    ) -> (),
    fn VideoProcessorGetStreamSourceRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pRect: *mut RECT
    ) -> (),
    fn VideoProcessorGetStreamDestRect(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pRect: *mut RECT
    ) -> (),
    fn VideoProcessorGetStreamAlpha(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pAlpha: *mut FLOAT
    ) -> (),
    fn VideoProcessorGetStreamPalette(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Count: UINT,
        pEntries: *mut UINT
    ) -> (),
    fn VideoProcessorGetStreamPixelAspectRatio(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pSourceAspectRatio: *mut DXGI_RATIONAL,
        pDestinationAspectRatio: *mut DXGI_RATIONAL
    ) -> (),
    fn VideoProcessorGetStreamLumaKey(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pLower: *mut FLOAT, pUpper: *mut FLOAT
    ) -> (),
    fn VideoProcessorGetStreamStereoFormat(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL, pFormat: *mut D3D11_VIDEO_PROCESSOR_STEREO_FORMAT,
        pLeftViewFrame0: *mut BOOL, pBaseViewFrame0: *mut BOOL,
        pFlipMode: *mut D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE, MonoOffset: *mut c_int
    ) -> (),
    fn VideoProcessorGetStreamAutoProcessingMode(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnabled: *mut BOOL
    ) -> (),
    fn VideoProcessorGetStreamFilter(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        Filter: D3D11_VIDEO_PROCESSOR_FILTER, pEnabled: *mut BOOL, pLevel: *mut c_int
    ) -> (),
    fn VideoProcessorGetStreamExtension(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pExtensionGuid: *const GUID, DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn VideoProcessorBlt(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor,
        pView: *mut ID3D11VideoProcessorOutputView, OutputFrame: UINT, StreamCount: UINT,
        pStreams: *const D3D11_VIDEO_PROCESSOR_STREAM
    ) -> HRESULT,
    fn NegotiateCryptoSessionKeyExchange(
        &mut self, pCryptoSession: *mut ID3D11CryptoSession, DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn EncryptionBlt(
        &mut self, pCryptoSession: *mut ID3D11CryptoSession, pSrcSurface: *mut ID3D11Texture2D,
        pDstSurface: *mut ID3D11Texture2D, IVSize: UINT, pIV: *mut c_void
    ) -> HRESULT,
    fn DecryptionBlt(
        &mut self, pCryptoSession: *mut ID3D11CryptoSession, pSrcSurface: *mut ID3D11Texture2D,
        pDstSurface: *mut ID3D11Texture2D, pEncryptedBlockInfo: *mut D3D11_ENCRYPTED_BLOCK_INFO,
        ContentKeySize: UINT, pContentKey: *const c_void, IVSize: UINT, pIV: *mut c_void
    ) -> HRESULT,
    fn StartSessionKeyRefresh(
        &mut self, pCryptoSession: *mut ID3D11CryptoSession, RandomNumberSize: UINT,
        pRandomNumber: *mut c_void
    ) -> HRESULT,
    fn FinishSessionKeyRefresh(&mut self, pCryptoSession: *mut ID3D11CryptoSession) -> HRESULT,
    fn GetEncryptionBltKey(
        &mut self, pCryptoSession: *mut ID3D11CryptoSession, KeySize: UINT,
        pReadbackKey: *mut c_void
    ) -> HRESULT,
    fn NegotiateAuthenticatedChannelKeyExchange(
        &mut self, pChannel: *mut ID3D11AuthenticatedChannel, DataSize: UINT, pData: *mut c_void
    ) -> HRESULT,
    fn QueryAuthenticatedChannel(
        &mut self, pChannel: *mut ID3D11AuthenticatedChannel, InputSize: UINT,
        pInput: *const c_void, OutputSize: UINT, pOutput: *mut c_void
    ) -> HRESULT,
    fn ConfigureAuthenticatedChannel(
        &mut self, pChannel: *mut ID3D11AuthenticatedChannel, InputSize: UINT,
        pInput: *const c_void, pOutput: *mut D3D11_AUTHENTICATED_CONFIGURE_OUTPUT
    ) -> HRESULT,
    fn VideoProcessorSetStreamRotation(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT, Enable: BOOL,
        Rotation: D3D11_VIDEO_PROCESSOR_ROTATION
    ) -> HRESULT,
    fn VideoProcessorGetStreamRotation(
        &mut self, pVideoProcessor: *mut ID3D11VideoProcessor, StreamIndex: UINT,
        pEnable: *mut BOOL, pRotation: *mut D3D11_VIDEO_PROCESSOR_ROTATION
    ) -> HRESULT
}}
RIDL!{interface ID3D11VideoDevice(ID3D11VideoDeviceVtbl): IUnknown(IUnknownVtbl) {
    fn CreateVideoDecoder(
        &mut self, pVideoDesc: *const D3D11_VIDEO_DECODER_DESC,
        pConfig: *const D3D11_VIDEO_DECODER_CONFIG, ppDecoder: *mut *mut ID3D11VideoDecoder
    ) -> HRESULT,
    fn CreateVideoProcessor(
        &mut self, pEnum: *mut ID3D11VideoProcessorEnumerator, RateConversionIndex: UINT,
        ppVideoProcessor: *mut *mut ID3D11VideoProcessor
    ) -> HRESULT,
    fn CreateAuthenticatedChannel(
        &mut self, ChannelType: D3D11_AUTHENTICATED_CHANNEL_TYPE,
        ppAuthenticatedChannel: *mut *mut ID3D11AuthenticatedChannel
    ) -> HRESULT,
    fn CreateCryptoSession(
        &mut self, pCryptoType: *const GUID, pDecoderProfile: *const GUID,
        pKeyExchangeType: *const GUID, ppCryptoSession: *mut *mut ID3D11CryptoSession
    ) -> HRESULT,
    fn CreateVideoDecoderOutputView(
        &mut self, pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC,
        ppVDOVView: *mut *mut ID3D11VideoDecoderOutputView
    ) -> HRESULT,
    fn CreateVideoProcessorInputView(
        &mut self, pResource: *mut ID3D11Resource, pEnum: *mut ID3D11VideoProcessorEnumerator,
        pDesc: *const D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC,
        ppVPIView: *mut *mut ID3D11VideoProcessorInputView
    ) -> HRESULT,
    fn CreateVideoProcessorOutputView(
        &mut self, pResource: *mut ID3D11Resource, pEnum: *mut ID3D11VideoProcessorEnumerator,
        pDesc: *const D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC,
        ppVPOView: *mut *mut ID3D11VideoProcessorOutputView
    ) -> HRESULT,
    fn CreateVideoProcessorEnumerator(
        &mut self, pDesc: *const D3D11_VIDEO_PROCESSOR_CONTENT_DESC,
        ppEnum: *mut *mut ID3D11VideoProcessorEnumerator
    ) -> HRESULT,
    fn GetVideoDecoderProfileCount(&mut self) -> UINT,
    fn GetVideoDecoderProfile(&mut self, Index: UINT, pDecoderProfile: *mut GUID) -> HRESULT,
    fn CheckVideoDecoderFormat(
        &mut self, pDecoderProfile: *const GUID, Format: DXGI_FORMAT, pSupported: *mut BOOL
    ) -> HRESULT,
    fn GetVideoDecoderConfigCount(
        &mut self, pDesc: *const D3D11_VIDEO_DECODER_DESC, pCount: *mut UINT
    ) -> HRESULT,
    fn GetVideoDecoderConfig(
        &mut self, pDesc: *const D3D11_VIDEO_DECODER_DESC, Index: UINT,
        pConfig: *mut D3D11_VIDEO_DECODER_CONFIG
    ) -> HRESULT,
    fn GetContentProtectionCaps(
        &mut self, pCryptoType: *const GUID, pDecoderProfile: *const GUID,
        pCaps: *mut D3D11_VIDEO_CONTENT_PROTECTION_CAPS
    ) -> HRESULT,
    fn CheckCryptoKeyExchange(
        &mut self, pCryptoType: *const GUID, pDecoderProfile: *const GUID, Index: UINT,
        pKeyExchangeType: *mut GUID
    ) -> HRESULT,
    fn SetPrivateData( &mut self, guid: REFGUID, DataSize: UINT, pData: *const c_void) -> HRESULT,
    fn SetPrivateDataInterface(&mut self, guid: REFGUID, pData: *const IUnknown) -> HRESULT
}}
RIDL!{interface ID3D11Device(ID3D11DeviceVtbl): IUnknown(IUnknownVtbl) {
    fn CreateBuffer(
        &mut self, pDesc: *const D3D11_BUFFER_DESC, pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppBuffer: *mut *mut ID3D11Buffer
    ) -> HRESULT,
    fn CreateTexture1D(
        &mut self, pDesc: *const D3D11_TEXTURE1D_DESC, pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture1D: *mut *mut ID3D11Texture1D
    ) ->  HRESULT,
    fn CreateTexture2D(
        &mut self, pDesc: *const D3D11_TEXTURE2D_DESC, pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture2D: *mut *mut ID3D11Texture2D
    ) -> HRESULT,
    fn CreateTexture3D(
        &mut self, pDesc: *const D3D11_TEXTURE3D_DESC, pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture3D: *mut *mut ID3D11Texture3D
    ) -> HRESULT,
    fn CreateShaderResourceView(
        &mut self, pResource: *mut ID3D11Resource, pDesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppSRView: *mut *mut ID3D11ShaderResourceView
    ) -> HRESULT,
    fn CreateUnorderedAccessView(
        &mut self, pResource: *mut ID3D11Resource, pDesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppUAView: *mut *mut ID3D11UnorderedAccessView
    ) -> HRESULT,
    fn CreateRenderTargetView(
        &mut self, pResource: *mut ID3D11Resource, pDesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        ppRTView: *mut *mut ID3D11RenderTargetView
    ) -> HRESULT,
    fn CreateDepthStencilView(
        &mut self, pResource: *mut ID3D11Resource, pDesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView
    ) -> HRESULT,
    fn CreateInputLayout(
        &mut self, pInputElementDescs: *const D3D11_INPUT_ELEMENT_DESC, NumElements: UINT,
        pShaderBytecodeWithInputSignature: *const c_void, BytecodeLength: SIZE_T,
        ppInputLayout: *mut *mut ID3D11InputLayout
    ) -> HRESULT,
    fn CreateVertexShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppVertexShader: *mut *mut ID3D11VertexShader
    ) -> HRESULT,
    fn CreateGeometryShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppGeometryShader: *mut *mut ID3D11GeometryShader
    ) -> HRESULT,
    fn CreateGeometryShaderWithStreamOutput(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pSODeclaration: *const D3D11_SO_DECLARATION_ENTRY, NumEntries: UINT,
        pBufferStrides: *const UINT, NumStrides: UINT, RasterizedStream: UINT,
        pClassLinkage: *mut ID3D11ClassLinkage, ppGeometryShader: *mut *mut ID3D11GeometryShader
    ) -> HRESULT,
    fn CreatePixelShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppPixelShader: *mut *mut ID3D11PixelShader
    ) -> HRESULT,
    fn CreateHullShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppHullShader: *mut *mut ID3D11HullShader
    ) -> HRESULT,
    fn CreateDomainShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppDomainShader: *mut *mut ID3D11DomainShader
    ) -> HRESULT,
    fn CreateComputeShader(
        &mut self, pShaderBytecode: *const c_void, BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage, ppComputeShader: *mut *mut ID3D11ComputeShader
    ) -> HRESULT,
    fn CreateClassLinkage(&mut self, ppLinkage: *mut *mut ID3D11ClassLinkage) -> HRESULT,
    fn CreateBlendState(
        &mut self, pBlendStateDesc: *const D3D11_BLEND_DESC,
        ppBlendState: *mut *mut ID3D11BlendState
    ) -> HRESULT,
    fn CreateDepthStencilState(
        &mut self, pDepthStencilDesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppDepthStencilState: *mut *mut ID3D11DepthStencilState
    ) -> HRESULT,
    fn CreateRasterizerState(
        &mut self, pRasterizerDesc: *const D3D11_RASTERIZER_DESC,
        ppRasterizerState: *mut *mut ID3D11RasterizerState
    ) -> HRESULT,
    fn CreateSamplerState(
        &mut self, pSamplerDesc: *const D3D11_SAMPLER_DESC,
        ppSamplerState: *mut *mut ID3D11SamplerState
    ) -> HRESULT,
    fn CreateQuery(
        &mut self, pQueryDesc: *const D3D11_QUERY_DESC, ppQuery: *mut *mut ID3D11Query
    ) -> HRESULT,
    fn CreatePredicate(
        &mut self, pPredicateDesc: *const D3D11_QUERY_DESC, ppPredicate: *mut *mut ID3D11Predicate
    ) -> HRESULT,
    fn CreateCounter(
        &mut self, pCounterDesc: *const D3D11_COUNTER_DESC, ppCounter: *mut *mut ID3D11Counter
    ) -> HRESULT,
    fn CreateDeferredContext(
        &mut self, ContextFlags: UINT, ppDeferredContext: *mut *mut ID3D11DeviceContext
    ) -> HRESULT,
    fn OpenSharedResource(
        &mut self, hResource: HANDLE, ReturnedInterface: REFIID, ppResource: *mut *mut c_void
    ) -> HRESULT,
    fn CheckFormatSupport(
        &mut self, Format: DXGI_FORMAT, pFormatSupport: *mut UINT
    ) -> HRESULT,
    fn CheckMultisampleQualityLevels(
        &mut self, Format: DXGI_FORMAT, SampleCount: UINT, pNumQualityLevels: *mut UINT
    ) -> HRESULT,
    fn CheckCounterInfo(&mut self, pCounterInfo: *mut D3D11_COUNTER_INFO) -> (),
    fn CheckCounter(
        &mut self, pDesc: *const D3D11_COUNTER_DESC, pType: *mut D3D11_COUNTER_TYPE,
        pActiveCounters: *mut UINT, szName: LPSTR, pNameLength: *mut UINT, szUnits: LPSTR,
        pUnitsLength: *mut UINT, szDescription: LPSTR, pDescriptionLength: *mut UINT
    ) -> HRESULT,
    fn CheckFeatureSupport(
        &mut self, Feature: D3D11_FEATURE, pFeatureSupportData: *mut c_void,
        FeatureSupportDataSize: UINT
    ) -> HRESULT,
    fn GetPrivateData(
        &mut self, guid: REFGUID, pDataSize: *mut UINT, pData: *mut c_void
    ) -> HRESULT,
    fn SetPrivateData(
        &mut self, guid: REFGUID, DataSize: UINT, pData: *const c_void
    ) -> HRESULT,
    fn SetPrivateDataInterface(&mut self, guid: REFGUID, pData: *const IUnknown) -> HRESULT,
    fn GetFeatureLevel(&mut self) -> D3D_FEATURE_LEVEL,
    fn GetCreationFlags(&mut self) -> UINT,
    fn GetDeviceRemovedReason(&mut self) -> HRESULT,
    fn GetImmediateContext(&mut self, ppImmediateContext: *mut *mut ID3D11DeviceContext) -> (),
    fn SetExceptionMode(&mut self, RaiseFlags: UINT) -> HRESULT,
    fn GetExceptionMode(&mut self) -> UINT
}}
FLAGS!{enum D3D11_CREATE_DEVICE_FLAG {
    D3D11_CREATE_DEVICE_SINGLETHREADED = 0x1,
    D3D11_CREATE_DEVICE_DEBUG = 0x2,
    D3D11_CREATE_DEVICE_SWITCH_TO_REF = 0x4,
    D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS = 0x8,
    D3D11_CREATE_DEVICE_BGRA_SUPPORT = 0x20,
    D3D11_CREATE_DEVICE_DEBUGGABLE = 0x40,
    D3D11_CREATE_DEVICE_PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY = 0x80,
    D3D11_CREATE_DEVICE_DISABLE_GPU_TIMEOUT = 0x100,
    D3D11_CREATE_DEVICE_VIDEO_SUPPORT = 0x800,
}}
pub const D3D11_SDK_VERSION: DWORD = 7;
