/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

import rene.dialogs.Warning;
import rene.util.FileName;
import rene.util.parser.StringParser;
import rene.zirkel.objects.DriverObject;

/**
 * The Global class.
 * <p>
 * This class will load a resource bundle with local support. It will set
 * various things from this resource file.
 */

public class Global {
	// Fonts:
	static public Font NormalFont = null, FixedFont = null, BoldFont = null;

	static public void makeFonts() {
		NormalFont = createfont("normalfont", "SansSerif", 12, false);
		FixedFont = createfont("fixedfont", "Monospaced", 12, false);
		BoldFont = createfont("fixedfont", "Monospaced", 12, true);

	}

	static {
		makeFonts();
	}

	static public Font createfont(final String name, final String def,
			final int defsize, final boolean bold) {
		final String fontname = getParameter(name + ".name", def);
		final String mode = getParameter(name + ".mode", "plain");
		if (bold || mode.equals("bold")) {
			return new Font(fontname, Font.BOLD, getParameter(name + ".size",
					defsize));
		} else if (mode.equals("italic")) {
			return new Font(fontname, Font.ITALIC, getParameter(name + ".size",
					defsize));
		} else {
			return new Font(fontname, Font.PLAIN, Global.getParameter(name
					+ ".size", defsize));
		}
	}

	static public Color Background = null, ControlBackground = null;

	static {
		makeColors();
	}

	static public void makeColors() {
		if (haveParameter("color.background"))
			Background = getParameter("color.background", Color.gray.brighter());
		else
			Background = SystemColor.window;
		if (haveParameter("color.control"))
			ControlBackground = getParameter("color.control", Color.gray
					.brighter());
		else
			ControlBackground = SystemColor.control;
	}

	// For heavy objects dependencies :
	static private Vector ObjectsToClearList = new Vector();

	static public void doClearList() {
		final Enumeration e = ObjectsToClearList.elements();
		while (e.hasMoreElements()) {
			final DriverObject dobj = (DriverObject) e.nextElement();
			if (dobj.somethingChanged())
				dobj.clearChanges();
		}
		ObjectsToClearList.clear();
	}

	static public void addClearList(final DriverObject oc) {
		ObjectsToClearList.add(oc);
	}

	// Resources:
	static protected ResourceBundle B;

	public static Enumeration names() {
		if (B != null)
			return B.getKeys();
		else
			return null;
	}

	public static String name(final String tag, final String def) {
		String s;
		if (B == null)
			return def;
		try {
			s = B.getString(tag);
		} catch (final Exception e) {
			s = def;
		}
		return s;
	}

	public static String name(final String tag) {
		return name(tag, tag.substring(tag.lastIndexOf(".") + 1));
	}

	public static void initBundle(final String file, final boolean language) {
		try {
			B = ResourceBundle.getBundle(file);
			String lang = getParameter("language", "");
			if (language && !lang.equals("") && !lang.equals("default")) {
				String langsec = "";
				if (lang.length() > 3 && lang.charAt(2) == '_') {
					langsec = lang.substring(3);
					lang = lang.substring(0, 2);
				}
				Locale.setDefault(new Locale(lang, langsec));
				initBundle(file, false);
			}
		} catch (final RuntimeException e) {
			B = null;
		}
	}

	public static void initBundle(final String file) {
		initBundle(file, false);
	}

	// Properties:
	public static Properties P = new Properties();
	static String ConfigName;

	public static synchronized Enumeration properties() {
		return P.keys();
	}

	public static synchronized void loadProperties(final InputStream in) {
		try {
			P = new Properties();
			P.load(in);
			in.close();
		} catch (final Exception e) {
			P = new Properties();
		}
	}

	public static synchronized boolean loadPropertiesFromResource(
			final String filename) {
		try {
			final Object G = new Object();
			final InputStream in = G.getClass().getResourceAsStream(filename);
			P = new Properties();
			P.load(in);
			in.close();
		} catch (final Exception e) {
			P = new Properties();
			return false;
		}
		ConfigName = filename;
		return true;
	}

	public static synchronized boolean loadProperties(final String filename) {
		ConfigName = filename;
		try {
			final FileInputStream in = new FileInputStream(filename);
			P = new Properties();
			P.load(in);
			in.close();
		} catch (final Exception e) {
			P = new Properties();
			return false;
		}
		return true;
	}

	public static synchronized void loadProperties(final String dir,
			final String filename) {
		try {
			final Properties p = System.getProperties();
			ConfigName = dir + p.getProperty("file.separator") + filename;
			loadProperties(ConfigName);
		} catch (final Exception e) {
			P = new Properties();
		}
	}

	public static synchronized void loadPropertiesInHome(final String filename) {
		try {
			final Properties p = System.getProperties();
			loadProperties(p.getProperty("user.home"), filename);
		} catch (final Exception e) {
			P = new Properties();
		}
	}

	public static synchronized void clearProperties() {
		P = new Properties();
	}

	public static synchronized void saveProperties(final String text) {
		try {
			final FileOutputStream out = new FileOutputStream(ConfigName);
			P.store(out, text);
			// P.save(out,text);
			out.close();
		} catch (final Exception e) {
		}
	}

	public static void saveProperties(final String text, final String filename) {
		ConfigName = filename;
		saveProperties(text);
	}

	public static synchronized void setParameter(final String key,
			final boolean value) {
		if (P == null)
			return;
		if (value)
			P.put(key, "true");
		else
			P.put(key, "false");
	}

	public static synchronized boolean getParameter(final String key,
			final boolean def) {
		try {
			final String s = P.getProperty(key);
			if (s.equals("true"))
				return true;
			else if (s.equals("false"))
				return false;
			return def;
		} catch (final Exception e) {
			return def;
		}
	}

	public static synchronized String getParameter(final String key,
			final String def) {
		String res = def;
		try {
			res = P.getProperty(key);
		} catch (final Exception e) {
		}
		if (res != null) {
			if (res.startsWith("$"))
				res = res.substring(1);
			return res;
		} else
			return def;
	}

	public static synchronized void setParameter(final String key, String value) {
		if (P == null)
			return;
		if (value.length() > 0 && Character.isSpaceChar(value.charAt(0)))
			value = "$" + value;
		P.put(key, value);
	}

	public static synchronized int getParameter(final String key, final int def) {
		try {
			return Integer.parseInt(getParameter(key, ""));
		} catch (final Exception e) {
			try {
				final double x = new Double(getParameter(key, ""))
				.doubleValue();
				return (int) x;
			} catch (final Exception ex) {
			}
			return def;
		}
	}

	public static synchronized void setParameter(final String key,
			final int value) {
		setParameter(key, "" + value);
	}

	public static synchronized double getParameter(final String key,
			final double def) {
		try {
			return new Double(getParameter(key, "")).doubleValue();
		} catch (final Exception e) {
			return def;
		}
	}

	public static synchronized void setParameter(final String key,
			final double value) {
		setParameter(key, "" + value);
	}

	static public synchronized Color getParameter(final String key,
			final Color c) {
		final String s = getParameter(key, "");
		if (s.equals(""))
			return c;
		final StringParser p = new StringParser(s);
		p.replace(',', ' ');
		int red, green, blue;
		red = p.parseint();
		green = p.parseint();
		blue = p.parseint();
		try {
			return new Color(red, green, blue);
		} catch (final RuntimeException e) {
			return c;
		}
	}

	static public synchronized Color getParameter(final String key, int red,
			int green, int blue) {
		final String s = getParameter(key, "");
		if (s.equals(""))
			return new Color(red, green, blue);
		final StringParser p = new StringParser(s);
		p.replace(',', ' ');
		red = p.parseint();
		green = p.parseint();
		blue = p.parseint();
		try {
			return new Color(red, green, blue);
		} catch (final RuntimeException e) {
			return Color.black;
		}
	}

	public static synchronized void setParameter(final String key, final Color c) {
		if (c != null)
			setParameter(key, "" + c.getRed() + "," + c.getGreen() + ","
					+ c.getBlue());
		else
			P.remove((Object) key);
	}

	/**
	 * Remove a specific Paramater.
	 */
	public static synchronized void removeParameter(final String key) {
		P.remove((Object) key);
	}

	/**
	 * Remove all Parameters that start with the string.
	 */
	public static synchronized void removeAllParameters(final String start) {
		final Enumeration e = P.keys();
		while (e.hasMoreElements()) {
			final String key = (String) e.nextElement();
			if (key.startsWith(start)) {
				P.remove((Object) key);
			}
		}
	}

	/**
	 * Set default values for parameters resetDefaults("default.") is the same
	 * as: setParameter("xxx",getParameter("default.xxx","")); if "default.xxx"
	 * has a value.
	 * 
	 * @param defaults
	 */
	public static synchronized void resetDefaults(final String defaults) {
		final Enumeration e = P.keys();
		while (e.hasMoreElements()) {
			final String key = (String) e.nextElement();
			if (key.startsWith(defaults)) {
				setParameter(key.substring(defaults.length()), getParameter(
						key, ""));
			}
		}
	}

	public static void resetDefaults() {
		resetDefaults("default.");
	}

	/**
	 * @return if I have such a parameter.
	 */
	public static synchronized boolean haveParameter(final String key) {
		try {
			final String res = P.getProperty(key);
			if (res == null)
				return false;
		} catch (final Exception e) {
			return false;
		}
		return true;
	}

	// Warnings

	static Frame F = null;

	public static void warning(final String s) {
		if (F == null) {
			F = new Frame();
		}
		final Warning W = new Warning(F, s, name("warning"), false);
		W.center();
		W.setVisible(true);
		// W.show();
	}

	// Clipboard for applets
	static public String AppletClipboard = null;

	static public boolean IsApplet = false;

	static public void setApplet(final boolean flag) {
		IsApplet = flag;
	}

	static public boolean isApplet() {
		return IsApplet;
	}

	// Java Version

	public static double getJavaVersion() {
		final String version = System.getProperty("java.version");
		if (version == null)
			return 0.0;
		double v = 0.0;
		final StringTokenizer t = new StringTokenizer(version, ".");
		if (t.hasMoreTokens()) {
			v = convert(t.nextToken());
		} else
			return v;
		if (t.hasMoreTokens()) {
			v = v + convert(t.nextToken()) / 10;
		} else
			return v;
		if (t.hasMoreTokens()) {
			v = v + convert(t.nextToken()) / 100;
		}
		return v;
	}

	public static double convert(final String s) {
		try {
			return Integer.parseInt(s);
		} catch (final Exception e) {
			return 0;
		}
	}

	public static synchronized String getUserDir() {
		final String dir = System.getProperty("user.dir");
		return FileName.canonical(dir);
	}

	public static Object ExitBlock = new Object();

	public static synchronized void exit(final int i) {
		synchronized (ExitBlock) {
			System.exit(i);
		}
	}

	public static void main(final String args[]) {
		try {
			System.out.println(new Color(4, 5, 600));
		} catch (final RuntimeException e) {
		}
	}
}
