import pygame
from pygame.locals import *

from widget import *
import common
from config import conf, PlayerConfig

menu_back = common.load_image('back.png')

def draw_background():
	common.backbuffer = menu_back.convert()
	common.blit(common.backbuffer)

class NewGameState(WidgetState):

	def __init__(self):
		WidgetState.__init__(self)

		def start_game(total_players, local_players, ai_players):
			import server
			ser = server.Server(total_players)
			ser.run(local_players, ai_players)

		def on_total_change():
			self.local_players.value = min(self.local_players.value, self.total_players.value)
			self.local_players.choices = range(self.total_players.value + 1)

		Button("back", (50, -20), self.quit)
		self.total_players = SpinBox("Total Players", (50, 360), (2,3,4), default=conf.total_players, on_change=on_total_change)
		self.local_players = SpinBox("Local Players", (50, 400), (1,2,3,4), default=conf.local_players)
		if common.debug:
			self.ai_players = SpinBox("AI Players", (50, 440), (0,1,2), conf.ai_players)
			Button("Start Game", (None, 250), lambda: start_game(self.total_players.value, self.local_players.value, self.ai_players.value))
		else:
			Button("Start Game", (None, 250), lambda: start_game(self.total_players.value, self.local_players.value, 0))
		on_total_change()

	def init_state_display(self):
		draw_background()
	
	def quit(self):
		WidgetState.quit(self)
		# save changes in config
		conf.total_players = self.total_players.value
		conf.local_players = self.local_players.value
		if common.debug:
			conf.ai_players = self.ai_players.value

class JoinGameState(WidgetState):

	def __init__(self):
		WidgetState.__init__(self);
		def join(server, local_players):
			import client
			cl = client.Client(server)
			cl.run(local_players)

		Button("back", (50, -20), self.quit)
		self.server = LineEdit("Server", (50, 360), conf.server)
		self.local_players = SpinBox("Local Players", (50, 400), (1,2))
		Button("Join Game", (None, 250), lambda: join(self.server.value, self.local_players.value) )

	def init_state_display(self):
		draw_background()

	def quit(self):
		WidgetState.quit(self)
		# save changes in config
		conf.server = self.server.value

class ConfigState(WidgetState):

	def __init__(self):
		WidgetState.__init__(self)
		top = 225
		line_height = 40
		(self.up, self.down, self.left, self.right) = ([0, 0], [0, 0], [0, 0], [0, 0])
		self.button = [[0, 0], [0, 0]]
		for i in (0,1):
			keys = PlayerConfig.instances[i].keys
			self.up[i] = [keys.up]
			self.down[i] = [keys.down]
			self.left[i] = [keys.left]
			self.right[i] = [keys.right]
			self.button[i][0] = [keys.button[0]]
			self.button[i][1] = [keys.button[1]]
			Button("Player " + str(i+1), (50 + i*500, top), None)
			KeyConfigButton("Up", (50 + i*500, top + line_height), self.up[i])
			KeyConfigButton("Down", (50 + i*500, top + line_height*2), self.down[i])
			KeyConfigButton("Left", (50 + i*500, top + line_height*3), self.left[i])
			KeyConfigButton("Right", (50 + i*500, top + line_height*4), self.right[i])
			KeyConfigButton("Button 1", (50 + i*500, top + line_height*5), self.button[i][0])
			KeyConfigButton("Button 2", (50 + i*500, top + line_height*6), self.button[i][1])

		Button("back", (50, -20), self.quit)

	def quit(self):
		for i in (0,1):
			keys = PlayerConfig.instances[i].keys
			keys.up = self.up[i][0]
			keys.down = self.down[i][0]
			keys.left = self.left[i][0]
			keys.right = self.right[i][0]
			keys.button[0] = self.button[i][0][0]
			keys.button[1] = self.button[i][1][0]
		WidgetState.quit(self)

class MenuState(WidgetState):

	def __init__(self):
		WidgetState.__init__(self)
		def help():
			from webbrowser import open
			from os.path import abspath
			file = "file://" + abspath("data/doc/rules.html")
			print file
			open(file, new=True)

		import sound
		sound.play_music()
		
		draw_background()
		Button("Start New Game", (25, 360), NewGameState)
		Button("Join Existing Game", (25, 400), JoinGameState)
		Button("Quit", (25, -20), self.quit)
		Button("Help", (-25, -20), help)
		Button("Options", (-25, -60), ConfigState)



