{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetFillProperties: TFillPropertiesNode;
    procedure SetFillProperties(const Value: TFillPropertiesNode);
    function GetLineProperties: TLinePropertiesNode;
    procedure SetLineProperties(const Value: TLinePropertiesNode);
    function GetTextureTransform: TAbstractTextureTransformNode;
    procedure SetTextureTransform(const Value: TAbstractTextureTransformNode);
    function GetShadowCaster: boolean;
    procedure SetShadowCaster(const Value: boolean);
    function GetHeightMapScale: Single;
    procedure SetHeightMapScale(const Value: Single);
    function GetBlendMode: TBlendModeNode;
    procedure SetBlendMode(const Value: TBlendModeNode);
  public
    property FillProperties: TFillPropertiesNode read GetFillProperties write SetFillProperties;
    property LineProperties: TLinePropertiesNode read GetLineProperties write SetLineProperties;
    property TextureTransform: TAbstractTextureTransformNode read GetTextureTransform write SetTextureTransform;
    property ShadowCaster: boolean read GetShadowCaster write SetShadowCaster;
    property HeightMapScale: Single read GetHeightMapScale write SetHeightMapScale;
    property BlendMode: TBlendModeNode read GetBlendMode write SetBlendMode;

{$endif read_interface}

{$ifdef read_implementation}

{ TAppearanceNode ----------------------------------------------- }

function TAppearanceNode.GetFillProperties: TFillPropertiesNode;
begin
  if FdFillProperties.Value is TFillPropertiesNode then
    Result := TFillPropertiesNode(FdFillProperties.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetFillProperties(const Value: TFillPropertiesNode);
begin
  FdFillProperties.Send(Value);
end;

function TAppearanceNode.GetLineProperties: TLinePropertiesNode;
begin
  if FdLineProperties.Value is TLinePropertiesNode then
    Result := TLinePropertiesNode(FdLineProperties.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetLineProperties(const Value: TLinePropertiesNode);
begin
  FdLineProperties.Send(Value);
end;

function TAppearanceNode.GetTextureTransform: TAbstractTextureTransformNode;
begin
  if FdTextureTransform.Value is TAbstractTextureTransformNode then
    Result := TAbstractTextureTransformNode(FdTextureTransform.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetTextureTransform(const Value: TAbstractTextureTransformNode);
begin
  FdTextureTransform.Send(Value);
end;

function TAppearanceNode.GetShadowCaster: boolean;
begin
  Result := FdShadowCaster.Value;
end;

procedure TAppearanceNode.SetShadowCaster(const Value: boolean);
begin
  FdShadowCaster.Send(Value);
end;

function TAppearanceNode.GetHeightMapScale: Single;
begin
  Result := FdHeightMapScale.Value;
end;

procedure TAppearanceNode.SetHeightMapScale(const Value: Single);
begin
  FdHeightMapScale.Send(Value);
end;

function TAppearanceNode.GetBlendMode: TBlendModeNode;
begin
  if FdBlendMode.Value is TBlendModeNode then
    Result := TBlendModeNode(FdBlendMode.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetBlendMode(const Value: TBlendModeNode);
begin
  FdBlendMode.Send(Value);
end;

{$endif read_implementation}
