{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetTimeOriginAtLoad: boolean;
    procedure SetTimeOriginAtLoad(const Value: boolean);
    function GetOctreeRendering: TKambiOctreePropertiesNode;
    procedure SetOctreeRendering(const Value: TKambiOctreePropertiesNode);
    function GetOctreeDynamicCollisions: TKambiOctreePropertiesNode;
    procedure SetOctreeDynamicCollisions(const Value: TKambiOctreePropertiesNode);
    function GetOctreeVisibleTriangles: TKambiOctreePropertiesNode;
    procedure SetOctreeVisibleTriangles(const Value: TKambiOctreePropertiesNode);
    function GetOctreeStaticCollisions: TKambiOctreePropertiesNode;
    procedure SetOctreeStaticCollisions(const Value: TKambiOctreePropertiesNode);
    function GetHeadBobbing: Single;
    procedure SetHeadBobbing(const Value: Single);
    function GetHeadBobbingTime: Single;
    procedure SetHeadBobbingTime(const Value: Single);
    function GetHeadlightNode: TAbstractLightNode;
    procedure SetHeadlightNode(const Value: TAbstractLightNode);
  public
    property TimeOriginAtLoad: boolean read GetTimeOriginAtLoad write SetTimeOriginAtLoad;
    property OctreeRendering: TKambiOctreePropertiesNode read GetOctreeRendering write SetOctreeRendering;
    property OctreeDynamicCollisions: TKambiOctreePropertiesNode read GetOctreeDynamicCollisions write SetOctreeDynamicCollisions;
    property OctreeVisibleTriangles: TKambiOctreePropertiesNode read GetOctreeVisibleTriangles write SetOctreeVisibleTriangles;
    property OctreeStaticCollisions: TKambiOctreePropertiesNode read GetOctreeStaticCollisions write SetOctreeStaticCollisions;
    property HeadBobbing: Single read GetHeadBobbing write SetHeadBobbing;
    property HeadBobbingTime: Single read GetHeadBobbingTime write SetHeadBobbingTime;
    property HeadlightNode: TAbstractLightNode read GetHeadlightNode write SetHeadlightNode;

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiNavigationInfoNode ----------------------------------------------- }

function TKambiNavigationInfoNode.GetTimeOriginAtLoad: boolean;
begin
  Result := FdTimeOriginAtLoad.Value;
end;

procedure TKambiNavigationInfoNode.SetTimeOriginAtLoad(const Value: boolean);
begin
  FdTimeOriginAtLoad.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeRendering: TKambiOctreePropertiesNode;
begin
  if FdOctreeRendering.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeRendering.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeRendering(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeRendering.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeDynamicCollisions: TKambiOctreePropertiesNode;
begin
  if FdOctreeDynamicCollisions.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeDynamicCollisions.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeDynamicCollisions(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeDynamicCollisions.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeVisibleTriangles: TKambiOctreePropertiesNode;
begin
  if FdOctreeVisibleTriangles.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeVisibleTriangles.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeVisibleTriangles(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeVisibleTriangles.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeStaticCollisions: TKambiOctreePropertiesNode;
begin
  if FdOctreeStaticCollisions.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeStaticCollisions.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeStaticCollisions(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeStaticCollisions.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbing: Single;
begin
  Result := FdHeadBobbing.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbing(const Value: Single);
begin
  FdHeadBobbing.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbingTime: Single;
begin
  Result := FdHeadBobbingTime.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbingTime(const Value: Single);
begin
  FdHeadBobbingTime.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadlightNode: TAbstractLightNode;
begin
  if FdHeadlightNode.Value is TAbstractLightNode then
    Result := TAbstractLightNode(FdHeadlightNode.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetHeadlightNode(const Value: TAbstractLightNode);
begin
  FdHeadlightNode.Send(Value);
end;

{$endif read_implementation}
