{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetAlpha: Single;
    procedure SetAlpha(const Value: Single);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
  public
    property Alpha: Single read GetAlpha write SetAlpha;
    property Color: TCastleColorRGB read GetColor write SetColor;

{$endif read_interface}

{$ifdef read_implementation}

{ TMultiTextureNode ----------------------------------------------- }

function TMultiTextureNode.GetAlpha: Single;
begin
  Result := FdAlpha.Value;
end;

procedure TMultiTextureNode.SetAlpha(const Value: Single);
begin
  FdAlpha.Send(Value);
end;

function TMultiTextureNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TMultiTextureNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

{$endif read_implementation}
