#
#   Copyright (C) 1998, 1999, 2000, 2001 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software 
#   Foundation, Inc. 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA.
#
package Catalog::tools::mifluz;
use strict;

use DBI;
use DBD::Mifluz;
use Catalog::tools::tools;
use Carp qw(cluck);

sub new {
    my($type) = @_;

    my($self) = {};
    bless($self, $type);
    $self->initialize();
    return $self;
}

sub initialize {
    my($self) = @_;

    my($config) = config_load("mifluz.conf");

    %$self = ( %$self , %$config );
}

sub connect {
    my($self) = @_;

    if(!defined($self->{'connection'})) {
	my($config) = config_path("mifluz.conf");
	error("unable to find the mifluz.conf file") if(!defined($config));
	dbg("config path is $config", "mifluz");
	    
	my($file) = $self->file();

	error("configuration file does not define mifluz_dir") if(!defined($self->{'mifluz_dir'}));

	my($dsn) = "dbi:Mifluz:base=$file;config=$config";
	dbg("DBI connect $dsn ", "mifluz");
	if(!($self->{'connection'} = DBI->connect($dsn, '', '', { PrintError => 0, }))) {
	    error("cannot connect to $dsn $DBI::errstr");
	}
    }
    return $self->{'connection'};
}

sub file {
    my($self) = @_;

    return "$self->{'mifluz_dir'}/mifluz";
}

sub exec_select_one {
    my($self) = shift;
    my($result) = $self->exec_select(@_, 1);
    if(@$result > 0) {
	return $result->[0];
    } else {
	return undef;
    }
}

sub select {
    my($self, $sql, $index, $length) = @_;

    my($base) = $self->connect();

    $index = 0 if(!defined($index) || $index < 0);
    $length = 10 if(!defined($length) || $length < 0);
    my($last) = $index + $length;

    my($stmt) = $base->prepare("$sql [limit=$index,$last]");
    error("cannot prepare $sql : " . $base->errstr()) if(!defined($stmt));
    $stmt->execute() or error("cannot execute $sql : " . $base->errstr());

    my(@result);
    my($ntuples) = 0;
    my($hash_ref);
    while($hash_ref = $stmt->fetchrow_hashref()) {
	$ntuples++;
	push(@result, { %$hash_ref });
    }
    $stmt->finish();

    my($total) = $stmt->{'matches_total'};

    dbg("$sql -> $ntuples out of $total rows\n", "mifluz");
    
    return (\@result, $total);
}

sub exec_select {
    my($self, $sql, $limit) = @_;

    my($base) = $self->connect();
    dbg("$sql\n", "mifluz");

    $limit = 0 if(!defined($limit));

    my($stmt) = $base->prepare("$sql [limit=$limit]");
    error("cannot prepare $sql : " . $base->errstr()) if(!defined($stmt));
    $stmt->execute() or error("cannot execute $sql : " . $base->errstr());

    my(@result);
    my($ntuples) = 0;
    my($hash_ref);
    while($hash_ref = $stmt->fetchrow_hashref()) {
	$ntuples++;
	push(@result, { %$hash_ref });
    }
    $stmt->finish();

    return (\@result, $ntuples);
}

sub exec {
    my($self, $sql) = @_;
    my($base) = $self->connect();
    my($count) = 0;
    if($::opt_fake) {
	print "$sql;\n";
    } else {
	dbg("$sql\n", "mifluz");
	$count = $base->do("$sql");
	error("cannot do $sql : " . $base->errstr()) if(!defined($count));
    }

    return $count;
}

sub logoff {
    my($self) = @_;

    if($self->{'connection'}) {
	$self->{'connection'}->disconnect();
	undef($self->{'connection'});
    }
}

1;
# Local Variables: ***
# mode: perl ***
# End: ***
