/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.jasper.servlet.JasperLoader;

public class JspEngineContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    JasperLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;

    public JspEngineContext(JasperLoader loader, String classpath, ServletContext context, String jspFile, boolean isErrPage, Options options, HttpServletRequest req, HttpServletResponse res) {
        this.loader = loader;
        this.classpath = classpath;
        this.context = context;
        this.jspFile = jspFile;
        this.isErrPage = isErrPage;
        this.options = options;
        this.req = req;
        this.res = res;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getClassPath() {
        return this.loader.getClassPath() + this.classpath;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void addJar(String jar) throws IOException {
        this.loader.addJar(jar);
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public final String getFullClassName() {
        if (this.servletPackageName == null) {
            return this.servletClassName;
        }
        return this.servletPackageName + "." + this.servletClassName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javac;
        String compilerPath = this.options.getJspCompilerPath();
        Class jspCompilerPlugin = this.options.getJspCompilerPlugin();
        if (jspCompilerPlugin != null) {
            try {
                javac = (JavaCompiler)jspCompilerPlugin.newInstance();
            }
            catch (Exception ex) {
                Constants.message("jsp.warning.compiler.class.cantcreate", new Object[]{jspCompilerPlugin, ex}, Integer.MIN_VALUE);
                javac = new SunJavaCompiler();
            }
        } else {
            javac = new SunJavaCompiler();
        }
        if (compilerPath != null) {
            javac.setCompilerPath(compilerPath);
        }
        JspCompiler jspCompiler = new JspCompiler(this);
        jspCompiler.setJavaCompiler(javac);
        return jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.charAt(0) == '/') {
            return uri;
        }
        String actURI = this.req.getServletPath();
        String baseURI = actURI.substring(0, actURI.lastIndexOf(47));
        return baseURI + '/' + uri;
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(res);
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }
}

