/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMFile;

final class RAMOutputStream
extends OutputStream {
    RAMFile file;
    int pointer = 0;

    public RAMOutputStream(RAMFile rAMFile) {
        this.file = rAMFile;
    }

    public final void flushBuffer(byte[] byArray, int n) {
        int n2;
        int n3 = this.pointer / 1024;
        int n4 = this.pointer % 1024;
        int n5 = 1024 - n4;
        int n6 = n2 = n5 >= n ? n : n5;
        if (n3 == this.file.buffers.size()) {
            this.file.buffers.addElement(new byte[1024]);
        }
        byte[] byArray2 = (byte[])this.file.buffers.elementAt(n3);
        System.arraycopy(byArray, 0, byArray2, n4, n2);
        if (n2 < n) {
            int n7 = n2;
            n2 = n - n2;
            if (++n3 == this.file.buffers.size()) {
                this.file.buffers.addElement(new byte[1024]);
            }
            byArray2 = (byte[])this.file.buffers.elementAt(n3);
            System.arraycopy(byArray, n7, byArray2, 0, n2);
        }
        this.pointer += n;
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
        this.file.lastModified = System.currentTimeMillis();
    }

    public final void close() throws IOException {
        super.close();
    }

    public final void seek(long l) throws IOException {
        super.seek(l);
        this.pointer = (int)l;
    }

    public final long length() throws IOException {
        return this.file.length;
    }
}

