;;; @file transnib.s
;;; Transfer routines for the 4-bit/4-bit PET/C64/C128/Vic-20 to Amiga cable
;;; designed by Matt Francis (m.p.francis@newcastle.ac.uk)
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (rhialto@mbfys.kun.nl)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#define initcable lda #$40:sta data:sta ddr
	;; deinitialize the cable
#define deinitcable
	;; determine whether a request is pending
#define isrequest bit data:bmi return:initcable
	
	; .A = data, .Y = 00, .X preserved
receive_switch:
	lda #$40	; $40 is DRCV (output), $80 is DRDY (input)
	sta ddr
receive:
rereceive:
	jsr recvnib	; high nibble first
	asl
	asl
	asl
	asl
	sta stemp
	jsr recvnib
	ldy #0	; (y is preserved in this function)
	ora stemp
	rts

recvnib:
rdrdyhi:
	bit data	; - Receiver starts waiting for DRDY to go low.
	bmi rdrdyhi
		; - Sender puts nibble on data lines, pulls DRDY low and waits
		; for DRCV to go low.
	lda data	; - Receiver gets nibble,
	and #$ff-$40	;   pulls DRCV low
	sta data
rdrdylo:
	bit data	;   and waits for DRDY to go high.
	bpl rdrdylo
		; - Sender pulls DRDY high and waits for DRCV to go high.
	ora #$40
	sta data	; - Receiver pulls DRCV high
	and #$0f
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
	ldy #$4f	; $80 is DRCV (input), $40 is DRDY (output)
	sty ddr	; note that the names are swapped from receiving but the
		; data direction isn't!
send:
	tay		; high nibble first
	lsr
	lsr
	lsr
	lsr
	jsr sendnib
	tya
	and #$0f	; fall through to send low nibble
	ldy #0	; clear y

sendnib:	; - Receiver starts waiting for DRDY to go low.
	sta data	; - Sender puts nibble on data lines, pulls DRDY low and
rdrcvhi:
	bit data	;   waits or DRCV to go low.
	bmi rdrcvhi
		; - Receiver gets nibble, pulls DRCV low
		;   and waits for DRDY to go high.
	ora #$40	; - Sender pulls DRDY high and
	sta data
rdrcvlo:
	bit data	;   waits for DRCV to go high.
	bpl rdrcvlo

	rts
