;;; @file petcommon.s
;;; Commodore PET definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (seibert@mbfys.kun.nl)

;;; start address for the server program
serverstart = $7c00
;;; start address for the utility programs
utilstart = $7000

;;; in the 6522, the interrupt flag has to be reset
clearviaifr = 1
;;; in the 6526, the FLAG line may need debouncing in the C64/C128
ciadebounce = 0

;;; Commodore cassette port definitions
c2n1read = $e811		; PIA Control Register A
c2n1rdval = $80			; CA1 (cassette #1 read)
c2n2read = $e84d		; VIA Interrupt Flag Register
c2n2rdval = $10			; CB1 (cassette #2 read)
;; use cassette port #1 by default
#define c2nread c2n1read
#define c2nrdval c2n1rdval
c2nwrite = $e840		; VIA output register B
c2nwrval = 8			; PB3 (cassette write)

;;; memory locations
stemp	= $bd	; memory place that may hold the byte being received

start	= $c7	; start address of the transfer area
end	= $c9	; end address of the transfer
cinv	= $0090	; interrupt vector

bstart	= $28	; start of basic program text
bend	= $2a	; end of basic program text
blnsw	= $a7
crsw	= $ac

stack	= $104	; offset to the stack while in interrupt

ackval	= $20	; CB2 value bit when set to manual control
ack	= $e84c ; VIA CRB
data	= $e84f ; VIA PA without handshake
ddr	= $e843 ; VIA DDRA
strval	= $02	; VIA CA1 bit in IFR
strobe	= $e84d ; VIA IFR

	;; program header
#define header

	;; exit from an interrupt
#define irqexit pla:tay:pla:tax:pla:rti

	;; store the speed settings and enable fast speed
#define phfast
	;; restore original speed from fast speed
#define plfast
	;; store the speed settings and enable slow speed (no badlines)
#define phslow
	;; restore original speed from slow speed
#define plslow
	;; disable timer interrupts
#define deactirq sei
	;; re-enable timer interrupts
#define reactirq
