/**
 * @file comm.h
 * Communication interface
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/* Copyright  2001 Marko Mkel.

   This file is part of CBMLINK, a program for data communications between
   Commodore 8-bit microcomputers and other computer systems.

   CBMLINK is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   CBMLINK is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** Communication primitives */
struct comm
{
  /** Switch from receive to send */
  void (*comm_rs) (void);
  /** Switch from send to receive */
  void (*comm_sr) (void);

  /** Send data
   * @param buf		the data to be sent
   * @param len		length of the data in bytes
   * @return		zero on success, nonzero on failure
   */
  int (*comm_write) (const void* buf, unsigned len);

  /** Receive data
   * @param buf		the data to be received
   * @param len		length of the data in bytes
   * @return		zero on success, nonzero on failure
   */
  int (*comm_read) (void* buf, unsigned len);
};
