#ifndef __GB2BIG_H
#define __GB2BIG_H

#ifdef __GNUC__
#  define strcmpi(s1, s2) strcasecmp(s1, s2)
#endif __GNUC__

#define LOBYTE(n)   ((n) & 0xFF)
#define HIBYTE(n)   ((n) / 256 )

static int GBToBig5Tbl[]={    /* 6769 GB chars */
    0xA140, 0xA142, 0xA143, 0xA14F, 0xA1C2, 0x0000, 0xA14C, 0xA1B2, 
    0x0000, 0xA277, 0xA1E3, 0xA1FC, 0xA14B, 0xA1A5, 0xA1A6, 0xA1A7, 
    0xA1A8, 0xA165, 0xA166, 0xA171, 0xA172, 0xA16D, 0xA16E, 0xA175, 
    0xA176, 0xA179, 0xA17A, 0x0000, 0x0000, 0xA169, 0xA16A, 0xA1D3, 
    0xA1D1, 0xA1D2, 0xA14A, 0xA34E, 0x0000, 0xA355, 0xA353, 0xA1E5, 
    0xA1E4, 0x0000, 0x0000, 0xA1D4, 0x0000, 0x0000, 0xA1E7, 0x0000, 
    0xA1F3, 0xA1EC, 0xA1ED, 0xA1DD, 0x0000, 0xA1DC, 0x0000, 0x0000, 
    0xA1DA, 0x0000, 0x0000, 0xA1D8, 0xA1D9, 0xA1DB, 0xA1EE, 0xA1EF, 
    0xA1F1, 0xA1F0, 0xA258, 0xA1AC, 0xA1AA, 0xA24A, 0xA243, 0x0000, 
    0xA246, 0xA247, 0x0000, 0xA1B1, 0x0000, 0xA1B8, 0xA1B9, 0xA1B3, 
    0xA1B4, 0xA1B7, 0xA1BA, 0xA1BB, 0xA1BC, 0xA1BD, 0xA1B5, 0xA1B6, 
    0xA1B0, 0xA1F7, 0xA1F6, 0xA1F4, 0xA1F5, 0xA2A4, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA2B9, 0xA2BA, 
    0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xA149, 0xA1A9, 0xA1AD, 0x0000, 
    0xA248, 0xA1AE, 0xA1AC, 0xA15D, 0xA15E, 0xA1AF, 0xA1CF, 0xA141, 
    0xA1D0, 0xA144, 0xA1FE, 0xA2AF, 0xA2B0, 0xA2B1, 0xA2B2, 0xA2B3, 
    0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 0xA147, 0xA151, 0xA1D5, 
    0xA1D7, 0xA1D6, 0xA148, 0xA249, 0xA2CF, 0xA2D0, 0xA2D1, 0xA2D2, 
    0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 0xA2D7, 0xA2D8, 0xA2D9, 0xA2DA, 
    0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0, 0xA2E1, 0xA2E2, 
    0xA2E3, 0xA2E4, 0xA2E5, 0xA2E6, 0xA2E7, 0xA2E8, 0xA1A3, 0xA240, 
    0xA1A4, 0xA173, 0xA15A, 0xA1AB, 0xA2E9, 0xA2EA, 0xA2EB, 0xA2EC, 
    0xA2ED, 0xA2EE, 0xA2EF, 0xA2F0, 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 
    0xA2F5, 0xA2F6, 0xA2F7, 0xA2F8, 0xA2F9, 0xA2FA, 0xA2FB, 0xA2FC, 
    0xA2FD, 0xA2FE, 0xA340, 0xA341, 0xA342, 0xA343, 0xA1A1, 0xA157, 
    0xA1A2, 0xA1C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA344, 0xA345, 
    0xA346, 0xA347, 0xA348, 0xA349, 0xA34A, 0xA34B, 0xA34C, 0xA34D, 
    0xA34E, 0xA34F, 0xA350, 0xA351, 0xA352, 0xA353, 0xA354, 0xA355, 
    0xA356, 0xA357, 0xA358, 0xA359, 0xA35A, 0xA35B, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA35C, 0xA35D, 
    0xA35E, 0xA35F, 0xA360, 0xA361, 0xA362, 0xA363, 0xA364, 0xA365, 
    0xA366, 0xA367, 0xA368, 0xA369, 0xA36A, 0xA36B, 0xA36C, 0xA36D, 
    0xA36E, 0xA36F, 0xA370, 0xA371, 0xA372, 0xA373, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA374, 0xA375, 
    0xA376, 0xA377, 0xA378, 0xA379, 0xA37A, 0xA37B, 0xA37C, 0xA37D, 
    0xA37E, 0xA3A1, 0xA3A2, 0xA3A3, 0xA3A4, 0xA3A5, 0xA3A6, 0xA3A7, 
    0xA3A8, 0xA3A9, 0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD, 0xA3AE, 0xA3AF, 
    0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7, 
    0xA3B8, 0xA3B9, 0xA3BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xA277, 0x0000, 0xA278, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA27A, 
    0x0000, 0x0000, 0x0000, 0xA27B, 0x0000, 0x0000, 0x0000, 0xA27C, 
    0x0000, 0x0000, 0x0000, 0xA27D, 0x0000, 0x0000, 0x0000, 0xA275, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA274, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA273, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA272, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA271, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xB0DA, 0xAAFC, 0xAE4A, 0xAEC1, 0xAB75, 0xADFC, 
    0xAB73, 0xBD4A, 0xC0F9, 0xC4A7, 0xB847, 0xA6E3, 0xC3AA, 0xB752, 
    0xB969, 0xBE62, 0xAEF2, 0xA677, 0xADCD, 0xABF6, 0xB774, 0xA9A4, 
    0xD369, 0xAED7, 0xCDAC, 0xA9F9, 0xAF73, 0xA557, 0xB1CE, 0xBCF5, 
    0xBFAC, 0xC3CD, 0xB6C6, 0xB6F8, 0xBED2, 0xBF44, 0xAADD, 0xAEC3, 
    0xA5B6, 0xA57A, 0xA761, 0xAFB9, 0xA44B, 0xACCD, 0xA4DA, 0xA9DE, 
    0xB65B, 0xB976, 0xA7E2, 0xAFD2, 0xC5F2, 0xC551, 0xBD7D, 0xAAA8, 
    0xA5D5, 0xAC66, 0xA6CA, 0xC25C, 0xA8D5, 0xB1D1, 0xABF4, 0xDEFB, 
    0xB4B3, 0xAF5A, 0xB768, 0xA7E6, 0xAFEB, 0xB97B, 0xAA4F, 0xAAA9, 
    0xA7EA, 0xA9D5, 0xA6F1, 0xC3A4, 0xA562, 0xBFEC, 0xB2CC, 0xA8B9, 
    0xC0B0, 0xB1F5, 0xBA5D, 0xBB48, 0xB86A, 0xB4CE, 0xBD53, 0xB046, 
    0xC2E9, 0xB3C4, 0xC1BD, 0xAD63, 0xAD4D, 0xA55D, 0xBDC7, 0xADE9, 
    0xC1A1, 0xB972, 0xAB4F, 0xB3F9, 0xB9A1, 0xC45F, 0xA9EA, 0xB3F8, 
    0xBCC9, 0xB05C, 0xC06A, 0xC37A, 0xACD7, 0xB84F, 0xB464, 0xA8F5, 
    0xA55F, 0xBDFA, 0xAD49, 0xA8A9, 0xBE58, 0xADBF, 0xAF56, 0xB3C6, 
    0xBECE, 0xB548, 0xB351, 0xA962, 0xAD66, 0xA5BB, 0xB2C2, 0xB159, 
    0xC15E, 0xACC7, 0xACA6, 0xC2DB, 0xB06E, 0xB947, 0xBBF3, 0xA4F1, 
    0xBBC0, 0xB5A7, 0xA9BC, 0xBAD1, 0xE3C9, 0xBDAA, 0xB2A6, 0xC0C5, 
    0xCF68, 0xB9F4, 0xA7C8, 0xDECD, 0xB3AC, 0xB1CD, 0xB9FA, 0xA5B2, 
    0xB940, 0xBEC0, 0xC175, 0xC1D7, 0xB0A1, 0xC340, 0xC3E4, 0xBD73, 
    0xB653, 0xABF3, 0xAB4B, 0xC5DC, 0xA4CB, 0xBFEB, 0xC547, 0xC47C, 
    0xB94D, 0xBCD0, 0xB343, 0xBDA8, 0xAAED, 0xC5BE, 0xE578, 0xA74F, 
    0xC3A7, 0xB16C, 0xD979, 0xC378, 0xC0D8, 0xBBAB, 0xECE8, 0xA74C, 
    0xA642, 0xAC60, 0xA4FE, 0xAAC3, 0xBBE6, 0xACB1, 0xAF66, 0xA67D, 
    0xACC1, 0xB5D4, 0xBCBD, 0xBCB7, 0xB2DA, 0xAA69, 0xB3D5, 0xAB6B, 
    0xB769, 0xB960, 0xBAE4, 0xA742, 0xA9AD, 0xB2ED, 0xB2E4, 0xBB4B, 
    0xB4F1, 0xAA79, 0xBBE9, 0xAEB7, 0xA452, 0xADF7, 0xB8C9, 0xB0F0, 
    0xA4A3, 0xA5AC, 0xA842, 0xC3AF, 0xB3A1, 0xA9C6, 0xC0BF, 0xB271, 
    0xB5F4, 0xA7F7, 0xA47E, 0xB05D, 0xB842, 0xBDF2, 0xAAF6, 0xB16D, 
    0xB5E6, 0xBDB2, 0xC05C, 0xB0D1, 0xD3C9, 0xB4DD, 0xBA46, 0xBA47, 
    0xC0E9, 0xBB61, 0xBFB5, 0xADDC, 0xB7C9, 0xC2C3, 0xBEDE, 0xC157, 
    0xBCD1, 0xB1E4, 0xAFF3, 0xB45A, 0xB5A6, 0xB0BC, 0xA555, 0xB4FA, 
    0xBC68, 0xF34F, 0xB4A1, 0xA465, 0xD3B3, 0xAFF9, 0xAC64, 0xE2ED, 
    0xB767, 0xB9EE, 0xA7C3, 0xAE74, 0xB8D2, 0xA9EE, 0xAEE3, 0xB05B, 
    0xC465, 0xBA55, 0xC2CD, 0xC661, 0xC5FE, 0xC4F1, 0xC3EA, 0xB2A3, 
    0xC4C4, 0xC5B8, 0xA9F7, 0xB273, 0xB3F5, 0xB9C1, 0xB160, 0xAAF8, 
    0xC076, 0xB87A, 0xC944, 0xB4AF, 0xBA5A, 0xB0DB, 0xADD2, 0xB657, 
    0xA7DB, 0xB672, 0xB4C2, 0xBC4A, 0xBCE9, 0xB15F, 0xA76E, 0xAAA3, 
    0xA8AE, 0xA7E8, 0xBA4D, 0xB477, 0xB9FD, 0xBAAB, 0xD7EB, 0xA6DA, 
    0xA8B0, 0xB9D0, 0xB1E1, 0xA7D5, 0xA849, 0xB3AF, 0xB658, 0xC5A8, 
    0xBCB5, 0xBAD9, 0xABB0, 0xBEED, 0xA6A8, 0xA765, 0xADBC, 0xB57B, 
    0xC367, 0xBCE1, 0xB8DB, 0xA9D3, 0xB378, 0xC1FE, 0xAFAF, 0xA659, 
    0xB7F6, 0xABF9, 0xB0CD, 0xA6C0, 0xBFF0, 0xA6A2, 0xB9A3, 0xAEA2, 
    0xBEA6, 0xA8D7, 0xA4D8, 0xA8AA, 0xAFCD, 0xA5B8, 0xBF4B, 0xA552, 
    0xA852, 0xC2CE, 0xB152, 0xC364, 0xA9E2, 0xB953, 0xC3A5, 0xC543, 
    0xB859, 0xB754, 0xC477, 0xA4B3, 0xBAF7, 0xE2E4, 0xA4A1, 0xAFE4, 
    0xAAEC, 0xA558, 0xC36F, 0xBC70, 0xC3DC, 0xBE53, 0xC2FA, 0xDE51, 
    0xB0A3, 0xB7A1, 0xC2A6, 0xC078, 0xC5F7, 0xDD7A, 0xE044, 0xB342, 
    0xB4A2, 0xA474, 0xACEF, 0xDDDC, 0xB6C7, 0xB2EE, 0xB3DD, 0xA6EA, 
    0xBD48, 0xB5A1, 0xBC6C, 0xA7C9, 0xC2F4, 0xB3D0, 0xA76A, 0xAAA4, 
    0xB4A8, 0xC1E8, 0xABAB, 0xAC4B, 0xDDCF, 0xBE4A, 0xAE42, 0xB245, 
    0xAFC2, 0xC4F8, 0xC257, 0xBAEF, 0xB2AB, 0xAFFD, 0xBACF, 0xBBDB, 
    0xC3E3, 0xB74F, 0xB2A1, 0xB5FC, 0xA6B9, 0xA8EB, 0xBDE7, 0xA6B8, 
    0xC16F, 0xBDB5, 0xA777, 0xA55E, 0xB171, 0xC24F, 0xB4EA, 0xB2CA, 
    0xBE4C, 0xC14C, 0xAB50, 0xF94F, 0xBF79, 0xC2AB, 0xBA52, 0xB15A, 
    0xB6CA, 0xAFDC, 0xB7F1, 0xBAE9, 0xB266, 0xBB41, 0xA7F8, 0xA673, 
    0xA46F, 0xBD52, 0xBCBC, 0xB762, 0xB1B9, 0xAEC0, 0xBFF9, 0xB766, 
    0xB946, 0xB5AA, 0xBD44, 0xA5B4, 0xA46A, 0xA762, 0xA4EF, 0xD856, 
    0xC0B9, 0xB161, 0xAC70, 0xA54E, 0xB655, 0xB355, 0xABDD, 0xB665, 
    0xABE5, 0xAFD4, 0xBEE1, 0xA4A6, 0xB3E6, 0xE858, 0xE5B8, 0xC178, 
    0xA5B9, 0xB4E1, 0xA6FD, 0xBCAA, 0xB248, 0xBDCF, 0xBC75, 0xB34A, 
    0xB7ED, 0xBED7, 0xD0DE, 0xBFBA, 0xC0C9, 0xA44D, 0xB76F, 0xC1D0, 
    0xADCB, 0xAE71, 0xC3AB, 0xBEC9, 0xA8EC, 0xBD5F, 0xB1A5, 0xB944, 
    0xB573, 0xBC77, 0xB16F, 0xAABA, 0xC3DE, 0xBF4F, 0xB56E, 0xB5A5, 
    0xC0FC, 0xB9B9, 0xBE48, 0xB3F6, 0xA743, 0xBA77, 0xAD7D, 0xBCC4, 
    0xB2C3, 0xA866, 0xBAB0, 0xBB43, 0xB9DE, 0xA9E8, 0xA9B3, 0xA661, 
    0xB8A6, 0xB2C4, 0xABD2, 0xA7CC, 0xBBBC, 0xBD6C, 0xC441, 0xD569, 
    0xB7BF, 0xB84B, 0xC249, 0xA8E5, 0xC051, 0xB9D4, 0xB971, 0xA6FA, 
    0xA86C, 0xA9B1, 0xB17D, 0xB3FE, 0xD5E0, 0xB7B5, 0xB84D, 0xA570, 
    0xC04A, 0xADE4, 0xA44E, 0xB1BC, 0xA651, 0xB3A8, 0xBDD5, 0xB65E, 
    0xAF52, 0xBAD0, 0xBDBA, 0xADA1, 0xBFD2, 0xC57C, 0xA442, 0xA86E, 
    0xA56D, 0xB076, 0xB3BB, 0xB9A9, 0xBFF5, 0xA977, 0xAD71, 0xA5E1, 
    0xAA46, 0xA556, 0xB8B3, 0xC0B4, 0xB0CA, 0xB4C9, 0xCBBE, 0xABF0, 
    0xADE1, 0xAC7D, 0xB0C2, 0xA7DD, 0xA4E6, 0xB07E, 0xA8A7, 0xB372, 
    0xB56B, 0xB3A3, 0xB7FE, 0xAC72, 0xC37D, 0xBF57, 0xC5AA, 0xB0F4, 
    0xB840, 0xBDE4, 0xA7F9, 0xC1E1, 0xA87B, 0xABD7, 0xB4E7, 0xA7AA, 
    0xBADD, 0xB575, 0xC1EB, 0xAC71, 0xC25F, 0xBD76, 0xB0EF, 0xA749, 
    0xB6A4, 0xB9EF, 0xBC5B, 0xCAA4, 0xC3DB, 0xB4B0, 0xB979, 0xA779, 
    0xB677, 0xACDE, 0xB950, 0xD573, 0xCE47, 0xA668, 0xB9DC, 0xCE57, 
    0xB8FA, 0xA6B7, 0xB8F6, 0xB2EB, 0xA8EF, 0xB46B, 0xBC5A, 0xB8BF, 
    0xAE6F, 0xC35A, 0xAB58, 0xC342, 0xB35F, 0xAE5A, 0xB463, 0xA4CC, 
    0xA7E3, 0xB94B, 0xB66B, 0xBE6A, 0xAEA6, 0xA6D3, 0xA8E0, 0xA6D5, 
    0xBAB8, 0xBBE7, 0xAC7C, 0xA447, 0xB64C, 0xB56F, 0xBB40, 0xB5AD, 
    0xA5EF, 0xA546, 0xBBD6, 0xAA6B, 0xB557, 0xC3BF, 0xA67C, 0xB566, 
    0xC2BD, 0xBCD4, 0xC473, 0xB3AB, 0xC163, 0xA45A, 0xB7D0, 0xA4CF, 
    0xAAF0, 0xBD64, 0xB363, 0xA5C7, 0xB6BA, 0xAA78, 0xA77B, 0xAADA, 
    0xA4E8, 0xAAD5, 0xA9D0, 0xA8BE, 0xA7AB, 0xA5E9, 0xB358, 0xAFBC, 
    0xA9F1, 0xB5E1, 0xAB44, 0xB0D8, 0xADB8, 0xAACE, 0xADEA, 0xBDDA, 
    0xA770, 0xAACD, 0xBC6F, 0xAA6D, 0xB64F, 0xAAE2, 0xD7F4, 0xA768, 
    0xAA5E, 0xA4C0, 0xAFC9, 0xBC58, 0xB549, 0xA857, 0xAFBB, 0xBEC4, 
    0xA5F7, 0xA9C1, 0xBCAB, 0xC154, 0xA4A5, 0xABCA, 0xB7AC, 0xB8C1, 
    0xAE70, 0xBE57, 0xADB7, 0xBAC6, 0xB26C, 0xB37B, 0xB6BE, 0xC15F, 
    0xBFD8, 0xA95E, 0xBBF1, 0xA6F2, 0xA75F, 0xA4D2, 0xBCC5, 0xBDA7, 
    0xB9E5, 0xA7DF, 0xA9D8, 0xBFE7, 0xB454, 0xAC74, 0xB2C5, 0xA5F1, 
    0xAB52, 0xAA41, 0xAF42, 0xB265, 0xBAD6, 0xB5F6, 0xA5B1, 0xA86A, 
    0xBCBE, 0xBBB2, 0xADC1, 0xB079, 0xA9F2, 0xB2E3, 0xB5C6, 0xA9B2, 
    0xBB47, 0xAD75, 0xB0C6, 0xC2D0, 0xBDE1, 0xCE60, 0xB3C5, 0xA549, 
    0xAAFA, 0xA4F7, 0xB8A1, 0xAD74, 0xB449, 0xAD72, 0xAAFE, 0xB0FC, 
    0xBFA3, 0xA94A, 0xBEBF, 0xB9C7, 0xB8D3, 0xA7EF, 0xB7A7, 0xB674, 
    0xBB5C, 0xB540, 0xA47A, 0xA5CC, 0xB1EC, 0xAC61, 0xACF1, 0xA878, 
    0xD3E3, 0xB750, 0xB57A, 0xB4B1, 0xC642, 0xA9A3, 0xADE8, 0xBFFB, 
    0xACFB, 0xA87A, 0xBAF5, 0xB15E, 0xB4E4, 0xA7FE, 0xBF74, 0xAF6F, 
    0xB0AA, 0xBB49, 0xAFCC, 0xBF7C, 0xB764, 0xC2EE, 0xBD5A, 0xA769, 
    0xADF4, 0xBA71, 0xC0C1, 0xA4E0, 0xC246, 0xAFDE, 0xAAB8, 0xB3CE, 
    0xADB2, 0xB8AF, 0xAEE6, 0xB5F0, 0xBBD5, 0xB96A, 0xBBCC, 0xADD3, 
    0xA655, 0xB5B9, 0xAEDA, 0xB8F2, 0xAFD1, 0xA7F3, 0xA9B0, 0xC3BC, 
    0xAE47, 0xAFD5, 0xB1F0, 0xA475, 0xA7F0, 0xA55C, 0xAEA5, 0xC5C7, 
    0xA8D1, 0xB060, 0xA4BD, 0xAE63, 0xA47D, 0xBE64, 0xA845, 0xABFD, 
    0xB05E, 0xA640, 0xB95F, 0xA4C4, 0xB7BE, 0xAD65, 0xAAAF, 0xABAF, 
    0xCCDB, 0xC1CA, 0xB0F7, 0xB664, 0xDBA3, 0xA942, 0xE354, 0xA6F4, 
    0xAA66, 0xA974, 0xA968, 0xB9AA, 0xA56A, 0xC5DB, 0xB0A9, 0xA8A6, 
    0xAAD1, 0xAC47, 0xC555, 0xA954, 0xB6B1, 0xA8ED, 0xA5CA, 0xD46C, 
    0xB9E8, 0xAC45, 0xBB6F, 0xA8C4, 0xA9E4, 0xA9C7, 0xB4C3, 0xC3F6, 
    0xA978, 0xAB61, 0xC65B, 0xBADE, 0xC05D, 0xC5F8, 0xBA44, 0xC4E9, 
    0xB365, 0xA5FA, 0xBC73, 0xB37D, 0xBAC0, 0xB357, 0xA663, 0xD6BA, 
    0xC26B, 0xC074, 0xBBD3, 0xAD79, 0xB0AD, 0xB8DE, 0xACD1, 0xAEDB, 
    0xCF40, 0xB8F7, 0xB651, 0xBC44, 0xBE40, 0xBA75, 0xB4D2, 0xC1E7, 
    0xB3A2, 0xB0EA, 0xAA47, 0xBB71, 0xB94C, 0xABA2, 0xC065, 0xABC4, 
    0xAEFC, 0xAEF3, 0xA5E8, 0xAE60, 0xC062, 0xB66F, 0xE977, 0xCDD5, 
    0xC1FA, 0xA774, 0xB25B, 0xB448, 0xA8E7, 0xB3DB, 0xA875, 0xBFAB, 
    0xBED9, 0xAEC2, 0xA7F2, 0xBED1, 0xAEAB, 0xB26B, 0xA6BD, 0xBA7E, 
    0xC971, 0xAA43, 0xAFE8, 0xC0A2, 0xC07A, 0xBBA8, 0xB240, 0xB071, 
    0xA66E, 0xAFD3, 0xB8B9, 0xAF45, 0xA8FE, 0xB3DC, 0xB2FC, 0xDB5D, 
    0xAED6, 0xA5DD, 0xA94D, 0xA6F3, 0xA658, 0xB2B0, 0xB8E8, 0xBBD2, 
    0xAA65, 0xB255, 0xBBAE, 0xBDC5, 0xC562, 0xB650, 0xBC4B, 0xB6C2, 
    0xB2AA, 0xABDC, 0xACBD, 0xABEB, 0xADF3, 0xA6EB, 0xBEEE, 0xBFC5, 
    0xABED, 0xC546, 0xABA1, 0xAF4D, 0xAD69, 0xC245, 0xAC78, 0xA7BB, 
    0xA5B0, 0xACF5, 0xB3EF, 0xAB4A, 0xB555, 0xA771, 0xAB70, 0xADD4, 
    0xA65A, 0xA949, 0xA547, 0xA9BF, 0xB7E4, 0xB3FD, 0xB8AC, 0xAD4A, 
    0xBDB9, 0xAAB0, 0xBD6B, 0xB4F2, 0xA9B7, 0xAAEA, 0xB0E4, 0xC540, 
    0xA4AC, 0xBAAD, 0xA4E1, 0xAAE1, 0xBC4D, 0xB5D8, 0xB7E2, 0xB7C6, 
    0xB565, 0xA645, 0xA4C6, 0xB8DC, 0xBA69, 0xABDE, 0xCAE4, 0xB261, 
    0xC361, 0xC577, 0xC0F4, 0xAED9, 0xC1D9, 0xBD77, 0xB4AB, 0xB177, 
    0xB3EA, 0xBAC8, 0xB8E6, 0xB7D8, 0xB541, 0xABC6, 0xA4DB, 0xAFEE, 
    0xB757, 0xB6C0, 0xC144, 0xBDC0, 0xC2AE, 0xACD3, 0xB0C4, 0xB471, 
    0xB7D7, 0xAECC, 0xB745, 0xABE9, 0xC1C0, 0xA6C7, 0xB4A7, 0xBDF7, 
    0xC0B2, 0xABEC, 0xB5EE, 0xA65E, 0xB7B4, 0xAEAC, 0xBC7A, 0xA563, 
    0xB466, 0xB1E2, 0xB8EC, 0xC2A9, 0xB77C, 0xC0ED, 0xB6D7, 0xBFD0, 
    0xBBA3, 0xC3B8, 0xB8A7, 0xA9FC, 0xB142, 0xBBEE, 0xB4FD, 0xB256, 
    0xC1C5, 0xACA1, 0xA5EB, 0xA4F5, 0xC0F2, 0xA9CE, 0xB462, 0xC04E, 
    0xB366, 0xBAD7, 0xC0BB, 0xA7A3, 0xB0F2, 0xC9F3, 0xB7EE, 0xBD5D, 
    0xBF6E, 0xBADF, 0xA6D9, 0xC4C8, 0xB8F1, 0xBF45, 0xC3D5, 0xC2FB, 
    0xAE56, 0xC15A, 0xBD72, 0xA64E, 0xCCE5, 0xB4C6, 0xBFE8, 0xC479, 
    0xB6B0, 0xA4CE, 0xABE6, 0xAF65, 0xA856, 0xA759, 0xB6FA, 0xAFC5, 
    0xC0BD, 0xA44C, 0xAFE1, 0xA476, 0xC1AA, 0xA7DE, 0xBEAC, 0xA975, 
    0xC9AB, 0xB2BD, 0xBEAF, 0xB1AA, 0xC0D9, 0xB148, 0xB149, 0xAD70, 
    0xB04F, 0xAC4A, 0xA7D2, 0xBBDA, 0xA7B2, 0xC47E, 0xACF6, 0xB9C5, 
    0xCF45, 0xA7A8, 0xA8CE, 0xAE61, 0xA55B, 0xB2F3, 0xC055, 0xB8EB, 
    0xA5D2, 0xB95B, 0xB0B2, 0xBD5B, 0xC9B2, 0xAC5B, 0xBE72, 0xB6F9, 
    0xC4E8, 0xBACA, 0xB0ED, 0xA679, 0xBAE0, 0xB6A1, 0xB7CE, 0xADDD, 
    0xAAD3, 0xC17D, 0xA66C, 0xBD70, 0xD3B5, 0xC0CB, 0xAC5A, 0xC650, 
    0xC650, 0xB47A, 0xBEDF, 0xC2B2, 0xBBFC, 0xB0C5, 0xB4EE, 0xAFF2, 
    0xC265, 0xC5B2, 0xBDEE, 0xBDE2, 0xA8A3, 0xC1E4, 0xBD62, 0xA5F3, 
    0xB0B7, 0xC4A5, 0xBC43, 0xC05E, 0xBAA5, 0xC271, 0xBCEE, 0xABD8, 
    0xBBF8, 0xABB8, 0xB14E, 0xBCDF, 0xA6BF, 0xC3A6, 0xBDB1, 0xBCD5, 
    0xBCFA, 0xC1BF, 0xA64B, 0xC2E6, 0xADB0, 0xBFBC, 0xB4D4, 0xC147, 
    0xB54A, 0xBDA6, 0xA5E6, 0xADA5, 0xBCE5, 0xC5BA, 0xBC62, 0xC45A, 
    0xC5CD, 0xBBC7, 0xC142, 0xB9AE, 0xB87D, 0xACBE, 0xA8A4, 0xBBE5, 
    0xC3BA, 0xB5B1, 0xB6CF, 0xB1D0, 0xBBC3, 0xC3E2, 0xB8FB, 0xA573, 
    0xB5A2, 0xB4A6, 0xB1B5, 0xACD2, 0xD6C5, 0xB5F3, 0xB6A5, 0xBA49, 
    0xA754, 0xB860, 0xAEDC, 0xAA4E, 0xB1B6, 0xB7FB, 0xBADC, 0xCFA1, 
    0xB5B2, 0xB8D1, 0xA96A, 0xA7D9, 0xC2C7, 0xAAE3, 0xACC9, 0xADC9, 
    0xA4B6, 0xACCE, 0xBB7C, 0xA9A1, 0xA479, 0xB5AC, 0xA4E7, 0xAAF7, 
    0xA4B5, 0xAC7A, 0xC3CC, 0xBAF2, 0xC041, 0xB6C8, 0xC2D4, 0xB669, 
    0xE0DA, 0xAECA, 0xB854, 0xAAF1, 0xC275, 0xAEFB, 0xBAC9, 0xAB6C, 
    0xAFF0, 0xB9B8, 0xB2F4, 0xB7FA, 0xB4B9, 0xC448, 0xA8CA, 0xD561, 
    0xBAEB, 0xB865, 0xB867, 0xA4AB, 0xC4B5, 0xB4BA, 0xC056, 0xC052, 
    0xB9D2, 0xB771, 0xC3E8, 0xAE7C, 0xB56A, 0xB974, 0xB3BA, 0xC476, 
    0xD0E4, 0xACB3, 0xB57E, 0xB4AA, 0xA873, 0xAAC8, 0xA868, 0xADB4, 
    0xA45B, 0xA862, 0xA445, 0xB073, 0xB45C, 0xB1CF, 0xC2C2, 0xA6DD, 
    0xB8A4, 0xA953, 0xB44E, 0xAAB9, 0xC1F9, 0xA9EB, 0xAAAE, 0xAF6A, 
    0xA97E, 0xBE73, 0xB5E2, 0xA7BD, 0xA943, 0xAF78, 0xC17C, 0xAA71, 
    0xBB45, 0xA9DA, 0xD575, 0xA5A8, 0xA8E3, 0xB65A, 0xBDF5, 0xBFF7, 
    0xADD1, 0xA579, 0xC4DF, 0xACB2, 0xBC40, 0xAEBD, 0xC359, 0xAE53, 
    0xADC2, 0xB2B2, 0xA8F7, 0xB868, 0xE5B1, 0xC5CC, 0xA7E0, 0xB1B8, 
    0xADCF, 0xC0EF, 0xC4B1, 0xA84D, 0xB35A, 0xB5B4, 0xA7A1, 0xB5DF, 
    0xB676, 0xAD78, 0xA767, 0xAE6D, 0xAB54, 0xB5A4, 0xAF43, 0xB070, 
    0xC240, 0xB3D8, 0xA940, 0xA564, 0xABA3, 0xC9DB, 0xB47B, 0xB7A2, 
    0xB3CD, 0xB46E, 0xA55A, 0xB3F4, 0xB0C9, 0xA7A2, 0xACE5, 0xACDD, 
    0xB164, 0xBA42, 0xC152, 0xA6AA, 0xA7DC, 0xA4AE, 0xAAA1, 0xA6D2, 
    0xABFE, 0xAF4E, 0xBE61, 0xA956, 0xAD56, 0xAC5F, 0xB4CA, 0xBD57, 
    0xC1FB, 0xACEC, 0xB4DF, 0xAB79, 0xA569, 0xB4F7, 0xA74A, 0xA8E8, 
    0xABC8, 0xBDD2, 0xAAD6, 0xB0D9, 0xBEC1, 0xC0B5, 0xA77C, 0xA75C, 
    0xAAC5, 0xAEA3, 0xA4D5, 0xB1B1, 0xE1E0, 0xA466, 0xA6A9, 0xB146, 
    0xAC5C, 0xADFA, 0xB85D, 0xAD57, 0xBBC5, 0xAE77, 0xBFC7, 0xA66A, 
    0xABB1, 0xCED8, 0xB8F3, 0xAFE3, 0xB6F4, 0xB85F, 0xBBFB, 0xA7D6, 
    0xBC65, 0xB4DA, 0xA64A, 0xB5A8, 0xA867, 0xAED8, 0xC471, 0xB2B5, 
    0xC36D, 0xAA70, 0xC1AB, 0xB2AF, 0xF5C9, 0xBF73, 0xB8AA, 0xABB6, 
    0xBBED, 0xB3C8, 0xF558, 0xB75C, 0xBCEC, 0xA95B, 0xA9F8, 0xAEB9, 
    0xA778, 0xAC41, 0xC258, 0xB9F8, 0xC1EF, 0xA955, 0xA9D4, 0xB3E2, 
    0xE3DC, 0xDB4B, 0xBBB6, 0xB0D5, 0xB5DC, 0xA8D3, 0xBFE0, 0xC2C5, 
    0xB0FD, 0xC4E6, 0xC464, 0xC478, 0xC1F1, 0xC4F5, 0xC469, 0xF8C2, 
    0xC5F3, 0xC4FD, 0xC369, 0xC66C, 0xC4EA, 0xC0DD, 0xB277, 0xB77D, 
    0xAF54, 0xB459, 0xADA6, 0xAED4, 0xAEF6, 0xBCB4, 0xB3D2, 0xA863, 
    0xA6D1, 0xA8D0, 0xABBE, 0xB954, 0xAF4F, 0xE5FC, 0xB0C7, 0xBCD6, 
    0xB970, 0xC54A, 0xC1A2, 0xBD55, 0xB2D6, 0xC077, 0xC253, 0xBEDD, 
    0xA6D8, 0xC3FE, 0xB25C, 0xD9B1, 0xB7AB, 0xA74E, 0xCDF9, 0xB1F9, 
    0xB270, 0xBEA4, 0xEDCC, 0xAF57, 0xD6C3, 0xF6E8, 0xB27A, 0xA7F5, 
    0xA8BD, 0xC355, 0xC2A7, 0xB2FA, 0xAFEF, 0xA64F, 0xAEDF, 0xC452, 
    0xBC46, 0xC079, 0xC474, 0xBEFA, 0xA751, 0x0000, 0xA8D2, 0xAB57, 
    0xB567, 0xA5DF, 0xB2C9, 0xC377, 0xC1F5, 0xA44F, 0xBCFE, 0xADF9, 
    0xADC7, 0xC170, 0xBDAC, 0xB373, 0xC549, 0xB747, 0xCCB0, 0xBAA7, 
    0xC3AE, 0xC0C4, 0xC179, 0xC3EC, 0xC5CA, 0xB7D2, 0xBD6D, 0xC2B3, 
    0xB244, 0xB1E7, 0xB864, 0xA87D, 0xA8E2, 0xBDF8, 0xB671, 0xB4BD, 
    0xAB47, 0xBDCC, 0xBCBA, 0xB2E1, 0xB9B1, 0xC0F8, 0xBF52, 0xB9E9, 
    0xBFF1, 0xBCE3, 0xA446, 0xE1E6, 0xF4EF, 0xB9F9, 0xAEC6, 0xA643, 
    0xB5F5, 0xAF50, 0xA648, 0xC279, 0xB559, 0xAA4C, 0xC143, 0xC04D, 
    0xC17B, 0xBE46, 0xC5EC, 0xB24F, 0xBBFE, 0xB8EE, 0xA75B, 0xA9F0, 
    0xACC2, 0xB5D9, 0xB973, 0xC4D6, 0xB961, 0xA744, 0xB2DC, 0xADE2, 
    0xC646, 0xB3AE, 0xCC64, 0xBBE2, 0xA574, 0xA54F, 0xB7C8, 0xAF5B, 
    0xBA68, 0xB2B8, 0xC348, 0xAF64, 0xBC42, 0xBD46, 0xAC79, 0xAC68, 
    0xA4BB, 0xC073, 0xC5A4, 0xC456, 0xC5A2, 0xC14B, 0xB6A9, 0xC362, 
    0xC36C, 0xC3F7, 0xBCD3, 0xB0FA, 0xBA4F, 0xC14D, 0xBA7C, 0xADAE, 
    0xC4AA, 0xBF63, 0xC660, 0xC366, 0xC46C, 0xBEDB, 0xB3BF, 0xB8B8, 
    0xBE7C, 0xC453, 0xB84C, 0xC553, 0xB8F4, 0xB8EF, 0xB3C0, 0xE9F0, 
    0xB853, 0xBFFD, 0xB3B0, 0xBCAE, 0xC66A, 0xA766, 0xBE54, 0xAB51, 
    0xAEC8, 0xBC69, 0xB9F0, 0xC15C, 0xBC7B, 0xB4E2, 0xABDF, 0xB276, 
    0xC26F, 0xBAF1, 0xC572, 0xC5CB, 0xC570, 0xC665, 0xA75A, 0xB6C3, 
    0xB1B0, 0xB2A4, 0xB1C1, 0xBDFC, 0xADDB, 0xA8DA, 0xB25F, 0xBAFA, 
    0xBDD7, 0xC5DA, 0xC1B3, 0xC3B9, 0xC5DE, 0xC672, 0xC659, 0xC55B, 
    0xBB72, 0xB8A8, 0xACA5, 0xC064, 0xB5B8, 0xB6FD, 0xB3C2, 0xBABF, 
    0xBD58, 0xBFC2, 0xB0A8, 0xBD7C, 0xB9C0, 0xB6DC, 0xAE49, 0xB652, 
    0xB3C1, 0xBDE6, 0xC1DA, 0xAFDF, 0xBF66, 0xC443, 0xC65A, 0xBAA1, 
    0xBDAF, 0xB0D2, 0xBA43, 0xBAA9, 0xF0E3, 0xA87E, 0xAFED, 0xAABC, 
    0xAA5D, 0xA6A3, 0xB2F5, 0xBFDF, 0xAD54, 0xC1E3, 0xA4F2, 0xA5D9, 
    0xB967, 0xA566, 0xAD5A, 0xAB5F, 0xB455, 0xBBAA, 0xB654, 0xA45C, 
    0xAAB4, 0xAA54, 0xB1F6, 0x0000, 0xBE60, 0xB7D1, 0xA853, 0xACDC, 
    0xB443, 0xC1E2, 0xA843, 0xACFC, 0xAC4E, 0xB44B, 0xA966, 0xB441, 
    0xAAF9, 0xB465, 0xADCC, 0xB5DE, 0xBB58, 0xC263, 0xB7F9, 0xBFF8, 
    0xB272, 0xB9DA, 0xA973, 0xD6A9, 0xEEC5, 0xC3FB, 0xC153, 0xB067, 
    0xC1BC, 0xC0B1, 0xA6CC, 0xAFA6, 0xB356, 0xAA63, 0xBB65, 0xB14B, 
    0xBEAD, 0xB4D6, 0xAF76, 0xBAF8, 0xB0C3, 0xA74B, 0xAB6A, 0xAE59, 
    0xBD71, 0xADB1, 0xAD5D, 0xB479, 0xBACB, 0xC2C6, 0xACED, 0xB4F9, 
    0xBC71, 0xA7AE, 0xBDB0, 0xB7C0, 0xA5C1, 0xA9D7, 0xA5D7, 0xB1D3, 
    0xBCA7, 0xBBD4, 0xA9FA, 0xBFC1, 0xBBEF, 0xBBCA, 0xA657, 0xA952, 
    0xC2D5, 0xBA4E, 0xBCB1, 0xC4A8, 0xBCD2, 0xBDA4, 0xBF69, 0xBCAF, 
    0xC55D, 0xA9D9, 0xA5BD, 0xB2F6, 0xBEA5, 0xC071, 0xAA6A, 0xBA7A, 
    0xB9E6, 0xADAF, 0xBFD1, 0xA6C8, 0xAC59, 0xA9E6, 0xA864, 0xAF61, 
    0xA969, 0xA5C0, 0xB9D3, 0xBCC7, 0xB9F5, 0xB6D2, 0xBC7D, 0xA4EC, 
    0xA5D8, 0xB7FC, 0xAAAA, 0xBF70, 0xAEB3, 0xADFE, 0xA76F, 0xB675, 
    0xA8BA, 0xAE52, 0xAFC7, 0xA6BB, 0xA444, 0xA5A4, 0xAD40, 0xA960, 
    0xAB6E, 0xA86B, 0xC3F8, 0xC56E, 0xBCB8, 0xB8A3, 0xB46F, 0xBE78, 
    0xD5EF, 0xA94F, 0xBE6B, 0xA4BA, 0xB9E0, 0xAFE0, 0xA967, 0xC04F, 
    0xADD9, 0xAA64, 0xA5A7, 0xC0C0, 0xA970, 0xB0CE, 0xBFB0, 0xB066, 
    0xB7C4, 0xE759, 0xA9E0, 0xA67E, 0xBD56, 0xC25B, 0xB1C9, 0xA9C0, 
    0xAE51, 0xC643, 0xB3BE, 0xA7BF, 0xAEBA, 0xC2BF, 0xC45E, 0xEFBF, 
    0xC668, 0xC2EC, 0xAF49, 0xB17A, 0xC266, 0xC0F1, 0xBEAE, 0xC972, 
    0xC0BE, 0xCD46, 0xA4FB, 0xA7E1, 0xB673, 0xAFC3, 0xC177, 0xBF40, 
    0xB941, 0xA7CB, 0xA5A3, 0xA756, 0xABE3, 0xA46B, 0xB778, 0xAD68, 
    0xBAC4, 0xAEBF, 0xC0B6, 0xC47A, 0xBFD5, 0xAE40, 0xBCDA, 0xC5C3, 
    0xBCDE, 0xC3C2, 0xB9C3, 0xB0B8, 0xE278, 0xB0D4, 0xAD77, 0xAAA6, 
    0xA9AC, 0xA9C8, 0xB55D, 0xA9E7, 0xB1C6, 0xB550, 0xB172, 0xB4FB, 
    0xACA3, 0xC36B, 0xBCEF, 0xBD4C, 0xBD59, 0xACDF, 0xAF60, 0xA750, 
    0xAB71, 0xA5E3, 0xC365, 0xAEC7, 0xEAE5, 0xAD44, 0xA9DF, 0xA948, 
    0xA753, 0xACB6, 0xB354, 0xB65D, 0xAA77, 0xA941, 0xAD46, 0xB0F6, 
    0xBB70, 0xBDDF, 0xB3AD, 0xB074, 0xA8D8, 0xA84B, 0xBC51, 0xACD6, 
    0xAF79, 0xA9E1, 0xB269, 0xBCEA, 0xB45E, 0xBDB4, 0xB4D7, 0xB84E, 
    0xC14F, 0xBFB1, 0xAA42, 0xC450, 0xB1B7, 0xB849, 0xCBF2, 0xCFEC, 
    0xC552, 0xA7E5, 0xA9DC, 0xBC41, 0xB55C, 0xAC73, 0xB0E0, 0xB5CA, 
    0xAF68, 0xA5D6, 0xA4C7, 0xB56C, 0xBBF7, 0xA7BE, 0xC4B4, 0xBD67, 
    0xB0BE, 0xA4F9, 0xC446, 0xC4C6, 0xBA7D, 0xBF5D, 0xB2BC, 0xBA4A, 
    0xBF68, 0xABF7, 0xC057, 0xB368, 0xAB7E, 0xB875, 0xA5E2, 0xA957, 
    0xD06D, 0xB5D3, 0xA5AD, 0xBECC, 0xB27E, 0xB5FB, 0xABCC, 0xA959, 
    0xBCE2, 0xBBE1, 0xB143, 0xAF7D, 0xBE7A, 0xADA2, 0xB2CB, 0xADE5, 
    0xA5B7, 0xE745, 0xA4B2, 0xB340, 0xB8B2, 0xB5D0, 0xBB5A, 0xAE48, 
    0xBEEB, 0xAE45, 0xB4B6, 0xAEFA, 0xC3D0, 0xC36E, 0xC272, 0xB4C1, 
    0xB4DB, 0xD1E1, 0xB1AD, 0xA964, 0xA443, 0xD0E2, 0xBAA3, 0xAC6D, 
    0xCB50, 0xA8E4, 0xB4D1, 0xA95F, 0xAA5B, 0xB2A5, 0xB154, 0xC2C0, 
    0xBBF4, 0xBA58, 0xACE8, 0xAAC2, 0xC34D, 0xB05F, 0xB05A, 0xA45E, 
    0xA5F8, 0xB1D2, 0xABB4, 0xACE4, 0xBEB9, 0xC961, 0xA8B4, 0xB1F3, 
    0xA854, 0xAA5F, 0xB057, 0xD574, 0xABEA, 0xACA2, 0xB26F, 0xC9E7, 
    0x0000, 0xB95D, 0xA464, 0xBE45, 0xC3B1, 0xA561, 0xC1BE, 0xB0AE, 
    0xC072, 0xBFFA, 0xB958, 0xAB65, 0xBCE7, 0xBBBA, 0xB24C, 0xC4FE, 
    0xB9D5, 0xB44F, 0xA4ED, 0xBA70, 0xBA6A, 0xB6E6, 0xB5C4, 0xAACA, 
    0xC0F0, 0xC1A5, 0xB16A, 0xB76D, 0xBEF5, 0xC1EA, 0xBA56, 0xAEA8, 
    0xBEF4, 0xC140, 0xB3EC, 0xB9B4, 0xA5A9, 0xC054, 0xBCC0, 0xC2BC, 
    0xAE6B, 0xAB4E, 0xC2AC, 0xA4C1, 0xAD58, 0xA542, 0xA9C4, 0xC5D1, 
    0xB4DC, 0xAB49, 0xBFCB, 0xAFB3, 0xB55E, 0xB6D4, 0xAAE0, 0xBEE0, 
    0xB856, 0xB9EC, 0xA847, 0xAB43, 0xBBB4, 0xB242, 0xB6C9, 0xADEB, 
    0xB24D, 0xC0BA, 0xB4B8, 0xD9E6, 0xB1A1, 0xB3BC, 0xBDD0, 0xBC79, 
    0xC3A3, 0xBD61, 0xACEE, 0xA543, 0xAAF4, 0xB279, 0xA844, 0xA57D, 
    0xADA9, 0xAA73, 0xC1CD, 0xB0CF, 0xB349, 0xA6B1, 0xC2DF, 0xA97D, 
    0xC558, 0xB4EB, 0xA8FA, 0xB0F9, 0xC654, 0xBDEC, 0xA568, 0xB0E9, 
    0xF9AF, 0xC576, 0xEEC7, 0xAC75, 0xA5FE, 0xB2AC, 0xAEB1, 0xA4FC, 
    0xA8E9, 0xC455, 0xAFCA, 0xCD50, 0xBF61, 0xAB6F, 0xC44E, 0xBA65, 
    0xDACC, 0xB3B6, 0xB8C8, 0xB873, 0xB54D, 0xBF55, 0xA554, 0xAC56, 
    0xC57B, 0xC45B, 0xC463, 0xC457, 0xC5FD, 0xC4C7, 0xCAF0, 0xC2B6, 
    0xB753, 0xBCF6, 0xA4D0, 0xA4AF, 0xA448, 0xA7D4, 0xB6B4, 0xA5F4, 
    0xBB7B, 0xA462, 0xA7B3, 0xACF7, 0xA5B5, 0xA4B4, 0xA4E9, 0xA6A5, 
    0xAFF1, 0xBB54, 0xBA61, 0xBFC4, 0xBAB2, 0xB7BB, 0xAE65, 0xB5B3, 
    0xA4BE, 0xB47C, 0xAC58, 0xA6D7, 0xAFF8, 0xC4AF, 0xBEA7, 0xC0A9, 
    0xA670, 0xB064, 0xA8C5, 0xA6BC, 0xA44A, 0xBFC8, 0xB36E, 0xA8BF, 
    0xBFB6, 0xB7E7, 0xBE55, 0xB67C, 0xBCED, 0xAD59, 0xAE7A, 0xBCBB, 
    0xC578, 0xC2C4, 0xB87C, 0xC4CE, 0xB6EB, 0xC1C9, 0xA454, 0xA454, 
    0xB3CA, 0xB4B2, 0xAEE1, 0xB6DA, 0xB3E0, 0xB76B, 0xC4CC, 0xB1BD, 
    0xB741, 0xB7E6, 0xA6E2, 0xC0DF, 0xB4CB, 0xB9AC, 0xB2EF, 0xACE2, 
    0xB1FE, 0xAB62, 0xA846, 0xAFBD, 0xB6CC, 0xD4A3, 0xB7D9, 0xBF7A, 
    0xAECD, 0xACC0, 0xD073, 0xA7FC, 0xA473, 0xA752, 0xBAB4, 0xAD6D, 
    0xB07B, 0xB0A2, 0xBED5, 0xC4BA, 0xBFAF, 0xB5BD, 0xA6C2, 0xAEB0, 
    0xC2B5, 0x0000, 0xB6CB, 0xB0D3, 0xBDE0, 0xAECE, 0xA457, 0xA97C, 
    0xBB6E, 0xB1E9, 0xAEB4, 0xB579, 0xBF4E, 0xA8A2, 0xA463, 0xBBE0, 
    0xA4D6, 0xADEF, 0xAAF2, 0xB2D0, 0xB0F8, 0xBBAD, 0xB344, 0xA6DE, 
    0xAAD9, 0xB36A, 0xC4E1, 0xAE67, 0xC4E0, 0xAF41, 0xAAC0, 0xB35D, 
    0xAF7E, 0xA5D3, 0xA944, 0xA6F9, 0xA8AD, 0xB260, 0xAE57, 0xB2D4, 
    0xAFAB, 0xA848, 0xBC66, 0xC254, 0xACC6, 0xB5C7, 0xB756, 0xBAAF, 
    0xC16E, 0xA5CD, 0xB563, 0xACB9, 0xA4C9, 0xC3B7, 0xACD9, 0xB2B1, 
    0xB3D1, 0xD060, 0xC96F, 0xAE76, 0xA5A2, 0xB7E0, 0xAC49, 0xC0E3, 
    0xB8D6, 0xA472, 0xAAEB, 0xA451, 0xA5DB, 0xAC42, 0xAEC9, 0xA4B0, 
    0xADB9, 0xBB6B, 0xB9EA, 0xC3D1, 0xA576, 0xA5DA, 0xA8CF, 0xABCB, 
    0xBE70, 0xA96C, 0xA6A1, 0xA5DC, 0xA468, 0xA540, 0xAC55, 0xA8C6, 
    0xABF8, 0xBB7D, 0xB375, 0xB6D5, 0xAC4F, 0xB6DD, 0xBEBD, 0xD3EC, 
    0xA54B, 0xA8CD, 0xC4C0, 0xB9A2, 0xA4F3, 0xA5AB, 0xABEE, 0xABC7, 
    0xB5F8, 0xB8D5, 0xA6AC, 0xA4E2, 0xADBA, 0xA675, 0xB9D8, 0xB1C2, 
    0xB0E2, 0xA8FC, 0xBD47, 0xC37E, 0xBDAD, 0xBCCF, 0xAEDE, 0xAEED, 
    0xA7E7, 0xBFE9, 0xA8FB, 0xB5CE, 0xB251, 0xB2A8, 0xAED1, 0xC5AB, 
    0xB145, 0xBCF4, 0xC1A6, 0xB4BB, 0xC0C6, 0xB870, 0xB8BE, 0xB6C1, 
    0xB9AB, 0xC4DD, 0xA5BA, 0xAD7A, 0xBEF0, 0xA7F4, 0xA6A7, 0xBDDD, 
    0xB9D6, 0xB166, 0xBCC6, 0xBAA4, 0xAEA4, 0xA8EA, 0xAD41, 0xBA4C, 
    0xB049, 0xA5CF, 0xABD3, 0xAEEA, 0xAC43, 0xC1F7, 0xC2F9, 0xB26E, 
    0xBDD6, 0xA4F4, 0xBACE, 0xB57C, 0xA76D, 0xC0FE, 0xB6B6, 0xB5CF, 
    0xBBA1, 0xBAD3, 0xAED2, 0xC37B, 0xB4B5, 0xBCB9, 0xBC52, 0xABE4, 
    0xA870, 0xA571, 0xB5B7, 0xA6BA, 0xB876, 0xA678, 0xB6E0, 0xA57C, 
    0xA6F8, 0xA6FC, 0xB97D, 0xA478, 0xAA51, 0xC171, 0xBCA3, 0xB97C, 
    0xB065, 0xA7BA, 0xB35E, 0xBB77, 0xB76A, 0xBFB4, 0xC25D, 0xB9C2, 
    0xC4AC, 0xB670, 0xAB55, 0xAFC0, 0xB374, 0xB5AF, 0xE0F4, 0xB6EC, 
    0xB7B9, 0xB14A, 0xB644, 0xB5C2, 0xBBC4, 0xBB5B, 0xBAE2, 0xC1F6, 
    0xB6A6, 0xC048, 0xB86B, 0xC5E8, 0xB848, 0xB7B3, 0xC14A, 0xB945, 
    0xC047, 0xAFA9, 0xAE5D, 0xB76C, 0xB5AB, 0xBB62, 0xB1F4, 0xADF6, 
    0xC159, 0xBABE, 0xAFC1, 0xC2EA, 0xA9D2, 0xB6F2, 0xA54C, 0xA5A6, 
    0xA66F, 0xB6F0, 0xC3A1, 0xBED8, 0xC1CF, 0xBDF1, 0xAD4C, 0xAD61, 
    0xA9EF, 0xA578, 0xAEF5, 0x0000, 0xA4D3, 0xBA41, 0xA84F, 0xA77E, 
    0xC575, 0xB367, 0xC5F5, 0xC579, 0xBEC2, 0xC0C8, 0xB7F0, 0xBCE6, 
    0xC3D3, 0xBDCD, 0xA95A, 0xB4E0, 0xB352, 0xBAD2, 0xB1B4, 0xB9C4, 
    0xACB4, 0xC0FA, 0xB6ED, 0xB765, 0xB0F3, 0xB4C5, 0xBDA3, 0xADF0, 
    0xBF7D, 0xADD5, 0xBDF6, 0xB249, 0xBDEB, 0xBF53, 0xB1C7, 0xC0DC, 
    0xB7CA, 0xB86C, 0xB5E5, 0xAEE7, 0xB06B, 0xB25E, 0xB3B3, 0xB051, 
    0xAE4D, 0xAF53, 0xC3C3, 0xC4CB, 0xAF6B, 0xC1C3, 0xB1E8, 0xADE7, 
    0xBDF0, 0xBE4F, 0xB4A3, 0xC344, 0xBFE1, 0xB3DA, 0xCA5E, 0xB4C0, 
    0xC0A1, 0xB1A7, 0xAEF7, 0xAB63, 0xB150, 0xA4D1, 0xB24B, 0xB6F1, 
    0xA5D0, 0xB2A2, 0xABEF, 0xBB51, 0xB5C9, 0xAC44, 0xB1F8, 0xAD7C, 
    0xB2B7, 0xB8F5, 0xB64B, 0xC54B, 0xA9AB, 0xC655, 0xC5A5, 0xD64C, 
    0xA5C5, 0xA7CA, 0xB0B1, 0xAB46, 0xAE78, 0xAEBC, 0xB8A5, 0xB371, 
    0xAEE4, 0xE0AC, 0xC0FB, 0xA650, 0xBBC9, 0xA7CD, 0xB5A3, 0xB1ED, 
    0xD1B6, 0xB5A9, 0xB2CE, 0xB568, 0xB0BD, 0xA7EB, 0xC059, 0xB37A, 
    0xA559, 0xA872, 0xACF0, 0xB9CF, 0xAE7B, 0xB37E, 0xD25C, 0xB14F, 
    0xA467, 0xA652, 0xA8DF, 0xB4F8, 0xB9CE, 0xB1C0, 0xC05A, 0xBB4C, 
    0xB8C0, 0xBFC6, 0xB068, 0xA75D, 0xA4D9, 0xC176, 0xA9EC, 0xA6AB, 
    0xB2E6, 0xC06B, 0xAAFB, 0xB9A4, 0xBE6D, 0xBEF2, 0xA7B4, 0xA9DD, 
    0xB3E8, 0xABF5, 0xAB7A, 0xB5EC, 0xCF71, 0xABBD, 0xA5CB, 0xC4FB, 
    0xAC6E, 0xA57E, 0xBDDC, 0xC573, 0xC657, 0xAAB1, 0xB978, 0xA459, 
    0xD64A, 0xA7B9, 0xB84A, 0xAEBE, 0xB1DF, 0xB570, 0xB17B, 0xA97B, 
    0xB0FB, 0xB855, 0xB5C3, 0xA84C, 0xA4FD, 0xA460, 0xAA50, 0xCA49, 
    0xA9B9, 0xA9F4, 0xB1E6, 0xA7D1, 0xA66B, 0xABC2, 0xC4DE, 0xB74C, 
    0xA64D, 0xADB3, 0xB948, 0xAEE9, 0xB3F2, 0xB0DF, 0xB1A9, 0xACB0, 
    0xC0E5, 0xBAFB, 0xB8AB, 0xB5E4, 0xA965, 0xB0B6, 0xB0B0, 0xA7C0, 
    0xBD6E, 0xA5BC, 0xBDAB, 0xA8FD, 0xACC8, 0xAD47, 0xB3DE, 0xC351, 
    0xA6EC, 0xB4F4, 0xBFD7, 0xB14C, 0xBCA2, 0xBDC3, 0xBD45, 0xB7C5, 
    0xB041, 0xA4E5, 0xBB44, 0xAFBE, 0xA76B, 0xC3AD, 0xAFBF, 0xB0DD, 
    0xB6E4, 0xAFCE, 0xCFD8, 0xBEE2, 0xBDBD, 0xB4F5, 0xBADB, 0xA7DA, 
    0xBA57, 0xAAD7, 0xB4A4, 0xA855, 0xA7C5, 0xB6E3, 0xC2EB, 0xAF51, 
    0xA6C3, 0xBB7A, 0xABCE, 0xB54C, 0xBFBE, 0xB1EF, 0xA75E, 0xA764, 
    0xA4F0, 0xAA5A, 0xA4AD, 0xAEB8, 0xA4C8, 0xBB52, 0xA5EE, 0xAB56, 
    0xB6F5, 0xA5B3, 0xC3FA, 0xB1E0, 0xAAAB, 0xA4C5, 0xB0C8, 0xAEA9, 
    0xBB7E, 0xA9F5, 0xBAB3, 0xAA52, 0xA6E8, 0xD6B4, 0xAABF, 0xB4B7, 
    0xBC48, 0xA76C, 0xBFFC, 0xC4EB, 0xB57D, 0xAEA7, 0xA7C6, 0xB178, 
    0xBDA5, 0xA469, 0xB1A4, 0xBAB6, 0xB26D, 0xB7CB, 0xA6C1, 0xB552, 
    0xC0CA, 0xC5A7, 0xAE75, 0xB2DF, 0xB740, 0xB3DF, 0xBBD1, 0xAC7E, 
    0xA874, 0xBBD8, 0xC0B8, 0xB2D3, 0xBD4D, 0xBDBC, 0xA758, 0xC1F8, 
    0xC1D2, 0xB776, 0xAE6C, 0xAB4C, 0xAF55, 0xA455, 0xB748, 0xAE4C, 
    0xC07E, 0xB1C8, 0x0000, 0xA5FD, 0xA550, 0xC241, 0xC5D6, 0xAB77, 
    0xBDE5, 0xBBCE, 0xB2EC, 0xB6A2, 0xB243, 0xA9B6, 0xB6FB, 0xC5E3, 
    0xC049, 0xB27B, 0xC46D, 0xBFA4, 0xB8A2, 0xC060, 0xDB43, 0xBECB, 
    0xB3B4, 0xADAD, 0xBD75, 0xACDB, 0xB45B, 0xC65E, 0xADBB, 0xBD63, 
    0xC1B8, 0xB4F0, 0xB66D, 0xB5BE, 0xB2BB, 0xB8D4, 0xB751, 0xC554, 
    0xA8C9, 0xB6B5, 0xABD1, 0xBEF3, 0xB9B3, 0xA656, 0xB648, 0xBFBD, 
    0xB576, 0xBE5D, 0xAB64, 0xADFD, 0xC4DB, 0xBE50, 0xAEF8, 0xAE64, 
    0xB263, 0xBEE5, 0xA470, 0xA7B5, 0xAED5, 0xA876, 0xBC53, 0xAFBA, 
    0xAEC4, 0xB7A4, 0xA8C7, 0xB7B2, 0xE7B2, 0xBE63, 0xA8F3, 0xAEB5, 
    0xC4E2, 0xA8B8, 0xB1D7, 0xAFD9, 0xBFD3, 0xBC67, 0xB1F1, 0xA8F8, 
    0xC3C9, 0xBED3, 0xAA6E, 0xC26D, 0xC1C2, 0xAE68, 0xC17E, 0xAAE4, 
    0xBE4E, 0xAA59, 0xA8AF, 0xB773, 0xCAE3, 0xA4DF, 0xAB48, 0xC65D, 
    0xAC50, 0xB87B, 0xB556, 0xB469, 0xBFB3, 0xA644, 0xABAC, 0xA7CE, 
    0xA8B7, 0xA6E6, 0xBFF4, 0xA9AF, 0xA7F6, 0xA9CA, 0xA96D, 0xA553, 
    0xA4BF, 0xAFDD, 0xA649, 0xACA4, 0xB6AF, 0xBAB5, 0xA5F0, 0xADD7, 
    0xB2DB, 0xA6B4, 0xB6E5, 0xC4C3, 0xA871, 0xB353, 0xC2B8, 0xBC56, 
    0xA6A6, 0xBBDD, 0xB5EA, 0xBC4E, 0xB6B7, 0xAE7D, 0xB35C, 0xBB57, 
    0xB3A4, 0xB1D4, 0xA6B0, 0xA7C7, 0xAF62, 0xABF2, 0xB5B6, 0xB442, 
    0xBAFC, 0xC4F2, 0xB061, 0xB3D9, 0xABC5, 0xC461, 0xB1DB, 0xA5C8, 
    0xBFEF, 0xC57E, 0xAF74, 0xB5BA, 0xB975, 0xC1A7, 0xBEC7, 0xA5DE, 
    0xB3B7, 0xA6E5, 0xB3D4, 0xE2C0, 0xB460, 0xA6AF, 0xB8DF, 0xB44D, 
    0xB9A5, 0xA8B5, 0xAEEE, 0xA6C4, 0xB056, 0xB054, 0xBBB9, 0xA8B3, 
    0xC0A3, 0xA9E3, 0xBE7E, 0xC06E, 0xA772, 0xA458, 0xAADE, 0xA4FA, 
    0xB048, 0xB156, 0xB8C5, 0xB250, 0xB6AE, 0xB0D7, 0xA8C8, 0xB359, 
    0xB26A, 0xAB7C, 0xEC49, 0xB7CF, 0xB254, 0xC651, 0xC459, 0xACE3, 
    0xE3E9, 0xA9A5, 0xA9B5, 0xA8A5, 0xC343, 0xC046, 0xAAA2, 0xAA75, 
    0xA961, 0xB1BB, 0xB2B4, 0xAD6C, 0xBA74, 0xC641, 0xB3F7, 0xBF50, 
    0xB9BD, 0xB578, 0xB6AD, 0xADF1, 0xABDB, 0xB54B, 0xAE62, 0xBFCE, 
    0xC5E7, 0xAC6F, 0xA5A1, 0xC06D, 0xAFB1, 0xB7A8, 0xB4AD, 0xA8CB, 
    0xBAC5, 0xA6CF, 0xAC76, 0xB6A7, 0xAEF1, 0xA5F5, 0xC46F, 0xBE69, 
    0xBCCB, 0xBA79, 0xC1DC, 0xB879, 0xA7AF, 0xBABD, 0xB76E, 0xB3F3, 
    0xBBBB, 0xBD60, 0xC1C1, 0xABC0, 0xAB72, 0xAFE6, 0xDFD3, 0xAD6E, 
    0xC4A3, 0xB7A6, 0xBC4F, 0xAD43, 0xB7DD, 0xB3A5, 0xA74D, 0xA45D, 
    0xADB6, 0xB1B3, 0xB77E, 0xB8AD, 0xA6B2, 0xB5C5, 0xA95D, 0xB247, 
    0xA440, 0xB3FC, 0xC2E5, 0xB4A5, 0xE476, 0xA8CC, 0xA5EC, 0xA6E7, 
    0xC05B, 0xA669, 0xBFF2, 0xB2BE, 0xBBF6, 0xAFD8, 0xBAC3, 0xA85E, 
    0xA979, 0xABBC, 0xC255, 0xB4C8, 0xC3C6, 0xADCA, 0xA477, 0xA441, 
    0xA86F, 0xA548, 0xC3C0, 0xA7ED, 0xA9F6, 0xA8B6, 0xA67A, 0xBBF5, 
    0xA7D0, 0xC172, 0xB668, 0xB877, 0xACCC, 0xA5E7, 0xB8C7, 0xB74E, 
    0xBCDD, 0xBED0, 0xB871, 0xAF71, 0xB7B8, 0xB8DA, 0xC4B3, 0xBDCB, 
    0xC4B6, 0xC9DD, 0xC16C, 0xB2DD, 0xC3B6, 0xAFF4, 0xBDAE, 0xA65D, 
    0xAEEF, 0xADB5, 0xB3B1, 0xABC3, 0xA775, 0xBBC8, 0xB25D, 0xB147, 
    0xB6BC, 0xA4A8, 0xA4DE, 0xC1F4, 0xA64C, 0xAD5E, 0xC4E5, 0xC0A6, 
    0xC64E, 0xC0B3, 0xC5D5, 0xBCFC, 0xBFC3, 0xC0E7, 0xBAB7, 0xC3C7, 
    0xAAEF, 0xC4B9, 0xACD5, 0xBC76, 0xBF6F, 0xB577, 0xAC4D, 0xB3E9, 
    0xBED6, 0xB6C4, 0xC173, 0xF7EA, 0xB165, 0xB96C, 0xBFE3, 0xB8BA, 
    0xB5FA, 0xAA61, 0xAF46, 0xA5C3, 0xB176, 0xAB69, 0xA5CE, 0xABD5, 
    0xC9AC, 0xB179, 0xBC7E, 0xA4D7, 0xA5D1, 0xB66C, 0xB95C, 0xB553, 
    0xAA6F, 0xB4E5, 0xA8BB, 0xA6B3, 0xA4CD, 0xA56B, 0xA6F6, 0xB956, 
    0xBBA4, 0xA453, 0xA5AE, 0xA8B1, 0xB24A, 0xA45F, 0xAABB, 0xB7AE, 
    0xB8B7, 0xB74D, 0xC1D6, 0xA745, 0xAB5C, 0xB94F, 0xB3BD, 0xB472, 
    0xB4FC, 0xBAAE, 0xB6A8, 0xA4A9, 0xAE54, 0xAB42, 0xC94F, 0xC0AC, 
    0xACEA, 0xA674, 0xBB79, 0xA6D0, 0xA5C9, 0xB0EC, 0xA8A1, 0xADA7, 
    0xA653, 0xB94A, 0xB3EB, 0xAE6E, 0xB173, 0xB755, 0xB1FD, 0xBABB, 
    0xA87C, 0xC541, 0xAF44, 0xB44A, 0xB8CE, 0xB977, 0xBFDD, 0xB6BF, 
    0xC070, 0xB257, 0xADDE, 0xA4B8, 0xABAE, 0xB04B, 0xADEC, 0xB4A9, 
    0xC1D5, 0xB6E9, 0xADFB, 0xB6EA, 0xB7E1, 0xB7BD, 0xBD74, 0xBBB7, 
    0xAD62, 0xBA40, 0xABE8, 0xB07C, 0xA4EA, 0xACF9, 0xB656, 0xC544, 
    0xC65F, 0xA9A8, 0xB866, 0xA4EB, 0xAEAE, 0xBE5C, 0xAFD0, 0xA4AA, 
    0xE0A8, 0xA4C3, 0xB96B, 0xA4B9, 0xB942, 0xC4AD, 0xC1DF, 0xB777, 
    0xC3FD, 0xA5A5, 0xA560, 0xAF7B, 0xC2F8, 0xAEE2, 0xAB76, 0xA861, 
    0xAE5F, 0xB8FC, 0xA641, 0xA662, 0xABA5, 0xF6E3, 0xBCC8, 0xC3D9, 
    0xC542, 0xC5A6, 0xB8AE, 0xBE44, 0xC156, 0xC677, 0xC4A6, 0xB4C7, 
    0xA6AD, 0xBEFE, 0xB044, 0xC4BC, 0xBEB8, 0xB379, 0xA86D, 0xA85F, 
    0xC0EA, 0xB364, 0xBEDC, 0xAB68, 0xBF41, 0xB8E9, 0xABE7, 0xBC57, 
    0xBCA8, 0xB4BF, 0xC3D8, 0xA4E3, 0xB3E5, 0xB4ED, 0xA5BE, 0xAAEE, 
    0xEED4, 0xB968, 0xAF77, 0xAC5D, 0xBA5E, 0xA951, 0xA545, 0xACB5, 
    0xB642, 0xBA4B, 0xC24E, 0xA676, 0xAFB6, 0xB6C5, 0xB9EB, 0xC2A4, 
    0xC0D6, 0xB8E2, 0xD6DF, 0xAA67, 0xB7F8, 0xB1D9, 0xC1D3, 0xB9F1, 
    0xAE69, 0xC5D9, 0xB4CC, 0xA565, 0xBED4, 0xAFB8, 0xB4EF, 0xBAEC, 
    0xBCCC, 0xB3B9, 0xB9FC, 0xBA73, 0xB169, 0xB478, 0xBAA6, 0xA7FA, 
    0xA456, 0xB162, 0xBDE3, 0xA54D, 0xB5C8, 0xBF60, 0xBBD9, 0xA9DB, 
    0xAC4C, 0xA7E4, 0xAA68, 0xBBAF, 0xB7D3, 0xB86E, 0xA5FC, 0xBB46, 
    0xA56C, 0xBE42, 0xA7E9, 0xADF5, 0xEE68, 0xC2E1, 0xAACC, 0xEBE3, 
    0xBDA9, 0xB36F, 0xAEFD, 0xACC3, 0xB772, 0xAF75, 0xBAC2, 0xAF7A, 
    0xBFB2, 0xAD73, 0xB077, 0xB0BB, 0xAA45, 0xAF6C, 0xB645, 0xBE5F, 
    0xAEB6, 0xC2ED, 0xB07D, 0xBB5D, 0xB1C3, 0xB843, 0xA9BA, 0xB275, 
    0xAAA7, 0xA9C3, 0xBEE3, 0xAC40, 0xA5BF, 0xAC46, 0xB456, 0xC470, 
    0xBE47, 0xB5FD, 0xAADB, 0xAA4B, 0xA4E4, 0xA773, 0xBB6A, 0xAABE, 
    0xAACF, 0xAFD7, 0xA5C4, 0xA4A7, 0xC2B4, 0xC2BE, 0xAABD, 0xB4D3, 
    0xB4DE, 0xB0F5, 0xADC8, 0xCBBB, 0xA77D, 0xABFC, 0xA4EE, 0xB36B, 
    0xB04E, 0xA6AE, 0xAFC8, 0xA7D3, 0xBCB0, 0xC259, 0xA6DC, 0xAD50, 
    0xB86D, 0xBC6D, 0xABCF, 0xA8EE, 0xB4BC, 0xAFB4, 0xB858, 0xBDE8, 
    0xAAA5, 0xB2A9, 0xBAA2, 0xAA76, 0xB2BF, 0xA4A4, 0xACD8, 0xA9BE, 
    0xC4C1, 0xB04A, 0xB2D7, 0xCFFA, 0xB87E, 0xADAB, 0xA5F2, 0xB2B3, 
    0xA6E0, 0xA950, 0xA67B, 0xAC77, 0xEEA4, 0xB5B0, 0xB662, 0xA879, 
    0xA9AA, 0xA947, 0xBD4B, 0xA97A, 0xB1DE, 0xC64A, 0xAF5D, 0xAEE8, 
    0xB5EF, 0xA6B6, 0xBDDE, 0xBDD1, 0xB8DD, 0xB376, 0xA6CB, 0xC0EB, 
    0xB54E, 0xA9D6, 0xC666, 0xC5F1, 0xA544, 0xB5DB, 0xAC57, 0xA755, 
    0xB345, 0xB64A, 0xC5B1, 0xBF76, 0xA6ED, 0xAA60, 0xAFAC, 0xBE6E, 
    0xA7EC, 0xA4F6, 0xABFB, 0xB14D, 0xBF6A, 0xC2E0, 0xBCB6, 0xC1C8, 
    0xBD66, 0xBCCE, 0xC9DC, 0xB8CB, 0xA7A9, 0xBCB2, 0xA7A7, 0xAAAC, 
    0xB4D5, 0xC040, 0xB06C, 0xC2D8, 0xBC59, 0xBAF3, 0xBDCE, 0xADE3, 
    0xAEBB, 0xA9E5, 0xA8F4, 0xAEE0, 0xB55A, 0xAD5F, 0xB075, 0xB0D6, 
    0xB5DB, 0xA860, 0xBF42, 0xAFF7, 0xAB74, 0xB8EA, 0xABBA, 0xB4FE, 
    0xB264, 0xA7B6, 0xB5B5, 0xA54A, 0xACF3, 0xB7BA, 0xA46C, 0xA6DB, 
    0xBA7B, 0xA672, 0xC34F, 0xB4C4, 0xC2DC, 0xA976, 0xBAEE, 0xC160, 
    0xC161, 0xB951, 0xA8AB, 0xABB5, 0xB47E, 0xAFB2, 0xA8AC, 0xA8F2, 
    0xB1DA, 0xAFAA, 0xB641, 0xAAFD, 0xB2D5, 0xC670, 0xC4A1, 0xBC4C, 
    0xBE4B, 0xB3CC, 0xB86F, 0xB44C, 0xBFED, 0xAC51, 0xA5AA, 0xA6F5, 
    0xAC67, 0xB0B5, 0xA740, 0xA7A4, 0xAE79, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xC948, 0xC946, 0xC94A, 0xA4A2, 0xA4DC, 0xA4CA, 
    0xA541, 0xA5E5, 0xA5E0, 0xB0AC, 0xD165, 0xBEB5, 0x0000, 0xACEB, 
    0x0000, 0xA450, 0xC947, 0xA4D4, 0xA4F8, 0xA567, 0xA5C2, 0xC9C7, 
    0xAD4E, 0xD850, 0xB7B6, 0xE2E9, 0x0000, 0x0000, 0xAB45, 0xE8F3, 
    0xC941, 0xA5E4, 0xC951, 0xAACB, 0xA7B8, 0xB6DE, 0xE14C, 0xA4B7, 
    0xCDF8, 0xADED, 0xF1EF, 0xB3D6, 0x0000, 0xC5E2, 0xC5AC, 0xC943, 
    0xA572, 0xD46F, 0xB9BC, 0xB0D0, 0xF0F3, 0xA8F6, 0xCA72, 0x0000, 
    0xA4C2, 0xA646, 0xCDF0, 0xCBD2, 0xE4F3, 0xB3CF, 0xAB66, 0xD0E9, 
    0xD0E6, 0xADE6, 0xE3C7, 0xB6D1, 0xB9BB, 0xE142, 0x0000, 0xBEB0, 
    0x0000, 0xAAC9, 0x0000, 0xA4B1, 0xC953, 0xC952, 0xC965, 0xC968, 
    0x0000, 0xA551, 0xDCBA, 0xA5F6, 0xC9B7, 0xCA5F, 0xC9AE, 0xADCE, 
    0xB3C9, 0xA5EA, 0xA6EE, 0xA6F0, 0xCA61, 0xA7F1, 0xA748, 0xA746, 
    0xCA63, 0xA6EF, 0x0000, 0xA6F7, 0xCBB8, 0xCBB9, 0xA8DD, 0xCBBA, 
    0xA8D4, 0xA8DC, 0xA8DB, 0xA8D9, 0xBEAB, 0xCBB3, 0xBBFA, 0xCBC6, 
    0xBEA9, 0xC56B, 0xC4D7, 0xCDDE, 0xAB5A, 0xCDE3, 0xCDE5, 0xAB4D, 
    0xAB53, 0xADC4, 0xADC5, 0xB0B4, 0xADD6, 0xD0D3, 0xB0BF, 0x0000, 
    0xADD8, 0xADDA, 0xD0D7, 0xADBE, 0xADC3, 0xADD0, 0xE0F3, 0xB0B3, 
    0xB0BA, 0xD455, 0xB0B9, 0xB6CD, 0xDCBC, 0xC56C, 0xBEAA, 0xF5C0, 
    0xDCBF, 0xB9AF, 0xE4EA, 0xB9B0, 0xE0FA, 0xE0F0, 0xB9AD, 0xE4EB, 
    0xE4EE, 0xC969, 0xC9F8, 0xCA65, 0xDCC2, 0xAB5B, 0xEFB6, 0x0000, 
    0xF740, 0xA4BC, 0xB453, 0xC664, 0xEF55, 0xF6D8, 0xC4DC, 0x0000, 
    0xAB6D, 0xD0B1, 0xB0CB, 0xE0ED, 0xA667, 0xA8E1, 0x0000, 0xAB5E, 
    0xADBD, 0xB34F, 0xD7C0, 0xC1B6, 0xF943, 0xB8CF, 0xB85B, 0xBEC6, 
    0xF2DD, 0xC3BD, 0x0000, 0xC9BC, 0xA8E6, 0xCBCE, 0x0000, 0x0000, 
    0xADE0, 0xADDF, 0x0000, 0xB050, 0xB052, 0xB053, 0xF0DD, 0xDBD6, 
    0xB35B, 0xB5FE, 0xB646, 0xB643, 0xB640, 0xDBDC, 0xDBDF, 0xE046, 
    0xE04C, 0xE047, 0xB8D7, 0xB8D9, 0xE04D, 0xB8E1, 0xB8E0, 0xBDD8, 
    0xEBA1, 0xE048, 0xBBA6, 0xBBA2, 0xBBA5, 0xE44D, 0xE7D4, 0xE7D8, 
    0xBDD3, 0xBDDB, 0xE7DC, 0xBDD4, 0xBDD9, 0xBFDB, 0xBFCF, 0xEBA6, 
    0xBFD6, 0xEBA7, 0xBFD9, 0xBFDC, 0xBFDA, 0xBFCD, 0xBFD4, 0xEBAB, 
    0xC2D3, 0xC66D, 0xEEA2, 0xEEB0, 0xC1C4, 0xC2D6, 0xF756, 0xF2FB, 
    0xC3D7, 0xC3D4, 0xF9A9, 0xC4B8, 0xC640, 0x0000, 0xCEAF, 0x0000, 
    0xCA56, 0xA6E9, 0xA8C0, 0xA8C1, 0xCDD9, 0xCDDA, 0xAB40, 0xB0A4, 
    0xD0C2, 0xD446, 0xDCA1, 0xB3B5, 0xB6AB, 0xB3B2, 0xDC7E, 0xB6AA, 
    0xE0D4, 0xEEF5, 0xCA52, 0xCA54, 0xF14B, 0xCA51, 0xE0A9, 0xCBA8, 
    0xCDD4, 0xCDD6, 0xAAF5, 0xBFF3, 0xAAF3, 0xCDD7, 0xD3F7, 0xD0BB, 
    0xD0BC, 0xEBD7, 0x0000, 0xD0BD, 0xDC50, 0xC5B0, 0xB072, 0xD3FC, 
    0xD3FB, 0xD3FA, 0xD7EF, 0xD7E8, 0xB66E, 0xDC52, 0xE46B, 0xBBC2, 
    0xE468, 0xBE49, 0xE854, 0xC1DD, 0xF4E1, 0xF65A, 0xAFEC, 0xABB7, 
    0xE4F4, 0xA757, 0xCA6F, 0xA8F0, 0xD0F8, 0x0000, 0xD46D, 0xBC45, 
    0xADEE, 0xC0E8, 0xF477, 0x0000, 0xC942, 0x0000, 0xD44A, 0x0000, 
    0xA5AF, 0xAF63, 0xDD57, 0xCAAC, 0xB0EE, 0x0000, 0xB9D1, 0xE94F, 
    0xBEC3, 0xC0A4, 0xA666, 0xA664, 0xC9C9, 0xA660, 0xC252, 0xC9C8, 
    0xA665, 0xC363, 0xA7A6, 0x0000, 0xA958, 0x0000, 0xCBF5, 0xF1F6, 
    0xA95C, 0xCBFB, 0xCC40, 0xCBF4, 0xCBF8, 0xCBFC, 0xD4C1, 0xCE53, 
    0xCE54, 0xDCE5, 0xD4BA, 0x0000, 0x0000, 0xABB2, 0xABAD, 0xD14C, 
    0xB6F6, 0xB3FA, 0xDCE4, 0xD14D, 0xD152, 0xD4B2, 0x0000, 0xD4B7, 
    0xB0F1, 0x0000, 0xD4B8, 0xD4CB, 0xD4B5, 0xD4B4, 0xD4B3, 0xD8A2, 
    0xD8A1, 0x0000, 0xB3FB, 0xDCED, 0x0000, 0xE15B, 0xE156, 0x0000, 
    0xBC55, 0xC4C9, 0xC567, 0xC574, 0x0000, 0xCA4D, 0xCA4E, 0xCB7A, 
    0xCBA1, 0xCDBF, 0xCBA3, 0xCB7C, 0xCB7D, 0xEB52, 0xAADC, 0xCDB4, 
    0xEAFC, 0xAAE8, 0xAAE7, 0xF4BE, 0x0000, 0xAD55, 0xCDB6, 0xAAE9, 
    0xCDBA, 0xB341, 0xB5E7, 0xE776, 0xCDC1, 0xCDBE, 0xCDC0, 0x0000, 
    0xAADF, 0x0000, 0xAD52, 0xCDC3, 0xD077, 0xAD5B, 0x0000, 0xD0A1, 
    0xF4B8, 0xD06E, 0xAD60, 0xD075, 0xAD5C, 0x0000, 0xD07A, 0xD07B, 
    0xAD64, 0xE772, 0x0000, 0xAD67, 0xB6F7, 0xDE72, 0xD0A2, 0xD071, 
    0xD37D, 0xD377, 0xEAFE, 0xE76E, 0xD3A5, 0xB2F7, 0xD3A6, 0xAFF5, 
    0xAFFC, 0xD76C, 0xEB4C, 0xD3AC, 0xAFF6, 0xD3AE, 0xAFFE, 0xEE50, 
    0xAFFB, 0xAFFA, 0xC2C9, 0xD374, 0xD072, 0xD373, 0xBABA, 0xE26C, 
    0xEB43, 0xD3A3, 0xF0B0, 0x0000, 0xBB5E, 0xDFD2, 0x0000, 0xD774, 
    0xB2F2, 0xE3C2, 0xB8B1, 0xB2FB, 0xD76D, 0xB2F9, 0x0000, 0xBB59, 
    0xB2FE, 0xEE56, 0xD767, 0xD768, 0xEB4F, 0xB2FD, 0xB2F1, 0xB2F0, 
    0xD75B, 0xC561, 0x0000, 0xB5D7, 0xDB6D, 0xDB6F, 0xDB70, 0xD4BB, 
    0x0000, 0xB5D6, 0xDB6E, 0xB5E0, 0xDB75, 0x0000, 0xB5E3, 0xDB7B, 
    0xDB7C, 0xB5E8, 0xB5E9, 0xDB79, 0xB5D1, 0xB5D2, 0xDB5E, 0xDBA5, 
    0xB5D5, 0xDB60, 0xBFA2, 0xB5DD, 0xDB72, 0x0000, 0xDFB1, 0xDFB8, 
    0xDFB9, 0xDFBB, 0xEB41, 0x0000, 0xDFC2, 0xEB44, 0xDFC4, 0xB8B0, 
    0xB8B6, 0xB8B4, 0xDFAC, 0xE76F, 0xDFD5, 0xB8A9, 0xB8B5, 0xE3B8, 
    0xE3B9, 0xE3BD, 0xC55A, 0x0000, 0xBB5F, 0xBB63, 0xBB55, 0xE3B0, 
    0xF7F0, 0xE3AE, 0xE3B6, 0xE3B7, 0xE3AC, 0xF16A, 0xEE40, 0xE75C, 
    0xBF5F, 0x0000, 0xE775, 0xF5FD, 0xE754, 0xC4A9, 0xEAF8, 0xE74D, 
    0xBDB6, 0xE764, 0xBFB7, 0xBFB8, 0xBFB9, 0xEB42, 0xBFBF, 0xEE44, 
    0xEA7B, 0xBFBB, 0xF4BF, 0xEDFB, 0xEDFC, 0xC1A9, 0xC1A8, 0xEDF5, 
    0xEE52, 0xC3C1, 0xC1A3, 0xEE51, 0xC2CA, 0xF0B8, 0xC2C8, 0xC4F6, 
    0x0000, 0xF2D4, 0xF4B9, 0xF5F8, 0xF4C1, 0xF5FC, 0x0000, 0xF7F3, 
    0xA47B, 0xABD9, 0xC9CB, 0xB9DD, 0xD055, 0xABB3, 0xAE4F, 0xAE4E, 
    0xB0CC, 0xA471, 0xC9D5, 0xA7BC, 0xC0AA, 0x0000, 0xB1BF, 0xE1DE, 
    0xCCBD, 0xCCB9, 0xA9E9, 0xA9ED, 0xABFA, 0xE5B9, 0xCEDF, 0xD1BA, 
    0xD1BB, 0xD1B8, 0xD56D, 0xD95E, 0xB1BA, 0xB1CC, 0xD571, 0xBA51, 
    0xD579, 0xB1C5, 0xD568, 0xB1CA, 0xD57A, 0xE1E8, 0xD960, 0x0000, 
    0xD95D, 0xBCC3, 0xD967, 0x0000, 0xD955, 0xB4AC, 0xB47D, 0xD964, 
    0xEFD2, 0xDDAE, 0xDDB6, 0xDDB8, 0xDD7D, 0xDDAA, 0xDDAB, 0xDDBA, 
    0xE1E7, 0xF44C, 0xBA54, 0xE5AF, 0xBA50, 0xC25E, 0xEFD7, 0xBCC1, 
    0xF5CD, 0x0000, 0xE9A6, 0xE9A4, 0xECEC, 0xC0C2, 0xF245, 0xF7DD, 
    0xF8EF, 0xA47C, 0xCAD6, 0x0000, 0xB749, 0x0000, 0xA577, 0xBC54, 
    0xA56E, 0xA56F, 0xA57B, 0xA65C, 0x0000, 0xA65B, 0x0000, 0xE546, 
    0xC56D, 0xCA79, 0xF1F2, 0xA763, 0x0000, 0xD0F9, 0xCE4A, 0x0000, 
    0x0000, 0xCBDF, 0x0000, 0xA945, 0xA94B, 0xCBEF, 0xA94E, 0xC07B, 
    0xA946, 0xA94C, 0xCBE7, 0x0000, 0x0000, 0xCDFC, 0xAB7B, 0x0000, 
    0xE8FD, 0xABA8, 0xAB78, 0xE4F9, 0xB9CD, 0xCE4D, 0x0000, 0xE941, 
    0xABA6, 0xABA9, 0x0000, 0xE944, 0x0000, 0xECC1, 0xABA7, 0xAB7D, 
    0x0000, 0xBEBA, 0xCDFE, 0xCE4E, 0xE14D, 0xD0F4, 0xBC47, 0xAE43, 
    0xADF8, 0xD0F5, 0xDCD4, 0x0000, 0xAE44, 0xD0FC, 0xAE41, 0xD477, 
    0xB9C9, 0xD86F, 0xD870, 0x0000, 0xC4DA, 0xB0E7, 0xB0DE, 0x0000, 
    0xD475, 0xD473, 0xADF2, 0xB0DC, 0xD471, 0xD472, 0xD86A, 0xB0E6, 
    0xD47C, 0xB0E3, 0xB3E3, 0xDCD6, 0xB3E4, 0xB3ED, 0x0000, 0xD86E, 
    0xD871, 0xB3E7, 0xB3EE, 0xDCDB, 0xD866, 0xB3D7, 0xB6D8, 0xB9C6, 
    0xF441, 0xB3E1, 0xB3F1, 0x0000, 0xB9C8, 0xB6E8, 0xB9CA, 0xB6DF, 
    0xC4D9, 0x0000, 0xDCD2, 0xB6DB, 0xDCD0, 0xDCD3, 0xB6E2, 0xB6E7, 
    0xDCDD, 0xBEBC, 0xDCCC, 0xDCDE, 0xB6D9, 0x0000, 0xB6E1, 0xC5AF, 
    0x0000, 0xB9CB, 0xE149, 0xE14E, 0xC458, 0x0000, 0xB9BE, 0xB9BF, 
    0xE147, 0x0000, 0xE4FE, 0xBC49, 0xBC50, 0xE544, 0x0000, 0xBEBE, 
    0xBEB2, 0xC250, 0xE4F8, 0x0000, 0xECC3, 0xBEB6, 0xBEBB, 0xBEB3, 
    0x0000, 0x0000, 0xC07D, 0xECC0, 0x0000, 0xF8EE, 0xC949, 0xA65F, 
    0xC9C6, 0xD4AC, 0xA77A, 0xCBF1, 0xABAA, 0xAE46, 0xD4AB, 0xB0EB, 
    0xE947, 0xB457, 0xCC6F, 0xCC6E, 0xA9AE, 0xECDB, 0xE1B2, 0xB9F6, 
    0xB163, 0xD8F2, 0xB9F7, 0xB9F3, 0x0000, 0xBC6E, 0xA7C4, 0xC9D7, 
    0xCAC0, 0xA7C1, 0xB9F2, 0xCAC2, 0xAE73, 0x0000, 0xA7C2, 0xB450, 
    0x0000, 0xCC5E, 0xCC65, 0x0000, 0xCC61, 0xA9A6, 0xA9A7, 0xCC63, 
    0x0000, 0xA9A2, 0xE961, 0xABD0, 0xE569, 0xCE7D, 0xB157, 0xE563, 
    0xD4FB, 0xB15D, 0xD4FC, 0xD544, 0xB15C, 0xD4F4, 0xB153, 0xB155, 
    0xC0AF, 0x0000, 0xB451, 0xD8E6, 0xDD52, 0xD8E3, 0xB744, 0xE1A8, 
    0xD8DB, 0xD8DD, 0xDD4F, 0xB743, 0x0000, 0xE1A3, 0xE562, 0xBC6A, 
    0xC1C7, 0xECDA, 0xC571, 0xC94C, 0xA7CF, 0xCC75, 0xABE0, 0xABE2, 
    0xABE1, 0xB174, 0xB170, 0xB175, 0xB461, 0xDD64, 0xBC78, 0xE975, 
    0xC5FC, 0x0000, 0x0000, 0xC9A6, 0xCA43, 0xC278, 0x0000, 0xCB63, 
    0xCB65, 0xAAAD, 0x0000, 0xCD61, 0xCFC0, 0xEA61, 0xACBC, 0xDEAC, 
    0xD2A5, 0xAF58, 0xD2AA, 0xD2A8, 0xEA60, 0xD2A4, 0xD2A9, 0xD661, 
    0xB274, 0xC57A, 0xD665, 0xD669, 0xD660, 0xF46E, 0xDA70, 0x0000, 
    0xB554, 0x0000, 0x0000, 0xDA71, 0xBABC, 0xE2CB, 0xBCFB, 0xE679, 
    0xEA5E, 0xED65, 0xF5DD, 0xA6DF, 0xB9D9, 0xB6B8, 0xB9DB, 0x0000, 
    0x0000, 0xEF4F, 0xB6BB, 0xF1AD, 0xB6B9, 0xDCAE, 0xB6BD, 0xB97E, 
    0xBBE8, 0xE8C1, 0xBE6C, 0xC05F, 0x0000, 0xC349, 0xF3B1, 0xF3AF, 
    0xC444, 0x0000, 0xF557, 0x0000, 0xC979, 0xE575, 0xCACD, 0xA9B4, 
    0xCEBA, 0xABD6, 0xD549, 0xB167, 0xB168, 0xD54B, 0xBDE9, 0xE1BC, 
    0xE1B6, 0xE573, 0xE972, 0xE96F, 0xC174, 0x0000, 0xC97B, 0xA6A4, 
    0xC9E2, 0xBCAD, 0xCADB, 0xE1D3, 0xCADD, 0xCADE, 0xB75A, 0xB1A3, 
    0xB75B, 0xA7D8, 0xCAD9, 0xA7D7, 0xCC7C, 0xA9C5, 0xCC7B, 0xA9CD, 
    0xA9C2, 0xCCA9, 0xA9CB, 0xA9CC, 0xCCA2, 0xE97D, 0xA9C9, 0xBA45, 
    0xECE6, 0xB46C, 0xB75F, 0xCECB, 0xABF1, 0xD940, 0xAEAF, 0xAEAA, 
    0xE1C7, 0xD1A7, 0xD1A8, 0xD1A5, 0xAEAD, 0xD1AA, 0xB467, 0xB1A2, 
    0xD55E, 0xD55C, 0xB1A6, 0xB1A8, 0xB1AB, 0xB17C, 0xB759, 0xE5A6, 
    0xB46A, 0xB468, 0xB46D, 0xB473, 0xB470, 0xDD68, 0xDD67, 0xBA48, 
    0xBCA9, 0xBCAC, 0xBCA5, 0x0000, 0xBECF, 0xC36A, 0xA9BD, 0xF16F, 
    0xADAC, 0xD845, 0xC1F2, 0xB6A3, 0xB67B, 0xDC7A, 0xF66B, 0xBE5B, 
    0xE8A7, 0xF9C4, 0xE8A6, 0xEC48, 0xEC4B, 0xF1BE, 0xEC4C, 0xEC4E, 
    0xEC46, 0xEEF1, 0xC1F0, 0xC2F3, 0xC2F5, 0xC2F6, 0xF545, 0x0000, 
    0xC962, 0xA9CF, 0x0000, 0xC9FD, 0xC9FA, 0xC9FC, 0xF5D3, 0xA84A, 
    0xA84E, 0xA85C, 0xA850, 0xA851, 0xCB53, 0xA858, 0xA85A, 0xA859, 
    0xD9EC, 0xCCF8, 0xCCF4, 0xCCF5, 0xF25D, 0xC379, 0xAA74, 0xAA72, 
    0x0000, 0xAA7E, 0xAA7D, 0xEFF6, 0xCCF0, 0xCCF1, 0xAA62, 0xAA6C, 
    0xAA7B, 0xAEF9, 0xACA7, 0xACA8, 0xAC7B, 0xAF48, 0xD9FE, 0xCFA7, 
    0xCF77, 0xCF78, 0xACAD, 0xACAE, 0xE9F8, 0xACAB, 0xACAC, 0xCF7A, 
    0xC273, 0xE271, 0xBCF1, 0xCF76, 0xD250, 0xD24F, 0xD5E9, 0xE65C, 
    0xD255, 0xAEFE, 0xAF4B, 0x0000, 0xD257, 0xD25A, 0xD246, 0xB25A, 
    0xB24E, 0xB258, 0xB253, 0xC270, 0xB267, 0xD5ED, 0xBF49, 0xB268, 
    0xD5F3, 0xB246, 0xC26E, 0xD5E1, 0xD5F1, 0xB252, 0xD9F1, 0xB4F3, 
    0xB542, 0xDA47, 0xDE59, 0xB547, 0xE2A9, 0xDA4B, 0xB4E6, 0xB4E8, 
    0xB4EC, 0xB544, 0xF9D0, 0xDE4C, 0xB7C2, 0xF5D4, 0xE2A5, 0xEFEF, 
    0xB7C1, 0xB7CC, 0xDE50, 0x0000, 0xDE54, 0xE65F, 0xB7CD, 0xDE58, 
    0xDE46, 0xB7BC, 0xDE48, 0xE643, 0xF25E, 0xC374, 0x0000, 0xBAA8, 
    0xE2A3, 0xBAAA, 0xE2A1, 0xC46B, 0xEFF5, 0xBAAC, 0xE275, 0xBA78, 
    0xE641, 0xE640, 0xE642, 0xBCE8, 0xE64C, 0xBCE0, 0xBCEB, 0xC375, 
    0xEA41, 0xBF43, 0xBF46, 0xBF47, 0xBEFC, 0xC0E1, 0xC0E4, 0xED57, 
    0xC0DA, 0xC0DE, 0xC376, 0xF263, 0xC373, 0xF465, 0xF45C, 0xF8AF, 
    0xC5F4, 0x0000, 0xC973, 0xCC58, 0xCC57, 0xABC9, 0xAE66, 0xDAAC, 
    0xC4CA, 0xBA53, 0xB9ED, 0xBC64, 0xEB72, 0xBEC8, 0xEEBF, 0xEEAA, 
    0x0000, 0xCDCE, 0xCDD1, 0xAD7E, 0xD0B5, 0xADA3, 0xC2E2, 0xAD7B, 
    0xB377, 0xADA4, 0xB06D, 0xD3EF, 0xD7E3, 0xC5DD, 0xD7E4, 0xB370, 
    0xB37C, 0xD7E7, 0xB666, 0xB66A, 0xDC4D, 0xDC4F, 0xE0A1, 0xB94E, 
    0xE07D, 0xB949, 0xBE43, 0xBBB8, 0xBBBD, 0xBBBF, 0xBEE6, 0xBFEE, 
    0xC1D8, 0xC1DB, 0xC2E4, 0xC2E3, 0xC3E5, 0x0000, 0xB16B, 0xCEBD, 
    0xD8F4, 0xC975, 0xABA4, 0xAE6A, 0xD4F3, 0xB447, 0xE1A2, 0xC0AB, 
    0xC4F3, 0xD179, 0xA9B8, 0xABDA, 0xD758, 0xB45D, 0xF7A7, 0xC94B, 
    0xA671, 0xA66D, 0xA7B0, 0xBC61, 0xB9E1, 0xA7AD, 0xCAB5, 0xA96E, 
    0xD8B5, 0xA7AC, 0xA7B1, 0xA971, 0xCC48, 0xA96F, 0xA96B, 0xA963, 
    0xD4D5, 0xBC63, 0xCE67, 0xF6DC, 0xABBB, 0xABB9, 0x0000, 0xAE5B, 
    0xAE5C, 0xB445, 0xBC5F, 0xAE50, 0xAE58, 0xAE55, 0xB0FE, 0xD4D1, 
    0xB144, 0xD4D0, 0xB140, 0xB141, 0xBC60, 0x0000, 0xB6FE, 0xB444, 
    0xB440, 0xD8B8, 0xB6FC, 0xE172, 0xB742, 0xE954, 0xC0A7, 0xDCF7, 
    0xE175, 0xB9E4, 0xE952, 0xB9E2, 0xB9DF, 0xB9E3, 0xE16B, 0xBC5E, 
    0xE951, 0xE958, 0xECD0, 0xC0A8, 0xC45C, 0xC9D4, 0x0000, 0xA7B7, 
    0xCC56, 0xB446, 0xA46D, 0xA46E, 0xCC55, 0xE8CA, 0xBE6F, 0xBE74, 
    0xF55F, 0xC5E6, 0xBE71, 0xE8CE, 0xC5BB, 0xF77E, 0xC063, 0xC67A, 
    0xF1AF, 0xF1B2, 0xF1B6, 0xF67C, 0xF563, 0xC445, 0xF67D, 0xF561, 
    0xF562, 0xC559, 0xF67B, 0xF77C, 0xC66B, 0xF9B3, 0x0000, 0xACFA, 
    0xACF4, 0xACF8, 0xD04B, 0xF5E7, 0xAFC6, 0xAFC4, 0xD356, 0xD6E6, 
    0xB2D8, 0xB2D9, 0xBFA8, 0xB2D1, 0xB2D2, 0xD6ED, 0x0000, 0xDAFB, 
    0xB5BC, 0xDF58, 0xDF60, 0xDF57, 0xBAF0, 0xBAF6, 0xE36E, 0x0000, 
    0xE36C, 0xBD78, 0xBAFE, 0xE371, 0xE365, 0xBAED, 0xBAFD, 0xBD79, 
    0xE6E7, 0xBD7B, 0xBD7A, 0xF072, 0xE6EB, 0xE6EC, 0xE6ED, 0xEAD8, 
    0xE6E8, 0xBFA7, 0xBFA6, 0xEAD0, 0xBFA5, 0xEDD0, 0xBF7E, 0xBFA1, 
    0xC47D, 0xC165, 0xC167, 0xC15D, 0xC15B, 0xC162, 0xF5E9, 0xC2B7, 
    0xC2B9, 0x0000, 0xF4AD, 0xF2B2, 0xF2B4, 0xF940, 0x0000, 0xBD42, 
    0x0000, 0xCD72, 0xB06F, 0xCA45, 0xBF59, 0xDEB3, 0xCD6A, 0xAAB3, 
    0xAAB2, 0xCFC8, 0xC46E, 0xACBF, 0xACC5, 0xACC4, 0x0000, 0xCFC9, 
    0xD2AD, 0xD2AC, 0xB97A, 0xB278, 0xD2B2, 0xD2B0, 0xAF5F, 0xC3A2, 
    0xB7E9, 0xE6A3, 0xB558, 0xB7EB, 0xB561, 0xB55B, 0xB562, 0xDA7C, 
    0xDA7A, 0xDA7B, 0xB560, 0xDAA1, 0xB7E8, 0xB7EC, 0xDEB6, 0xB7E5, 
    0xB7EA, 0xC0F5, 0xBAC1, 0xBD40, 0xBF58, 0xC4ED, 0xBD41, 0xE6A6, 
    0xE6A2, 0xBCFD, 0xBF5C, 0xC0F6, 0xC0F3, 0xED69, 0xC27A, 0xC5D0, 
    0xF46F, 0xF1A4, 0xF3A5, 0xC3FC, 0xCB42, 0xA840, 0xA7FB, 0xCB43, 
    0xE259, 0xF455, 0xAA4A, 0xAA57, 0xAA48, 0xCCD9, 0x0000, 0xAA53, 
    0xD9B3, 0xBCD7, 0xB1FA, 0xAA44, 0xAA49, 0xAA56, 0xCF55, 0xC0CD, 
    0xCF43, 0xF453, 0xAC5E, 0xAC69, 0xF456, 0xAC6A, 0xCF4A, 0xAC63, 
    0xCF4C, 0xAC6C, 0xB1F7, 0xCF61, 0xAC65, 0xAC6B, 0xF252, 0xCEFB, 
    0xECF7, 0xD1DC, 0xD1DD, 0xD9B2, 0xBEF8, 0xD1E8, 0xB7A9, 0xD1E9, 
    0xE24E, 0xB1F2, 0xD1EB, 0x0000, 0xBEEC, 0xAEEC, 0xC0CC, 0xAEE5, 
    0xF7E1, 0x0000, 0xD1DB, 0xAEDD, 0xB1EB, 0xD5C0, 0xD5BE, 0xD5C1, 
    0xB1EA, 0xD5C4, 0xF9BB, 0xB4D8, 0xD9C8, 0xC370, 0xE5DE, 0xB4CD, 
    0xF7E2, 0xDDDE, 0xD9CA, 0xBCCD, 0xDDD4, 0xB4D0, 0xD9B9, 0xDDCE, 
    0xDDD2, 0xB7A3, 0xDDD3, 0xB7AF, 0xC656, 0xB7AA, 0x0000, 0x0000, 
    0xDDDF, 0xDDE0, 0xBA6C, 0xC468, 0xC371, 0xE241, 0xF5D1, 0xDDC9, 
    0xB7B0, 0xB7AD, 0xBA64, 0xE249, 0xBA66, 0xBA67, 0xBA6B, 0xE252, 
    0xE1FC, 0xBA60, 0xE254, 0xC262, 0xBA5F, 0xF24C, 0xE24A, 0xE5D3, 
    0xC0CE, 0xBCD8, 0xE5CC, 0xE5E8, 0xF255, 0xE5DA, 0xBEF1, 0xE9C4, 
    0xC0D2, 0xE9D1, 0xE9C8, 0xBEF6, 0xECFE, 0xC372, 0xBEEA, 0xE9CA, 
    0xBEEF, 0xF258, 0xED44, 0xC0D1, 0xECF5, 0xC0D0, 0x0000, 0xB7DF, 
    0xE676, 0xAA5C, 0xCF65, 0xBCDC, 0xCF66, 0xE266, 0xC0D4, 0xD5DC, 
    0xE9E3, 0xDDFB, 0xC26C, 0xE9E2, 0xB062, 0xB36D, 0x0000, 0xB661, 
    0xF847, 0xDC40, 0xB663, 0xDC48, 0x0000, 0xF765, 0xDBFE, 0xB8FD, 
    0xB8FE, 0xE079, 0xE078, 0xBBB3, 0xBDFB, 0xBDFE, 0xBDF9, 0xBDFD, 
    0xBFEA, 0xF146, 0xC3E1, 0x0000, 0xCCB1, 0xE1D7, 0xB1AE, 0xB475, 
    0xB761, 0xB760, 0xDD75, 0xDD76, 0xE1D6, 0xBB4E, 0xBF5E, 0xD2BE, 
    0xDEC0, 0xED72, 0xED70, 0xF049, 0x0000, 0xC9EE, 0xC9ED, 0xCAF8, 
    0xA9FE, 0xBEE8, 0xAA58, 0xCCCA, 0xA9FD, 0xA9FB, 0xCD52, 0xAC54, 
    0xCEF5, 0xCEF6, 0xAC52, 0xCEEB, 0xCEEE, 0xAFCF, 0xD1D4, 0xBEE7, 
    0xAED0, 0xAECB, 0xB775, 0xD5AA, 0x0000, 0xB4BE, 0xB779, 0xDDC0, 
    0xC0C7, 0xBA5C, 0xE9B4, 0xEFDB, 0xC260, 0xC466, 0xC4E4, 0xB64E, 
    0xDBEA, 0xDBE8, 0xB64D, 0xF0F4, 0xB8ED, 0xB8F0, 0xF652, 0xBBAC, 
    0xE7EC, 0xE453, 0x0000, 0xE7EE, 0xC1CC, 0xDBD1, 0xC1BB, 0xE444, 
    0xF753, 0xBFCC, 0xEE7A, 0xC2D1, 0xF2F3, 0xCFBD, 0x0000, 0xA6C9, 
    0x0000, 0xACBA, 0xD65C, 0xD65F, 0xB551, 0xDA6C, 0xDEA5, 0x0000, 
    0xBAB9, 0xAEB2, 0xD566, 0xD954, 0xE1EE, 0xC0BC, 0xACFE, 0x0000, 
    0xD9E5, 0xB7B7, 0xE5F7, 0xDE40, 0xBEFB, 0xF25B, 0xE9E8, 0xF6E7, 
    0xC97E, 0xC9F7, 0xCB49, 0xCB4A, 0xCF6C, 0xB4E3, 0xAEF4, 0xD5DF, 
    0xBA72, 0x0000, 0xB1D5, 0x0000, 0xC37C, 0xB7DE, 0xBCF8, 0xACB8, 
    0xE77E, 0xA647, 0x0000, 0xCB78, 0xA877, 0x0000, 0xCCD2, 0x0000, 
    0xAAD0, 0xAAD2, 0xCDB0, 0xAAD4, 0x0000, 0xC467, 0x0000, 0x0000, 
    0xC4A4, 0xAD4B, 0xD05B, 0xAD48, 0xD05F, 0xD067, 0xD065, 0xCEFA, 
    0xAD4F, 0xD748, 0xAFD6, 0xAFDB, 0xAFDA, 0xC17A, 0x0000, 0xD36A, 
    0xAFE2, 0xAED3, 0x0000, 0xB362, 0xDFA2, 0xD74C, 0xD74B, 0xD745, 
    0x0000, 0x0000, 0xB5CB, 0xB5CC, 0xB5CD, 0x0000, 0x0000, 0xB878, 
    0xDF73, 0xDF76, 0x0000, 0xE3A6, 0x0000, 0xDF7D, 0xDCE6, 0xDCF9, 
    0xBB4A, 0xBB4D, 0xC2C1, 0xBCF0, 0xE6FD, 0x0000, 0xEDEA, 0xC261, 
    0xEDEB, 0xEDE8, 0x0000, 0xEAE9, 0xC26A, 0xD5D8, 0xD9DA, 0xDDF7, 
    0xDDF5, 0xBEF9, 0xE4CD, 0xBBE3, 0xC1FC, 0xC442, 0xF674, 0x0000, 
    0xC95F, 0xDD62, 0xC1D4, 0xEE7D, 0xB4B4, 0xF87E, 0xC4E3, 0xA9F3, 
    0xD1CF, 0xD1D1, 0xD1D0, 0xB1DC, 0xB1DD, 0xD97E, 0xBA59, 0xB7D5, 
    0xDE6D, 0xCD57, 0xE2C4, 0x0000, 0x0000, 0xCFAE, 0xACAF, 0xCFB1, 
    0xEA4D, 0xAF4C, 0xD651, 0xD655, 0xBF54, 0xDA5A, 0xDA5D, 0x0000, 
    0xB7D4, 0xB7DB, 0x0000, 0xDE73, 0x0000, 0xDE74, 0x0000, 0x0000, 
    0xE672, 0xE669, 0xBCF7, 0xE666, 0xC0EE, 0xEA4F, 0xC0E6, 0xEFFB, 
    0xF5DA, 0xC679, 0x0000, 0xC276, 0xB7D6, 0xBF51, 0xA9D1, 0xCCB2, 
    0xCED3, 0xB1AF, 0xB476, 0x0000, 0xAAC1, 0xACE6, 0xACE7, 0xD2E7, 
    0xD2E9, 0xD2EA, 0xAFAE, 0xF2A5, 0xAFAD, 0xAFA8, 0xBAD5, 0xD6BD, 
    0xB852, 0xC149, 0xE2F9, 0xE6CB, 0xC148, 0xC5A1, 0xCAD7, 0xCAD8, 
    0xEFC8, 0xD17C, 0xD17D, 0xD17E, 0xD1A1, 0xAE7E, 0xAEA1, 0xE1C3, 
    0xB75E, 0xB75D, 0xBC7C, 0xBECD, 0xE976, 0xC0B7, 0xC256, 0xF9BA, 
    0x0000, 0xA6D6, 0xCCEE, 0xED4F, 0xD9E7, 0xC146, 0xCD7A, 0xE2EE, 
    0xCFF1, 0xDACF, 0x0000, 0xCFEB, 0xAC48, 0xAFA2, 0x0000, 0xAF7C, 
    0x0000, 0xC472, 0xF5E2, 0xAFA4, 0x0000, 0xAFA1, 0xD2DA, 0xD2D9, 
    0xD2E2, 0xB2BA, 0xDAC9, 0xDAC6, 0xEDA6, 0xD6B9, 0xD6BB, 0x0000, 
    0xD6B8, 0xDACB, 0xBF6C, 0xB850, 0xDEE5, 0xDEE4, 0xEAA7, 0xDEEC, 
    0xBAD4, 0xE2EB, 0x0000, 0xE2F3, 0xE6C6, 0x0000, 0xE6CA, 0xBF6B, 
    0xEDAA, 0xEDAB, 0xC145, 0xF058, 0xF47D, 0xF2A4, 0xF2A1, 0xF7CE, 
    0xDCB0, 0xEFB0, 0xF3F5, 0xCD77, 0xCFE2, 0x0000, 0xACDA, 0xACE0, 
    0xCFE0, 0xD2D6, 0xD2D7, 0xD2D5, 0xD6AA, 0x0000, 0xD6B2, 0xB2B6, 
    0xB7FD, 0xC2A5, 0xDABB, 0x0000, 0xDEDD, 0xB845, 0xB846, 0xB844, 
    0xBACD, 0xE6BC, 0xBACC, 0xE2E7, 0xBD4F, 0xBD50, 0xBF67, 0xBF65, 
    0xC0FD, 0xED7A, 0xC2A2, 0xCB6D, 0xCD71, 0xACCA, 0xACCB, 0xCFDB, 
    0xD2C1, 0xDAAE, 0xDEC4, 0x0000, 0xD04D, 0xD35C, 0xAFCB, 0xDBE0, 
    0xDF6A, 0xF2BC, 0x0000, 0xBFA9, 0xC5F9, 0xEDE3, 0xAF72, 0xBF64, 
    0xF7F8, 0x0000, 0xD0C1, 0xD0C0, 0xB07A, 0xB078, 0xD442, 0xD841, 
    0xB3A9, 0xD7FC, 0xEBEA, 0xB3A6, 0xD7FD, 0x0000, 0xDC67, 0xB964, 
    0xB67A, 0xB678, 0xDC62, 0xDC70, 0xDC6F, 0xDC64, 0xDC6A, 0xE0B1, 
    0xE0B2, 0xB957, 0xE0B3, 0x0000, 0xB95A, 0xB959, 0xE0B5, 0xE0BB, 
    0xE0BA, 0xB966, 0xC5E0, 0xE0B0, 0xB962, 0xE0AE, 0xB963, 0xE0B7, 
    0xB965, 0xC54D, 0xBE52, 0xE47B, 0xE47A, 0xE47D, 0xE4A8, 0xE868, 
    0xC4C2, 0x0000, 0xC54C, 0x0000, 0xE4A1, 0xF15A, 0xBBCB, 0xE86F, 
    0xE4B7, 0xF4F3, 0xBBCD, 0xE4A6, 0xF36A, 0xE4A2, 0xBFFE, 0xE4A3, 
    0xE0B6, 0xF4E7, 0xBBCF, 0xE4A7, 0xF4F9, 0xEBE4, 0xE869, 0xC3F4, 
    0x0000, 0xBE59, 0xE870, 0xE872, 0xBE56, 0xE86E, 0x0000, 0x0000, 
    0x0000, 0xE863, 0xE86A, 0xE876, 0xEBE8, 0xEBE1, 0x0000, 0xEBE6, 
    0x0000, 0xEBE9, 0xC043, 0xC044, 0x0000, 0x0000, 0xEBDF, 0xEBE0, 
    0xC045, 0xC1E6, 0xEED2, 0xEED6, 0xC1EE, 0xEED0, 0xF15C, 0xC1EC, 
    0x0000, 0xC3F3, 0xC3F2, 0xF4F0, 0x0000, 0xF368, 0xC2F0, 0xC54F, 
    0x0000, 0xF15E, 0xC2EF, 0xF153, 0xF767, 0xC3F0, 0xC3ED, 0xC3EE, 
    0xC3F1, 0xF360, 0xC3EB, 0xF361, 0xC3E9, 0xF4EC, 0x0000, 0xF4F5, 
    0x0000, 0xF4E8, 0xF953, 0xF4EA, 0x0000, 0xF366, 0xF4F1, 0xF769, 
    0xC54E, 0xF65E, 0x0000, 0xC5DF, 0xC1E9, 0xCFE8, 0xDAC4, 0xB96E, 
    0xCFF9, 0xD2F1, 0xAFB0, 0xD2ED, 0x0000, 0xB452, 0xDAD8, 0xDAD6, 
    0xB85C, 0xB85A, 0xE6D2, 0xBD5E, 0xC2A8, 0xC248, 0xC34C, 0xF6F8, 
    0xACD4, 0xB2AE, 0xB571, 0xDED5, 0xED78, 0xD2BC, 0xB27D, 0xA869, 
    0xB9A7, 0xBBF0, 0xE8E9, 0xBE7D, 0xC06C, 0xF3F0, 0xF9B7, 0xECA9, 
    0xECAE, 0xC5EE, 0xEF7B, 0xF7C1, 0xEF7E, 0xEFA2, 0xC67D, 0xF1D0, 
    0xF9CF, 0xC35B, 0xF1D9, 0xF871, 0xF1CF, 0xC44D, 0x0000, 0xC44F, 
    0xF3ED, 0xC44C, 0xF57C, 0xF5A7, 0x0000, 0x0000, 0xF5AD, 0xC563, 
    0xF6B4, 0xC678, 0xC5C2, 0xF7BA, 0xF863, 0xF86B, 0xF86C, 0xF866, 
    0x0000, 0xC64F, 0xC67C, 0x0000, 0xCB6F, 0xF04B, 0xC27E, 0xAAB7, 
    0x0000, 0xACD0, 0xAF69, 0x0000, 0xAF6E, 0xD2C6, 0x0000, 0xD2C3, 
    0x0000, 0xAF6D, 0x0000, 0xB2AD, 0xB569, 0xC0F7, 0xDAB2, 0xDAB5, 
    0xED77, 0xDAAF, 0xDEC9, 0xB7F3, 0xDECC, 0xB7F5, 0xDECF, 0xB7EF, 
    0xED76, 0xE2DC, 0xE6B0, 0xE2DF, 0xE6AF, 0x0000, 0xE2DD, 0xE6B1, 
    0xE6B7, 0xEA70, 0xBD49, 0xBD43, 0x0000, 0xEA6C, 0xEA73, 0xF6F4, 
    0xEA71, 0xED74, 0xC57D, 0xEA6F, 0x0000, 0xC4EE, 0x0000, 0xF04A, 
    0xC27D, 0xC5F6, 0x0000, 0xD6F6, 0xDADC, 0xCDA5, 0xAAC6, 0xCFFE, 
    0xD2F6, 0xAFB7, 0xB2C0, 0xC475, 0xB85E, 0xE34C, 0xE34A, 0xEAB2, 
    0xE6D5, 0x0000, 0xD0AE, 0xD3D4, 0xB04D, 0xD3D7, 0xB04C, 0xD7B5, 
    0xC3CB, 0xDBCB, 0xDBCA, 0xDBCF, 0xEE72, 0xDFF4, 0xF2F0, 0xF0D9, 
    0xE3F7, 0xBB75, 0xE3FC, 0xBB74, 0xE3FA, 0xE440, 0xBFCA, 0xE7C8, 
    0xBDC8, 0xC1B9, 0xBDCA, 0xC4B0, 0xBFC9, 0xC1B7, 0xEE75, 0xF4CB, 
    0xF94B, 0xA5D4, 0xAD45, 0xE2E1, 0xB572, 0xACE1, 0xA6D4, 0xD054, 
    0xD366, 0xB2E0, 0x0000, 0x0000, 0x0000, 0xBDA2, 0xEDE7, 0xEAE6, 
    0xBFAE, 0x0000, 0xB5C0, 0xCDAA, 0xD743, 0xB2E2, 0xF4B2, 0xB5C1, 
    0xF07C, 0xC16D, 0xB5F7, 0xDCAC, 0xE0E0, 0xE0DE, 0xBE65, 0xBE67, 
    0xE5F9, 0xE8B8, 0xC058, 0xC345, 0xC346, 0xF9AE, 0xF54F, 0xF3A8, 
    0xC556, 0x0000, 0xC649, 0xCA4F, 0xB040, 0xCDC8, 0xCDCA, 0xF2E3, 
    0xAD6B, 0xD0A8, 0xAD6A, 0xD3BA, 0xD3BC, 0xD3C2, 0xB8C3, 0xD3CC, 
    0xD3C8, 0xB047, 0xB042, 0xB043, 0xB045, 0xB346, 0xB347, 0xB348, 
    0xC4F7, 0xD7A5, 0xD7A4, 0xB34B, 0xB34C, 0xB34D, 0xF2DE, 0xD7AB, 
    0xDBBC, 0xDFE6, 0xC2CC, 0xB5ED, 0xEB6B, 0xB5F1, 0xB8BB, 0xB5F2, 
    0xF4C5, 0xB5EB, 0xDBB1, 0xDBBF, 0xB8C2, 0xB8BD, 0xDFEA, 0xB8BC, 
    0xB8C4, 0xDFEF, 0xDFEC, 0xE3D6, 0xBB66, 0xE3DB, 0xBB68, 0xE3DA, 
    0xE3F2, 0xE3E2, 0xC1B4, 0xBB69, 0xE3EB, 0xBB6D, 0xBB6C, 0xBB64, 
    0xBDB8, 0xBB67, 0x0000, 0xF4C6, 0xE7BC, 0xBDBB, 0x0000, 0xBDC1, 
    0xE7B8, 0x0000, 0xBDC2, 0xE7A2, 0xC1B2, 0xE7A3, 0xBDBF, 0xE7BA, 
    0xEB5E, 0xEE67, 0x0000, 0xC1AF, 0xC1B0, 0xEB60, 0xEB67, 0xEE5A, 
    0xEB5D, 0xBFC0, 0xC1B1, 0xF0C1, 0xEE5D, 0xEE5F, 0xC1AE, 0xC1B5, 
    0xF0C7, 0xEE6E, 0xC1AD, 0xC1AC, 0xEE69, 0xF0BE, 0xF0C0, 0xC2CF, 
    0x0000, 0xF4C9, 0xF4C8, 0xC3CA, 0xF2E7, 0xF642, 0xC4F9, 0xC5FB, 
    0xF96E, 0xA6CE, 0xC4A2, 0xC16A, 0xEDE1, 0xAFE7, 0xAAC7, 0xACF2, 
    0xD344, 0xBF77, 0xD340, 0xB863, 0xD345, 0xD6D7, 0xD343, 0xD6CC, 
    0xD6DB, 0xD6D4, 0xB2C6, 0xB2C8, 0xD6D6, 0xB2C1, 0xD6CE, 0xD6D1, 
    0xD6D2, 0xF8FB, 0xB2C7, 0xDAE5, 0xEDC3, 0xDAE6, 0xBAE1, 0xDAE2, 
    0xBAE5, 0xB861, 0xB862, 0x0000, 0x0000, 0xDF4B, 0xDF4E, 0xE352, 
    0xEDBD, 0xE6D7, 0xBAE6, 0xE6D9, 0xBAE3, 0xF6FB, 0xE358, 0xC2B0, 
    0xE34F, 0x0000, 0xC2AD, 0xBD65, 0xC2B1, 0xBD68, 0xBD6A, 0xEABA, 
    0xEABD, 0xEABC, 0xBF7B, 0xEAC1, 0xC150, 0xC14E, 0x0000, 0xEDBB, 
    0xF8B8, 0xEDC2, 0xF065, 0xC2AF, 0xF068, 0xC3B0, 0xC5A3, 0xC3B3, 
    0xAAD8, 0xD370, 0xB2EA, 0xDB57, 0xAFE5, 0xD3D0, 0xD069, 0xAD51, 
    0xF2C3, 0x0000, 0xD371, 0xAFEA, 0xAFE9, 0xD753, 0xF746, 0xD754, 
    0xD756, 0x0000, 0xDFA5, 0xDFA4, 0xBB53, 0xE746, 0xEDF1, 0xF0A2, 
    0xF4B6, 0xD3DA, 0xB8CD, 0xB350, 0xB8CA, 0xB8C6, 0xC3CE, 0xD6F4, 
    0xDF6D, 0xDF6E, 0xBD7E, 0xE6F3, 0xBFAA, 0x0000, 0xAEC5, 0xD34A, 
    0xF5E6, 0xF8FD, 0xDAE8, 0xDAE7, 0xDF54, 0xE360, 0xBAEA, 0xC158, 
    0x0000, 0xE6E1, 0x0000, 0xE6E0, 0xE6DF, 0xEAC9, 0xEDCF, 0xA6E1, 
    0xBA5B, 0xACFD, 0xB2DE, 0xB5BF, 0xE37D, 0xBB42, 0xE6F9, 0xBDA1, 
    0xBFAD, 0xC16B, 0xA6CD, 0xEDDE, 0xE375, 0xE376, 0xEDD9, 0xF941, 
    0xBEA2, 0xC454, 0xAD76, 0xDBED, 0xE064, 0xE05E, 0xF96F, 0xB369, 
    0xBDEA, 0xD3DE, 0xB361, 0xADAA, 0xD3FE, 0xD440, 0xD441, 0xDC5E, 
    0xDC60, 0xDC5D, 0x0000, 0xB955, 0xE0AD, 0xC66F, 0xF971, 0xE473, 
    0xBBC6, 0xE474, 0x0000, 0xE85B, 0xEBD9, 0xEBDB, 0xEBDA, 0xEEC6, 
    0xC1DE, 0xF152, 0xF35F, 0xC3E7, 0xF151, 0xF4E4, 0xC4BF, 0xC548, 
    0xA8A8, 0xF6C9, 0xC4BB, 0xE072, 0xE460, 0xC2D9, 0xF144, 0xD3E5, 
    0xD7D9, 0xD7D6, 0xB36C, 0xEEBE, 0xDBF4, 0xDBFA, 0xB65C, 0xF760, 
    0xB659, 0xDBF6, 0xB65F, 0xB660, 0xE069, 0xC3DF, 0xC2DE, 0xE06E, 
    0xF75F, 0xC545, 0xB8F8, 0xE457, 0xE45B, 0xE840, 0xBDEF, 0xBDF3, 
    0xC5AE, 0xE7F7, 0xE7F4, 0xC5AD, 0x0000, 0xEBC0, 0xBFE5, 0xBFE6, 
    0xEBC4, 0xBFE2, 0xC1CE, 0xEBC5, 0xBFE4, 0xC65C, 0xC2DA, 0xC1D1, 
    0xF75D, 0xC3DD, 0xC3DA, 0xF353, 0xC3E0, 0xC4BD, 0xC66E, 0xF75E, 
    0xF761, 0xF970, 0xF8C3, 0xCBA4, 0xB649, 0xB8E7, 0xE05A, 0xF0F1, 
    0xEEB7, 0xB1D8, 0xD7C6, 0xC2D2, 0xDBD4, 0xE043, 0xDFFD, 0xE448, 
    0xF2F5, 0xB8E4, 0xF0E7, 0xE8B0, 0xB3B8, 0xC645, 0xB6B2, 0xBE5E, 
    0xC5B4, 0xE8AE, 0xC050, 0xC04B, 0xC3F9, 0xC647, 0xC4C5, 0xC5B5, 
    0xEFB5, 0xC4D4, 0xF5BE, 0xF5BB, 0xC568, 0xC569, 0xC5C5, 0xC5C6, 
    0xC653, 0xE0EF, 0xEFB1, 0xF965, 0xAB41, 0xD447, 0xB96D, 0xE0D5, 
    0xBBDC, 0xC2A3, 0xF841, 0xE4A9, 0xC671, 0xE874, 0xC3F5, 0xEEDE, 
    0xF36C, 0xEEDC, 0x0000, 0xF8CA, 0xBE7B, 0xE8DB, 0xF85B, 0x0000, 
    0x0000, 0xC674, 0xBF71, 0xEC7B, 0xC64D, 0xEC7C, 0xC244, 0xEF6A, 
    0xC243, 0xEF6C, 0xF95C, 0xC242, 0xF3D0, 0xF858, 0xF1C7, 0xF9CE, 
    0xC5BF, 0xF7AE, 0xF6AD, 0xF7B2, 0xC358, 0xC354, 0xF1C3, 0xC356, 
    0xC44A, 0xF3C7, 0xF3C8, 0xF3D6, 0xF3CB, 0xC449, 0x0000, 0xF3CD, 
    0xF3CE, 0xC44B, 0x0000, 0xF3CF, 0x0000, 0xF56B, 0xC673, 0xC4CF, 
    0xF56E, 0xF576, 0x0000, 0x0000, 0xF7B4, 0xC55F, 0xF6AE, 0xC560, 
    0xF6AF, 0xF7AF, 0xC5C0, 0xF7AB, 0xC5C1, 0x0000, 0x0000, 0xC5ED, 
    0xC5EB, 0xF857, 0xF8D7, 0xBBDE, 0xBBDF, 0xC5B6, 0x0000, 0xEC56, 
    0xC669, 0xF17C, 0xC2FD, 0x0000, 0x0000, 0xE4DA, 0xBBEB, 0xBE75, 
    0xF6BC, 0x0000, 0x0000, 0xC066, 0xC34E, 0xF1B9, 0xC55C, 0xF3C1, 
    0xC662, 0xF8D4, 0xC5EA, 0xBE79, 0xE8D9, 0xC64C, 0xC352, 0xEF69, 
    0xC353, 0xC55E, 0xC557, 0xC5E4, 0xC34B, 0xC5B9, 0xF776, 0xD449, 
    0xB9A6, 0xBBEC, 0xBE77, 0xE8D4, 0xC067, 0xC068, 0xEC70, 0xF1BB, 
    0x0000, 0xC64B, 0xF855, 0xC663, 0xBBF2, 0xBEA3, 0xEDDD, 0xB9A8, 
    0xECB1, 0xECAF, 0xC247, 0xC451, 0xC3EF, 0xC565, 0xC5EF, 0xC24C, 
    0xC24A, 0xC24B, 0xC35C, 0xF1E0, 0x0000, 0xC675, 0xF5B6, 0xF5B4, 
    0xF876, 0xC566, 0xEFB4, 0xC35E, 0xC4D3, 0xC5C4, 0xF87B, 0xECB8, 
    0xC24D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 
 }; 
    
#endif __GB2BIG_H
