# Contributors Guide

Please read and understand the contribution guide before creating an issue or pull request. We would like to thank [Nishad TR](https://github.com/nishad) for their contributor's guide, upon which we based ours.

## Etiquette

This project is open source, and as such, we (the maintainers) give our **free time** to build, maintain and **provide user support** for the CCExtractor program. We make the code freely available in the hope that it will be of use to other developers and users. It would be extremely unfair for us to suffer abuse or anger for our hard work.

Please be considerate towards the developers and other users when raising issues or presenting pull requests.

It's the duty of the maintainer to ensure that all submissions to the project are of sufficient quality to benefit the project. Many developers have different skillsets, strengths, and weaknesses. Respect the decision of the maintainers, and do not be upset or abusive if your submission is not used.

## Viability

When requesting or submitting new features, first consider whether it might be useful to others. Open source projects are used by many developers, who may have entirely different needs to your own. Think about whether or not your feature is likely to be used by other users of the project.

## Procedure

**Before filing an issue**:

- Attempt to replicate the problem, to ensure that it wasn't a coincidental incident.
- Check to make sure your feature suggestion isn't already present within the project.
- Check the pull requests tab to ensure that the bug doesn't have a fix in progress.
- Check the pull requests tab to ensure that the feature isn't already in progress.

**Before submitting a pull request**:

- Ensure that your submission is [viable](#viability) for the project.
- Check the codebase to ensure that your feature doesn't already exist.
- Check the pull requests to ensure that another person hasn't already submitted the feature or fix.

## Technical requirements

- Before Submitting your Pull Request, merge `master` with your new branch and fix any conflicts. (Make sure you don't break anything in development!)
- Commit Unix line endings.
- Make sure to reasonably test your code. We have a sample platform that runs a test-suite for you, but it only covers a general set of tests.
