/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef LISTARRAY_H
#define LISTARRAY_H

#include <vector>

void split_intstring(const char *intstr, int *first, int *last, int *inc);

template <typename T>
class ListArray
{
private:
  std::vector<T> array;
  int nalloc;
  int allinc;
  void ensureArraySize(int num);

public:
  ListArray();
  T *data();

  void setValue(int num, T value);
  T getValue(int num);
  int argvToInt(int argc, char **argv);
  int argvToFlt(int argc, char **argv);
};

#endif /* LISTARRAY_H */
