/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef PMLIST_H
#define PMLIST_H

#include <list>
#include <vector>
#include <string>
#include "listbuffer.h"

struct KeyValues
{
  int nvalues;
  std::string key;
  std::vector<std::string> values;
};

class KVList : public std::list<KeyValues>
{
public:
  std::string name;

  void print() const;
  int parseArguments(const int argc, const char **argv);
  const KeyValues *search(const std::string &key) const;
  void append(const char *, const char **, int);
};

class PMList : public std::list<KVList>
{
public:
  const KVList *searchKVListVentry(const std::string &key, const std::string &value, const std::vector<std::string> &entry);
  const KVList *getKVListVentry(const std::vector<std::string> &entry);
  void print();
  void readNamelist(FILE *fp, const char *name);
  void readCmortable(FILE *fp, const char *name);
};

#include "list.h"

typedef struct
{
  int nvalues;
  char *key;
  char **values;
} keyValues_t;

keyValues_t *kvlist_search(list_t *kvlist, const char *key);

void free_keyval(void *data);
void free_kvlist(void *data);

list_t *kvlist_new(const char *name);
void kvlist_destroy(list_t *list);
void kvlist_append(list_t *kvlist, const char *key, const char **values, int nvalues);

int parseListBuffer(PMList &pmlist, ListBuffer &listBuffer);

#endif
