/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef PSTREAM_H
#define PSTREAM_H

#ifdef HAVE_CONFIG_H
#include "config.h" /* _FILE_OFFSET_BITS influence off_t */
#endif

#include "varlist.h"
#include "pipe.h"
#include "cdoStream.h"

#include <sys/types.h> /* off_t */
#include <memory>
#include <vector>


class Pstream : public CdoStream
{
public:
  Pstream(int p_processID);
  Pstream(std::string p_filename);

  int openRead();
  int openWrite(int p_filetype);
  int openAppend();

  int inqVlist();
  void defVlist(int p_vlistID);

  void inqRecord(int *varID, int *levelID);
  void defRecord(int varID, int levelID);

  void readRecord(double *data, size_t *nmiss);
  void readRecord(float *data, size_t *nmiss);
  void writeRecord(double *data, size_t nmiss);
  void writeRecord(float *data, size_t nmiss);
  void copyRecord(CdoStreamID dest);

  int inqTimestep(int tsID);
  void defTimestep(int p_tsID);

  int inqFileType();
  int inqByteorder();

  void close();

  size_t getNvals();

  bool isPipe();
  void init();
  void waitForPipe();
  void closePipe();
  int getFileID();

  int m_mode;
  bool isopen;
  std::string m_name;
  std::vector<varlist_t> m_varlist;
#ifdef HAVE_LIBPTHREAD
  std::shared_ptr<pipe_t> pipe;
  pthread_t rthreadID; /* read  thread ID */
  pthread_t wthreadID; /* write thread ID */
#endif
private:
  int openReadPipe();
  void openReadFile();
  int openWritePipe(int filetype);
  int openWriteFile(int filetype);
  Pstream(){}
  ~Pstream() {};
};

CdoStreamID pstreamToPointer(int pstreamID);
void closeAllStreams();

void cdoVlistCopyFlag(int vlistID2, int vlistID1);

void setProcessNum(int p_num);

#endif /* PSTREAM_H */
