/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef VERTICAL_INTERP_H
#define VERTICAL_INTERP_H

#include <cstddef>

void height2pressure(double *phlev, const double *hlev, long nphlev);

template <typename T>
void presh(T *fullp, T *halfp, const double *vct, const T *ps, long nhlev, long ngp);

void extrapolate_P(double *slp, const double *halfp, const double *fullp, const double *geop, const double *temp, long ngp);

template <typename T>
void vertical_interp_T(const T *geop, const T *gt, T *pt, const T *fullp, const T *halfp, const int *nx,
                       const double *plev, long nplev, long ngp, long nhlev, double missval);

template <typename T>
void vertical_interp_Z(const T *geop, const T *gz, T *pz, const T *fullp, const T *halfp, const int *nx,
                       const T *gt, const double *plev, long nplev, long ngp, long nhlev, double missval);

template <typename T>
void vertical_interp_X(const T *gt, T *pt, const T *hyb_press, const int *nx, const double *plev,
                       long nplev, long ngp, long nhlev, double missval);

template <typename T>
void genind(int *nx, const double *plev, const T *fullp, long ngp, long nplev, long nhlev, bool lreverse = false);

template <typename T>
void genindmiss(int *nx, const double *plev, int ngp, int nplev, const T *ps_prog, size_t *pnmiss, bool lreverse = false);

#endif /* VERTICAL_INTERP_H */
