// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "MultiColumnList.pypp.hpp"

namespace bp = boost::python;

struct MultiColumnList_wrapper : CEGUI::MultiColumnList, bp::wrapper< CEGUI::MultiColumnList > {

    MultiColumnList_wrapper(::CEGUI::String const & type, ::CEGUI::String const & name )
    : CEGUI::MultiColumnList( boost::ref(type), boost::ref(name) )
      , bp::wrapper< CEGUI::MultiColumnList >(){
        // constructor
    
    }

    virtual void initialiseComponents(  ) {
        if( bp::override func_initialiseComponents = this->get_override( "initialiseComponents" ) )
            func_initialiseComponents(  );
        else{
            this->CEGUI::MultiColumnList::initialiseComponents(  );
        }
    }
    
    void default_initialiseComponents(  ) {
        CEGUI::MultiColumnList::initialiseComponents( );
    }

    virtual void beginInitialisation(  ) {
        if( bp::override func_beginInitialisation = this->get_override( "beginInitialisation" ) )
            func_beginInitialisation(  );
        else{
            this->CEGUI::Window::beginInitialisation(  );
        }
    }
    
    void default_beginInitialisation(  ) {
        CEGUI::Window::beginInitialisation( );
    }

    virtual void cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_cloneChildWidgetsTo = this->get_override( "cloneChildWidgetsTo" ) )
            func_cloneChildWidgetsTo( boost::ref(target) );
        else{
            this->CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
        }
    }
    
    void default_cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
    }

    virtual void clonePropertiesTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_clonePropertiesTo = this->get_override( "clonePropertiesTo" ) )
            func_clonePropertiesTo( boost::ref(target) );
        else{
            this->CEGUI::Window::clonePropertiesTo( boost::ref(target) );
        }
    }
    
    void default_clonePropertiesTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::clonePropertiesTo( boost::ref(target) );
    }

    virtual void destroy(  ) {
        if( bp::override func_destroy = this->get_override( "destroy" ) )
            func_destroy(  );
        else{
            this->CEGUI::Window::destroy(  );
        }
    }
    
    void default_destroy(  ) {
        CEGUI::Window::destroy( );
    }

    virtual void endInitialisation(  ) {
        if( bp::override func_endInitialisation = this->get_override( "endInitialisation" ) )
            func_endInitialisation(  );
        else{
            this->CEGUI::Window::endInitialisation(  );
        }
    }
    
    void default_endInitialisation(  ) {
        CEGUI::Window::endInitialisation( );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    virtual void getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        if( bp::override func_getRenderingContext_impl = this->get_override( "getRenderingContext_impl" ) )
            func_getRenderingContext_impl( boost::ref(ctx) );
        else{
            this->CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
        }
    }
    
    void default_getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
    }

    virtual ::CEGUI::Rect getUnclippedInnerRect_impl(  ) const  {
        if( bp::override func_getUnclippedInnerRect_impl = this->get_override( "getUnclippedInnerRect_impl" ) )
            return func_getUnclippedInnerRect_impl(  );
        else{
            return this->CEGUI::Window::getUnclippedInnerRect_impl(  );
        }
    }
    
    ::CEGUI::Rect default_getUnclippedInnerRect_impl(  ) const  {
        return CEGUI::Window::getUnclippedInnerRect_impl( );
    }

    virtual bool isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        if( bp::override func_isHit = this->get_override( "isHit" ) )
            return func_isHit( boost::ref(position), allow_disabled );
        else{
            return this->CEGUI::Window::isHit( boost::ref(position), allow_disabled );
        }
    }
    
    bool default_isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        return CEGUI::Window::isHit( boost::ref(position), allow_disabled );
    }

    virtual void performChildWindowLayout(  ) {
        if( bp::override func_performChildWindowLayout = this->get_override( "performChildWindowLayout" ) )
            func_performChildWindowLayout(  );
        else{
            this->CEGUI::Window::performChildWindowLayout(  );
        }
    }
    
    void default_performChildWindowLayout(  ) {
        CEGUI::Window::performChildWindowLayout( );
    }

    virtual void setLookNFeel( ::CEGUI::String const & look ) {
        if( bp::override func_setLookNFeel = this->get_override( "setLookNFeel" ) )
            func_setLookNFeel( boost::ref(look) );
        else{
            this->CEGUI::Window::setLookNFeel( boost::ref(look) );
        }
    }
    
    void default_setLookNFeel( ::CEGUI::String const & look ) {
        CEGUI::Window::setLookNFeel( boost::ref(look) );
    }

    virtual void setMargin( ::CEGUI::UBox const & margin ) {
        if( bp::override func_setMargin = this->get_override( "setMargin" ) )
            func_setMargin( boost::ref(margin) );
        else{
            this->CEGUI::Window::setMargin( boost::ref(margin) );
        }
    }
    
    void default_setMargin( ::CEGUI::UBox const & margin ) {
        CEGUI::Window::setMargin( boost::ref(margin) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

    virtual void update( float elapsed ) {
        if( bp::override func_update = this->get_override( "update" ) )
            func_update( elapsed );
        else{
            this->CEGUI::Window::update( elapsed );
        }
    }
    
    void default_update( float elapsed ) {
        CEGUI::Window::update( elapsed );
    }

    virtual void writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        if( bp::override func_writeXMLToStream = this->get_override( "writeXMLToStream" ) )
            func_writeXMLToStream( boost::ref(xml_stream) );
        else{
            this->CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
        }
    }
    
    void default_writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
    }

};

void register_MultiColumnList_class(){

    { //::CEGUI::MultiColumnList
        typedef bp::class_< MultiColumnList_wrapper, bp::bases< CEGUI::Window >, boost::noncopyable > MultiColumnList_exposer_t;
        MultiColumnList_exposer_t MultiColumnList_exposer = MultiColumnList_exposer_t( "MultiColumnList", "*!\n\
        \n\
           Base class for the multi column list widget.\n\
        *\n", bp::init< CEGUI::String const &, CEGUI::String const & >(( bp::arg("type"), bp::arg("name") ), "*************************************************************************\n\
           Construction and Destruction\n\
        *************************************************************************\n\
        *!\n\
        \n\
           Constructor for the Multi-column list base class\n\
        *\n") );
        bp::scope MultiColumnList_scope( MultiColumnList_exposer );
        bp::enum_< CEGUI::MultiColumnList::SelectionMode>("SelectionMode")
            .value("RowSingle", CEGUI::MultiColumnList::RowSingle)
            .value("RowMultiple", CEGUI::MultiColumnList::RowMultiple)
            .value("CellSingle", CEGUI::MultiColumnList::CellSingle)
            .value("CellMultiple", CEGUI::MultiColumnList::CellMultiple)
            .value("NominatedColumnSingle", CEGUI::MultiColumnList::NominatedColumnSingle)
            .value("NominatedColumnMultiple", CEGUI::MultiColumnList::NominatedColumnMultiple)
            .value("ColumnSingle", CEGUI::MultiColumnList::ColumnSingle)
            .value("ColumnMultiple", CEGUI::MultiColumnList::ColumnMultiple)
            .value("NominatedRowSingle", CEGUI::MultiColumnList::NominatedRowSingle)
            .value("NominatedRowMultiple", CEGUI::MultiColumnList::NominatedRowMultiple)
            .export_values()
            ;
        { //::CEGUI::MultiColumnList::addColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*addColumn_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::UDim const & ) ;
            
            MultiColumnList_exposer.def( 
                "addColumn"
                , addColumn_function_type( &::CEGUI::MultiColumnList::addColumn )
                , ( bp::arg("text"), bp::arg("col_id"), bp::arg("width") )
                , "*!\n\
               \n\
                  Add a column to the list box.\n\
            \n\
               @param text\n\
                  String object containing the text label for the column header.\n\
            \n\
               @param col_id\n\
                  ID code to be assigned to the column header.\n\
            \n\
               @param width\n\
                  UDim describing the initial width to be set for the column.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::addRow
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*addRow_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "addRow"
                , addRow_function_type( &::CEGUI::MultiColumnList::addRow )
                , ( bp::arg("row_id")=(::CEGUI::uint)(0) )
                , "*!\n\
               \n\
                  Add an empty row to the list box.\n\
            \n\
               @param row_id\n\
                  ID code to be assigned to the new row.\n\
            \n\
               \note\n\
                  If the list is being sorted, the new row will appear at an appropriate position according to\
                  the sorting being\n\
                  applied.  If no sorting is being done, the new row will appear at the bottom of the list.\n\
            \n\
               @return\n\
                  Initial zero based index of the new row.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::addRow
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*addRow_function_type )( ::CEGUI::ListboxItem *,::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "addRow"
                , addRow_function_type( &::CEGUI::MultiColumnList::addRow )
                , ( bp::arg("item"), bp::arg("col_id"), bp::arg("row_id")=(::CEGUI::uint)(0) )
                , "*!\n\
               \n\
                  Add a row to the list box, and set the item in the column with ID  col_id to  item.\n\
            \n\
               \note\n\
                  If the list is being sorted, the new row will appear at an appropriate position according to\
                  the sorting being\n\
                  applied.  If no sorting is being done, the new row will appear at the bottom of the list.\n\
            \n\
               @param item\n\
                  Pointer to a ListboxItem to be used as the initial contents for the column with ID  col_id.\n\
            \n\
               @param col_id\n\
                  ID code of the column whos initial item is to be set to  item.\n\
            \n\
               @param row_id\n\
                  ID code to be assigned to the new row.\n\
            \n\
               @return\n\
                  Initial zero based index of the new row.\n\
            \n\
               @exception InvalidRequestException  thrown if no column with the specified ID is attached to the\
               list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::autoSizeColumnHeader
        
            typedef void ( ::CEGUI::MultiColumnList::*autoSizeColumnHeader_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "autoSizeColumnHeader"
                , autoSizeColumnHeader_function_type( &::CEGUI::MultiColumnList::autoSizeColumnHeader )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Automatically determines the best fit size for the specified column and sets\n\
                  the column width to the same.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column to be sized.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::clearAllSelections
        
            typedef void ( ::CEGUI::MultiColumnList::*clearAllSelections_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "clearAllSelections"
                , clearAllSelections_function_type( &::CEGUI::MultiColumnList::clearAllSelections )
                , "*!\n\
               \n\
                  Removed the selected state from any currently selected ListboxItem attached to the list.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::findColumnItemWithText
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*findColumnItemWithText_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "findColumnItemWithText"
                , findColumnItemWithText_function_type( &::CEGUI::MultiColumnList::findColumnItemWithText )
                , ( bp::arg("text"), bp::arg("col_idx"), bp::arg("start_item") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListboxItem in column  col_idx that has the text string  text.\n\
            \n\
               @param text\n\
                  String object containing the text to be searched for.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column to be searched.\n\
            \n\
               @param start_item\n\
                  Pointer to the ListboxItem where the exclusive search is to start, or NULL to search from the\
                  top of the column.\n\
            \n\
               @return\n\
                  Pointer to the first ListboxItem in column  col_idx, after  start_item, that has the string\
                  text.\n\
            \n\
               @exception InvalidRequestException  thrown if  start_item is not attached to the list box, or if\
               col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::findListItemWithText
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*findListItemWithText_function_type )( ::CEGUI::String const &,::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "findListItemWithText"
                , findListItemWithText_function_type( &::CEGUI::MultiColumnList::findListItemWithText )
                , ( bp::arg("text"), bp::arg("start_item") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListboxItem that has the text string  text.\n\
            \n\
               \note\n\
                  List box searching progresses across the columns in each row.\n\
            \n\
               @param text\n\
                  String object containing the text to be searched for.\n\
            \n\
               @param start_item\n\
                  Pointer to the ListboxItem where the exclusive search is to start, or NULL to search the whole\
                  list box.\n\
            \n\
               @return\n\
                  Pointer to the first ListboxItem, after  start_item, that has the string  text.\n\
            \n\
               @exception InvalidRequestException  thrown if  start_item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::findRowItemWithText
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*findRowItemWithText_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "findRowItemWithText"
                , findRowItemWithText_function_type( &::CEGUI::MultiColumnList::findRowItemWithText )
                , ( bp::arg("text"), bp::arg("row_idx"), bp::arg("start_item") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListboxItem in row  row_idx that has the text string  text.\n\
            \n\
               @param text\n\
                  String object containing the text to be searched for.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row to be searched.\n\
            \n\
               @param start_item\n\
                  Pointer to the ListboxItem where the exclusive search is to start, or NULL to search from the\
                  start of the row.\n\
            \n\
               @return\n\
                  Pointer to the first ListboxItem in row  row_idx, after  start_item, that has the string\
                  text.\n\
            \n\
               @exception InvalidRequestException  thrown if  start_item is not attached to the list box, or if\
               row_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getColumnCount
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getColumnCount_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getColumnCount"
                , getColumnCount_function_type( &::CEGUI::MultiColumnList::getColumnCount )
                , "*!\n\
               \n\
                  Return the number of columns in the multi-column list\n\
            \n\
               @return\n\
                  uint value equal to the number of columns in the list.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getColumnHeaderWidth
        
            typedef ::CEGUI::UDim ( ::CEGUI::MultiColumnList::*getColumnHeaderWidth_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getColumnHeaderWidth"
                , getColumnHeaderWidth_function_type( &::CEGUI::MultiColumnList::getColumnHeaderWidth )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Return the width of the specified column header (and therefore the column itself).\n\
            \n\
               @param col_idx\n\
                  Zero based column index of the column whos width is to be returned.\n\
            \n\
               @return\n\
                  Width of the column header at the zero based column index specified by  col_idx, as a UDim\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getColumnID
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getColumnID_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getColumnID"
                , getColumnID_function_type( &::CEGUI::MultiColumnList::getColumnID )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Return the ID code assigned to the requested column.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column whos ID code is to be returned.\n\
            \n\
               @return\n\
                  Current ID code assigned to the column at the requested index.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is out of range\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getColumnWithHeaderText
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getColumnWithHeaderText_function_type )( ::CEGUI::String const & ) const;
            
            MultiColumnList_exposer.def( 
                "getColumnWithHeaderText"
                , getColumnWithHeaderText_function_type( &::CEGUI::MultiColumnList::getColumnWithHeaderText )
                , ( bp::arg("text") )
                , "*!\n\
               \n\
                  Return the zero based index of the column whos header text matches the specified text.\n\
            \n\
               @param text\n\
                  String object containing the text to be searched for.\n\
            \n\
               @return\n\
                  Zero based column index of the column whos header has the specified text.\n\
            \n\
               @exception InvalidRequestException  thrown if no columns header has the requested text.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getColumnWithID
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getColumnWithID_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getColumnWithID"
                , getColumnWithID_function_type( &::CEGUI::MultiColumnList::getColumnWithID )
                , ( bp::arg("col_id") )
                , "*!\n\
               \n\
                  Return the zero based column index of the column with the specified ID.\n\
            \n\
               @param col_id\n\
                  ID code of the column whos index is to be returned.\n\
            \n\
               @return\n\
                  Zero based column index of the first column whos ID matches  col_id.\n\
            \n\
               @exception  InvalidRequestException    thrown if no attached column has the requested ID.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getFirstSelectedItem
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*getFirstSelectedItem_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getFirstSelectedItem"
                , getFirstSelectedItem_function_type( &::CEGUI::MultiColumnList::getFirstSelectedItem )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the first selected ListboxItem attached to this list box.\n\
            \n\
               \note\n\
                  List box searching progresses across the columns in each row.\n\
            \n\
               @return\n\
                  Pointer to the first ListboxItem attached to this list box that is selected, or NULL if no\
                  item is selected.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getHeaderSegmentForColumn
        
            typedef ::CEGUI::ListHeaderSegment & ( ::CEGUI::MultiColumnList::*getHeaderSegmentForColumn_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getHeaderSegmentForColumn"
                , getHeaderSegmentForColumn_function_type( &::CEGUI::MultiColumnList::getHeaderSegmentForColumn )
                , ( bp::arg("col_idx") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListHeaderSegment object for the specified column\n\
            \n\
               @param col_idx\n\
                  zero based index of the column whos ListHeaderSegment is to be returned.\n\
            \n\
               @return\n\
                  ListHeaderSegment object for the column at the requested index.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getHighestRowItemHeight
        
            typedef float ( ::CEGUI::MultiColumnList::*getHighestRowItemHeight_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getHighestRowItemHeight"
                , getHighestRowItemHeight_function_type( &::CEGUI::MultiColumnList::getHighestRowItemHeight )
                , ( bp::arg("row_idx") )
                , "*!\n\
            \n\
                Return, in pixels, the height of the highest item in the given row.\n\
            *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getHorzScrollbar
        
            typedef ::CEGUI::Scrollbar * ( ::CEGUI::MultiColumnList::*getHorzScrollbar_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getHorzScrollbar"
                , getHorzScrollbar_function_type( &::CEGUI::MultiColumnList::getHorzScrollbar )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the horizontal scrollbar component widget for this\n\
                    MultiColumnList.\n\
            \n\
                @return\n\
                    Pointer to a Scrollbar object.\n\
            \n\
                @exception UnknownObjectException\n\
                    Thrown if the horizontal Scrollbar component does not exist.\n\
                *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getItemAtGridReference
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*getItemAtGridReference_function_type )( ::CEGUI::MCLGridRef const & ) const;
            
            MultiColumnList_exposer.def( 
                "getItemAtGridReference"
                , getItemAtGridReference_function_type( &::CEGUI::MultiColumnList::getItemAtGridReference )
                , ( bp::arg("grid_ref") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the ListboxItem at the specified grid reference.\n\
            \n\
               @param grid_ref\n\
                  MCLGridRef object that describes the position of the ListboxItem to be returned.\n\
            \n\
               @return\n\
                  Pointer to the ListboxItem at grid reference  grid_ref.\n\
            \n\
               @exception InvalidRequestException  thrown if  grid_ref is invalid for this list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getItemColumnIndex
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getItemColumnIndex_function_type )( ::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "getItemColumnIndex"
                , getItemColumnIndex_function_type( &::CEGUI::MultiColumnList::getItemColumnIndex )
                , ( bp::arg("item") )
                , "*!\n\
               \n\
                  Return the current zero based index of the column that contains  item.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem that the column index is to returned for.\n\
            \n\
               @return\n\
                  Zero based index of the column that contains ListboxItem  item.\n\
            \n\
               @exception InvalidRequestException  thrown if  item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getItemGridReference
        
            typedef ::CEGUI::MCLGridRef ( ::CEGUI::MultiColumnList::*getItemGridReference_function_type )( ::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "getItemGridReference"
                , getItemGridReference_function_type( &::CEGUI::MultiColumnList::getItemGridReference )
                , ( bp::arg("item") )
                , "*!\n\
               \n\
                  Return the grid reference for  item.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem whos current grid reference is to be returned.\n\
            \n\
               @return\n\
                  MCLGridRef object describing the current grid reference of ListboxItem  item.\n\
            \n\
               @exception InvalidRequestException  thrown if  item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getItemRowIndex
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getItemRowIndex_function_type )( ::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "getItemRowIndex"
                , getItemRowIndex_function_type( &::CEGUI::MultiColumnList::getItemRowIndex )
                , ( bp::arg("item") )
                , "*!\n\
               \n\
                  Return the zero based index of the Row that contains  item.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem that the row index is to returned for.\n\
            \n\
               @return\n\
                  Zero based index of the row that contains ListboxItem  item.\n\
            \n\
               @exception InvalidRequestException  thrown if  item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getListHeader
        
            typedef ::CEGUI::ListHeader * ( ::CEGUI::MultiColumnList::*getListHeader_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getListHeader"
                , getListHeader_function_type( &::CEGUI::MultiColumnList::getListHeader )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the list header component widget for this\n\
                    MultiColumnList.\n\
            \n\
                @return\n\
                    Pointer to a ListHeader object.\n\
            \n\
                @exception UnknownObjectException\n\
                    Thrown if the list header component does not exist.\n\
                *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getListRenderArea
        
            typedef ::CEGUI::Rect ( ::CEGUI::MultiColumnList::*getListRenderArea_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getListRenderArea"
                , getListRenderArea_function_type( &::CEGUI::MultiColumnList::getListRenderArea )
                , "*!\n\
                \n\
                    Return a Rect object describing, in un-clipped pixels, the window relative area\n\
                    that is to be used for rendering list items.\n\
            \n\
                @return\n\
                    Rect object describing the area of the Window to be used for rendering\n\
                    list box items.\n\
                *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getNextSelected
        
            typedef ::CEGUI::ListboxItem * ( ::CEGUI::MultiColumnList::*getNextSelected_function_type )( ::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "getNextSelected"
                , getNextSelected_function_type( &::CEGUI::MultiColumnList::getNextSelected )
                , ( bp::arg("start_item") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the next selected ListboxItem after  start_item.\n\
            \n\
               \note\n\
                  List box searching progresses across the columns in each row.\n\
            \n\
               @param start_item\n\
                  Pointer to the ListboxItem where the exclusive search is to start, or NULL to search the whole\
                  list box.\n\
            \n\
               @return\n\
                  Pointer to the first selected ListboxItem attached to this list box, after  start_item, or\
                  NULL if no item is selected.\n\
            \n\
               @exception InvalidRequestException  thrown if  start_item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getNominatedSelectionColumn
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getNominatedSelectionColumn_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getNominatedSelectionColumn"
                , getNominatedSelectionColumn_function_type( &::CEGUI::MultiColumnList::getNominatedSelectionColumn )
                , "*!\n\
               \n\
                  Return the index of the currently set nominated selection column to be used when in one of the\
                  NominatedColumn*\n\
                  selection modes.\n\
            \n\
               @return\n\
                  Zero based index of the nominated selection column.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getNominatedSelectionColumnID
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getNominatedSelectionColumnID_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getNominatedSelectionColumnID"
                , getNominatedSelectionColumnID_function_type( &::CEGUI::MultiColumnList::getNominatedSelectionColumnID )
                , "*!\n\
               \n\
                  Return the ID of the currently set nominated selection column to be used when in one of the\
                  NominatedColumn*\n\
                  selection modes. There must be at least one column to successfully call this method.\n\
            \n\
               \note\n\
                  You should only ever call this when getColumnCount() returns > 0.\n\
            \n\
               @return\n\
                  ID code of the nominated selection column.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getNominatedSelectionRow
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getNominatedSelectionRow_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getNominatedSelectionRow"
                , getNominatedSelectionRow_function_type( &::CEGUI::MultiColumnList::getNominatedSelectionRow )
                , "*!\n\
               \n\
                  Return the index of the currently set nominated selection row to be used when in one of the\
                  NominatedRow*\n\
                  selection modes.\n\
            \n\
               @return\n\
                  Zero based index of the nominated selection column.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getRowCount
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getRowCount_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getRowCount"
                , getRowCount_function_type( &::CEGUI::MultiColumnList::getRowCount )
                , "*!\n\
               \n\
                  Return the number of rows in the multi-column list.\n\
            \n\
               @return\n\
                  uint value equal to the number of rows currently in the list.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getRowID
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getRowID_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getRowID"
                , getRowID_function_type( &::CEGUI::MultiColumnList::getRowID )
                , ( bp::arg("row_idx") )
                , "*!\n\
               \n\
                  Return the ID code assigned to the requested row.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row who's ID code is to be returned.\n\
            \n\
               @return\n\
                  Current ID code assigned to the row at the requested index.\n\
            \n\
               @exception InvalidRequestException  thrown if  row_idx is out of range\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getRowWithID
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getRowWithID_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getRowWithID"
                , getRowWithID_function_type( &::CEGUI::MultiColumnList::getRowWithID )
                , ( bp::arg("row_id") )
                , "*!\n\
               \n\
                  Return the zero based row index of the row with the specified ID.\n\
            \n\
               @param row_id\n\
                  ID code of the row who's index is to be returned.\n\
            \n\
               @return\n\
                  Zero based row index of the first row who's ID matches  row_id.\n\
            \n\
               @exception  InvalidRequestException    thrown if no row has the requested ID.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getSelectedCount
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getSelectedCount_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getSelectedCount"
                , getSelectedCount_function_type( &::CEGUI::MultiColumnList::getSelectedCount )
                , "*!\n\
               \n\
                  Return the number of selected ListboxItems attached to this list box.\n\
            \n\
               return\n\
                  uint value equal to the number of ListboxItems attached to this list box that are currently\
                  selected.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getSelectionMode
        
            typedef ::CEGUI::MultiColumnList::SelectionMode ( ::CEGUI::MultiColumnList::*getSelectionMode_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getSelectionMode"
                , getSelectionMode_function_type( &::CEGUI::MultiColumnList::getSelectionMode )
                , "*!\n\
               \n\
                  Return the currently set selection mode.\n\
            \n\
               @return\n\
                  One of the MultiColumnList.SelectionMode enumerated values specifying the current selection\
                  mode.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getSortColumn
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*getSortColumn_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getSortColumn"
                , getSortColumn_function_type( &::CEGUI::MultiColumnList::getSortColumn )
                , "*!\n\
               \n\
                  Return the zero based index of the current sort column.  There must be at least one column to\
                  successfully call this\n\
                  method.\n\
            \n\
               @return\n\
                  Zero based column index that is the current sort column.\n\
            \n\
               @exception  InvalidRequestException    thrown if there are no columns in this multi column\
               list.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getSortDirection
        
            typedef ::CEGUI::ListHeaderSegment::SortDirection ( ::CEGUI::MultiColumnList::*getSortDirection_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getSortDirection"
                , getSortDirection_function_type( &::CEGUI::MultiColumnList::getSortDirection )
                , "*!\n\
               \n\
                  Return the currently set sort direction.\n\
            \n\
               @return\n\
                  One of the ListHeaderSegment.SortDirection enumerated values specifying the current sort\
                  direction.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getTotalColumnHeadersWidth
        
            typedef ::CEGUI::UDim ( ::CEGUI::MultiColumnList::*getTotalColumnHeadersWidth_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getTotalColumnHeadersWidth"
                , getTotalColumnHeadersWidth_function_type( &::CEGUI::MultiColumnList::getTotalColumnHeadersWidth )
                , "*!\n\
               \n\
                  Return the total width of all column headers.\n\
            \n\
               @return\n\
                  Sum total of all the column header widths as a UDim.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getTotalRowsHeight
        
            typedef float ( ::CEGUI::MultiColumnList::*getTotalRowsHeight_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getTotalRowsHeight"
                , getTotalRowsHeight_function_type( &::CEGUI::MultiColumnList::getTotalRowsHeight )
                , "*!\n\
            \n\
                Return the sum of all row heights in pixels.\n\
            *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getVertScrollbar
        
            typedef ::CEGUI::Scrollbar * ( ::CEGUI::MultiColumnList::*getVertScrollbar_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getVertScrollbar"
                , getVertScrollbar_function_type( &::CEGUI::MultiColumnList::getVertScrollbar )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the vertical scrollbar component widget for this\n\
                    MultiColumnList.\n\
            \n\
                @return\n\
                    Pointer to a Scrollbar object.\n\
            \n\
                @exception UnknownObjectException\n\
                    Thrown if the vertical Scrollbar component does not exist.\n\
                *\n" );
        
        }
        { //::CEGUI::MultiColumnList::getWidestColumnItemWidth
        
            typedef float ( ::CEGUI::MultiColumnList::*getWidestColumnItemWidth_function_type )( ::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "getWidestColumnItemWidth"
                , getWidestColumnItemWidth_function_type( &::CEGUI::MultiColumnList::getWidestColumnItemWidth )
                , ( bp::arg("col_idx") )
                , "*!\n\
            \n\
                Return the pixel width of the widest item in the given column\n\
            *\n" );
        
        }
        { //::CEGUI::MultiColumnList::handleUpdatedItemData
        
            typedef void ( ::CEGUI::MultiColumnList::*handleUpdatedItemData_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "handleUpdatedItemData"
                , handleUpdatedItemData_function_type( &::CEGUI::MultiColumnList::handleUpdatedItemData )
                , "*!\n\
               \n\
                  Inform the list box that one or more attached ListboxItems have been externally modified,\
                  and\n\
                  the list should re-sync its internal state and refresh the display as needed.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::initialiseComponents
        
            typedef void ( ::CEGUI::MultiColumnList::*initialiseComponents_function_type )(  ) ;
            typedef void ( MultiColumnList_wrapper::*default_initialiseComponents_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "initialiseComponents"
                , initialiseComponents_function_type(&::CEGUI::MultiColumnList::initialiseComponents)
                , default_initialiseComponents_function_type(&MultiColumnList_wrapper::default_initialiseComponents) );
        
        }
        { //::CEGUI::MultiColumnList::insertColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*insertColumn_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::UDim const &,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "insertColumn"
                , insertColumn_function_type( &::CEGUI::MultiColumnList::insertColumn )
                , ( bp::arg("text"), bp::arg("col_id"), bp::arg("width"), bp::arg("position") )
                , "*!\n\
               \n\
                  Insert a new column in the list.\n\
            \n\
               @param text\n\
                  String object containing the text label for the column header.\n\
            \n\
               @param col_id\n\
                  ID code to be assigned to the column header.\n\
            \n\
               @param width\n\
                  UDim describing the initial width to be set for the column.\n\
            \n\
               @param position\n\
                  Zero based index where the column is to be inserted.  If this is greater than the current\n\
                  number of columns, the new column is inserted at the end.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::insertRow
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*insertRow_function_type )( ::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "insertRow"
                , insertRow_function_type( &::CEGUI::MultiColumnList::insertRow )
                , ( bp::arg("row_idx"), bp::arg("row_id")=(::CEGUI::uint)(0) )
                , "*!\n\
               \n\
                  Insert an empty row into the list box.\n\
            \n\
               \note\n\
                  If the list is being sorted, the new row will appear at an appropriate position according to\
                  the sorting being\n\
                  applied.  If no sorting is being done, the new row will appear at the specified index.\n\
            \n\
               @param row_idx\n\
                  Zero based index where the row should be inserted.  If this is greater than the current number\
                  of rows, the row is\n\
                  appended to the list.\n\
            \n\
               @param row_id\n\
                  ID code to be assigned to the new row.\n\
            \n\
               @return\n\
                  Zero based index where the row was actually inserted.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::insertRow
        
            typedef ::CEGUI::uint ( ::CEGUI::MultiColumnList::*insertRow_function_type )( ::CEGUI::ListboxItem *,::CEGUI::uint,::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "insertRow"
                , insertRow_function_type( &::CEGUI::MultiColumnList::insertRow )
                , ( bp::arg("item"), bp::arg("col_id"), bp::arg("row_idx"), bp::arg("row_id")=(::CEGUI::uint)(0) )
                , "*!\n\
               \n\
                  Insert a row into the list box, and set the item in the column with ID  col_id to  item.\n\
            \n\
               \note\n\
                  If the list is being sorted, the new row will appear at an appropriate position according to\
                  the sorting being\n\
                  applied.  If no sorting is being done, the new row will appear at the specified index.\n\
            \n\
               @param item\n\
                  Pointer to a ListboxItem to be used as the initial contents for the column with ID  col_id.\n\
            \n\
               @param col_id\n\
                  ID code of the column whos initial item is to be set to  item.\n\
            \n\
               @param row_idx\n\
                  Zero based index where the row should be inserted.  If this is greater than the current number\
                  of rows, the row is\n\
                  appended to the list.\n\
            \n\
               @param row_id\n\
                  ID code to be assigned to the new row.\n\
            \n\
               @return\n\
                  Zero based index where the row was actually inserted.\n\
            \n\
               @exception InvalidRequestException  thrown if no column with the specified ID is attached to the\
               list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isHorzScrollbarAlwaysShown
        
            typedef bool ( ::CEGUI::MultiColumnList::*isHorzScrollbarAlwaysShown_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "isHorzScrollbarAlwaysShown"
                , isHorzScrollbarAlwaysShown_function_type( &::CEGUI::MultiColumnList::isHorzScrollbarAlwaysShown )
                , "*!\n\
               \n\
                  Return whether the horizontal scroll bar is always shown.\n\
            \n\
               @return\n\
                  - true if the scroll bar will always be shown even if it is not required.\n\
                  - false if the scroll bar will only be shown when it is required.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isItemSelected
        
            typedef bool ( ::CEGUI::MultiColumnList::*isItemSelected_function_type )( ::CEGUI::MCLGridRef const & ) const;
            
            MultiColumnList_exposer.def( 
                "isItemSelected"
                , isItemSelected_function_type( &::CEGUI::MultiColumnList::isItemSelected )
                , ( bp::arg("grid_ref") )
                , "*!\n\
               \n\
                  Return whether the ListboxItem at  grid_ref is selected.\n\
            \n\
               @param grid_ref\n\
                  MCLGridRef object describing the grid reference that is to be examined.\n\
            \n\
               @return\n\
                  - true if there is a ListboxItem at  grid_ref and it is selected.\n\
                  - false if there is no ListboxItem at  grid_ref, or if the item is not selected.\n\
            \n\
               @exception InvalidRequestException  thrown if  grid_ref contains an invalid grid position.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isListboxItemInColumn
        
            typedef bool ( ::CEGUI::MultiColumnList::*isListboxItemInColumn_function_type )( ::CEGUI::ListboxItem const *,::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "isListboxItemInColumn"
                , isListboxItemInColumn_function_type( &::CEGUI::MultiColumnList::isListboxItemInColumn )
                , ( bp::arg("item"), bp::arg("col_idx") )
                , "*!\n\
               \n\
                  return whether ListboxItem  item is attached to the column at index  col_idx.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem to look for.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column that is to be searched.\n\
            \n\
               @return\n\
                  - true if  item is attached to list box column  col_idx.\n\
                  - false if  item is not attached to list box column  col_idx.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isListboxItemInList
        
            typedef bool ( ::CEGUI::MultiColumnList::*isListboxItemInList_function_type )( ::CEGUI::ListboxItem const * ) const;
            
            MultiColumnList_exposer.def( 
                "isListboxItemInList"
                , isListboxItemInList_function_type( &::CEGUI::MultiColumnList::isListboxItemInList )
                , ( bp::arg("item") )
                , "*!\n\
               \n\
                  return whether ListboxItem  item is attached to the list box.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem to look for.\n\
            \n\
               @return\n\
                  - true if  item is attached to list box.\n\
                  - false if  item is not attached to list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isListboxItemInRow
        
            typedef bool ( ::CEGUI::MultiColumnList::*isListboxItemInRow_function_type )( ::CEGUI::ListboxItem const *,::CEGUI::uint ) const;
            
            MultiColumnList_exposer.def( 
                "isListboxItemInRow"
                , isListboxItemInRow_function_type( &::CEGUI::MultiColumnList::isListboxItemInRow )
                , ( bp::arg("item"), bp::arg("row_idx") )
                , "*!\n\
               \n\
                  return whether ListboxItem  item is attached to the row at index  row_idx.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem to look for.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row that is to be searched.\n\
            \n\
               @return\n\
                  - true if  item is attached to list box row  row_idx.\n\
                  - false if  item is not attached to list box row  row_idx.\n\
            \n\
               @exception InvalidRequestException  thrown if  row_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isUserColumnDraggingEnabled
        
            typedef bool ( ::CEGUI::MultiColumnList::*isUserColumnDraggingEnabled_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "isUserColumnDraggingEnabled"
                , isUserColumnDraggingEnabled_function_type( &::CEGUI::MultiColumnList::isUserColumnDraggingEnabled )
                , "*!\n\
               \n\
                  Return whether the user may modify the order of the columns.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the order of the columns, false if they may not.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isUserColumnSizingEnabled
        
            typedef bool ( ::CEGUI::MultiColumnList::*isUserColumnSizingEnabled_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "isUserColumnSizingEnabled"
                , isUserColumnSizingEnabled_function_type( &::CEGUI::MultiColumnList::isUserColumnSizingEnabled )
                , "*!\n\
               \n\
                  Return whether the user may size column segments.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the width of columns, false if they may not.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isUserSortControlEnabled
        
            typedef bool ( ::CEGUI::MultiColumnList::*isUserSortControlEnabled_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "isUserSortControlEnabled"
                , isUserSortControlEnabled_function_type( &::CEGUI::MultiColumnList::isUserSortControlEnabled )
                , "*************************************************************************\n\
                  Accessor Methods\n\
               *************************************************************************\n\
               *!\n\
               \n\
                  Return whether user manipulation of the sort column and direction are enabled.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the sort column and direction.  false if the user\
                  may not\n\
                  modify the sort column and direction (these can still be set programmatically).\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::isVertScrollbarAlwaysShown
        
            typedef bool ( ::CEGUI::MultiColumnList::*isVertScrollbarAlwaysShown_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "isVertScrollbarAlwaysShown"
                , isVertScrollbarAlwaysShown_function_type( &::CEGUI::MultiColumnList::isVertScrollbarAlwaysShown )
                , "*!\n\
               \n\
                  Return whether the vertical scroll bar is always shown.\n\
            \n\
               @return\n\
                  - true if the scroll bar will always be shown even if it is not required.\n\
                  - false if the scroll bar will only be shown when it is required.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::moveColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*moveColumn_function_type )( ::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "moveColumn"
                , moveColumn_function_type( &::CEGUI::MultiColumnList::moveColumn )
                , ( bp::arg("col_idx"), bp::arg("position") )
                , "*!\n\
               \n\
                  Move the column at index  col_idx so it is at index  position.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column to be moved.\n\
            \n\
               @param position\n\
                  Zero based index of the new position for the column.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is invalid.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::moveColumnWithID
        
            typedef void ( ::CEGUI::MultiColumnList::*moveColumnWithID_function_type )( ::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "moveColumnWithID"
                , moveColumnWithID_function_type( &::CEGUI::MultiColumnList::moveColumnWithID )
                , ( bp::arg("col_id"), bp::arg("position") )
                , "*!\n\
               \n\
                  Move the column with ID  col_id so it is at index  position.\n\
            \n\
               @param col_id\n\
                  ID code of the column to be moved.\n\
            \n\
               @param position\n\
                  Zero based index of the new position for the column.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if no column with  col_id is available on this list\
               box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::removeColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*removeColumn_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "removeColumn"
                , removeColumn_function_type( &::CEGUI::MultiColumnList::removeColumn )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Removes a column from the list box.  This will cause any ListboxItem using the autoDelete\
                  option in the column to be deleted.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column to be removed.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is invalid.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::removeColumnWithID
        
            typedef void ( ::CEGUI::MultiColumnList::*removeColumnWithID_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "removeColumnWithID"
                , removeColumnWithID_function_type( &::CEGUI::MultiColumnList::removeColumnWithID )
                , ( bp::arg("col_id") )
                , "*!\n\
               \n\
                  Removes a column from the list box.  This will cause any ListboxItem using the autoDelete\
                  option in the column to be deleted.\n\
            \n\
               @param col_id\n\
                  ID code of the column to be deleted.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if no column with  col_id is available on this list\
               box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::removeRow
        
            typedef void ( ::CEGUI::MultiColumnList::*removeRow_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "removeRow"
                , removeRow_function_type( &::CEGUI::MultiColumnList::removeRow )
                , ( bp::arg("row_idx") )
                , "*!\n\
               \n\
                  Remove the list box row with index  row_idx.  Any ListboxItem in row  row_idx using autoDelete\
                  mode will be deleted.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row to be removed.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  row_idx is invalid.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::resetList
        
            typedef void ( ::CEGUI::MultiColumnList::*resetList_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "resetList"
                , resetList_function_type( &::CEGUI::MultiColumnList::resetList )
                , "*!\n\
               \n\
                  Remove all items from the list.\n\
            \n\
                  Note that this will cause 'AutoDelete' items to be deleted.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setColumnHeaderWidth
        
            typedef void ( ::CEGUI::MultiColumnList::*setColumnHeaderWidth_function_type )( ::CEGUI::uint,::CEGUI::UDim const & ) ;
            
            MultiColumnList_exposer.def( 
                "setColumnHeaderWidth"
                , setColumnHeaderWidth_function_type( &::CEGUI::MultiColumnList::setColumnHeaderWidth )
                , ( bp::arg("col_idx"), bp::arg("width") )
                , "*!\n\
               \n\
                  Set the width of the specified column header (and therefore the column itself).\n\
            \n\
               @param col_idx\n\
                  Zero based column index of the column whos width is to be set.\n\
            \n\
               @param width\n\
                  UDim value specifying the new width for the column.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setItem
        
            typedef void ( ::CEGUI::MultiColumnList::*setItem_function_type )( ::CEGUI::ListboxItem *,::CEGUI::MCLGridRef const & ) ;
            
            MultiColumnList_exposer.def( 
                "setItem"
                , setItem_function_type( &::CEGUI::MultiColumnList::setItem )
                , ( bp::arg("item"), bp::arg("position") )
                , "*!\n\
               \n\
                  Set the ListboxItem for grid reference  position.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem to be set at  position.\n\
            \n\
               @param position\n\
                  MCLGridRef describing the grid reference of the item to be set.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  position contains an invalid grid reference.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setItem
        
            typedef void ( ::CEGUI::MultiColumnList::*setItem_function_type )( ::CEGUI::ListboxItem *,::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setItem"
                , setItem_function_type( &::CEGUI::MultiColumnList::setItem )
                , ( bp::arg("item"), bp::arg("col_id"), bp::arg("row_idx") )
                , "*!\n\
               \n\
                  Set the ListboxItem for the column with ID  col_id in row  row_idx.\n\
            \n\
               @param item\n\
                  Pointer to the ListboxItem to be set into the list.\n\
            \n\
               @param col_id\n\
                  ID code of the column to receive  item.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row to receive  item.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if no column with ID  col_id exists, or of  row_idx is\
               out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setItemSelectState
        
            typedef void ( ::CEGUI::MultiColumnList::*setItemSelectState_function_type )( ::CEGUI::ListboxItem *,bool ) ;
            
            MultiColumnList_exposer.def( 
                "setItemSelectState"
                , setItemSelectState_function_type( &::CEGUI::MultiColumnList::setItemSelectState )
                , ( bp::arg("item"), bp::arg("state") )
                , "*!\n\
               \n\
                  Sets or clears the selected state of the given ListboxItem which must be attached to the\
                  list.\n\
            \n\
               \note\n\
                  Depending upon the current selection mode, this may cause other items to be selected, other\n\
                  items to be deselected, or for nothing to actually happen at all.\n\
            \n\
               @param item\n\
                  Pointer to the attached ListboxItem to be affected.\n\
            \n\
               @param state\n\
                  - true to put the ListboxItem into the selected state.\n\
                  - false to put the ListboxItem into the de-selected state.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  item is not attached to the list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setItemSelectState
        
            typedef void ( ::CEGUI::MultiColumnList::*setItemSelectState_function_type )( ::CEGUI::MCLGridRef const &,bool ) ;
            
            MultiColumnList_exposer.def( 
                "setItemSelectState"
                , setItemSelectState_function_type( &::CEGUI::MultiColumnList::setItemSelectState )
                , ( bp::arg("grid_ref"), bp::arg("state") )
                , "*!\n\
               \n\
                  Sets or clears the selected state of the ListboxItem at the given grid reference.\n\
            \n\
               \note\n\
                  Depending upon the current selection mode, this may cause other items to be selected, other\n\
                  items to be deselected, or for nothing to actually happen at all.\n\
            \n\
               @param grid_ref\n\
                  MCLGridRef object describing the position of the item to be affected.\n\
            \n\
               @param state\n\
                  - true to put the ListboxItem into the selected state.\n\
                  - false to put the ListboxItem into the de-selected state.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  grid_ref is invalid for this list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setNominatedSelectionColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*setNominatedSelectionColumn_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setNominatedSelectionColumn"
                , setNominatedSelectionColumn_function_type( &::CEGUI::MultiColumnList::setNominatedSelectionColumn )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Set the column to be used for the NominatedColumn* selection modes.\n\
            \n\
               @param   col_idx\n\
                  zero based index of the column to be used in NominatedColumn* selection modes.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setNominatedSelectionColumnID
        
            typedef void ( ::CEGUI::MultiColumnList::*setNominatedSelectionColumnID_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setNominatedSelectionColumnID"
                , setNominatedSelectionColumnID_function_type( &::CEGUI::MultiColumnList::setNominatedSelectionColumnID )
                , ( bp::arg("col_id") )
                , "*!\n\
               \n\
                  Set the column to be used for the NominatedColumn* selection modes.\n\
            \n\
               @param   col_id\n\
                  ID code of the column to be used in NominatedColumn* selection modes.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if no column has ID code  col_id.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setNominatedSelectionRow
        
            typedef void ( ::CEGUI::MultiColumnList::*setNominatedSelectionRow_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setNominatedSelectionRow"
                , setNominatedSelectionRow_function_type( &::CEGUI::MultiColumnList::setNominatedSelectionRow )
                , ( bp::arg("row_idx") )
                , "*!\n\
               \n\
                  Set the row to be used for the NominatedRow* selection modes.\n\
            \n\
               @param   row_idx\n\
                  zero based index of the row to be used in NominatedRow* selection modes.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  row_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setRowID
        
            typedef void ( ::CEGUI::MultiColumnList::*setRowID_function_type )( ::CEGUI::uint,::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setRowID"
                , setRowID_function_type( &::CEGUI::MultiColumnList::setRowID )
                , ( bp::arg("row_idx"), bp::arg("row_id") )
                , "*!\n\
               \n\
                  Set the ID code assigned to a given row.\n\
            \n\
               @param row_idx\n\
                  Zero based index of the row who's ID code is to be set.\n\
            \n\
               @param row_id\n\
                  ID code to be assigned to the row at the requested index.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  row_idx is out of range\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setSelectionMode
        
            typedef void ( ::CEGUI::MultiColumnList::*setSelectionMode_function_type )( ::CEGUI::MultiColumnList::SelectionMode ) ;
            
            MultiColumnList_exposer.def( 
                "setSelectionMode"
                , setSelectionMode_function_type( &::CEGUI::MultiColumnList::setSelectionMode )
                , ( bp::arg("sel_mode") )
                , "*!\n\
               \n\
                  Set the selection mode for the list box.\n\
            \n\
               @param sel_mode\n\
                  One of the MultiColumnList.SelectionMode enumerated values specifying the selection mode to be\
                  used.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception  InvalidRequestException thrown if the value specified for  sel_mode is invalid.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setShowHorzScrollbar
        
            typedef void ( ::CEGUI::MultiColumnList::*setShowHorzScrollbar_function_type )( bool ) ;
            
            MultiColumnList_exposer.def( 
                "setShowHorzScrollbar"
                , setShowHorzScrollbar_function_type( &::CEGUI::MultiColumnList::setShowHorzScrollbar )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether the horizontal scroll bar should always be shown, or just when needed.\n\
            \n\
               @param setting\n\
                  - true to have the horizontal scroll bar shown at all times.\n\
                  - false to have the horizontal scroll bar appear only when needed.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setShowVertScrollbar
        
            typedef void ( ::CEGUI::MultiColumnList::*setShowVertScrollbar_function_type )( bool ) ;
            
            MultiColumnList_exposer.def( 
                "setShowVertScrollbar"
                , setShowVertScrollbar_function_type( &::CEGUI::MultiColumnList::setShowVertScrollbar )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether the vertical scroll bar should always be shown, or just when needed.\n\
            \n\
               @param setting\n\
                  - true to have the vertical scroll bar shown at all times.\n\
                  - false to have the vertical scroll bar appear only when needed.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setSortColumn
        
            typedef void ( ::CEGUI::MultiColumnList::*setSortColumn_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setSortColumn"
                , setSortColumn_function_type( &::CEGUI::MultiColumnList::setSortColumn )
                , ( bp::arg("col_idx") )
                , "*!\n\
               \n\
                  Set the column to be used as the sort key.\n\
            \n\
               @param col_idx\n\
                  Zero based index of the column to use as the key when sorting the list items.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if col_idx is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setSortColumnByID
        
            typedef void ( ::CEGUI::MultiColumnList::*setSortColumnByID_function_type )( ::CEGUI::uint ) ;
            
            MultiColumnList_exposer.def( 
                "setSortColumnByID"
                , setSortColumnByID_function_type( &::CEGUI::MultiColumnList::setSortColumnByID )
                , ( bp::arg("col_id") )
                , "*!\n\
               \n\
                  Set the column to be used as the sort key.\n\
            \n\
               @param col_id\n\
                  ID code of the column to use as the key when sorting the list items.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if col_id is invalid for this list box.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setSortDirection
        
            typedef void ( ::CEGUI::MultiColumnList::*setSortDirection_function_type )( ::CEGUI::ListHeaderSegment::SortDirection ) ;
            
            MultiColumnList_exposer.def( 
                "setSortDirection"
                , setSortDirection_function_type( &::CEGUI::MultiColumnList::setSortDirection )
                , ( bp::arg("direction") )
                , "*!\n\
               \n\
                  Set the sort direction to be used.\n\
            \n\
               @param direction\n\
                  One of the ListHeaderSegment.SortDirection enumerated values specifying the sort direction to\
                  be used.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setUserColumnDraggingEnabled
        
            typedef void ( ::CEGUI::MultiColumnList::*setUserColumnDraggingEnabled_function_type )( bool ) ;
            
            MultiColumnList_exposer.def( 
                "setUserColumnDraggingEnabled"
                , setUserColumnDraggingEnabled_function_type( &::CEGUI::MultiColumnList::setUserColumnDraggingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether the user may modify the order of the columns.\n\
            \n\
               @param setting\n\
                  - true if the user may interactively modify the order of the columns.\n\
                  - false if the user may not modify the order of the columns.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setUserColumnSizingEnabled
        
            typedef void ( ::CEGUI::MultiColumnList::*setUserColumnSizingEnabled_function_type )( bool ) ;
            
            MultiColumnList_exposer.def( 
                "setUserColumnSizingEnabled"
                , setUserColumnSizingEnabled_function_type( &::CEGUI::MultiColumnList::setUserColumnSizingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether the user may size column segments.\n\
            \n\
               @param setting\n\
                  - true if the user may interactively modify the width of columns.\n\
                  - false if the user may not change the width of the columns.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::MultiColumnList::setUserSortControlEnabled
        
            typedef void ( ::CEGUI::MultiColumnList::*setUserSortControlEnabled_function_type )( bool ) ;
            
            MultiColumnList_exposer.def( 
                "setUserSortControlEnabled"
                , setUserSortControlEnabled_function_type( &::CEGUI::MultiColumnList::setUserSortControlEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether user manipulation of the sort column and direction are enabled.\n\
            \n\
               @param setting\n\
                  - true if the user may interactively modify the sort column and direction.\n\
                  - false if the user may not modify the sort column and direction (these can still be set\
                  programmatically).\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        MultiColumnList_exposer.add_static_property( "EventHorzScrollbarModeChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventHorzScrollbarModeChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventListColumnMoved"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventListColumnMoved
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventListColumnSized"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventListColumnSized
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventListContentsChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventListContentsChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventNominatedSelectColumnChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventNominatedSelectColumnChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventNominatedSelectRowChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventNominatedSelectRowChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventSelectionChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventSelectionChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventSelectionModeChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventSelectionModeChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventSortColumnChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventSortColumnChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventSortDirectionChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventSortDirectionChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "EventVertScrollbarModeChanged"
                        , bp::make_getter( &CEGUI::MultiColumnList::EventVertScrollbarModeChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "HorzScrollbarNameSuffix"
                        , bp::make_getter( &CEGUI::MultiColumnList::HorzScrollbarNameSuffix
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "ListHeaderNameSuffix"
                        , bp::make_getter( &CEGUI::MultiColumnList::ListHeaderNameSuffix
                                , bp::return_value_policy< bp::return_by_value >() ) );
        MultiColumnList_exposer.add_static_property( "VertScrollbarNameSuffix"
                        , bp::make_getter( &CEGUI::MultiColumnList::VertScrollbarNameSuffix
                                , bp::return_value_policy< bp::return_by_value >() ) );
        { //::CEGUI::Window::beginInitialisation
        
            typedef void ( ::CEGUI::Window::*beginInitialisation_function_type )(  ) ;
            typedef void ( MultiColumnList_wrapper::*default_beginInitialisation_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "beginInitialisation"
                , beginInitialisation_function_type(&::CEGUI::Window::beginInitialisation)
                , default_beginInitialisation_function_type(&MultiColumnList_wrapper::default_beginInitialisation) );
        
        }
        { //::CEGUI::Window::cloneChildWidgetsTo
        
            typedef void ( ::CEGUI::Window::*cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( MultiColumnList_wrapper::*default_cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            
            MultiColumnList_exposer.def( 
                "cloneChildWidgetsTo"
                , cloneChildWidgetsTo_function_type(&::CEGUI::Window::cloneChildWidgetsTo)
                , default_cloneChildWidgetsTo_function_type(&MultiColumnList_wrapper::default_cloneChildWidgetsTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::clonePropertiesTo
        
            typedef void ( ::CEGUI::Window::*clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( MultiColumnList_wrapper::*default_clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            
            MultiColumnList_exposer.def( 
                "clonePropertiesTo"
                , clonePropertiesTo_function_type(&::CEGUI::Window::clonePropertiesTo)
                , default_clonePropertiesTo_function_type(&MultiColumnList_wrapper::default_clonePropertiesTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::destroy
        
            typedef void ( ::CEGUI::Window::*destroy_function_type )(  ) ;
            typedef void ( MultiColumnList_wrapper::*default_destroy_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "destroy"
                , destroy_function_type(&::CEGUI::Window::destroy)
                , default_destroy_function_type(&MultiColumnList_wrapper::default_destroy) );
        
        }
        { //::CEGUI::Window::endInitialisation
        
            typedef void ( ::CEGUI::Window::*endInitialisation_function_type )(  ) ;
            typedef void ( MultiColumnList_wrapper::*default_endInitialisation_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "endInitialisation"
                , endInitialisation_function_type(&::CEGUI::Window::endInitialisation)
                , default_endInitialisation_function_type(&MultiColumnList_wrapper::default_endInitialisation) );
        
        }
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( MultiColumnList_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            MultiColumnList_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&MultiColumnList_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::Window::getRenderedStringParser
        
            typedef ::CEGUI::RenderedStringParser & ( ::CEGUI::Window::*getRenderedStringParser_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getRenderedStringParser"
                , getRenderedStringParser_function_type(&::CEGUI::Window::getRenderedStringParser)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::Window::getRenderingContext_impl
        
            typedef void ( ::CEGUI::Window::*getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            typedef void ( MultiColumnList_wrapper::*default_getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            
            MultiColumnList_exposer.def( 
                "getRenderingContext_impl"
                , getRenderingContext_impl_function_type(&::CEGUI::Window::getRenderingContext_impl)
                , default_getRenderingContext_impl_function_type(&MultiColumnList_wrapper::default_getRenderingContext_impl)
                , ( bp::arg("ctx") ) );
        
        }
        { //::CEGUI::Window::getUnclippedInnerRect_impl
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedInnerRect_impl_function_type )(  ) const;
            typedef ::CEGUI::Rect ( MultiColumnList_wrapper::*default_getUnclippedInnerRect_impl_function_type )(  ) const;
            
            MultiColumnList_exposer.def( 
                "getUnclippedInnerRect_impl"
                , getUnclippedInnerRect_impl_function_type(&::CEGUI::Window::getUnclippedInnerRect_impl)
                , default_getUnclippedInnerRect_impl_function_type(&MultiColumnList_wrapper::default_getUnclippedInnerRect_impl) );
        
        }
        { //::CEGUI::Window::isHit
        
            typedef bool ( ::CEGUI::Window::*isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            typedef bool ( MultiColumnList_wrapper::*default_isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            
            MultiColumnList_exposer.def( 
                "isHit"
                , isHit_function_type(&::CEGUI::Window::isHit)
                , default_isHit_function_type(&MultiColumnList_wrapper::default_isHit)
                , ( bp::arg("position"), bp::arg("allow_disabled")=(bool const)(false) ) );
        
        }
        { //::CEGUI::Window::performChildWindowLayout
        
            typedef void ( ::CEGUI::Window::*performChildWindowLayout_function_type )(  ) ;
            typedef void ( MultiColumnList_wrapper::*default_performChildWindowLayout_function_type )(  ) ;
            
            MultiColumnList_exposer.def( 
                "performChildWindowLayout"
                , performChildWindowLayout_function_type(&::CEGUI::Window::performChildWindowLayout)
                , default_performChildWindowLayout_function_type(&MultiColumnList_wrapper::default_performChildWindowLayout) );
        
        }
        { //::CEGUI::Window::setLookNFeel
        
            typedef void ( ::CEGUI::Window::*setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            typedef void ( MultiColumnList_wrapper::*default_setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            
            MultiColumnList_exposer.def( 
                "setLookNFeel"
                , setLookNFeel_function_type(&::CEGUI::Window::setLookNFeel)
                , default_setLookNFeel_function_type(&MultiColumnList_wrapper::default_setLookNFeel)
                , ( bp::arg("look") ) );
        
        }
        { //::CEGUI::Window::setMargin
        
            typedef void ( ::CEGUI::Window::*setMargin_function_type )( ::CEGUI::UBox const & ) ;
            typedef void ( MultiColumnList_wrapper::*default_setMargin_function_type )( ::CEGUI::UBox const & ) ;
            
            MultiColumnList_exposer.def( 
                "setMargin"
                , setMargin_function_type(&::CEGUI::Window::setMargin)
                , default_setMargin_function_type(&MultiColumnList_wrapper::default_setMargin)
                , ( bp::arg("margin") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( MultiColumnList_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            MultiColumnList_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&MultiColumnList_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( MultiColumnList_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            MultiColumnList_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&MultiColumnList_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::Window::update
        
            typedef void ( ::CEGUI::Window::*update_function_type )( float ) ;
            typedef void ( MultiColumnList_wrapper::*default_update_function_type )( float ) ;
            
            MultiColumnList_exposer.def( 
                "update"
                , update_function_type(&::CEGUI::Window::update)
                , default_update_function_type(&MultiColumnList_wrapper::default_update)
                , ( bp::arg("elapsed") ) );
        
        }
        { //::CEGUI::Window::writeXMLToStream
        
            typedef void ( ::CEGUI::Window::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            typedef void ( MultiColumnList_wrapper::*default_writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            MultiColumnList_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type(&::CEGUI::Window::writeXMLToStream)
                , default_writeXMLToStream_function_type(&MultiColumnList_wrapper::default_writeXMLToStream)
                , ( bp::arg("xml_stream") ) );
        
        }
    }

}
