#ifndef __MSN_INTERFACE_H__
#define __MSN_INTERFACE_H__

/* msn_interface.h - functions that talk to the outside world */

/*
	void ext_show_error(char * msg);

	Purpose:        Displays an error
	Arguments:
	  msg           The error message
	Return:         Nothing
*/

void ext_register_sock(int s, int read, int write);
void ext_unregister_sock(int s);

void ext_show_error(msnconn * conn, const char * msg);

void ext_buddy_set(msnconn * conn, const char * buddy, const char * friendlyname, const char * state);

void ext_buddy_offline(msnconn * conn, const char * buddy);

void ext_got_friendlyname(msnconn * conn, const char * friendlyname);

void ext_got_info(msnconn * conn, syncinfo * data);

void ext_debug( char *msg );

void ext_latest_serial(msnconn * conn, int serial);

void ext_got_GTC(msnconn * conn, char c);

void ext_got_BLP(msnconn * conn, char c);

void ext_new_RL_entry(msnconn * conn, const char * username, const char * friendlyname);

void ext_new_list_entry(msnconn * conn, const char * lst, const char * username, const char * friendlyname, int gid);

void ext_del_list_entry(msnconn * conn, const char * lst, const char * username);

void ext_new_group(msnconn * conn, const char * name, int id);

void ext_renamed_group(msnconn * conn, const char * name, int id);

void ext_del_group(msnconn * conn, const char * name, int id);

void ext_got_SB(msnconn * conn, void * tag);

void ext_user_joined(msnconn * conn, const char * username, const char * friendlyname, int is_initial);

void ext_user_left(msnconn * conn, const char * username);

void ext_got_IM(msnconn * conn, const char * username, const char * friendlyname, message * msg);

void ext_IM_failed(msnconn * conn);

void ext_typing_user(msnconn * conn, const char * username, const char * friendlyname);

void ext_initial_email(msnconn * conn, int unread_inbox, int unread_folders);

void ext_new_mail_arrived(msnconn * conn, const char * from, const char * subject);

void ext_filetrans_invite(msnconn * conn, const char * username, const char * friendlyname, invitation_ftp * inv);

void ext_filetrans_progress(invitation_ftp * inv, const char * status, unsigned long recv, unsigned long total);

void ext_filetrans_failed(invitation_ftp * inv, int error, const char * message);

void ext_filetrans_success(invitation_ftp * inv);

void ext_new_connection(msnconn * conn);

void ext_closing_connection(msnconn * conn);

void ext_changed_state(msnconn * conn, const char * state);

/*
	int connect_socket(char * server, int port);

	Purpose:        Makes a TCP socket, connects it to the specified server and port,
			and then registers it for
	Arguments:
	  server        The server name
	  port          The TCP port to connect to
	Return:         Nothing
*/
int ext_connect_socket(const char * server, int port);

int ext_connect_socket_ssl(const char * server, int port);

int ext_server_socket(int port);

char * ext_get_IP(void);

void ext_protocol_log(const char *buf, int readev, int writeev);

#endif
