--
-- Meta Services.
--
CREATE TABLE meta_service (
  meta_id int NOT NULL,

  meta_name varchar(254) default NULL,
  meta_display varchar(254) default NULL,
  check_period int default NULL,
  max_check_attempts int default NULL,
  normal_check_interval int default NULL,
  retry_check_interval int default NULL,
  notification_interval int default NULL,
  notification_period int default NULL,
  notification_options varchar(255) default NULL,
  notifications_enabled enum('0','1','2') default NULL,
  calcul_type enum('SOM','AVE','MIN','MAX') default NULL,
  data_source_type smallint NOT NULL default 0,
  meta_select_mode enum('1','2') default '1',
  regexp_str varchar(254) default NULL,
  metric varchar(255) default NULL,
  warning varchar(254) default NULL,
  critical varchar(254) default NULL,
  graph_id int default NULL,
  meta_comment text,
  meta_activate enum('0','1') default NULL,
  value float default NULL,

  PRIMARY KEY (meta_id)
);
CREATE SEQUENCE meta_service_seq
START WITH 1
INCREMENT BY 1;
CREATE TRIGGER meta_service_trigger
BEFORE INSERT ON meta_service
FOR EACH ROW
BEGIN
  SELECT meta_service_seq.nextval INTO :NEW.meta_id FROM dual;
END;
/
