*
* $Id: ctq1opd.F,v 1.1.1.2 1996/10/30 08:27:41 cernlib Exp $
*
* $Log: ctq1opd.F,v $
* Revision 1.1.1.2  1996/10/30 08:27:41  cernlib
* Version 7.04
*
* Revision 1.1.1.1  1996/04/12 15:29:05  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"

      FUNCTION Ctq1OPd (Ist, Lp, XX, QQ, Irt)

C                     Returns xf(x,Q) -- the momentum fraction distribution !!
C                     Returns valence and sea rather than combined flavor distr.

C            Ist : PDF set label

C            Lp  : Parton label:   2, 1 = d_ and u_ valence
C                                     0 = gluon
C                            -1, ... -6 = u, d, s, c, b, t sea quarks

C            XX  : Bjorken-x
C            QQ  : scale parameter "Q"
C            Irt : Return code

C     IMPLICIT DOUBLE PRECISION (A-H, O-Z)
C+SEQ, IMPDP.
      PARAMETER (D0=0D0, D1=1D0, D2=2D0, D3=3D0, D4=4D0, D10=1D1)
      PARAMETER (Nex = 5, MxFl = 6, Npn = 3, Nst = 30, Nexpt=20)
      Parameter (Nst4 = Nst*4)

#include "pdf/expdp.inc"
     +       P012, P34, P5, PDFD
      REAL PDF

      DIMENSION
     >   AC(0:Nex, 0:Npn, -MxFl:2, Nst), A(0:Nex)
     > , Iord(Nst), Isch(Nst), Nqrk(Nst),Alm(Nst)
     > , Vlm(4:6,Nst), Qms(4:6, Nst)
     > , Xmn(Nst), Qmn(Nst), Qmx(Nst), Nexp(Nexpt)
     > , Mex(Nst), Mpn(Nst), ExpN(Nexpt, Nst), ExpNor(Nexpt)

C                                                             CTEQ1M
      DATA
     >  Isch(1), Iord(1), Nqrk(1), Alm(1) /  1,  2,  6,  .152 /
     > ,(Vlm(I,1), I=4,6) / .231,    .152,    .059  /
     > ,(Qms(I,1), I=4,6) / 1.50,   5.00,  180.0 /
     > ,Xmn(1), Qmn(1), Qmx(1) /  1.E-5,  2.00,  1.E3  /
     > ,Mex(1), Mpn(1), Nexp(1) /  5, 3, 8  /
     > ,(ExpN(I, 1), I=1,8)
     >  / 0.989, 1.00, 1.02, 0.978, 1.10, 0.972, 0.987, 0.846 /
      DATA (((AC(IEX,IPN,IFL,1), IEX=0,5), IPN=0,3), IFL=-6,-4)
     >/  1.291 ,    .693 ,   3.195 ,  -2.294 ,    .291 ,    .000 ,
     >   -.038 ,   -.016 ,    .299 ,  -1.560 ,   -.183 ,    .451 ,
     >   -.118 ,    .043 ,   -.015 ,    .164 ,    .074 ,    .141 ,
     >   -.006 ,   -.018 ,    .128 ,    .366 ,   -.017 ,   -.043 ,
     >  -1.255 ,    .269 ,   3.766 ,   3.355 ,    .823 ,    .000 ,
     >    .332 ,    .068 ,    .670 ,  -1.056 ,   -.343 ,    .242 ,
     >   -.350 ,   -.020 ,   -.051 ,    .373 ,    .098 ,    .079 ,
     >    .008 ,    .005 ,    .023 ,   -.035 ,   -.018 ,    .013 ,
     >    .999 ,   -.031 ,   8.015 ,   3.874 ,   2.773 ,    .000 ,
     >  -2.366 ,   -.857 ,   -.059 ,  -1.854 ,  -1.508 ,    .383 ,
     >   -.339 ,   1.117 ,   -.876 ,    .580 ,    .290 ,   2.472 ,
     >    .202 ,   -.459 ,    .302 ,   -.135 ,    .050 ,  -1.184 /
      DATA (((AC(IEX,IPN,IFL,1), IEX=0,5), IPN=0,3), IFL=-3,-1)
     >/ -1.176 ,    .005 ,   7.490 ,  -4.470 ,    .603 ,    .000 ,
     >   -.473 ,   -.377 ,  -1.143 ,   2.230 ,   -.446 ,   -.134 ,
     >  -1.481 ,    .074 ,   2.564 ,   4.076 ,   1.201 ,    .800 ,
     >    .879 ,   -.009 ,  -1.175 ,  -3.678 ,   -.692 ,   -.461 ,
     >  -2.022 ,   -.158 ,   8.559 ,   3.169 ,   1.477 ,    .000 ,
     >  -1.002 ,    .126 ,    .188 ,   -.055 ,    .025 ,   1.650 ,
     >    .011 ,   -.335 ,    .256 ,   -.132 ,   -.143 ,  -1.177 ,
     >   -.056 ,    .138 ,   -.103 ,    .060 ,    .046 ,    .457 ,
     >  -1.137 ,   -.032 ,  11.636 ,   3.925 ,   3.300 ,    .000 ,
     >  -1.427 ,   -.109 ,  -2.300 ,  -1.122 ,   -.911 ,   1.052 ,
     >    .603 ,   -.255 ,   2.474 ,    .432 ,    .444 ,  -1.231 ,
     >   -.295 ,    .133 ,   -.959 ,   -.145 ,   -.126 ,    .578 /
      DATA (((AC(IEX,IPN,IFL,1), IEX=0,5), IPN=0,3), IFL= 0, 2)
     >/ -6.851 ,    .179 ,   8.667 ,   3.918 ,   1.757 ,   2.338 ,
     >   1.494 ,    .723 , -11.768 ,  -5.471 ,  -2.241 ,   6.119 ,
     >  -6.385 ,   -.725 ,  11.511 ,   9.052 ,   2.205 ,  -3.177 ,
     >   2.552 ,    .405 ,  -4.517 ,  -3.569 ,   -.617 ,   1.517 ,
     >  -3.012 ,   -.407 ,   6.986 ,  -3.839 ,   -.005 ,   1.092 ,
     >   4.825 ,   2.720 ,  -1.852 ,   1.513 ,    .046 ,   4.612 ,
     >  -8.807 ,  -6.151 ,  -5.616 ,  -3.152 ,    .018 , -11.986 ,
     >   4.213 ,   3.833 ,   7.066 ,   2.737 ,   -.025 ,   8.430 ,
     >  -8.291 ,   -.109 ,   8.279 ,   1.359 ,  11.254 ,   2.274 ,
     >   6.770 ,  -2.028 ,  -7.774 ,  11.962 ,   9.376 ,  -2.552 ,
     >  -3.104 ,   3.322 ,  11.896 ,   9.854 ,   -.920 ,   6.730 ,
     >   9.352 ,   8.716 ,  11.981 ,  11.994 ,  -5.632 ,  -4.979 /

C                                                             CTEQ1MS
      DATA
     >  Isch(2), Iord(2), Nqrk(2), Alm(2) /  1,  2,  6, .152  /
     > ,(Vlm(I,2), I=4,6) / .231,    .152,    .059  /
     > ,(Qms(I,2), I=4,6) / 1.50,   5.00,  180.0 /
     > ,Xmn(2), Qmn(2), Qmx(2) /  1.E-5,  2.00,  1.E3  /
     > ,Mex(2), Mpn(2), Nexp(2) /  5, 3, 8  /
     > ,(ExpN(I, 2), I=1,8 )
     >  / 0.989, 1.00, 1.02, 0.984, 1.05, 0.891, 0.923, 0.824 /
      DATA (((AC(IEX,IPN,IFL,2), IEX=0,5), IPN=0,3), IFL=-6,-4)
     >/  0.603 ,   0.606 ,   3.454 ,  -1.341 ,   0.892 ,   0.000 ,
     >  -0.592 ,  -0.051 ,  -0.640 ,  -3.736 ,  -0.628 ,   0.436 ,
     >   1.609 ,   0.035 ,   2.432 ,   5.353 ,  -0.205 ,  -0.636 ,
     >  -1.124 ,   0.009 ,  -1.035 ,  -1.841 ,   0.292 ,   0.553 ,
     >  -1.243 ,   0.273 ,   3.736 ,   3.311 ,   0.804 ,   0.000 ,
     >   0.337 ,   0.069 ,   0.668 ,  -1.051 ,  -0.334 ,   0.251 ,
     >  -0.390 ,  -0.029 ,  -0.050 ,   0.401 ,   0.087 ,   0.050 ,
     >   0.030 ,   0.012 ,   0.023 ,  -0.051 ,  -0.012 ,   0.032 ,
     >  -2.475 ,  -0.479 ,   5.071 ,   3.349 ,   0.499 ,   0.000 ,
     >  -0.473 ,  -0.066 ,   1.189 ,  -1.869 ,  -1.527 ,  -0.944 ,
     >   0.204 ,   0.012 ,  -0.805 ,   0.489 ,   2.612 ,   4.458 ,
     >  -0.280 ,   0.067 ,   0.205 ,  -0.107 ,  -1.344 ,  -2.243 /
      DATA (((AC(IEX,IPN,IFL,2), IEX=0,5), IPN=0,3), IFL=-3,-1)
     >/ -0.826 ,   0.035 ,   6.781 , -12.000 ,   0.306 ,   0.000 ,
     >  -3.668 ,  -0.433 ,  -0.494 ,  11.065 ,   0.942 ,   1.003 ,
     >   3.573 ,   0.094 ,   2.550 ,  -9.100 ,  -0.069 ,  -1.325 ,
     >  -1.575 ,   0.018 ,  -1.113 ,   6.251 ,  -0.120 ,   0.731 ,
     >  -2.602 ,  -0.273 ,   7.719 ,   2.890 ,   1.167 ,   0.000 ,
     >  -0.490 ,   0.198 ,   0.011 ,  -0.748 ,  -0.134 ,   1.503 ,
     >  -0.581 ,  -0.233 ,   0.237 ,   0.693 ,   0.137 ,  -0.446 ,
     >   0.135 ,   0.079 ,  -0.077 ,  -0.210 ,  -0.058 ,   0.141 ,
     >  -0.423 ,   0.028 ,   7.553 ,  -2.379 ,   0.197 ,   0.000 ,
     >  -2.385 ,  -0.355 ,   0.216 ,   2.235 ,   0.304 ,   0.253 ,
     >   0.506 ,   0.075 ,  -0.967 ,  -4.420 ,   0.536 ,   0.409 ,
     >   0.139 ,  -0.019 ,   1.027 ,   2.583 ,  -0.415 ,  -0.328 /
      DATA (((AC(IEX,IPN,IFL,2), IEX=0,5), IPN=0,3), IFL= 0, 2)
     >/ -7.079 ,   0.846 ,   6.606 ,   1.205 ,  -1.230 ,   0.093 ,
     >   4.935 ,  -2.194 ,  -1.211 ,   2.680 ,   4.238 ,   6.468 ,
     >  -5.897 ,   1.178 ,  -8.073 , -11.571 ,  -6.159 ,  -7.322 ,
     >   3.223 ,  -0.119 ,  11.714 ,   9.362 ,   4.042 ,   2.248 ,
     >  -7.397 ,   0.074 ,   9.720 ,   3.531 ,   1.327 ,   2.230 ,
     >   1.231 ,   0.319 , -11.617 ,  -2.030 ,   0.499 ,   7.402 ,
     >  -6.532 ,  -0.109 ,  -2.119 ,  -3.973 ,  -6.102 ,  -7.770 ,
     >   6.548 ,  -0.703 ,  11.966 ,   4.277 ,   4.918 ,   0.063 ,
     >  -8.118 ,   5.785 ,  10.958 ,   1.271 ,  -4.631 ,   3.188 ,
     >  -3.630 ,  -5.093 , -11.222 ,   0.699 ,  -8.569 ,  -7.516 ,
     >  11.721 ,  11.973 ,   1.942 ,  11.484 ,  10.563 ,  -9.477 ,
     >   9.243 ,  11.808 ,  -1.901 ,  10.223 ,  12.000 ,  -9.659 /

C                                                             CTEQ1D
      DATA
     >  Isch(3), Iord(3), Nqrk(3), Alm(3) /  2,  2,  6, .164  /
     > ,(Vlm(I,3), I=4,6) / .247,    .164,    .064  /
     > ,(Qms(I,3), I=4,6) / 1.50,   5.00,  180.0 /
     > ,Xmn(3), Qmn(3), Qmx(3) /  1.E-5,  2.00,  1.E3  /
     > ,Mex(3), Mpn(3), Nexp(3) /  5, 3, 8 /
     > ,(ExpN(I, 3), I=1,8 )
     >  / 0.983, 1.00, 1.01, 0.975, 0.964, 1.23, 1.00, 1.12 /
      DATA (((AC(IEX,IPN,IFL,3), IEX=0,5), IPN=0,3), IFL=-6,-4)
     > /  .491 ,    .579 ,   2.839 ,  -2.212 ,    .801 ,    .000 ,
     >    .546 ,   -.090 ,    .573 ,  -1.963 ,  -1.124 ,   -.290 ,
     >   -.443 ,    .133 ,   -.084 ,   1.364 ,    .929 ,    .781 ,
     >   -.001 ,   -.045 ,    .003 ,   -.983 ,   -.281 ,   -.222 ,
     >  -1.040 ,    .266 ,   3.514 ,   3.091 ,    .900 ,    .000 ,
     >    .272 ,    .054 ,    .669 ,   -.970 ,   -.340 ,    .213 ,
     >   -.271 ,   -.007 ,   -.052 ,    .296 ,    .088 ,    .084 ,
     >    .029 ,    .004 ,    .026 ,   -.055 ,   -.017 ,    .006 ,
     >   1.009 ,    .006 ,   8.200 ,   3.907 ,   2.387 ,    .000 ,
     >  -2.313 ,  -1.001 ,   -.109 ,  -1.877 ,  -1.251 ,    .105 ,
     >   -.638 ,   1.358 ,  -1.195 ,    .767 ,    .229 ,   3.220 ,
     >    .301 ,   -.548 ,    .431 ,   -.183 ,    .051 ,  -1.458 /
      DATA (((AC(IEX,IPN,IFL,3), IEX=0,5), IPN=0,3), IFL=-3,-1)
     >/ -1.602 ,   -.077 ,   8.008 , -12.000 ,    .902 ,    .000 ,
     >  -1.365 ,   -.063 ,  -2.116 ,  11.788 ,    .447 ,   1.214 ,
     >    .471 ,   -.212 ,   2.664 ,   1.951 ,    .017 ,  -1.001 ,
     >   -.102 ,    .080 ,   -.892 ,  -8.620 ,   -.246 ,    .284 ,
     >  -2.395 ,   -.237 ,   8.447 ,   3.436 ,   1.629 ,    .000 ,
     >   -.710 ,    .300 ,    .236 ,   -.286 ,   -.130 ,   1.914 ,
     >   -.310 ,   -.393 ,   -.018 ,   -.004 ,   -.067 ,  -1.068 ,
     >    .105 ,    .126 ,    .048 ,   -.005 ,    .027 ,    .292 ,
     >   -.917 ,    .002 ,   9.613 ,  -1.016 ,    .384 ,    .000 ,
     >  -1.914 ,   -.048 ,  -4.422 ,   -.674 ,    .300 ,   1.428 ,
     >    .979 ,   -.370 ,   5.186 ,    .583 ,    .135 ,  -1.735 ,
     >   -.273 ,    .166 ,  -1.869 ,   -.469 ,   -.187 ,    .654 /
      DATA (((AC(IEX,IPN,IFL,3), IEX=0,5), IPN=0,3), IFL= 0, 2)
     >/ -5.837 ,   -.118 ,   8.788 ,   3.105 ,   1.759 ,    .660 ,
     >   4.625 ,    .334 ,  -7.686 ,  -6.079 ,  -2.041 ,   3.668 ,
     >  -8.633 ,   -.726 ,   5.499 ,   6.792 ,    .042 ,  -3.124 ,
     >   3.750 ,    .284 ,   -.894 ,  -2.211 ,    .623 ,    .994 ,
     >  -4.883 ,   -.410 ,   7.236 ,  -1.244 ,    .030 ,   -.209 ,
     >   7.234 ,   1.276 ,  -4.142 ,  -2.411 ,    .013 ,   6.729 ,
     > -10.009 ,  -2.572 ,   4.865 ,   3.458 ,   -.037 , -11.907 ,
     >   6.428 ,   1.508 ,  -1.351 ,  -3.510 ,   -.005 ,   7.070 ,
     >  -4.736 ,   -.536 ,   8.822 ,  -2.407 ,    .029 ,   -.034 ,
     >   6.936 ,   1.519 , -11.919 ,  -8.543 ,    .070 ,   6.899 ,
     > -10.860 ,  -2.198 ,  -4.707 ,  -7.172 ,   -.057 ,  -9.557 ,
     >  -2.932 ,   1.249 ,  11.998 ,  -5.721 ,   -.342 ,  11.930 /

C                                                             CTEQ1L
      DATA
     >  Isch(4), Iord(4), Nqrk(4), Alm(4) /  1,  2,  6, .125  /
     > ,(Vlm(I,4), I=4,6) / .168,    .125,     .063   /
     > ,(Qms(I,4), I=4,6) / 1.50,   5.00,  180.0 /
     > ,Xmn(4), Qmn(4), Qmx(4) /  1.E-5,  2.00,  1.E3  /
     > ,Mex(4), Mpn(4), Nexp(4) /  5, 3, 8  /
     > ,(ExpN(I, 4), I=1,8 )
     >  / 0.982, 1.01, 1.00, 0.972, 0.840, 0.959, 0.930, 0.861 /
      DATA (((AC(IEX,IPN,IFL,4), IEX=0,5), IPN=0,3), IFL=-6,-4)
     > /  .583 ,    .608 ,   3.470 ,  -1.155 ,   1.007 ,    .000 ,
     >   -.548 ,    .053 ,   -.676 ,  -3.980 ,   -.652 ,    .821 ,
     >   -.745 ,    .096 ,   2.155 ,   7.420 ,   1.592 ,    .654 ,
     >    .367 ,   -.062 ,   -.834 ,  -3.138 ,   -.505 ,   -.392 ,
     >   -.668 ,    .276 ,   3.579 ,   2.890 ,   1.120 ,    .000 ,
     >    .036 ,    .056 ,    .712 ,   -.791 ,   -.394 ,    .313 ,
     >   -.145 ,   -.001 ,   -.004 ,    .161 ,    .113 ,    .065 ,
     >    .007 ,    .001 ,   -.001 ,   -.036 ,   -.026 ,    .001 ,
     >    .997 ,   -.010 ,   7.174 ,   3.398 ,   2.572 ,    .000 ,
     >  -2.694 ,  -1.279 ,    .440 ,  -1.681 ,  -1.486 ,   -.262 ,
     >   -.474 ,   1.867 ,  -1.071 ,    .872 ,    .310 ,   4.279 ,
     >    .351 ,   -.827 ,    .307 ,   -.351 ,    .059 ,  -2.173 /
      DATA (((AC(IEX,IPN,IFL,4), IEX=0,5), IPN=0,3), IFL=-3,-1)
     >/ -1.280 ,    .000 ,  11.000 ,   3.620 ,   1.960 ,    .000 ,
     >  -1.421 ,    .140 ,  -2.068 ,  -1.124 ,   -.562 ,   1.801 ,
     >   1.116 ,   -.962 ,   3.225 ,    .221 ,    .290 ,  -3.519 ,
     >   -.734 ,    .510 ,  -1.553 ,    .003 ,   -.149 ,   1.902 ,
     >  -1.874 ,   -.128 ,   8.649 ,   3.777 ,   2.238 ,    .000 ,
     >   -.755 ,    .290 ,    .081 ,   -.537 ,   -.403 ,   1.786 ,
     >   -.082 ,   -.784 ,    .368 ,   -.275 ,   -.032 ,  -2.179 ,
     >   -.035 ,    .340 ,   -.124 ,    .191 ,    .048 ,    .932 ,
     >   -.990 ,    .009 ,  10.273 ,  -1.835 ,    .819 ,    .000 ,
     >  -2.295 ,    .499 ,  -6.955 ,   2.127 ,  -1.032 ,   3.397 ,
     >   1.305 ,  -1.254 ,   8.613 ,  -3.620 ,   2.081 ,  -4.647 ,
     >   -.390 ,    .547 ,  -3.228 ,   1.768 ,  -1.098 ,   1.881 /
      DATA (((AC(IEX,IPN,IFL,4), IEX=0,5), IPN=0,3), IFL= 0, 2)
     >/ -4.634 ,   2.501 ,   6.519 ,   -.075 ,  -2.309 ,   1.799 ,
     >   -.269 ,  -7.341 ,   3.055 ,   5.026 ,   6.286 ,  -5.076 ,
     >  -5.752 ,   4.656 , -11.795 ,  -4.939 ,  -5.771 ,   4.691 ,
     >   1.928 ,    .368 ,   6.233 ,   3.582 ,   2.682 ,   3.704 ,
     >  -6.652 ,   -.037 ,   5.764 ,   -.122 ,    .058 ,   1.467 ,
     >  11.952 ,   -.263 ,  -4.995 ,  -7.099 ,   -.146 ,   1.097 ,
     >  -9.664 ,    .128 ,  11.665 ,   5.411 ,    .053 ,  -2.291 ,
     >  -3.722 ,   -.154 ,  -6.858 ,   4.432 ,    .108 ,   1.817 ,
     > -11.229 ,   1.127 ,   6.623 ,   4.334 ,   1.829 ,   7.775 ,
     >  -4.606 ,  -8.717 , -12.000 ,  -1.353 ,  -5.906 , -11.999 ,
     >   5.527 ,  11.919 , -11.960 ,  -9.739 ,  -4.425 ,  -7.885 ,
     >   5.294 ,   4.647 , -11.995 ,  -7.602 ,  11.961 , -11.528 /

C                                                             CTEQ1ML
      DATA
     >  Isch(5), Iord(5), Nqrk(5), Alm(5) /  1,  2,  6, .220  /
     > ,(Vlm(I,5), I=4,6) / .322,    .220,     .088  /
     > ,(Qms(I,5), I=4,6) / 1.50,   5.00,  180.0 /
     > ,Xmn(5), Qmn(5), Qmx(5) /  1.E-5,  2.00,  1.E3  /
     > ,Mex(5), Mpn(5), Nexp(5) /  5, 3, 8 /
     > ,(ExpN(I, 5), I=1,8 )
     >  / 0.985, 1.00, 1.01, 0.977, 1.07, 1.31, 1.19, 1.09 /
      DATA (((AC(IEX,IPN,IFL,5), IEX=0,5), IPN=0,3), IFL=-6,-4)
     >/  1.329 ,   0.710 ,   3.259 ,  -2.037 ,   0.289 ,   0.000 ,
     >  -0.171 ,  -0.051 ,   0.568 ,  -0.594 ,  -0.162 ,   0.387 ,
     >   0.357 ,   0.087 ,  -0.687 ,  -2.327 ,   0.011 ,   0.144 ,
     >  -0.250 ,  -0.036 ,   0.455 ,   1.564 ,   0.016 ,  -0.032 ,
     >  -1.280 ,   0.276 ,   3.710 ,   3.377 ,   0.807 ,   0.000 ,
     >   0.439 ,   0.074 ,   0.688 ,  -1.164 ,  -0.346 ,   0.236 ,
     >  -0.493 ,  -0.040 ,  -0.078 ,   0.512 ,   0.091 ,   0.040 ,
     >   0.077 ,   0.018 ,   0.033 ,  -0.096 ,  -0.010 ,   0.042 ,
     >   1.073 ,   0.000 ,   8.529 ,   4.956 ,   3.396 ,   0.000 ,
     >  -2.117 ,  -1.044 ,   0.029 ,  -2.517 ,  -2.020 ,  -0.289 ,
     >  -0.323 ,   1.243 ,  -0.777 ,   0.932 ,   0.708 ,   2.836 ,
     >   0.121 ,  -0.465 ,   0.189 ,  -0.259 ,  -0.132 ,  -1.164 /
      DATA (((AC(IEX,IPN,IFL,5), IEX=0,5), IPN=0,3), IFL=-3,-1)
     >/ -1.058 ,   0.019 ,   7.301 , -10.896 ,   0.440 ,   0.000 ,
     >  -2.500 ,   0.311 ,  -1.030 ,   6.555 ,   0.479 ,   3.038 ,
     >   1.760 ,  -1.618 ,   0.045 ,   6.295 ,   0.150 ,  -6.173 ,
     >  -0.804 ,   0.990 ,   0.425 ,  -4.081 ,  -0.367 ,   3.574 ,
     >  -1.771 ,  -0.093 ,   9.119 ,   3.395 ,   1.668 ,   0.000 ,
     >  -0.966 ,  -0.101 ,   0.282 ,  -0.098 ,  -0.016 ,   0.997 ,
     >   0.023 ,  -0.142 ,   0.230 ,  -0.101 ,  -0.123 ,  -0.641 ,
     >  -0.080 ,   0.078 ,  -0.135 ,   0.037 ,   0.031 ,   0.303 ,
     >  -0.939 ,  -0.014 ,   9.812 ,  -0.981 ,   0.494 ,   0.000 ,
     >  -3.186 ,   0.185 ,  -6.334 ,  -1.277 ,   0.888 ,   2.922 ,
     >   3.040 ,  -0.606 ,   7.480 ,   2.012 ,  -1.487 ,  -3.663 ,
     >  -1.241 ,   0.249 ,  -2.711 ,  -0.892 ,   0.676 ,   1.454 /
      DATA (((AC(IEX,IPN,IFL,5), IEX=0,5), IPN=0,3), IFL= 0, 2)
     >/ -6.421 ,   0.004 ,   5.303 , -11.596 ,   7.121 ,   1.436 ,
     >   6.098 ,  -0.296 ,  -1.129 ,   6.321 ,  -5.644 ,   0.686 ,
     > -10.204 ,   0.691 ,  -4.176 ,  11.994 ,  -3.263 ,   2.657 ,
     >   5.577 ,  -0.515 ,   4.255 ,  -8.338 ,   2.663 ,  -2.657 ,
     >  -7.550 ,   0.033 ,   4.596 , -11.000 ,   5.769 ,   2.355 ,
     >   7.371 ,  -0.525 ,  -0.947 ,  -4.358 ,  -4.192 ,  -0.559 ,
     >  -9.918 ,   0.513 ,   4.015 ,  11.844 ,   2.203 ,   0.872 ,
     >   4.771 ,  -0.232 ,  -2.706 ,   3.373 ,  -3.659 ,  -0.453 ,
     >  -5.130 ,  -2.246 ,  11.942 ,  -0.186 ,  -1.349 ,  -2.626 ,
     >  -7.144 ,  10.040 ,  -5.395 ,   1.984 ,   5.378 ,  11.999 ,
     >   9.832 ,  -9.146 , -11.060 , -11.302 ,  11.672 ,  11.999 ,
     >  11.669 ,  -7.615 , -10.440 ,  -0.618 ,  10.684 ,  11.918 /


      Irt = 0
      Ip = Abs(Lp)
      Ifl = 2 - Nqrk(Ist) - Lp
C                             For Lp = 2, ... -N  we have Ifl = -N, ..., 2.
C                          This transformation inverts the counting of the
C                data matrix AC(...) which is created with Ifl = 2, -N, -1.
      X  = XX

      If (Ip.GE.4 .and. QQ.LE.Qms(Ip, Ist)) Then
         Ctq1OPd = 0.
         Return
      Endif

      Qi   = Qmn (Ist)
      Alam = Alm (Ist)
      SQ = LOG ( LOG(QQ/Alam) / LOG(Qi/Alam) )

      DO 20 Iex = 0, Mex(Ist)
          A(Iex) = AC(Iex, 0, Ifl, Ist)
          DO 21 Ipn = 1, Mpn(Ist)
            A(Iex) = A(Iex) + AC(Iex, Ipn, Ifl, Ist) * SQ **Ipn
  21      Continue
 20   continue

      P012 = Exp(A(0)) * X**A(1) * (1.-X)**A(2)
      P34  = 1. + (Exp(A(3)) - 1.) * X**A(4)
      P5   = Log(1.+ 1./X) ** A(5)
C
      PDFD   = P012 * P34 * P5
      PDF    = PDFD
C                                 Return parton (momentum fraction) function!
      Ctq1OPd = PDF
      IF(Ctq1OPd.LT.0.0) Ctq1OPd = 0.0

      Return
C                                                -----------------------------
      Entry ParCtq1
     >        (Iset, Iordr, Ischeme, MxFlv,
     >         Alam4, Alam5, Alam6, Amas4, Amas5, Amas6,
     >         Xmin, Qini, Qmax, ExpNor)

C                           Return QCD parameters and Fitting parameters
C                           associated with parton distribution set Iset.
C    Iord    : Order Of Fit
C    Ischeme : (0, 1, 2)  for  (LO, MS-bar-NLO, DIS-NLO) resp.
C    MxFlv   : Maximum number of flavors included
C    Alam_i  : i = 4,5,6  Effective lambda for i-flavors
C    Amas_i  : i = 4,5,6  Mass parameter for flavor i
C    Xmin, Qini, Qmax : self explanary
C    ExpNor(I)  : Normalization factor for the experimental data set used in
C                 obtaining the best global fit for parton distributions Iset:

C;I = 1,;2,;3,;4,;5,;6,;7,;8
C;BCDMS;NMC90;NMC280;CCFR;E605;WA70;E706;UA6
      Iordr  = Iord (Iset)
      Ischeme= Isch (Iset)
      MxFlv  = Nqrk (Iset)

      Alam4  = Vlm(4,Iset)
      Alam5  = Vlm(5,Iset)
      Alam6  = Vlm(6,Iset)

      Amas4  = Qms(4,Iset)
      Amas5  = Qms(5,Iset)
      Amas6  = Qms(6,Iset)

      Xmin   = Xmn  (Iset)
      Qini   = Qmn  (Iset)
      Qmax   = Qmx  (Iset)

      Do 101 Iexp = 1, Nexp(Iset)
         ExpNor(Iexp) = ExpN(Iexp, Iset)
  101 Continue

         Ctq1OPd = 0.
      Return
C                         *************************
      END
