/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/* Copyright (C) 2018 Hans Petter Jansson
 *
 * This file is part of Chafa, a program that turns images into character art.
 *
 * Chafa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Chafa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Chafa.  If not, see <http://www.gnu.org/licenses/>. */

#include "config.h"

#include <nmmintrin.h>
#include "chafa/chafa.h"
#include "chafa/chafa-private.h"

gint
chafa_pop_count_u64_builtin (guint64 v)
{
    return (gint) _mm_popcnt_u64 (v);
}

void
chafa_pop_count_vu64_builtin (const guint64 *vv, gint *vc, gint n)
{
    while (n--)
    {
        *(vc++) = _mm_popcnt_u64 (*(vv++));
    }
}

void
chafa_hamming_distance_vu64_builtin (guint64 a, const guint64 *vb, gint *vc, gint n)
{
    while (n >= 4)
    {
        n -= 4;
        *(vc++) = _mm_popcnt_u64 (a ^ *(vb++));
        *(vc++) = _mm_popcnt_u64 (a ^ *(vb++));
        *(vc++) = _mm_popcnt_u64 (a ^ *(vb++));
        *(vc++) = _mm_popcnt_u64 (a ^ *(vb++));
    }

    while (n--)
        *(vc++) = _mm_popcnt_u64 (a ^ *(vb++));
}
