/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkMultiRow Copyright (C) 1998 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_MULTIROW_H__
#define __GTK_MULTIROW_H__


#include <gdk/gdk.h>
#include <gtk/gtkbox.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_MULTIROW(obj)          GTK_CHECK_CAST (obj, gtk_multirow_get_type (), GtkMultiRow)
#define GTK_MULTIROW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_multirow_get_type (), GtkMultiRowClass)
#define GTK_IS_MULTIROW(obj)       GTK_CHECK_TYPE (obj, gtk_multirow_get_type ())


typedef struct _GtkMultiRow       GtkMultiRow;
typedef struct _GtkMultiRowClass  GtkMultiRowClass;

struct _GtkMultiRow
{
	GtkBox		box;

	gint		ncols;

	gint		vspacing;
	gint		hspacing;
};

struct _GtkMultiRowClass
{
	GtkBoxClass parent_class;
};

guint		gtk_multirow_get_type		(void);
GtkWidget*	gtk_multirow_new		(gint 		nrows);
void		gtk_multirow_set_number_of_columns	
						(GtkMultiRow	*multirow ,
						 gint		nrows);
void		gtk_multirow_set_spacing	(GtkMultiRow	*multirow ,
						 gint		hspacing ,
						 gint		vspacing);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_MULTIROW_H__ */
