
/* -*- linux-c -*- */

/*
 * Author : Stephen Smalley, <sds@epoch.ncsc.mil> 
 */

#ifndef _LINUX_FLASK_TYPES_H_
#define _LINUX_FLASK_TYPES_H_

/*
 * The basic Flask types and constants.
 */

#include <linux/types.h>

/*
 * A security context is a set of security attributes 
 * associated with each subject and object controlled
 * by the security policy.  The security context type
 * is defined as a variable-length string that can be
 * interpreted by any application or user with an 
 * understanding of the security policy.
 */
typedef char* security_context_t;

/*
 * An access vector (AV) is a collection of related permissions
 * for a pair of SIDs.  The bits within an access vector
 * are interpreted differently depending on the class of
 * the object.  The access vector interpretations are specified
 * in flask/access_vectors, and the corresponding constants
 * for permissions are defined in the automatically generated
 * header file av_permissions.h.
 */
typedef __u32 access_vector_t;

/*
 * Each object class is identified by a fixed-size value.
 * The set of security classes is specified in flask/security_classes, 
 * with the corresponding constants defined in the automatically 
 * generated header file flask.h.
 */
typedef __u16 security_class_t;
#define SECCLASS_NULL			0x0000 /* no class */

#ifdef __KERNEL__

/* Private kernel definitions */

/*
 * A kernel security identifier (SID) is a fixed-size value
 * that is mapped by the security server to a 
 * particular security context.  The SID mapping
 * cannot be assumed to be consistent either across
 * executions (reboots) of the security server or
 * across security servers on different nodes.
 *
 * Certain SIDs (specified in flask/initial_sids) are 
 * predefined for system initialization. The corresponding
 * constants are defined in the automatically generated
 * header file flask.h.
 */
typedef __u32 security_id_t;
#define SECSID_NULL			0x00000000 /* unspecified SID */
#define SECSID_WILD			0xFFFFFFFF /* wildcard SID */

#define SELINUX_MAGIC 0xf97cff8c 

#endif

#endif

