//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "effect_chain.h"


void Effect_Chain::process_buffer(sample_t *p_buffer,int p_length,bool p_stereo,int p_mix_freq) {

	for (int i=0;i<chain.size();i++) {

		chain[i]->process_buffer(p_buffer,p_length,p_stereo,p_mix_freq);
	}
}


void Effect_Chain::add_effect(Effect *p_effect) {

	chain.push_back(p_effect);
}
int Effect_Chain::get_effect_count() {

	return chain.size();
}
Effect* Effect_Chain::get_effect(int p_which) {

	if ((p_which<0) ||  (p_which>=chain.size()))
		return NULL;

	return chain[p_which];
}
bool Effect_Chain::remove_effect(int p_which) {

	if ((p_which<0) ||  (p_which>=chain.size()))
		return false;

	delete chain[p_which];
	chain.erase(chain.begin()+p_which);
	return true;
}

bool Effect_Chain::move_effect_up(int p_which) {

	if (p_which<1) return false;
	if (p_which>=chain.size()) return false;

	Effect *fx=chain[p_which-1];
	chain[p_which-1]=chain[p_which];
	chain[p_which]=fx;

	return true;


}
bool Effect_Chain::move_effect_down(int p_which) {

	if (p_which<0) return false;
	if (p_which>=(chain.size()-1)) return false;

	Effect *fx=chain[p_which+1];
	chain[p_which+1]=chain[p_which];
	chain[p_which]=fx;

	return true;
}

Effect_Chain::Effect_Chain()
{

}


Effect_Chain::~Effect_Chain()
{
}


