/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          midi_event.cpp  -  description
                             -------------------
    begin                : Mon Feb 4 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "midi_control.h"


/* NOTE ON HANDLER */
void Midi_Control::note_on(char p_chan,char p_note,char p_velocity) {

        //printf("note -- banks %i\n",engine_manager->get_bank_count());  
        event_count++; //increase number of processed events
	
	/* Data to compute new note */
	    
        Midi_Voice *new_voice=NULL;  //this is going to point to the new voice

        if (p_chan==drums_channel) { //If this channel is a drums channel, get the midi note configured voice

		new_voice = engine_manager->get_midi_drum_voice(channel[p_chan].bank,channel[p_chan].patch,p_note);
	
        } else { //otherwise, get a normal voice

		new_voice = engine_manager->get_midi_voice(channel[p_chan].bank,channel[p_chan].patch);
	       
	}

        if (new_voice == NULL) { //Couldnt get a voice it seems

	        //printf("no voice here!\n");
        
        	return; //thus nothing to do
	}
	
	new_voice->set_channel(p_chan); //the mixer needs to know the channel, or more like.. the buffer to mix to.

	/* Check for existing voice, this should be rewritten to allow duplicate voices? */
	
	if (channel[p_chan].voice_list[p_note]!=NULL) { //If it does exist

	        //printf("voice is not here!!\n");

		Voice *old_voice=channel[p_chan].voice_list[p_note];

  		//seek and destroy
	  	mixer->replace_voice(old_voice,new_voice);
	   	// Give the mixer the responsability of getting rid
	    	// of the voice in a non-clicky way :)


	} else {
	        //printf("gots new voice!\n");
	
		//allocate a new voice
	  	mixer->allocate_voice(new_voice);
	   	//if the mixer wants to ignore it,
	    	//then it's up to it.
	
	}

	/* IMPORTANT: registering the voice in the mixer must be done first */
	/* configuring it should be later, this way the mixer can set on it */
	/* parameters such as mixing frequency and such */

	//set a new note, p_note is ignored on drum channels.
	new_voice->set_note_on(p_note,p_velocity);

	/* Pass the note the current status of the CC map */

	for (int i=0;i<128;i++) {

		//dont set a CC if the channel isnt using it. Assume patch default.
		if (channel[p_chan].default_custom_ctrl[i]!=UNUSED_CTRL)
			new_voice->set_controller(i,channel[p_chan].default_custom_ctrl[i]);
	}

	/* Set pitch bender status on the voice */

        new_voice->set_pitch_bender(channel[p_chan].pitch_bender);

        /* TODO: set RPN/NRPN */

        	

	/* This is just a simple callback that let us know if the mixer decided */
	/* to kill a voice. It uses the LIBSIGC library. */
	/* With a bit more work, I assume the need for libsigc can be removed, */
	/* but for now, it helps me to do things faster */
	/* When the voice dies, we remove it from the hashmap */
#warning fix this	
// 	new_voice->on_kill.connect(SigC::bind<int,int>(SigC::slot(*this,&Midi_Control::on_note_kill),p_chan,p_note));

	channel[p_chan].voice_list[p_note]=new_voice;

}

/* NOTE OFF HANDLER */
void Midi_Control::note_off(char p_chan,char p_note,char p_velocity) {

	event_count++;

	Midi_Voice *voice=channel[p_chan].voice_list[p_note];

        /* Let's see if we have this note */
	if (voice==NULL) {

		/* If we dont print a warning, although
		this behavior is "legal", it's good for debugging
		*/
		//printf("Warning: I dont have note %i in channel %i for noteoff\n",p_note,p_chan);

		return;
	}

	//set note off
	voice->set_note_off(p_velocity,0);

}

/* CC HANDLER */
void Midi_Control::controller(char p_chan,char p_ctrl,char p_param) {

	event_count++;

	switch (p_ctrl) { 

		/* First, try to capture the non-voice specific */
		/* CC commands */
			
		case 32: { // Set Bank

  			channel[p_chan].bank=p_param;
  		} break;
		case 120: //kill/mute/wathever all notes
		case 121:
		case 123: {

			kill_chan_notes(p_chan);
		} break;
		
                /* Not handled, pass it to the voice */
		default: { //now if we dont handle it, lets give it to the voice!
		
			for (int i=0;i<128;i++) {

				if (channel[p_chan].voice_list[i]!=NULL) {
					channel[p_chan].voice_list[i]->set_controller(p_ctrl,p_param);
				}
			}
		}
	}
}

/* MIDI PITCH BEND CONTROL */
void Midi_Control::pitch_bend(char p_chan,int p_val) {

	channel[p_chan].pitch_bender=p_val;

	/* Set pitch bender on all the channel voices */

       	for (int i=0;i<128;i++) {

       		if (channel[p_chan].voice_list[i]!=NULL) {
       			channel[p_chan].voice_list[i]->set_pitch_bender(channel[p_chan].pitch_bender);
       		}
       	}
}

/* MIDI PROGRAM CHANGE HANDLER */
void Midi_Control::program_change(char p_chan,char p_program) {

	/*dont really bother if changing to the same */
	if (channel[p_chan].patch==p_program) return;

	/* As seen on most devices, this mutes the current channel */
	kill_chan_notes(p_chan);
	channel[p_chan].clear_controls(); //clear CCs
        channel[p_chan].patch=p_program;
        

}

/* Handler that silences all the channel voices */
void Midi_Control::kill_chan_notes(char p_chan) {


       	for (int i=0;i<128;i++) {

       		if (channel[p_chan].voice_list[i]!=NULL) {
         		mixer->eliminate_voice(channel[p_chan].voice_list[i]);
       		}
       	}
	channel[p_chan].clear_controls(); // reset the channel, as says on midispec!
}

/* Some info retrieving methods */
int Midi_Control::get_chan_bank(int p_chan) {

	return channel[p_chan].bank;
}
int Midi_Control::get_chan_patch(int p_chan) {

	return channel[p_chan].patch;
}

/* Callback when a voice dies */
void Midi_Control::on_note_kill(int p_chan,int p_note) {


	if (channel[p_chan].voice_list[p_note]==NULL) {

          	ERROR("Fatal error!! killing a note i dont have?! (this is a bug!)");
	}

	channel[p_chan].voice_list[p_note]=NULL;
}


Midi_Control::Midi_Control(){

	event_count=0;
	drums_channel=9; //This is channel 10 in your sequencer
}
Midi_Control::~Midi_Control(){
}
