//
// C++ Interface: chorus_effect
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CHORUS_EFFECT_H
#define CHORUS_EFFECT_H

#include "plugins/effects/freeverb/revmodel.h"
#include "common/components/audio/effect.h"
#include <vector>
	using std::vector;
/**
@author Juan Linietsky
*/
class Chorus_Effect : public Effect {

	enum {

		BUFFER_EXTRA_ALLOCATON=30000
	};

        struct BridgeParam {

		int voices;
		int delay;
		int lfo_speed;
		int lfo_depth;
		int wet;
		int dry;
		int width;
	} bridge_parm,real_parm;

	Int_Property_Bridge bridge_voices;
	Int_Property_Bridge bridge_delay;
	Int_Property_Bridge bridge_lfo_speed;
	Int_Property_Bridge bridge_lfo_depth;
	Int_Property_Bridge bridge_wet;
	Int_Property_Bridge bridge_dry;
	Int_Property_Bridge bridge_width;

   	vector<Sint32> ringbuffer;

	int mix_freq;
	int buffer_mask;
	int buffer_bits;
	unsigned int buffer_index;
	double counter;

	void ensure_ringbuffer_size();

public:

	void reset();
        void process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq);
	string get_name();
	string get_display_name();
	list<Property_Bridge*> get_properties();

        static Effect * create_this() { return new Chorus_Effect; }

	Chorus_Effect();
	~Chorus_Effect();

};

#endif
