//
// C++ Implementation: effect_amp
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "effect_distort.h"


#define FIXED_BITS 8
#define FIXED_LENGTH (1<<FIXED_BITS)
#define FIXED_MASK (FIXED_LENGTH-1)

void Effect_Distort::reset() {


}


void Effect_Distort::process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq) {

	int multiplier;
	multiplier=(percent * FIXED_LENGTH) / 100;
	int limit;
	limit = (100-clip) * 65536 / 100;
	if (limit>=65536)
		limit=65535;
	limit<<=15;

	Uint64 low_limit=-limit;
	Uint64 high_limit=limit;

	if (p_stereo_samples)
		p_length*=2;

	Uint64	val;
	while (p_length--) {

		val = *p_buffer;

		val>>=FIXED_BITS;
		val*=multiplier;
		if (val<low_limit)
			val=low_limit;
		if (val>high_limit)
			val=high_limit;
		*p_buffer++ = val;
	}

}


string Effect_Distort::get_name() {

	return "distort";
}
string Effect_Distort::get_display_name() {

	return "Distort";
}
list<Property_Bridge*> Effect_Distort::get_properties() {

	list<Property_Bridge*> pipio;
	pipio.push_back(&prop_percent);
	pipio.push_back(&prop_clip);
	return pipio;
}

Effect_Distort::Effect_Distort() : prop_percent("amp%",&percent,0,32767,"amp"), prop_clip("Clip%",&clip,0,100,"clip") {

	percent=100;
	clip=0;
}


Effect_Distort::~Effect_Distort()
{
}


