//
// C++ Implementation: effect_echo
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "effect_echo.h"


void Effect_Echo::reset() {

	memset(&buffer[0],0,buffer.size()*sizeof(Sint32));
	buffer_pos=0;

}
inline static double get_samples_from_msecs(double p_msecs,double p_mixfreq) {

	return (p_msecs*p_mixfreq)/1000.0;

}
void Effect_Echo::check_buffer_length() {

	int desired_length=get_samples_from_msecs(delay,mix_freq)*2; //stereo

        if (desired_length!=buffer.size()) {

		buffer.resize(desired_length);
		reset();
	}

}

void Effect_Echo::process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq) {

	mix_freq=p_buffer_freq;
	check_buffer_length();

	//int multiplier=(feedback*65535)/100;
	int buflength=buffer.size();

	sample_32s_t width=separation*65535/64;
	sample_32s_t width_inv=(64-separation)*65535/64;
	sample_32s_t aux;
	width=feedback*width/100;
	width_inv=feedback*width_inv/100;

	Sint32 *dst_buffer=&buffer[0];
        for (int i=0;i<p_length;i++) {

		Sint32 val_l=dst_buffer[buffer_pos];
		Sint32 val_r=dst_buffer[buffer_pos+1];
		Sint32 buf_l=p_buffer[i*2];
		Sint32 buf_r=p_buffer[i*2+1];
		p_buffer[i*2]+=val_l;
		p_buffer[i*2+1]+=val_r;

		val_l>>=16;
		val_r>>=16;
		buf_l>>=16;
		buf_r>>=16;

		val_l+=buf_l;
		val_r+=buf_r;
//		val_l*=multiplier;
//		val_r*=multiplier;

		aux=val_r;

		val_r=val_r*width_inv +val_l*width;
		val_l=aux*width +val_l*width_inv;

		dst_buffer[buffer_pos]=val_l;
		dst_buffer[buffer_pos+1]=val_r;

		buffer_pos+=2;
		buffer_pos%=buflength;
	}
}

string Effect_Echo::get_name() {

	return "echo";
}

string Effect_Echo::get_display_name() {

	return "Echo";
}

list<Property_Bridge*> Effect_Echo::get_properties() {

	list<Property_Bridge*> copoto;
        copoto.push_back(&prop_delay);
        copoto.push_back(&prop_separation);
        copoto.push_back(&prop_feedback);
	return copoto;


}


Effect_Echo::Effect_Echo() :

	prop_delay("Delay(ms)",&delay,1,500,"delay"),
	prop_separation("Separation",&separation,-64,64,"separation"),
	prop_feedback("Feedback%",&feedback,0,80,"feedback") {

	feedback=30;
	delay=250;
	separation=0;

}

Effect_Echo::~Effect_Echo() {

}

