//
// C++ Implementation: freeverb_effect
//
// Description:
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "freeverb_effect.h"


#define REVERB_SOFT_BITS 16

void Freeverb_Effect::check_params_changed() {

	if (
		(current_parm.room_size==bridge_parm.room_size) &&
		(current_parm.damp==bridge_parm.damp) &&
		(current_parm.wet==bridge_parm.wet) &&
		(current_parm.width==bridge_parm.width) &&
		(current_parm.dry==bridge_parm.dry) &&
		(current_parm.old_freq==bridge_parm.old_freq) )
			return;


	current_parm=bridge_parm;


	float room=(float)current_parm.room_size/127.0;
//	room*=(float)current_parm.old_freq/44100.0f; //make it independent to sampling rate? This just helps a bit i think
	freeverb.setroomsize(room);
        freeverb.setdamp((float)current_parm.damp/127.0);
	freeverb.setwet((float)current_parm.wet/127.0);
	freeverb.setdry((float)current_parm.dry/127.0);
	freeverb.setwidth((float)current_parm.width/127.0);

//	freeverb.mute();

}
void Freeverb_Effect::reset() {

	freeverb.mute();
}

void Freeverb_Effect::process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq) {


	bridge_parm.old_freq=p_buffer_freq;
	check_params_changed();
        float soft=0.65f;
	sample_32s_t* buffer=p_buffer;

	while (p_length) {

		int amount=(p_length>INTERNAL_BUFFER_SIZE)?INTERNAL_BUFFER_SIZE:p_length;

		float *buf_in_r_ptr=&buffer_in_r[0];
		float *buf_in_l_ptr=&buffer_in_l[0];
		float *buf_out_r_ptr=&buffer_out_r[0];
		float *buf_out_l_ptr=&buffer_out_l[0];
		sample_32s_t* read_ptr=buffer;
		for (int i=0;i<amount;i++) {

			buf_in_l_ptr[i]=soft * (float)(*(read_ptr++) >> REVERB_SOFT_BITS);
			buf_in_r_ptr[i]=soft * (float)(*(read_ptr++) >> REVERB_SOFT_BITS);
		}

		freeverb.processreplace(buf_in_l_ptr, buf_in_r_ptr,buf_out_l_ptr, buf_out_r_ptr,amount,1);

		for (int i=0;i<amount;i++) {

			*buffer++ =lrintf(buf_out_l_ptr[i]) << REVERB_SOFT_BITS;
			*buffer++ =lrintf(buf_out_r_ptr[i]) << REVERB_SOFT_BITS;
		}
		p_length-=amount;
	}
}


string Freeverb_Effect::get_display_name() {

	return "Reverb";
}

string Freeverb_Effect::get_name() {

	return "freeverb";
}

list<Property_Bridge*> Freeverb_Effect::get_properties() {

	list<Property_Bridge*> props;

	props.push_back(&room_size_bridge);
	props.push_back(&damp_bridge);
	props.push_back(&wet_bridge);
	props.push_back(&dry_bridge);
	props.push_back(&width_bridge);

	return props;
}



Freeverb_Effect::Freeverb_Effect() :

	room_size_bridge("Room Size",&bridge_parm.room_size,0,127,"room_size"),
	damp_bridge("Damping",&bridge_parm.damp,0,127,"damping"),
	wet_bridge("Wet Amount",&bridge_parm.wet,0,127,"wet_mount"),
	dry_bridge("Dry Amount",&bridge_parm.dry,0,127,"dry_amount"),
	width_bridge("Width",&bridge_parm.width,0,127,"width") {

        buffer_in_r.resize(INTERNAL_BUFFER_SIZE);
        buffer_in_l.resize(INTERNAL_BUFFER_SIZE);
        buffer_out_r.resize(INTERNAL_BUFFER_SIZE);
        buffer_out_l.resize(INTERNAL_BUFFER_SIZE);

	bridge_parm.room_size=105;
	bridge_parm.damp=80;
	bridge_parm.wet=80;
	bridge_parm.dry=0;
	bridge_parm.width=110;
	bridge_parm.old_freq=0;

	current_parm.room_size=-1;
	current_parm.damp=-1;
	current_parm.wet=-1;
	current_parm.dry=-1;
	current_parm.width=-1;
	current_parm.old_freq=-1;
	freeverb.setmode(0);
}




Freeverb_Effect::~Freeverb_Effect() {


}



