/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef HELPERS_H
#define HELPERS_H


//hardcoded for now!
#define FILTER_BITS 12
#define RAMP_BITS 11
#define RAMP_LENGTH (1<<11)

//This will not really happen if the sample is 16 bits, as it
//will be removed by the optimizer

#define DEPTH_SHIFT ( (sizeof(Depth)==1) ? 8 : 0 )


/* Since all resamplers will most likely share this, and this is the most critical section
  of the code (besides i cannot trust the compiler for inlining this properly)
  I am forced to go with a macro scheme to share the common parts of te resampling process.
*/

//need local variables in the stack, as the stack will be cached in a single cache line.
#define HELPER_INITIALIZE \
										\
		/*Precision template */						\
		Uint8 fractional_size=mixdata->fractional_size;			\
        	Depth *data_ptr=(Depth*)mixdata->sample->get_data_16();         \
		data_ptr+=mixdata->sample_offset >> fractional_size;		\
		sample_32s_t *dest_buffer=mixdata->dst_buff;			\
		/* Data handler */						\
        	register Sint32 final_data;                                     \
        	Sint32 send_l=mixdata->l_volume;                                \
        	Sint32 send_r=mixdata->r_volume;  				\
        	Sint32 send_l_prev=mixdata->l_volume_prev;                      \
        	Sint32 send_r_prev=mixdata->r_volume_prev;  			\
        	Sint32 segment_offset=mixdata->sample_offset&( ((Sint64)1<<(Sint64)fractional_size)-1); \
        	Sint32 increment=mixdata->increment;				\
        	/* Filter Setup */                                              \
		Sint32 hist_1=mixdata->filter.hist1;				\
		Sint32 hist_2=mixdata->filter.hist2;                            \
		Sint32 gain=mixdata->filter.gain;	                        \
		Sint32 coef1=mixdata->filter.coef1;	                        \
		Sint32 coef2=mixdata->filter.coef2;	                        \
        	                                                                \
        	/* Ramp Setup */                                                \
		double ramp_l_base=(float)(send_l-send_l_prev)/(float)mixdata->samples_to_mix; \
		double ramp_r_base=(float)(send_r-send_r_prev)/(float)mixdata->samples_to_mix; \
		Sint32 ramp_l=lrintf(ramp_l_base*RAMP_LENGTH);                          \
		Sint32 ramp_r=lrintf(ramp_r_base*RAMP_LENGTH);                          \
		send_l_prev<<=RAMP_BITS;						\
		send_r_prev<<=RAMP_BITS;						\
		int sample_increment_threshold=(abs(increment)>>fractional_size)?1:((1<<fractional_size)/abs(increment));	\
		sample_increment_threshold+=5;	 /*just in case?*/		\
        	                                                                \
        	Uint32 samples_to_mix=mixdata->samples_to_mix;                  \
		if (sample_increment_threshold>samples_to_mix) sample_increment_threshold=samples_to_mix;

/* Using 8 simply to allow for more complex interpolation methods */

#define CHECK_END_OF_SAMPLE_AT_MIX_END  ((mixdata->increment>0) && ( (((Sint64)mixdata->sample_offset+((Sint64)mixdata->increment*(Sint64)samples_to_mix))>>fractional_size) >= (Uint64)(mixdata->sample->get_size()-sample_increment_threshold)))
#define CHECK_END_OF_SAMPLE_AT_MIX_BEGIN ((mixdata->increment<0) && ( (((Sint64)mixdata->sample_offset)>>fractional_size) >= (Uint64)(mixdata->sample->get_size()-sample_increment_threshold)))

#define HELPER_BEGIN_LOOP	\
				\
		while(samples_to_mix--) {




#define HELPER_PERFORM_DEPTH_SHIFT 	\
					\
			final_data<<=DEPTH_SHIFT;

#define HELPER_PERFORM_VOLUME_RAMP 	\
					\
			send_l_prev+=ramp_l; 		\
			send_r_prev+=ramp_r; 		\
			send_l=send_l_prev>>RAMP_BITS; 	\
			send_r=send_r_prev>>RAMP_BITS; 	\


#define HELPER_PERFORM_FILTERING 	\
					\
		/* This will also be removed if compiling with no filter version */				\
			if (FILTER_VERSION) {										\
															\
				final_data = (final_data * gain + hist_1 * coef1 + hist_2 * coef2) >> FILTER_BITS; 	\
				hist_2=hist_1;                                                             		\
				hist_1=final_data; 									\
			}

#define HELPER_PERFORM_MIXDOWN 	\
                                \
			*dest_buffer++ += send_l * final_data;					\
			*dest_buffer++ += send_r * final_data;                              	\
			segment_offset+=increment;                                		\

#define HELPER_END_LOOP	\
                        \
		}


#define HELPER_MIX_ONE_RAW_SAMPLE \
	final_data=data_ptr[segment_offset>>fractional_size];	\
	HELPER_PERFORM_DEPTH_SHIFT				\
	HELPER_PERFORM_VOLUME_RAMP				\
        HELPER_PERFORM_FILTERING				\
	HELPER_PERFORM_MIXDOWN





#define HELPER_UPDATE_MIXDATA_STATUS	\
					\
		mixdata->filter.hist1=hist_1;        						\
		mixdata->filter.hist2=hist_2;                                                   \
		mixdata->sample_offset+=segment_offset;                                           \



#endif


