/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
//
// C++ Implementation: cpp
//
// Description:
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "interface__QT/interface.h"
#include "interface__QT/mdi_main_window.h"
#include <qapplication.h>
#include <qpushbutton.h>
#include <qfont.h>
#include "components/audio/sound_driver_manager.h"
#include "components/audio/sound_driver_dummy.h"
#include "os/path_data.h"
#include "drivers/posix/sound_driver_oss.h"
#include "drivers/posix/sound_driver_jack.h"
#include "drivers/posix/mutex_lock_pthreads.h"
#include "drivers/rtaudio/sound_driver_rtaudio.h"
#include "drivers/win32/sound_driver_winmm.h"
#include "components/data/keyboard_input.h"
#include "components/audio/effect_source_manager.h"
#include "components/audio/effect_source_internal.h"
//#include "plugins/effects/custom/dummy_effect.h"
#include "plugins/effects/custom/freeverb_effect.h"
#include "plugins/effects/custom/chorus_effect.h"
#include "plugins/effects/custom/effect_amp.h"
#include "plugins/effects/custom/effect_echo.h"
#include "plugins/effects/custom/effect_stereo_enhancer.h"
#include "plugins/effects/custom/effect_distort.h"
#include "plugins/effects/ladspa/ladspa_effect_source.h"
#include "plugins/resamplers/resampler_dummy.h"

#include <unistd.h>

Sound_Driver_Manager driver_manager; //this is global yo :)

#ifdef POSIX_ENABLED

	#define SLEEP_MSECS(m_arg) usleep(m_arg*1000)
#endif

static bool quit_request=false;
static bool thread_finished=false;


void* audio_thread_cbk(void *data) {

	while(!quit_request)
		if (driver_manager.external_poll_active_driver())
			SLEEP_MSECS(1);

	thread_finished=true;
}


#ifdef WIN32_ENABLED

static const char* DIR_SEPARATOR= "\\";
static const char* CONFIG_FILE= "cheese_qt.cfg";

#endif
#ifdef POSIX_ENABLED

static const char* CONFIG_FILE= ".cheesetracker_QT";
static const char* DIR_SEPARATOR= "/";

#endif

void display_help() {

	printf("Usage: cheesetracker_qt [flags] [songs]\n");
	printf("Flags:\n");
	//printf("\t--help shows this help\n");
	printf("\t--schedfifo runs at schedfifo priority (suid root needed)\n");
}

int main( int argc, char **argv )
{

#ifdef POSIX_ENABLED

	Mutex_Lock_Pthreads variables_lock;
	Mutex_Lock_Pthreads pattern_lock;
	Mutex_Lock_Pthreads driver_lock;
	Mutex_Lock_Pthreads info_lock;

	pthread_t player_thread;
	pthread_attr_t thread_attr;
#endif

	driver_manager.set_variables_lock(&variables_lock);
	driver_manager.set_driver_lock(&driver_lock);
	Pattern::data_lock=&pattern_lock;

//	driver_oss.link_to_mixer(&mixer);
#ifdef OSS_ENABLED
	Sound_Driver_OSS driver_oss;
	driver_manager.register_driver(&driver_oss);
#endif

#ifdef RTAUDIO_ENABLED
	Sound_Driver_RtAudio driver_rtaudio;
	driver_manager.register_driver(&driver_rtaudio);
#endif

#ifdef JACK_ENABLED
	Sound_Driver_JACK driver_jack;
	driver_manager.register_driver(&driver_jack);
#endif

#if ((CYGWIN_ENABLED) || (WIN32_ENABLED))

	Sound_Driver_WinMM driver_winmm;
	driver_manager.register_driver(&driver_winmm);
#endif
	Sound_Driver_Dummy driver_dummy;

	driver_manager.register_driver(&driver_dummy);

	Resampler_Manager resampler_manager;
	Resampler_Raw resampler_raw;
	Resampler_Linear resampler_linear;
	Resampler_Dummy resampler_dummy;
	//resampler_manager.register_resampler(&resampler_dummy);
	resampler_manager.register_resampler(&resampler_raw);
	resampler_manager.register_resampler(&resampler_linear);

	Effect_Source_Manager effect_source_manager_singleton;
	Effect_Source_Internal effect_source_internal;
	effect_source_manager_singleton.register_effect_source(&effect_source_internal);
//	effect_source_internal.register_effect_constructor("Dummy","dummy",&Dummy_Effect::create_this );
	effect_source_internal.register_effect_constructor("Amplifier","amplifier",&Effect_Amp::create_this );
	effect_source_internal.register_effect_constructor("Distort","distort",&Effect_Distort::create_this );
	effect_source_internal.register_effect_constructor("Echo","echo",&Effect_Echo::create_this );
	effect_source_internal.register_effect_constructor("Stereo Enhancer","stereo_enhancer",&Effect_Stereo_Enhancer::create_this );

	effect_source_internal.register_effect_constructor("Chorus","chorus",&Chorus_Effect::create_this );
	effect_source_internal.register_effect_constructor("Reverb","freeverb",&Freeverb_Effect::create_this );
#ifdef LADSPA_ENABLED
	LADSPA_Effect_Source effect_source_ladspa;
	effect_source_manager_singleton.register_effect_source(&effect_source_ladspa);

#endif

        Keyboard_Input keyboard_input; //singleton instance here!

	QApplication a( argc, argv );

	MDI_Main_Window main_window;
	main_window.set_sound_driver_manager(&driver_manager);
	main_window.set_info_lock(&info_lock);

	a.setMainWidget( &main_window);

	string settings_file=Path_Data::get_home_dir()+DIR_SEPARATOR+(string)CONFIG_FILE;
        if (Path_Data::file_exists(settings_file)) {

		ConfigHandler config;
		config.set_header_check("CHEESETRACKER_CONFIG");
		config.load_from_text(settings_file);

        	main_window.get_settings_window()->load_settings(&config);
	} else {

		printf("Warning, config file not found at %s. One will be created on exit!\n",settings_file.c_str());
		//should add something like "first time or stuff :)
		//initializing default driver since no config found!
		driver_manager.set_active_driver(1);
		driver_manager.reset_active_driver();
	}

	main_window.show();

	//start the thread

	int priority=sched_get_priority_max(SCHED_RR);

	for (int i=1;i<argc;i++) {


		if ((string)argv[i]=="--help") {
			display_help();
			exit(255);
		} else if ((string)argv[i]=="--schedfifo") {
			printf("Warning, running in SCHEDFIFO mode!\n");
			priority=sched_get_priority_max(SCHED_FIFO);
		} else {

			main_window.open_song(argv[i]);
		}
	}

#ifdef POSIX_ENABLED

	pthread_attr_init(&thread_attr);
	sched_param thread_sched_param;
	memset(&thread_sched_param,0,sizeof(thread_sched_param));
	thread_sched_param.sched_priority=priority;
        pthread_attr_setschedparam (&thread_attr,&thread_sched_param);
	pthread_create(&player_thread,&thread_attr,&audio_thread_cbk,NULL);
#endif

	int result=a.exec();


	{
		ConfigHandler config;
		config.set_header_check("CHEESETRACKER_CONFIG");
		main_window.get_settings_window()->save_settings(&config);

		config.save_to_text(settings_file);
		printf("Saving settings to %s\n",settings_file.c_str());

	}

	//quit requested, cleaning up!

	quit_request=true;
	while(!thread_finished) {
		SLEEP_MSECS(1);
	}

	return result;
}

