/*
 * AUTHOR: Pedro Lineu Orso                          pedro.orso@gmail.com
 *                                                             1998, 2006
 * CHETCPASSWD System Password Change Utility http://sarg.sourceforge.net
 * ----------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void UserForm()
{

   printf("Content-type: text/html\n");
   puts("\n");
   printf("<html>\n");
   printf("<head>\n");
   printf("<title>%s</title>\n",Title);
   printf("</head>\n");
   printf("<style>\n");
   printf(".body {margin:0px; background-color:%s}\n",BackgroundColor);
   printf(".title {font-family:%s;font-size:%s;color:%s;text-align:center;padding:10px}\n", \
		FontFamily,TitleFontSize,TitleFontColor);
   printf(".subtitle {font-family:%s;font-size:%s;color:%s;text-align:center;padding:5px}\n", \
		FontFamily,SubTitleFontSize,SubTitleFontColor);
   printf(".data {font-family:%s;font-size:%s;color:%s;text-align:left,padding:5px}\n", \
		FontFamily,FontSize,FontColor);
   printf(".field {font-family:%s;font-size:%s;color:%s;text-align:right,padding:5px}\n", \
		FontFamily,FieldsFontSize,FieldsFontColor);
   printf(".input {font-family:%s;font-size:%s;color:%s;text-align:right,padding:5px}\n", \
		FontFamily,InputFontSize,InputFontColor);
   printf(".inst {font-family:%s;font-size:%s;color:%s;text-align:right,padding:5px;border:0}\n", \
		FontFamily,InstructionsFontSize,InstructionsFontColor);
   printf(".arrow {font-family:%s;font-size:%s;color:%s;text-align:left}\n", \
		FontFamily,ArrowSize,ArrowColor);
   printf(".bottom {font-family:%s;font-size:%s;color:%s;text-align:center}\n", \
		FontFamily,BottomFontSize,BottomFontColor);
   printf(".info {font-family:%s;font-size:8px}\n", \
		FontFamily);
   printf("</style>\n");
   printf("<body class=\"body\">\n");
   printf("<center><table class=\"data\">\n");
   if(strlen(LogoImage) > 1) {
      printf("<tr><td align=\"center\"><img src=\"%s\" width=\"%s\" height=\"%s\"></td></tr>\n", \
		LogoImage,LogoImageWidth,LogoImageHeight);
      printf("<tr><td class=\"title\">%s</td></tr>\n",Title);
   } else
      printf("<tr><th class=\"title\">%s\n",Title);
   printf("<tr><th class=\"subtitle\">%s\n",SubTitle);
   printf("</table></center>\n");
   printf("<br>\n");
   printf("<center><table class=\"data\">\n");
   printf("<tr><td class=\"inst\"><b>%s</b><br><br></td></tr>\n",text[24]);
   printf("<tr><td class=\"data\">&nbsp;&nbsp;<font class=\"arrow\">&rArr;</font>&nbsp;%s</td></tr>\n",text[25]);
   printf("<tr><td class=\"data\">&nbsp;&nbsp;<font class=\"arrow\">&rArr;</font>&nbsp;%s</td></tr>\n",text[26]);
   sprintf(warea,"%s",text[27]);
   sprintf(warea,warea,PasswordMinimumLenght);
   printf("<tr><td class=\"data\">&nbsp;&nbsp;<font class=\"arrow\">&rArr;</font>&nbsp;%s</td></tr>\n",warea);
   printf("<tr><td class=\"data\">&nbsp;&nbsp;<font class=\"arrow\">&rArr;</font>&nbsp;%s</td></tr>\n",text[28]);
   printf("</table>\n");
   printf("<br><br>\n");
   printf("<form action='chetcpasswd.cgi' method=POST>\n");
   printf("<center>\n");
   printf("<table class=\"field\">\n");
   printf("<tr><td class=\"field\">%s\n",text[29]);
   printf("<td>&nbsp;&nbsp;&nbsp;</td><td class=\"input\"><input class=\"input\" type=text name=user size=\"15\" maxlength=\"%s\">\n",MaxUserLen);
   printf("<tr><td class=\"field\">%s\n",text[30]);
   printf("<td>&nbsp;&nbsp;&nbsp;</td><td class=\"input\"><input class=\"input\" type=password name=old_pw size=\"15\" maxlength=\"%s\">\n",MaxPwdLen);
   printf("<tr><td class=\"field\">%s\n",text[31]);
   printf("<td>&nbsp;&nbsp;&nbsp;</td><td class=\"input\"><input class=\"input\" type=password name=new_pw1 size=\"15\" maxlength=\"%s\">\n",MaxPwdLen);
   printf("<tr><td class=\"field\">%s\n",text[32]);
   printf("<td>&nbsp;&nbsp;&nbsp;</td><td class=\"input\"><input class=\"input\" type=password name=new_pw2 size=\"15\" maxlength=\"%s\">\n",MaxPwdLen);
   printf("</table>\n");
   printf("<br><br>\n");
   printf("<input class=\"bottom\" type=submit name=change value='%s'>\n",text[33]);
   printf("<input class=\"bottom\" type=reset name=reset value='%s'>\n",text[34]);
   printf("<input class=\"bottom\" type=submit name=\"cancel\" value=\"%s\">\n",text[35]);
   printf("</center>\n");
   printf("</form>\n");
   if(strcmp(VersionInfo,"on") == 0 || strcmp(VersionInfo,"ON") == 0)
      printf("<p class=\"info\"><a href='%s'>%s-%s</a></p>\n",URL,PGM,VERSION);
   printf("</body>\n");
   printf("</html>\n");
}
