#!/bin/bash
# install childsplay.  
# Be aware that childsplay probably won't work when you edit this file :-(
# As of 11/2004 childsplay will be converted to follow the File System
# Hierarchy (FSH).
# As a result it won't be possible to choose a install location and
# you just should let this script do his thing.
# However, you can change the "prefix" to "/usr" and childsplay will still
# work. Set it to anything else and your on your own.
  
PREFIX=/usr/local

#################################################################
# DON'T EDIT BEHIND THIS POINT 
#################################################################
if [ $* ]
then PREFIX=$*
fi
echo "PREFIX=$PREFIX"

PYTHON=`which python`

EXECDIR=$PREFIX/bin
LOCALEDIR=$PREFIX/share/locale
ASSETMLDIR=/usr/share/assetml
SCOREDIR=/var/games
SCOREFILE=$SCOREDIR/childsplay.score
DOCDIR=$PREFIX/share/doc/childsplay
MANDIR=$PREFIX/man/man6
CPDIR=$PREFIX/lib/games/childsplay
SHAREDIR=$PREFIX/share/childsplay
BINDIR=$PREFIX/games
LIBDIR=$CPDIR/lib
MODULESDIR=$LIBDIR
SHARELIBDATADIR=$SHAREDIR/lib
SHAREDATADIR=$SHAREDIR/Data
RCDIR=$SHARELIBDATADIR/ConfigData

HOME_DIR_NAME=.childsplay
CHILDSPLAYRC=childsplayrc

OLDCPDIR=$PREFIX/games/childsplay

echo "Making directorys"
mkdir -vp $CPDIR
mkdir -vp $CPDIR/lib
mkdir -vp $DOCDIR
mkdir -vp $LOCALEDIR
mkdir -vp $ASSETMLDIR
mkdir -vp $SCOREDIR
mkdir -vp $MANDIR
mkdir -vp $SHAREDIR
mkdir -vp $SHAREDATADIR
mkdir -vp $SHARELIBDATADIR
mkdir -vp $BINDIR
mkdir -vp $EXECDIR

set -e

CWD=`pwd`
USERID=`id | sed -e 's/).*//; s/^.*(//;'`
if [ "$USERID" != "root" ]; then
    echo " You must be root to install the plugins"
    echo " exit"
    exit 1
fi
echo " Looking for obsolete childsplay files in $OLDCPDIR"
if [ -e $OLDCPDIR ] && [ -d $OLDCPDIR ]
then rm -fr $OLDCPDIR
     echo " Old files removed"
fi

echo -e "\n>>>>>>>>>>> Install childsplay >>>>>>>>>>>>>>>>>>>>"
echo " Installing in $PREFIX"

## Begin install
echo " Copy libraries"
for DIR in `ls $CWD/lib`
do 
    if [ -d $CWD/lib/$DIR ]
	 then cp -rf $CWD/lib/$DIR $SHARELIBDATADIR
	 else cp -f $CWD/lib/$DIR $CPDIR/lib
    fi
done

cp -f $CWD/*.py $CPDIR/

echo " Copy misc. data files"
for FILE in `ls $CWD/Data`
do 
    if [ -f $CWD/Data/$FILE ]
	 then cp -f $CWD/Data/$FILE $SHAREDATADIR/
    fi
done

cp -rf $CWD/Data/icons $SHAREDATADIR/
cp -f $CWD/Data/childsplay.score $SCOREDIR/
chmod 0666 $SCOREDIR/childsplay.score
## As we are on *nix we must move the score file and replace it with a symlink 
mv -f $SHAREDATADIR/childsplay.score $SHAREDATADIR/childsplay.score.org
## Childsplay looks in his Data dir for the score file
ln -s $SCOREDIR/childsplay.score $SHAREDATADIR/childsplay.score

echo " Copy assetml files"
cp -rf $CWD/assetml/* $ASSETMLDIR/

echo " Copy locale files"
cp -rf $CWD/locale/* $LOCALEDIR/

echo " Copy manpage"
cp -f $CWD/man/* $MANDIR/

echo " Copy docs"
cp -rf $CWD/doc/* $DOCDIR/

echo " Copy executable and setting permissions."
cp -f $CWD/childsplay.sh $BINDIR/childsplay
cp -f $CWD/childsplay.sh $EXECDIR/childsplay
chmod +x $BINDIR/childsplay
chmod +x $EXECDIR/childsplay

chmod +x $CPDIR/childsplay.py
chmod +x $CPDIR/letters-trans.py

#echo " Looking for the old executable, if any"
#if [ -e /usr/local/bin/childsplay ]
#then rm -f /usr/local/bin/childsplay
#    echo "found and removed"
#fi

echo " Setting the base path in childsplay to $PREFIX"
echo "## Automated file please do not edit" > $CPDIR/BASEPATH.py
echo "BASEPATH=\"$PREFIX\"" >> $CPDIR/BASEPATH.py
echo "EXECDIR=\"$EXECDIR\"" >> $CPDIR/BASEPATH.py
echo "LOCALEDIR=\"$LOCALEDIR\"" >> $CPDIR/BASEPATH.py
echo "ASSETMLDIR=\"$ASSETMLDIR\"" >> $CPDIR/BASEPATH.py
echo "SCOREDIR=\"$SCOREDIR\"" >> $CPDIR/BASEPATH.py
echo "SCOREFILE=\"$SCOREFILE\"" >> $CPDIR/BASEPATH.py
echo "DOCDIR=\"$DOCDIR\"" >> $CPDIR/BASEPATH.py
echo "MANDIR=\"$MANDIR\"" >> $CPDIR/BASEPATH.py
echo "CPDIR=\"$CPDIR\"" >> $CPDIR/BASEPATH.py
echo "SHAREDIR=\"$SHAREDIR\"" >> $CPDIR/BASEPATH.py
echo "BINDIR=\"$BINDIR\"" >> $CPDIR/BASEPATH.py
echo "LIBDIR=\"$LIBDIR\"" >> $CPDIR/BASEPATH.py
echo "MODULESDIR=\"$MODULESDIR\"" >> $CPDIR/BASEPATH.py
echo "SHARELIBDATADIR=\"$SHARELIBDATADIR\"" >> $CPDIR/BASEPATH.py
echo "SHAREDATADIR=\"$SHAREDATADIR\"" >> $CPDIR/BASEPATH.py
echo "RCDIR=\"$RCDIR\"" >> $CPDIR/BASEPATH.py
echo "CHILDSPLAYRC=\"$CHILDSPLAYRC\"" >> $CPDIR/BASEPATH.py
echo "HOME_DIR_NAME=\"$HOME_DIR_NAME\"" >> $CPDIR/BASEPATH.py
echo "" >> $CPDIR/BASEPATH.py

echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""
echo "  Instalation of childsplay complete"
echo "  The childsplay executable is $BINDIR/childsplay"
echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo " One thing left todo..."
echo " Translating words"
$PYTHON $CPDIR/letters-trans.py $ASSETMLDIR
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo " Be sure to read the README-MEMORY file on how you can"
echo " use your own pictures in the memory game."
echo ""
echo " Have fun, and don't forget that for a program like this"
echo " translations are very important."
echo " So if your langauge is not yet supported and you want to"
echo " give something back to the free-source community."
echo " Ask info on how to help:"
echo " childsplay@users.sourceforge.net"
echo ""
echo " Enjoy."
