# -*- coding: utf-8 -*-
#~ /***************************************************************************
 #~ *            CPConstants.py
 #~ *
 #~ *  Mon Feb 23 11:21:36 2004
 #~ *  Copyright  2004  Stas Z
 #~ *  stasz@linux.isbeter.nl
 #~ ****************************************************************************/
CPC_DEBUG = 0
## CPConstants
## This file provides constants used by all the childsplay modules.

## The module "BASEPATH" is created by the installation proces.

import os,sys
        
## paths ##
import BASEPATH

BASEDIR = BASEPATH.CPDIR
DATADIR = BASEPATH.SHAREDATADIR
MODULESDATADIR = BASEPATH.SHARELIBDATADIR
LOCALEDIR = BASEPATH.LOCALEDIR
ASSETMLROOT = BASEPATH.ASSETMLDIR
SCOREFILE = BASEPATH.SCOREFILE
CHILDSPLAYRC = BASEPATH.CHILDSPLAYRC
LIBDIR = BASEPATH.LIBDIR
MODULES = BASEPATH.MODULESDIR

RCDIR = BASEPATH.RCDIR

HOME_DIR_NAME = BASEPATH.HOME_DIR_NAME

# Check if there's a childsplay dir in the home directory
HOMEDIR = os.path.join(os.environ['HOME'],HOME_DIR_NAME)

# this is the directory tree in HOME_DIR_NAME.
# Names seperated by commas are the names from which directories are created
# if a name are followed by a ; then the next name is considered a sub dir.
# Example: 'childsplay,memory;my_images', will become
# $HOME/.childsplay/childsplay/
# $HOME/.childsplay/memory/my_images/
HOME_DIR_TREE = 'childsplay,ConfigData,memory;my_images'


##  flags ##
MONITOR = None # Special monitor plugin, optional, future use
RCFILES = None # Can we use configuration files
SPLASH = True # do we want a splash  
helptext = "Not much help here yet, look at the manpage and docs."

## fribidi support. Used for RTL locales
# This is to signal that we running under a RTL locale like Hebrew or Arabic
# Only Hebrew is supported until now
try:
    import pyfribidi# only needed for RTL languages
except ImportError:
    if CPC_DEBUG:
        print "I can't find pyfribidi."
    pyfribidi = None

LOCALE_RTL = None

# Hash tables used to provide different keyboard layouts for RTL languages
# and Russian.
# See the 'map_keys' function on possible usage.
he_key_map={
u'Q':u'/',
u'W':u'\'',
u'E':u'ק',
u'R':u'ר',
u'T':u'א',
u'Y':u'ט',
u'U':u'ו',
u'I':u'ן',
u'O':u'ם',
u'P':u'פ',
u'[':u']',
u']':u'[',
u'A':u'ש',
u'S':u'ד',
u'D':u'ג',
u'F':u'כ',
u'G':u'ע',
u'H':u'י',
u'J':u'ח',
u'K':u'ל',
u'L':u'ך',
u';':u'ף',
u'\'':u',',
u'Z':u'ז',
u'X':u'ס',
u'C':u'ב',
u'V':u'ה',
u'B':u'נ',
u'N':u'מ',
u'M':u'צ',
u',':u'ת',
u'.':u'ץ',
u'/':u'.'
}

ar_key_map={
u'Q':u'ض',
u'W':u'ص',
u'E':u'ث',
u'R':u'ق',
u'T':u'ف',
u'Y':u'غ',
u'U':u'ع',
u'I':u'ه',
u'O':u'خ',
u'P':u'ح',
u'[':u'ج',
u']':u'د',
u'A':u'ش',
u'S':u'س',
u'D':u'ي',
u'F':u'ب',
u'G':u'ل',
u'H':u'ا',
u'J':u'ت',
u'K':u'ن',
u'L':u'م',
u';':u'ك',
u'\'':u'ط',
u'Z':u'<',
u'X':u'ئ',
u'C':u'ء',
u'V':u'ؤ',
u'B':u'ر',
u'N':u'ﻻ',
u'M':u'ى',
u',':u'ة',
u'.':u'و',
u'/':u'ز'
}

ru_key_map={
u'Q':u'й',
u'W':u'ц',
u'E':u'у',
u'R':u'к',
u'T':u'е',
u'Y':u'н',
u'U':u'г',
u'I':u'ш',
u'O':u'щ',
u'P':u'з',
u'[':u'х',
u']':u'ъ',
u'A':u'ф',
u'S':u'ы',
u'D':u'в',
u'F':u'а',
u'G':u'п',
u'H':u'р',
u'J':u'о',
u'K':u'л',
u'L':u'д',
u';':u'ж',
u'\'':u'э',
u'Z':u'я',
u'X':u'ч',
u'C':u'с',
u'V':u'м',
u'B':u'и',
u'N':u'т',
u'M':u'ь',
u',':u'б',
u'.':u'ю',
u'/':u'.'
}






