/*
 * Camera.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  Camera.cpp  
  
  Alles, was in Camera.hpp kein Template ist.
*/
#include "Camera.hpp"

void list (TNT::Array1D<XYindex> A)
{
  printf ("Array1D[ %i ]:\n", A.dim());
  for (int i=0; i < A.dim(); i++)
    printf ("%3i:  (%i, %i)\n", i, A[i].x, A[i].y);
}

void list (TNT::Array2D<unsigned char> A)
{
  printf ("Array2D[ %i x %i ]:\n", A.dim1(), A.dim2());
  for (int i=0; i < A.dim1(); i++)
  { 
    printf ("%4i: ", i);
    for (int j=0; j < A.dim2(); j++)   printf (" %3i", A[i][j]);
    printf ("\n");
  }
}

