/*
 * br_types.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  @file br_types.hpp 
    
  Some globaly used types of the Bracketing_to_HDR project.
   No dependencies.
   
  OPEN: To put into namespace "br"?
*/
#ifndef br_types_hpp
#define br_types_hpp


/**
    Kuerzere bzw. bit-praezise Integer-Typen: 
     @TODO 'int32 == int' could be wrong on 32-bit machines. Fortunately `int32'
      and `uint32' not used till now.
*/
typedef int                 int32;
//typedef long long           int64;  // ISO C++ does not support `long long

typedef unsigned char       uint8;
typedef unsigned short      uint16;
typedef unsigned int        uint32;   // could be wrong on 32-bit machines
typedef unsigned long       ulong;
//typedef unsigned long long  uint64, ullong;


/**
    Type of our ID-numbers to identificate images:
*/ 
typedef unsigned  ImageID;

/**
    Genauigkeit, in der Float-Daten ausgetauscht werden
*/
typedef double  RealCom;     // "RealCommunication"

/**
    Genauigkeit, in der ernste Rechnungen intern ausgefuehrt werden:
*/
typedef double  RealNum;     // "RealNumeric"

/**
    Typ der Exposure Werte (noch am probieren)
*/
typedef double  Texpose;  

/**
    Type of plot data (needed by abstract interfaces of br_core classes to GUI)
*/
typedef double  PlotValueT;

/**
    RGB-Struktur mit alpha-Kanal:
*/
template <class T>          // Muss alpha ueberhaupt notwendig vom selben Typ
struct Rgba                 // wie die RGB's sein?
{                   
    T   r,g,b, alpha;
};

/**
    Struktur XYindex:
*/
struct XYindex 
{
    int x,y;

    XYindex ()    {}                // keine Nullung, Effizienz.
    XYindex (int _x, int _y) : x(_x), y(_y) {}
};


/**
    Rueckgabwert der Korrelationsfunktionen bei einem Fehler:
*/
#define CORR_RES_ERR    -2.0


#endif    // br_types_hpp

// END OF FILE

