#include "cp_types.h"
#include "cp_proto.h"

/* new combinatorics in pack q.
Each edge gets new vertex, each face broken into 4 faces.
Try to salvage old centers/radii. Propogate original overlaps
to new edges; new edge gets overlap of original edge it is
parallel to. (Note: orig verts end up with same vector of
overlaps they started with.) return 0 if fails.*/

struct New_verts
{
        int v,w;        /* endpoints of edge, v<w */
};

int hex_refine(struct p_data *q)
{
  int v,w,j,k,new,Num,count=1,j1,j2,j3,j4;
  struct New_verts *new_verts=NULL;
  struct p_data *p=NULL;
  struct K_data *pK_ptr1=NULL,*pK_ptr2=NULL;
  struct R_data *pR_ptr2=NULL;

  if (!q->status || !(pK_ptr1=(struct K_data *)
		      calloc((size_t)(q->nodecount+2),sizeof(struct K_data)))
      || !(p=(struct p_data *)calloc((size_t)1,sizeof(struct p_data)))
      ) goto ABORT;
  *p=*q;
  p->packK_ptr=pK_ptr1;
  Num=(q->facecount)+(q->nodecount)-(q->euler); /* number of edges */
  if (!alloc_pack_space(q,q->nodecount+Num,1))
    {
      sprintf(msgbuf,"hex_refine failed; space allocation problems.");
      emsg();
      goto ABORT;
    }
  pK_ptr2=q->packK_ptr;pR_ptr2=q->packR_ptr;
  for(j=1;j<=q->nodecount;j++) 
    /* copy needed as changes made. Make space twice as 
       long to hold crossref data for vert_for_edge. */
    {
      pK_ptr1[j]=pK_ptr2[j];
      pK_ptr1[j].flower=(int *)
	calloc((size_t)(2*pK_ptr1[j].num+2),sizeof(int));
      for (k=0;k<=pK_ptr1[j].num;k++)
	pK_ptr1[j].flower[k]=pK_ptr2[j].flower[k];
      free(pK_ptr2[j].flower);
      pK_ptr2[j].flower=NULL;
    }

  /* create new vertex indices and crossref data. */
  new_verts=(struct New_verts *)calloc((size_t)(Num+2),
				       sizeof(struct New_verts));
  for (v=1;v<q->nodecount;v++)
    for (k=0;k<(pK_ptr1[v].num+pK_ptr1[v].bdry_flag);k++)
      if ((w=pK_ptr1[v].flower[k])>v)
	{
	  new_verts[count].v=v;
	  new_verts[count].w=w;
	  pK_ptr1[v].flower[pK_ptr1[v].num+1+k]=q->nodecount+count;
	  count++;
	}
  /* NOTE: store new vertex number only when w>v */
  if (count!=(Num+1)) goto ABORT;

  /* fix original flowers */
  for (v=1;v<=q->nodecount;v++)
    {
      pK_ptr2[v].flower=(int *)
	calloc((size_t)(pK_ptr1[v].num+1),sizeof(int));
      for (j=0;j<=pK_ptr1[v].num;j++)
	if ((pK_ptr2[v].flower[j]=vert_for_edge(p,v,j)) < 0) 
	  goto ABORT;
      pR_ptr2[v].rad *= 0.5; 
      /* cut radius in half as first guess */
    }

  /* fix flowers of new verts. */
			
  for (new=q->nodecount+1;new<=q->nodecount+Num;new++) 
    {
      v=new_verts[new-q->nodecount].v;
      w=new_verts[new-q->nodecount].w;
      if ((pK_ptr1[v].bdry_flag && w==pK_ptr1[v].flower[0])
	  || (pK_ptr1[w].bdry_flag && v==pK_ptr1[w].flower[0])) 
	/* bdry edge? in one face only. */
	{
	  if (v==pK_ptr1[w].flower[0]) {j=v;v=w;w=j;}
	  /* now <v,w> is ctr-clkwise bdry edge */
	  pK_ptr2[new].flower=(int *)calloc((size_t)4,sizeof(int));
	  pK_ptr2[new].flower[0]=w;
	  pK_ptr2[new].flower[1]=vert_for_edge(p,w,pK_ptr1[w].num-1);
	  pK_ptr2[new].flower[2]=vert_for_edge(p,v,1);
	  pK_ptr2[new].flower[3]=v;
	  pK_ptr2[new].num=3;
	  pK_ptr2[new].bdry_flag=1;
	  if (q->overlap_status)
	    {
	      pK_ptr2[new].overlaps=(double *)calloc((size_t)4,
						     sizeof(double));
	      pK_ptr2[new].overlaps[0]=pK_ptr1[w].overlaps[pK_ptr1[w].num];
	      pK_ptr2[new].overlaps[1]=pK_ptr1[v].overlaps[1];
	      pK_ptr2[new].overlaps[2]=pK_ptr1[w].overlaps[pK_ptr1[w].num-1];
	      pK_ptr2[new].overlaps[3]=pK_ptr1[v].overlaps[0];
	    }
	}
      else
	{
	  pK_ptr2[new].flower=(int *)calloc((size_t)7,sizeof(int));
	  pK_ptr2[new].flower[0]=w;
	  j1=(nghb(p,w,v)-1+pK_ptr1[w].num)%(pK_ptr1[w].num);
	  pK_ptr2[new].flower[1]=vert_for_edge(p,w,j1);
	  j2=(nghb(p,v,w)+1);
	  pK_ptr2[new].flower[2]=vert_for_edge(p,v,j2);
	  pK_ptr2[new].flower[3]=v;
	  j3=(j2-2+pK_ptr1[v].num)%(pK_ptr1[v].num);
	  pK_ptr2[new].flower[4]=vert_for_edge(p,v,j3);
	  j4=(nghb(p,w,v)+1);
	  pK_ptr2[new].flower[5]=vert_for_edge(p,w,j4);
	  pK_ptr2[new].flower[6]=w;
	  pK_ptr2[new].num=6;
	  pK_ptr2[new].bdry_flag=0;
	  if (q->overlap_status)
	    {
	      pK_ptr2[new].overlaps=(double *)calloc((size_t)7,
						     sizeof(double));
	      pK_ptr2[new].overlaps[0]=
		pK_ptr2[new].overlaps[6]=
		pK_ptr1[w].overlaps[nghb(p,w,v)];
	      pK_ptr2[new].overlaps[1]=pK_ptr1[v].overlaps[j2];
	      pK_ptr2[new].overlaps[2]=pK_ptr1[w].overlaps[j1];
	      pK_ptr2[new].overlaps[3]=pK_ptr1[v].overlaps[nghb(p,v,w)];
	      pK_ptr2[new].overlaps[4]=pK_ptr1[w].overlaps[j4];
	      pK_ptr2[new].overlaps[5]=pK_ptr1[v].overlaps[j3];
	    }
	}
      pK_ptr2[new].mark=0;
      pK_ptr2[new].color=FG_COLOR;
      pR_ptr2[new].rad=(pR_ptr2[v].rad+pR_ptr2[w].rad)/2.0;
      pR_ptr2[new].center=pR_ptr2[v].center;
      if (q->hes <= 0)
	{
          pR_ptr2[new].center.re=
	    (pR_ptr2[v].center.re+pR_ptr2[w].center.re)/2.0;
          pR_ptr2[new].center.im=
	    (pR_ptr2[v].center.im+pR_ptr2[w].center.im)/2.0;
	}
    }

  if (pK_ptr1) 
    {
      for (j=1;j<=q->nodecount;j++) 
	if (pK_ptr1[j].flower) free(pK_ptr1[j].flower);
      free(pK_ptr1);
    }
  if (p) free(p);
  q->nodecount=q->nodecount+Num;
  complex_count(q,0);
  facedraworder(q,0);
  fillcurves(q);
  set_aim_default(q);
  if (new_verts) free(new_verts);
  return 1;

 ABORT:
  if (new_verts) free(new_verts);
  if (pK_ptr1) 
    {
      for (j=1;j<=q->nodecount;j++) 
	if (pK_ptr1[j].flower) free(pK_ptr1[j].flower);
      free(pK_ptr1);
    }
  if (p) free(p);
  return 0;
} /* hex_refine */

int vert_for_edge(struct p_data *p,int v,int j)
     /* WARNING: use ONLY in hex_refine. Given 
edge v and index j to a petal, return new vert number for midpoint. 
New nos. have been temporarily stored as extra data in second half 
of p flower ptrs. -1 for error. */
{
  int k,w;

  if (j<0 || j>p->packK_ptr[v].num) return -1;
  if (!p->packK_ptr[v].bdry_flag && j==p->packK_ptr[v].num) j=0;
  w=p->packK_ptr[v].flower[j];
  if (v<w) return p->packK_ptr[v].flower[p->packK_ptr[v].num+1+j];
  if ((k=nghb(p,w,v))<0) return -1;
  return p->packK_ptr[w].flower[p->packK_ptr[w].num+1+k];
} /* vert_for_edge */
