<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Contact/RelationshipType.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:43f57afa1c349eaa69cb12143276f444)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Contact_DAO_RelationshipType extends CRM_Core_DAO {
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_relationship_type';
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Primary key
   *
   * @var int unsigned
   */
  public $id;
  /**
   * name for relationship of contact_a to contact_b.
   *
   * @var string
   */
  public $name_a_b;
  /**
   * label for relationship of contact_a to contact_b.
   *
   * @var string
   */
  public $label_a_b;
  /**
   * Optional name for relationship of contact_b to contact_a.
   *
   * @var string
   */
  public $name_b_a;
  /**
   * Optional label for relationship of contact_b to contact_a.
   *
   * @var string
   */
  public $label_b_a;
  /**
   * Optional verbose description of the relationship type.
   *
   * @var string
   */
  public $description;
  /**
   * If defined, contact_a in a relationship of this type must be a specific contact_type.
   *
   * @var string
   */
  public $contact_type_a;
  /**
   * If defined, contact_b in a relationship of this type must be a specific contact_type.
   *
   * @var string
   */
  public $contact_type_b;
  /**
   * If defined, contact_sub_type_a in a relationship of this type must be a specific contact_sub_type.
   *
   * @var string
   */
  public $contact_sub_type_a;
  /**
   * If defined, contact_sub_type_b in a relationship of this type must be a specific contact_sub_type.
   *
   * @var string
   */
  public $contact_sub_type_b;
  /**
   * Is this relationship type a predefined system type (can not be changed or de-activated)?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Is this relationship type currently active (i.e. can be used when creating or editing relationships)?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * class constructor
   *
   * @return civicrm_relationship_type
   */
  function __construct() {
    $this->__table = 'civicrm_relationship_type';
    parent::__construct();
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship Type ID') ,
          'description' => 'Primary key',
          'required' => true,
        ) ,
        'name_a_b' => array(
          'name' => 'name_a_b',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Type Name A to B') ,
          'description' => 'name for relationship of contact_a to contact_b.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'label_a_b' => array(
          'name' => 'label_a_b',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Type Label A to B') ,
          'description' => 'label for relationship of contact_a to contact_b.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'name_b_a' => array(
          'name' => 'name_b_a',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Type Name B to A') ,
          'description' => 'Optional name for relationship of contact_b to contact_a.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'label_b_a' => array(
          'name' => 'label_b_a',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Type Label B to A') ,
          'description' => 'Optional label for relationship of contact_b to contact_a.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Description') ,
          'description' => 'Optional verbose description of the relationship type.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'contact_type_a' => array(
          'name' => 'contact_type_a',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type for Contact A') ,
          'description' => 'If defined, contact_a in a relationship of this type must be a specific contact_type.',
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NULL',
          )
        ) ,
        'contact_type_b' => array(
          'name' => 'contact_type_b',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type for Contact B') ,
          'description' => 'If defined, contact_b in a relationship of this type must be a specific contact_type.',
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NULL',
          )
        ) ,
        'contact_sub_type_a' => array(
          'name' => 'contact_sub_type_a',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Subtype A') ,
          'description' => 'If defined, contact_sub_type_a in a relationship of this type must be a specific contact_sub_type.
    ',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NOT NULL',
          )
        ) ,
        'contact_sub_type_b' => array(
          'name' => 'contact_sub_type_b',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Subtype B') ,
          'description' => 'If defined, contact_sub_type_b in a relationship of this type must be a specific contact_sub_type.
    ',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NOT NULL',
          )
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Relationship Type is Reserved') ,
          'description' => 'Is this relationship type a predefined system type (can not be changed or de-activated)?',
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Relationship Type is Active') ,
          'description' => 'Is this relationship type currently active (i.e. can be used when creating or editing relationships)?
    ',
          'default' => '1',
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'relationship_type', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'relationship_type', $prefix, array());
    return $r;
  }
}
